/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.purorder;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.inspect.common.ApWriteBackScmcHelper;

public class PurOrderPaidAmountPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(PurOrderPaidAmountPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "supplier", "supplier.internal_company", "billentry.id", "billentry.seq", "billentry.entrysettleorg", "paidpreallamount", "paidallamount");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        DataSet inspectDataSet = args.copy();
        Map<Long, PaidAmountResult> receiveResult = this.calculate(args);
        try (DataSet inspectData = inspectDataSet.select(new String[]{"id", "billno", "paidpreallamount", "paidallamount"}).distinct();){
            for (Row row : inspectData) {
                BigDecimal paidallamount;
                BigDecimal receivePaidallamount;
                PaidAmountResult result;
                String billNo = row.getString("billno");
                Long billId = row.getLong("id");
                if (billId == null || (result = receiveResult.get(billId)) == null) continue;
                BigDecimal receivePaidpreallamount = result.getPaidpreallamount();
                BigDecimal paidpreallamount = row.getBigDecimal("paidpreallamount");
                String msg = "";
                boolean flag = false;
                if (receivePaidpreallamount.compareTo(paidpreallamount) != 0) {
                    msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e00\uff1a\u5355\u5934\u5df2\u9884\u4ed8\u91d1\u989d\uff1a%1$s\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5df2\u9884\u4ed8\u91d1\u989d\uff1a%2$s\u4e0d\u4e00\u81f4\u3002", (String)"PurOrderPaidAmountPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), paidpreallamount, receivePaidpreallamount);
                    flag = true;
                }
                if ((receivePaidallamount = result.getPaidallamount()).compareTo(paidallamount = row.getBigDecimal("paidallamount")) != 0) {
                    msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e8c\uff1a\u5355\u5934\u5df2\u4ed8\u91d1\u989d\uff1a%1$s\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5df2\u4ed8\u91d1\u989d\uff1a%2$s\u4e0d\u4e00\u81f4\u3002", (String)"PurOrderPaidAmountPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), paidallamount, receivePaidallamount);
                    flag = true;
                }
                if (!flag) continue;
                errorInfo.add(this.getExpMsg(this.getClass().getName(), msg, billId, billId, billNo));
            }
        }
        return errorInfo;
    }

    private Map<Long, PaidAmountResult> calculate(DataSet inspectDataSet) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(16);
        try (DataSet selectData = inspectDataSet.select(new String[]{"id", "supplier", "supplier.internal_company", "billentry.id", "billentry.entrysettleorg"});){
            for (Row row : selectData) {
                HashMap<String, Constable> param = new HashMap<String, Constable>(16);
                param.put("mainbillid", row.getLong("id"));
                Long supplierId = row.getLong("supplier");
                if (supplierId == null || supplierId == 0L) continue;
                param.put("asstid", row.getLong("supplier"));
                boolean flag = false;
                Long company = row.getLong("supplier.internal_company");
                if (company != null && company != 0L) {
                    flag = true;
                }
                param.put("internal_company", Boolean.valueOf(flag));
                Long entryId = row.getLong("billentry.id");
                if (entryId == null) continue;
                param.put("mainbillentryid", entryId);
                param.put("settleorgid", row.getLong("billentry.entrysettleorg"));
                paramList.add(param);
            }
        }
        List<Map<String, Object>> constructWriteBackPurParam = ApWriteBackScmcHelper.writeBackHeadPaidAmt(paramList);
        HashMap<Long, PaidAmountResult> receiveResult = new HashMap<Long, PaidAmountResult>(16);
        if (constructWriteBackPurParam != null && constructWriteBackPurParam.size() > 0) {
            for (Map<String, Object> obj : constructWriteBackPurParam) {
                receiveResult.put((Long)obj.get("mainbillid"), PaidAmountResult.assertResult((BigDecimal)obj.get("paidpreallamount"), (BigDecimal)obj.get("paidallamount")));
            }
        }
        return receiveResult;
    }

    @Override
    public List<FixLogInfo> fixMainDataSet(DataSet args) {
        DataSet inspectDataSet = args.copy();
        Map<Long, PaidAmountResult> receiveResult = this.calculate(args);
        ArrayList<FixLogInfo> expMsg = new ArrayList<FixLogInfo>(16);
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "paidpreallamount", "paidallamount");
        try (DataSet inspectData = inspectDataSet.select(new String[]{"id", "billno", "paidpreallamount", "paidallamount"}).distinct();){
            String updateSql = "update t_pm_purorderbill  set fpaidpreallamount=?,fpaidallamount=?  where  fid=?";
            ArrayList<Object[]> parameterList = new ArrayList<Object[]>();
            for (Row row2 : inspectData) {
                PaidAmountResult result;
                Object[] parameter = new Object[3];
                String billNo = row2.getString("billno");
                Long billId = row2.getLong("id");
                if (billId == null || (result = receiveResult.get(billId)) == null) continue;
                BigDecimal paidpreallamount = row2.getBigDecimal("paidpreallamount");
                BigDecimal paidallamount = row2.getBigDecimal("paidallamount");
                BigDecimal receivePaidpreallamount = result.getPaidpreallamount();
                BigDecimal receivePaidallamount = result.getPaidallamount();
                if (paidpreallamount.compareTo(receivePaidpreallamount) == 0 && paidallamount.compareTo(receivePaidallamount) == 0) continue;
                if (receivePaidpreallamount.compareTo(paidpreallamount) != 0) {
                    expMsg.add(new FixLogInfo(billId, billNo, 0, Long.valueOf("0"), "paidpreallamount", fieldName.get("paidpreallamount"), paidpreallamount.toString(), receivePaidpreallamount.toString()));
                    paidpreallamount = receivePaidpreallamount;
                }
                if (receivePaidallamount.compareTo(paidallamount) != 0) {
                    expMsg.add(new FixLogInfo(billId, billNo, 0, Long.valueOf("0"), "paidallamount", fieldName.get("paidallamount"), paidallamount.toString(), receivePaidallamount.toString()));
                    paidallamount = receivePaidallamount;
                }
                parameter[0] = paidpreallamount;
                parameter[1] = paidallamount;
                parameter[2] = billId;
                parameterList.add(parameter);
            }
            int updateDataNum = parameterList.size();
            if (updateDataNum > 0) {
                if (updateDataNum > 1000) {
                    List partition = DmfSchemeExecuteHelper.partition(parameterList, 1000);
                    partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, (List)row));
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, parameterList);
                }
            }
        }
        return expMsg;
    }

    static class PaidAmountResult {
        private BigDecimal paidpreallamount;
        private BigDecimal paidallamount;

        public BigDecimal getPaidpreallamount() {
            return this.paidpreallamount;
        }

        public BigDecimal getPaidallamount() {
            return this.paidallamount;
        }

        public PaidAmountResult(BigDecimal paidpreallamount, BigDecimal paidallamount) {
            this.paidallamount = paidallamount;
            this.paidpreallamount = paidpreallamount;
        }

        public static PaidAmountResult assertResult(BigDecimal paidpreallamount, BigDecimal paidallamount) {
            return new PaidAmountResult(paidpreallamount, paidallamount);
        }

        public String toString() {
            return "PaidAmountResult{paidpreallamount=" + this.paidpreallamount + ", paidallamount=" + this.paidallamount + '}';
        }
    }
}

