/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.purorder;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.inspect.common.ApWriteBackScmcHelper;

public class PurOrderReceiveQtyAmountPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(PurOrderReceiveQtyAmountPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "supplier", "supplier.internal_company", "billentry.id", "billentry.seq", "billentry.entrysettleorg", "billentry.unit", "billentry.payableamount", "billentry.payablepriceqty");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        String simpleName = "PurOrderReceiveQtyAmountPlugin";
        DataSet inspectDataSet = args.copy();
        Map<Long, InvokeResult> receiveResult = this.calculate(args);
        try (DataSet inspectData = inspectDataSet.select(new String[]{"id", "billno", "billentry.id", "billentry.seq", "billentry.payableamount", "billentry.payablepriceqty"});){
            for (Row row : inspectData) {
                InvokeResult invokeResult;
                String billNo = row.getString("billno");
                Long entryId = row.getLong("billentry.id");
                if (entryId == null || (invokeResult = receiveResult.get(entryId)) == null) continue;
                BigDecimal payableAmount = row.getBigDecimal("billentry.payableamount");
                BigDecimal payableQty = row.getBigDecimal("billentry.payablepriceqty");
                BigDecimal receiveQty = invokeResult.getQty();
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"PurOrderReceiveQtyAmountPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), row.get("billentry.seq"));
                msg = msg + "\uff0c";
                boolean flag = false;
                if (payableQty == null || receiveQty == null) continue;
                if (payableQty.compareTo(receiveQty) != 0) {
                    msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e00\uff1a\u5e94\u4ed8\u6570\u91cf\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u4ed8\u6570\u91cf\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"PurOrderReceiveQtyAmountPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), payableQty, receiveQty);
                    flag = true;
                }
                BigDecimal receivePayableAmount = invokeResult.getAmount();
                if (payableAmount == null || receivePayableAmount == null) continue;
                if (payableAmount.compareTo(receivePayableAmount) != 0) {
                    msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e8c\uff1a\u5e94\u4ed8\u91d1\u989d\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u4ed8\u91d1\u989d\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"PurOrderReceiveQtyAmountPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), payableAmount, receivePayableAmount);
                    flag = true;
                }
                if (!flag) continue;
                errorInfo.add(this.getExpMsg(simpleName, msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
            }
        }
        return errorInfo;
    }

    private Map<Long, InvokeResult> calculate(DataSet inspectDataSet) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(16);
        try (DataSet selectData = inspectDataSet.select(new String[]{"id", "supplier", "supplier.internal_company", "billentry.id", "billentry.entrysettleorg", "billentry.unit"});){
            for (Row row : selectData) {
                HashMap<String, Constable> param = new HashMap<String, Constable>(16);
                param.put("mainbillid", row.getLong("id"));
                Long supplierid = row.getLong("supplier");
                if (supplierid == null || supplierid == 0L) continue;
                param.put("asstid", row.getLong("supplier"));
                boolean flag = false;
                Long company = row.getLong("supplier.internal_company");
                if (company != null && company != 0L) {
                    flag = true;
                }
                param.put("internal_company", Boolean.valueOf(flag));
                Long entryId = row.getLong("billentry.id");
                if (entryId == null) continue;
                param.put("mainbillentryid", entryId);
                param.put("unit", row.getLong("billentry.unit"));
                param.put("settleorgid", row.getLong("billentry.entrysettleorg"));
                paramList.add(param);
            }
        }
        List<Map<String, Object>> constructWriteBackPurParam = ApWriteBackScmcHelper.constructWriteBackScmcParam(paramList);
        HashMap<Long, InvokeResult> receiveResult = new HashMap<Long, InvokeResult>(16);
        if (constructWriteBackPurParam != null && constructWriteBackPurParam.size() > 0) {
            for (Map<String, Object> obj : constructWriteBackPurParam) {
                receiveResult.put((Long)obj.get("mainbillentryid"), InvokeResult.acceptResult((BigDecimal)obj.get("amount"), (BigDecimal)obj.get("qty")));
            }
        }
        return receiveResult;
    }

    @Override
    public List<FixLogInfo> fixDataSet(DataSet args) {
        DataSet inspectDataSet = args.copy();
        Map<Long, InvokeResult> receiveResult = this.calculate(args);
        ArrayList<FixLogInfo> expMsg = new ArrayList<FixLogInfo>(16);
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "payablepriceqty", "payableamount");
        try (DataSet inspectData = inspectDataSet.select(new String[]{"id", "billno", "billentry.id", "billentry.seq", "billentry.payableamount", "billentry.payablepriceqty"});){
            String updateSql = "update t_pm_purorderbillentry_r  set fpayableamount=?,fpayablepriceqty=?  where  fentryid=?";
            ArrayList<Object[]> parameterList = new ArrayList<Object[]>();
            for (Row row2 : inspectData) {
                InvokeResult invokeResult;
                Object[] parameter = new Object[3];
                String billNo = row2.getString("billno");
                Long entryId = row2.getLong("billentry.id");
                if (entryId == null || (invokeResult = receiveResult.get(entryId)) == null) continue;
                BigDecimal payableAmount = row2.getBigDecimal("billentry.payableamount");
                BigDecimal payableQty = row2.getBigDecimal("billentry.payablepriceqty");
                BigDecimal receiveQty = invokeResult.getQty();
                BigDecimal receiveAmount = invokeResult.getAmount();
                if (payableQty.compareTo(receiveQty) == 0 && payableAmount.compareTo(receiveAmount) == 0) continue;
                String entryMsg = "";
                if (payableQty.compareTo(receiveQty) != 0) {
                    expMsg.add(new FixLogInfo(row2.getLong("id"), billNo, row2.getInteger("billentry.seq"), entryId, "payablepriceqty", fieldName.get("payablepriceqty"), payableQty.toString(), receiveQty.toString()));
                    payableQty = receiveQty;
                }
                if (receiveAmount.compareTo(payableAmount) != 0) {
                    expMsg.add(new FixLogInfo(row2.getLong("id"), billNo, row2.getInteger("billentry.seq"), entryId, "payableamount", fieldName.get("payableamount"), payableAmount.toString(), receiveAmount.toString()));
                    payableAmount = receiveAmount;
                }
                parameter[0] = payableAmount;
                parameter[1] = payableQty;
                parameter[2] = entryId;
                parameterList.add(parameter);
            }
            int updateDataNum = parameterList.size();
            if (updateDataNum > 0) {
                if (updateDataNum > 1000) {
                    List partition = DmfSchemeExecuteHelper.partition(parameterList, 1000);
                    partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, (List)row));
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, parameterList);
                }
            }
        }
        return expMsg;
    }

    static class InvokeResult {
        private Long mainbillid;
        private Long mainbillentryid;
        private BigDecimal baseqty;
        private BigDecimal amount;
        private BigDecimal qty;

        public static InvokeResult acceptResult(BigDecimal baseqty, BigDecimal payableamount, BigDecimal qty) {
            return new InvokeResult(baseqty, payableamount, qty);
        }

        public static InvokeResult acceptResult(BigDecimal payableamount, BigDecimal qty) {
            return new InvokeResult(payableamount, qty);
        }

        public InvokeResult(BigDecimal amount, BigDecimal qty) {
            this.amount = amount;
            this.qty = qty;
        }

        public InvokeResult(BigDecimal baseqty, BigDecimal amount, BigDecimal qty) {
            this.baseqty = baseqty;
            this.amount = amount;
            this.qty = qty;
        }

        public Long getMainbillid() {
            return this.mainbillid;
        }

        public void setMainbillid(Long mainbillid) {
            this.mainbillid = mainbillid;
        }

        public Long getMainbillentryid() {
            return this.mainbillentryid;
        }

        public void setMainbillentryid(Long mainbillentryid) {
            this.mainbillentryid = mainbillentryid;
        }

        public BigDecimal getBaseqty() {
            return this.baseqty;
        }

        public void setBaseqty(BigDecimal baseqty) {
            this.baseqty = baseqty;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        private InvokeResult() {
        }

        public String toString() {
            return "InvokeResult{mainbillid=" + this.mainbillid + ", mainbillentryid=" + this.mainbillentryid + ", baseqty=" + this.baseqty + ", amount=" + this.amount + ", qty=" + this.qty + '}';
        }
    }
}

