/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.sou;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class SouExrateCheckPlugin
extends AbstractDmfPlugin {
    private static Log logger = LogFactory.getLog(SouExrateCheckPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "materialentry.id", "materialentry.seq", "materialentry.exrate");
    }

    @Override
    public void beginInspectOperation(InspectOptionInfo inspectOptionInfo) {
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("materialentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        logger.info("\u6bd4\u4ef7\u5355\u6c47\u7387\u5de1\u68c0\u5f00\u59cb\u65f6\u95f4\uff1a", (Object)FORMATTER.format(LocalDateTime.now()));
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        for (Row row : args) {
            BigDecimal exrate = row.getBigDecimal("materialentry.exrate");
            String billno = row.getString("billno");
            Object seq = row.get("materialentry.seq");
            if (exrate == null || BigDecimal.ZERO.compareTo(exrate) != 0) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u6bd4\u4ef7\u5355\uff1a%1s\uff0c\u7b2c%2s\u884c\u6c47\u7387\u4e3a\u96f6\u3002", (String)"SouExrateCheckPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billno, seq);
            errorInfos.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("materialentry.id"), billno));
        }
        logger.info("\u6bd4\u4ef7\u5355\u6c47\u7387\u5de1\u68c0\u7ed3\u675f\u65f6\u95f4\uff1a{},\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfos.size());
        return errorInfos;
    }
}

