/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.datamanage.opplugin.DmfInspectPlanSaveOp;

public class DmfInspectPlanDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DmfInspectPlanSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("schedule");
        keys.add("job");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ArrayList<Object> jobIdList = new ArrayList<Object>(16);
        ArrayList<Object> planIdList = new ArrayList<Object>(16);
        for (DynamicObject plan : e.getDataEntities()) {
            DynamicObject jobId = plan.getDynamicObject("job");
            if (jobId == null) {
                return;
            }
            jobIdList.add(jobId.getPkValue());
            DynamicObject planId = plan.getDynamicObject("schedule");
            if (planId == null) {
                return;
            }
            planIdList.add(planId.getPkValue());
        }
        if (jobIdList.size() <= 0 || planIdList.size() <= 0) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"DmfInspectPlanDeleteOp", (String)"afterExecuteOperationTransaction:");){
            OperationResult deletePlanResult = OperationServiceHelper.executeOperate((String)"delete", (String)"sch_schedule", (Object[])planIdList.toArray(), (OperateOption)OperateOption.create());
            if (!deletePlanResult.isSuccess()) {
                logger.error("\u5de1\u68c0\u8ba1\u5212\u5220\u9664\u5931\u8d25\uff1a{}", (Object)((IOperateInfo)deletePlanResult.getAllErrorOrValidateInfo().get(0)).getMessage());
                this.getOption().setVariableValue("operateFlag", "false");
                return;
            }
            OperationResult deleteJobResult = OperationServiceHelper.executeOperate((String)"delete", (String)"sch_job", (Object[])jobIdList.toArray(), (OperateOption)OperateOption.create());
            if (!deleteJobResult.isSuccess()) {
                logger.error("\u5de1\u68c0\u4efb\u52a1\u5220\u9664\u5931\u8d25\uff1a{}", (Object)((IOperateInfo)deleteJobResult.getAllErrorOrValidateInfo().get(0)).getMessage());
                this.getOption().setVariableValue("operateFlag", "false");
                return;
            }
        }
    }
}

