/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;

public class DmfInspectPlanSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DmfInspectPlanSaveOp.class);
    private static final String[] CKMONTH = new String[]{"ckjan", "ckfeb", "ckmar", "ckapr", "ckmay", "ckjun", "ckjul", "ckaug", "cksep", "ckoct", "cknov", "ckdec"};
    private static final String[] CKDATE = new String[]{"ckone", "cktwo", "ckthree", "ckfour", "ckfive", "cksix", "ckseven", "ckeight", "cknine", "ckten", "ckeleven", "cktwelve", "ckthirteen", "ckfourteen", "ckfifteen", "cksixteen", "ckseventeen", "ckeighteen", "cknineteen", "cktwenty", "cktwentyone", "cktwentytwo", "cktwentythree", "cktwentyfour", "cktwentyfive", "cktwentysix", "cktwentyseven", "cktwentyeight", "cktwentynine", "ckthirty", "ckthirtyone"};
    private static final String[] CKDAY = new String[]{"cksun", "ckmon", "cktues", "ckwed", "ckthur", "ckfri", "cksat"};
    public static final String SINGLE_TASK_CLASSNAME = "kd.mpscmm.msbd.algox.mservice.InspectSingleTaskServiceImpl";
    public static final String SINGLE_TASK_ID = "2+XHCST7ER7S";
    public static final String BROADCAST_TASK_CLASSNAME = "kd.mpscmm.msbd.algox.mservice.InspectBroadcastTaskServiceImpl";
    public static final String BROADCAST_TASK_ID = "200YDPMIV=9L";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>(16);
        for (DynamicObject plan : e.getDataEntities()) {
            boolean isFlag = plan.getDataEntityState().getFromDatabase();
            try {
                if (isFlag) {
                    DynamicObject schedulePlan = BusinessDataServiceHelper.loadSingle((Object)plan.getDynamicObject("schedule").getPkValue(), (String)"sch_schedule");
                    this.refreshSchedulePlan(schedulePlan, plan);
                    this.savePlanObj(schedulePlan, "sch_schedule");
                } else {
                    Object jobId = this.saveJobObj(this.createJobInfo(plan), "sch_job");
                    DynamicObject schedulePlan = BusinessDataServiceHelper.newDynamicObject((String)"sch_schedule");
                    this.refreshSchedulePlan(schedulePlan, plan);
                    DynamicObject paramEntry = schedulePlan.getDynamicObjectCollection("entryentity").addNew();
                    paramEntry.set("jobnumber", jobId);
                    schedulePlan.set("job", jobId);
                    Object planId = this.savePlanObj(schedulePlan, "sch_schedule");
                    plan.set("schedule", planId);
                    plan.set("job", jobId);
                }
                successList.add(plan);
            }
            catch (KDBizException exp) {
                logger.error("\u540c\u6b65\u8c03\u5ea6\u7ba1\u7406\u8c03\u5ea6\u8ba1\u5212\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)exp.getLocalizedMessage());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u8c03\u5ea6\u7ba1\u7406\u8c03\u5ea6\u8ba1\u5212\u4fdd\u5b58\u5f02\u5e38:%s", (String)"DmfInspectPlanSaveOp_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), exp.getLocalizedMessage()));
            }
        }
        e.setDataEntities(successList.toArray(new DynamicObject[successList.size()]));
    }

    private void refreshSchedulePlan(DynamicObject schedulePlan, DynamicObject inspectPlan) {
        Arrays.stream(CKMONTH).forEach(month -> schedulePlan.set(month, inspectPlan.get(month)));
        Arrays.stream(CKDATE).forEach(date -> schedulePlan.set(date, inspectPlan.get(date)));
        Arrays.stream(CKDAY).forEach(day -> schedulePlan.set(day, inspectPlan.get(day)));
        String randomNum = DmfSchemeExecuteHelper.getRandomNum();
        schedulePlan.set("number", (Object)inspectPlan.getString("number").concat(randomNum));
        schedulePlan.set("name", inspectPlan.get("name"));
        schedulePlan.set("txtdesc", inspectPlan.get("txtdesc"));
        schedulePlan.set("repeatmode", inspectPlan.get("repeatmode"));
        schedulePlan.set("cyclenum", inspectPlan.get("cyclenum"));
        schedulePlan.set("combdorw", inspectPlan.get("combdorw"));
        schedulePlan.set("comno", inspectPlan.get("comno"));
        schedulePlan.set("comweek", inspectPlan.get("comweek"));
        schedulePlan.set("starttime", inspectPlan.get("starttime"));
        schedulePlan.set("endtime", inspectPlan.get("endtime"));
        schedulePlan.set("plan", inspectPlan.get("plan"));
        schedulePlan.set("status", (Object)"1");
        schedulePlan.set("snotifytype", inspectPlan.get("snotifytype"));
        schedulePlan.set("msgreceiver", inspectPlan.get("msgreceiver"));
        schedulePlan.set("smsgcontent", inspectPlan.get("smsgcontent"));
        schedulePlan.set("schprincipal", inspectPlan.get("schprincipal"));
        Arrays.stream(new String[]{"sfailnotify", "ssuccessnotify", "stimeout"}).forEach(field -> schedulePlan.set(field, (Object)inspectPlan.getBoolean(field)));
    }

    private DynamicObject createJobInfo(DynamicObject plan) {
        DynamicObject inspectJob = plan.getDynamicObject("inspectjob");
        DynamicObject shceduleJob = BusinessDataServiceHelper.newDynamicObject((String)"sch_job");
        String randomNum = DmfSchemeExecuteHelper.getRandomNum();
        shceduleJob.set("number", (Object)inspectJob.getString("number").concat(randomNum));
        shceduleJob.set("name", inspectJob.get("name"));
        shceduleJob.set("jobtype", (Object)"BIZ");
        String runMode = inspectJob.getString("runmode");
        if ("0".equals(runMode)) {
            shceduleJob.set("taskclassname", (Object)SINGLE_TASK_ID);
            shceduleJob.set("classname", (Object)SINGLE_TASK_CLASSNAME);
        }
        if ("1".equals(runMode)) {
            shceduleJob.set("taskclassname", (Object)BROADCAST_TASK_ID);
            shceduleJob.set("classname", (Object)BROADCAST_TASK_CLASSNAME);
        }
        shceduleJob.set("runmode", (Object)runMode);
        shceduleJob.set("runbyuser", (Object)RequestContext.get().getCurrUserId());
        shceduleJob.set("status", (Object)Character.valueOf('1'));
        shceduleJob.set("jobprincipal", plan.get("schprincipal"));
        shceduleJob.set("runconcurrent", inspectJob.get("runconcurrent"));
        shceduleJob.set("runorder", inspectJob.get("runorder"));
        shceduleJob.set("strategy", inspectJob.get("strategy"));
        DynamicObjectCollection entryEntity = shceduleJob.getDynamicObjectCollection("entryentity");
        Arrays.stream(new String[]{"inspectPlanId", "inspectJobId", "number"}).forEach(key -> {
            DynamicObject entry = entryEntity.addNew();
            entry.set("must", (Object)Boolean.TRUE);
            entry.set("paramtype", (Object)"0");
            entry.set("paramname", key);
            if ("inspectPlanId".equals(key)) {
                entry.set("paramvalue", (Object)String.valueOf(plan.getPkValue()));
            } else if ("number".equals(key)) {
                entry.set("paramvalue", (Object)plan.getString(key));
            } else {
                entry.set("paramvalue", (Object)String.valueOf(shceduleJob.getPkValue()));
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("inspectPlanId", String.valueOf(plan.getPkValue()));
        params.put("inspectJobId", String.valueOf(inspectJob.getPkValue()));
        params.put("number", plan.getString("number"));
        shceduleJob.set("params", (Object)SerializationUtils.toJsonString(params));
        return shceduleJob;
    }

    private Object savePlanObj(DynamicObject obj, String entityNumber) {
        return this.invokeSaveOpeateion(obj, entityNumber, ResManager.loadKDString((String)"\u540c\u6b65\u8c03\u5ea6\u7ba1\u7406\u8c03\u5ea6\u8ba1\u5212\u4fdd\u5b58\u5f02\u5e38\u3002", (String)"DmfInspectPlanSaveOp_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
    }

    private Object saveJobObj(DynamicObject obj, String entityNumber) {
        return this.invokeSaveOpeateion(obj, entityNumber, ResManager.loadKDString((String)"\u540c\u6b65\u8c03\u5ea6\u7ba1\u7406\u8c03\u5ea6\u4efb\u52a1\u4fdd\u5b58\u5f02\u5e38\u3002", (String)"DmfInspectPlanSaveOp_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
    }

    private Object invokeSaveOpeateion(DynamicObject obj, String entityNumber, String tipMsg) {
        try (TraceSpan traceSpan = Tracer.create((String)"DmfInspectPlanSaveOp", (String)"invokeSaveOpeateion:");){
            OperationResult saveResult = null;
            try (TXHandle tx = TX.requiresNew((String)DmfInspectPlanSaveOp.class.getName());){
                try {
                    saveResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])new DynamicObject[]{obj}, null);
                    if (!saveResult.isSuccess()) {
                        throw new KDBizException(tipMsg + ((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(0)).getMessage());
                    }
                }
                catch (Exception exp) {
                    tx.markRollback();
                    logger.error(tipMsg, (Object)Arrays.toString(exp.getStackTrace()));
                    throw new KDBizException(tipMsg);
                }
            }
            Object objId = saveResult.getSuccessPkIds().get(0);
            var8_9 = objId;
            return var8_9;
        }
    }
}

