/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;

public class InspectPlanRunValidator
extends AbstractValidator {
    public void validate() {
        ArrayList inspectUnitAllIdList = new ArrayList(16);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject inspectPlan = data.getDataEntity();
            DynamicObject inspectJob = inspectPlan.getDynamicObject("inspectjob");
            if (inspectJob != null) {
                if (!inspectJob.getBoolean("enable")) {
                    this.addMessage(data, ResManager.loadKDString((String)"\u5de1\u68c0\u8ba1\u5212\u7684\u5de1\u68c0\u4efb\u52a1\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u518d\u624b\u52a8\u8fd0\u884c\u3002", (String)"InspectPlanRunValidator_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
            } else {
                this.addMessage(data, ResManager.loadKDString((String)"\u5de1\u68c0\u8ba1\u5212\u7684\u5de1\u68c0\u4efb\u52a1\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u624b\u52a8\u8fd0\u884c\u3002", (String)"InspectPlanRunValidator_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            List inspectUnitIdList = inspectJob.getDynamicObjectCollection("entry").stream().map(entry -> (Long)entry.getDynamicObject("inspectunit").getPkValue()).collect(Collectors.toList());
            inspectUnitAllIdList.addAll(inspectUnitIdList);
            Date currentTime = new Date(System.currentTimeMillis());
            Date endTime = inspectPlan.getDate("endtime");
            if (endTime == null) {
                return;
            }
            boolean flag = endTime.before(currentTime);
            if (flag) {
                this.addMessage(data, ResManager.loadKDString((String)"\u6570\u636e\u5de1\u68c0\u8ba1\u5212\u5df2\u7ecf\u5931\u6548\uff0c\u4e0d\u80fd\u518d\u624b\u52a8\u8fd0\u884c\u3002", (String)"InspectPlanRunValidator_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            Long inspectPlanId = (Long)inspectPlan.getPkValue();
            boolean runningInspectPlan = DmfSchemeExecuteHelper.getRunningInspectPlan(inspectPlanId);
            if (runningInspectPlan) {
                this.addMessage(data, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5de1\u68c0\u8ba1\u5212\u8fd8\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u8fdb\u884c\u91cd\u8bd5\u3002", (String)"InspectPlanRunValidator_5", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            Set insUnitSet = inspectJob.getDynamicObjectCollection("entry").stream().map(row -> (Long)row.getDynamicObject("inspectunit").getPkValue()).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", insUnitSet);
            DataSet inspectUnit = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectunit", (String)"entity.number", (QFilter[])qFilter.toArray(), null);
            HashSet entityNumberSet = new HashSet();
            inspectUnit.forEach(row -> entityNumberSet.add(row.getString("entity.number")));
            if (entityNumberSet.size() == 1) continue;
            List<String> defaultFilter = Arrays.asList("biztime", "org.number", "org.name", "billno");
            String palnQFilterStr = inspectPlan.getString("areajson_tag");
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)palnQFilterStr, FilterCondition.class);
            List filterRow = condition.getFilterRow();
            boolean uniqueFlag = false;
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                if (defaultFilter.contains(simpleFilterRow.getFieldName())) continue;
                uniqueFlag = true;
            }
            if (!uniqueFlag) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u6570\u636e\u5de1\u68c0\u8ba1\u5212\u4e0a\uff0c\u6570\u636e\u8303\u56f4\u4e0d\u5728\u9ed8\u8ba4\u7684\u6570\u636e\u8303\u56f4\u5185\u3002", (String)"InspectPlanRunValidator_6", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        if (inspectUnitAllIdList.size() <= 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", inspectUnitAllIdList);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection enableInspectUnitColl = QueryServiceHelper.query((String)"msbd_inspectunit", (String)"id", (QFilter[])qFilter.toArray());
        List enableInspectUnitList = enableInspectUnitColl.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
        for (ExtendedDataEntity bill : this.dataEntities) {
            DynamicObject inspectJob = bill.getDataEntity().getDynamicObject("inspectjob");
            List inspectUnitIdList = inspectJob.getDynamicObjectCollection("entry").stream().map(entry -> (Long)entry.getDynamicObject("inspectunit").getPkValue()).collect(Collectors.toList());
            List enableInspectUnit = inspectUnitIdList.stream().filter(row -> enableInspectUnitList.contains(row)).collect(Collectors.toList());
            if (enableInspectUnit.size() > 0) continue;
            this.addMessage(bill, ResManager.loadKDString((String)"\u6570\u636e\u5de1\u68c0\u8ba1\u5212\u4e0b\u5de1\u68c0\u4efb\u52a1\u4e0b\u7684\u5de1\u68c0\u6a21\u578b\uff0c\u5df2\u7ecf\u5168\u90e8\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u518d\u624b\u52a8\u8fd0\u884c\u3002", (String)"InspectPlanRunValidator_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

