/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.price;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.mservice.api.price.PriceProcessService;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategySeqInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuoteSimpleCalcEngine;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.common.consts.advanceprice.PriceProcessConst;
import kd.mpscmm.msbd.pricemodel.common.consts.quote.QuoteStrategyCalEntryConst;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;

public class PriceProcessServiceImpl
implements PriceProcessService {
    private static final Log log = LogFactory.getLog(PriceProcessServiceImpl.class);

    @Override
    public Map<String, ?> queryGroupPriceIgnoreExp(Long priceProcessID, Map<String, Object> otherParam) {
        QFilter qFilter = new QFilter("id", "=", (Object)priceProcessID);
        List selector = PriceProcessConst.getSubSelectorList();
        DynamicObject priceProcess = BusinessDataServiceHelper.loadSingle((String)"msbd_pricingprocess", (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{qFilter});
        DynamicObject quoteStrategy = priceProcess.getDynamicObject("quotestrategy");
        DynamicObject calStrategy = priceProcess.getDynamicObject("calstrategy");
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter idFilter = new QFilter("id", "=", quoteStrategy.getPkValue());
        StringBuilder selecties = new StringBuilder("id,createorg");
        selecties.append(',').append(String.join((CharSequence)",", QuoteStrategyCalEntryConst.getSelectorList()));
        quoteStrategy = BusinessDataServiceHelper.loadSingle((String)"plat_quotestrategy", (String)selecties.toString(), (QFilter[])new QFilter[]{idFilter, statusFilter, enableFilter});
        if (quoteStrategy != null) {
            DynamicObject calStrategy_s;
            DynamicObjectCollection entrys = quoteStrategy.getDynamicObjectCollection("calentry");
            if (entrys.size() == 0) {
                String msg = ResManager.loadKDString((String)"\u5b9a\u4ef7\u8fc7\u7a0b\u5bf9\u5e94\u7684\u53d6\u4ef7\u7b56\u7565\u4e2d\u5df2\u7ecf\u5220\u9664\u5bf9\u5e94\u7684\u8ba1\u7b97\u7b56\u7565\u3002", (String)"PriceProcessServiceImpl_1", (String)"mpscmm-msbd-mservice", (Object[])new Object[0]);
                return this.returnFailResult(msg);
            }
            for (int i = 0; i < entrys.size() && !(calStrategy_s = ((DynamicObject)entrys.get(i)).getDynamicObject("calstrategy")).getPkValue().equals(calStrategy.getPkValue()); ++i) {
                if (i != entrys.size() - 1) continue;
                String msg = ResManager.loadKDString((String)"\u5b9a\u4ef7\u8fc7\u7a0b\u5bf9\u5e94\u7684\u53d6\u4ef7\u7b56\u7565\u4e2d\u5df2\u7ecf\u5220\u9664\u5bf9\u5e94\u7684\u8ba1\u7b97\u7b56\u7565\u3002", (String)"PriceProcessServiceImpl_1", (String)"mpscmm-msbd-mservice", (Object[])new Object[0]);
                return this.returnFailResult(msg);
            }
            if ((calStrategy = QuoteHelper.getSimpleCalcstrategyInfo((Object)calStrategy.getPkValue())) != null) {
                QuoteCalcColl quoteCalcColl = new QuoteCalcColl(quoteStrategy);
                DynamicObject quoteEntity = priceProcess.getDynamicObject("quoteentity");
                QuoteStrategySeqInfo calSeqInfoCheck = new QuoteStrategySeqInfo(Integer.valueOf(0), "", null, null, null, null);
                calSeqInfoCheck.setOrigialQuoteType(quoteEntity.getString("id"));
                quoteCalcColl.applyStratege(calStrategy, calSeqInfoCheck);
                quoteCalcColl.load();
                DynamicObject quoteOrg = priceProcess.getDynamicObject("org");
                Long billID = priceProcess.getLong("billid");
                Long[] ids = new Long[]{billID};
                QuoteStrategeColl quoteStrategeColl = QuoteHelper.fetchQuoteSchemeFromST((Long)quoteOrg.getLong("id"), (String)quoteEntity.getString("id"), otherParam);
                PriceEntityKeyInfo qccInfo = QuoteHelper.getQuoteCommonConst((String)quoteEntity.getString("id"), (QuoteStrategeColl)quoteStrategeColl);
                DataSet quoteOriginDataSet = QuoteHelper.buildQuoteDataSetByIDs((Long[])ids, (String)quoteEntity.getString("id"), (QuoteStrategeColl)quoteStrategeColl, (PriceEntityKeyInfo)qccInfo);
                Long billEntryID = priceProcess.getLong("entryid");
                if (billEntryID != null && billEntryID > 0L && qccInfo.getLEFTIDFIELDS().size() > 1) {
                    quoteOriginDataSet = quoteOriginDataSet.filter((String)qccInfo.getLEFTIDFIELDS().get(1) + OperatorEnum.EQUALS.getProptery() + billEntryID);
                }
                QuoteParam quoteParam = new QuoteParam(quoteOriginDataSet, Long.valueOf(quoteOrg.getLong("id")), qccInfo, quoteEntity.getString("id"));
                QuoteLogProxy logProxys = new QuoteLogProxy(false, null, null, null, null, null);
                QuoteSimpleCalcEngine engine = new QuoteSimpleCalcEngine(logProxys);
                Map result = engine.startQuote((QuoteCalcInfo)quoteCalcColl.getQuoteCalcInfos().get(0), quoteStrategy, quoteParam);
                return result;
            }
            String msg = ResManager.loadKDString((String)"\u5b9a\u4ef7\u8fc7\u7a0b\u5bf9\u5e94\u7684\u8ba1\u7b97\u7b56\u7565\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u4e0d\u53ef\u7528\u3002", (String)"PriceProcessServiceImpl_2", (String)"mpscmm-msbd-mservice", (Object[])new Object[0]);
            return this.returnFailResult(msg);
        }
        String msg = ResManager.loadKDString((String)"\u5b9a\u4ef7\u8fc7\u7a0b\u5bf9\u5e94\u7684\u53d6\u4ef7\u7b56\u7565\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u4e0d\u53ef\u7528\u3002", (String)"PriceProcessServiceImpl_3", (String)"mpscmm-msbd-mservice", (Object[])new Object[0]);
        return this.returnFailResult(msg);
    }

    private Map<String, Object> returnFailResult(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("msg", msg);
        result.put("success", Boolean.FALSE);
        return result;
    }
}

