/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.workbench;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.msbd.mservice.api.workbench.WorkBenchTaskCompleteService;

public class WorkBenchTaskCompleteServiceImpl
implements WorkBenchTaskCompleteService {
    private static final Log logger = LogFactory.getLog(WorkBenchTaskCompleteServiceImpl.class);

    @Override
    public Map<String, Object> completeWbTask(List<Map<String, String>> taskData, String billType, long taskId) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(2);
        resMap.put("success", "true");
        resMap.put("num", 0);
        resMap.put("msg", "");
        DynamicObject[] workBenchConfig = this.loadTaskServiceConfigs(billType, taskId);
        if (workBenchConfig == null || workBenchConfig.length == 0) {
            logger.info("\u67e5\u8be2\u4efb\u52a1\u670d\u52a1\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\uff0c\u5355\u636e\u7c7b\u578b:" + billType + "\uff0c\u4efb\u52a1\u5206\u7c7b\uff1a" + taskId);
            return resMap;
        }
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        ISimpleProperty primaryKey = billEntityType.getPrimaryKey();
        Set<Object> idSet = primaryKey instanceof TextProp ? taskData.stream().map(p -> (String)p.get("id")).collect(Collectors.toSet()) : taskData.stream().map(p -> Long.parseLong((String)p.get("id"))).collect(Collectors.toSet());
        Map<String, List<DynamicObject>> allTaskData = this.getAllTaskData(taskId, billType, idSet);
        if (allTaskData.isEmpty()) {
            logger.info("\u67e5\u8be2\u4efb\u52a1\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\uff0c\u5355\u636e\u7c7b\u578b:" + billType + "\uff0cid\uff1a" + SerializationUtils.toJsonString(idSet));
            return resMap;
        }
        StringBuilder errInfo = new StringBuilder();
        int total = 0;
        for (DynamicObject workBenchCf : workBenchConfig) {
            QFilter qFilter = this.getTaskServiceConfigFilter(workBenchCf);
            if (qFilter == null) continue;
            boolean genTaskByEntry = workBenchCf.getBoolean("gentaskbyentry");
            String entryKey = workBenchCf.getString("entrykey");
            long cfTaskTypeId = workBenchCf.getLong("taskservicegroup.id");
            Set<String> matchCondtionSet = WorkBenchTaskCompleteServiceImpl.filterBySql(billType, idSet, genTaskByEntry, entryKey, qFilter);
            HashSet<Long> completeIdSet = new HashSet<Long>(16);
            if (matchCondtionSet.isEmpty()) {
                for (List list : allTaskData.values()) {
                    for (DynamicObject dynamicObject : list) {
                        long taskType = dynamicObject.getLong("tasktype");
                        if (cfTaskTypeId != taskType) continue;
                        long taskManageId = dynamicObject.getLong("id");
                        completeIdSet.add(taskManageId);
                    }
                }
            } else {
                for (Map map : taskData) {
                    String id;
                    String key = id = (String)map.get("id");
                    if (genTaskByEntry && StringUtils.isNotEmpty((CharSequence)entryKey)) {
                        String entryId = map.getOrDefault("rowid", "0");
                        key = id + entryId;
                    }
                    List<DynamicObject> taskList = allTaskData.get(key);
                    boolean matchCondition = matchCondtionSet.contains(key);
                    if (matchCondition) continue;
                    for (DynamicObject dynamicObject : taskList) {
                        long taskType = dynamicObject.getLong("tasktype");
                        if (cfTaskTypeId != taskType) continue;
                        long taskManageId = dynamicObject.getLong("id");
                        completeIdSet.add(taskManageId);
                    }
                }
            }
            int successCount = this.setTaskDataComplete(completeIdSet, errInfo);
            total += successCount;
        }
        resMap.put("num", total);
        if (errInfo.length() > 0) {
            logger.info("\u5de5\u4f5c\u53f0\u4efb\u52a1\u5b8c\u6210\u670d\u52a1\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)errInfo.toString());
            resMap.put("success", "false");
            resMap.put("msg", errInfo.toString());
        }
        return resMap;
    }

    private Map<String, List<DynamicObject>> getAllTaskData(long taskId, String billType, Set<Object> idSet) {
        QFilter filter = new QFilter("srcobj.number", "=", (Object)billType);
        filter.and("taskstatus", "=", (Object)"A");
        filter.and("tasktype.id", "=", (Object)taskId);
        filter.and("srcid", "in", idSet);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"msbd_wb_task_manage", (String)"id,srcid,srcentryid,tasktype,srcentrykey,srcbillno", (QFilter[])filter.toArray(), null);
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(query.size());
        for (DynamicObject dynamicObject : query) {
            String id = dynamicObject.getString("srcid");
            String entryKey = dynamicObject.getString("srcentrykey");
            String key = id;
            if (StringUtils.isNotEmpty((CharSequence)entryKey)) {
                String entryId = dynamicObject.getString("srcentryid");
                key = id + entryId;
            }
            List taskList = map.computeIfAbsent(key, k -> new ArrayList(8));
            taskList.add(dynamicObject);
        }
        return map;
    }

    private DynamicObject[] loadTaskServiceConfigs(String billNumber, long taskId) {
        QFilter filter = new QFilter("billobj.number", "=", (Object)billNumber);
        filter.and("enable", "=", (Object)"1");
        filter.and("taskservicegroup.id", "=", (Object)taskId);
        filter.and("group", "=", (Object)1931298209213604864L);
        return BusinessDataServiceHelper.load((String)"msbd_task_service_conf", (String)"gentaskbyentry,entrykey,bizorg,billobj,billoperation,filterjson_tag,filterformula_tag,taskservicegroup,tasksubjectcfg", (QFilter[])filter.toArray());
    }

    private QFilter getTaskServiceConfigFilter(DynamicObject configObject) {
        String billEntityNumber = configObject.getDynamicObject("billobj").getString("number");
        String filterJson = configObject.getString("filterjson_tag");
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)filterJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)billEntityNumber), filterCondition);
            filterBuilder.buildFilter(false);
            qFilter = filterBuilder.getQFilter();
        }
        return qFilter;
    }

    private int setTaskDataComplete(Set<Long> completeIdSet, StringBuilder errorInfo) {
        if (completeIdSet == null || completeIdSet.isEmpty()) {
            return 0;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"complete", (String)"msbd_wb_task_manage", (Object[])completeIdSet.toArray(), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            operationResult.getAllErrorOrValidateInfo().forEach(p -> errorInfo.append(p.getMessage()).append('\n'));
        }
        return operationResult.getSuccessPkIds().size();
    }

    public static Set<String> filterBySql(String entityNumber, Set<Object> billIds, boolean genTaskByEntry, String entryKey, QFilter filter) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter.and(filter);
        String selectedField = "id";
        if (genTaskByEntry && StringUtils.isNotEmpty((CharSequence)entryKey)) {
            selectedField = selectedField + "," + entryKey + ".id";
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityNumber, (String)selectedField, (QFilter[])qFilter.toArray(), null);
        HashSet<String> matchCondtionSet = new HashSet<String>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            String id = dynamicObject.getString("id");
            String entryId = "";
            if (genTaskByEntry && StringUtils.isNotEmpty((CharSequence)entryKey)) {
                entryId = dynamicObject.getString(entryKey + ".id");
            }
            String key = id + entryId;
            matchCondtionSet.add(key);
        }
        return matchCondtionSet;
    }
}

