/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.workbench;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.DefaultEcServiceIdempotentPropHelper;
import kd.mpscmm.msbd.mservice.api.workbench.WorkBenchTaskCreateService;
import kd.mpscmm.msbd.workbench.ext.InvWorkBenchDefaultExpand;
import kd.sdk.mpscmm.msbd.expoint.workbench.BizOperatorAndGroup;
import kd.sdk.mpscmm.msbd.expoint.workbench.IWorkBenchPlugin;

public class WorkBenchTaskCreateServiceImpl
extends BaseECService
implements WorkBenchTaskCreateService,
IdempotentService {
    private static final Log logger = LogFactory.getLog(WorkBenchTaskCreateServiceImpl.class);
    private Map<String, PluginProxy<IWorkBenchPlugin>> domainBizPluginMap;

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        long startTime = System.currentTimeMillis();
        return DefaultEcServiceIdempotentPropHelper.generate((String)this.getClass().getName(), (Object)param, (long)startTime);
    }

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        logger.info("WorkBenchTaskListServiceImpl.doExecute()\u5f00\u59cb\u5de5\u4f5c\u53f0\u4efb\u52a1\u6d41\u7a0b\u670d\u52a1:");
        CommonParam commonParam = (CommonParam)param;
        String entityType = (String)commonParam.get((Object)"entitytype");
        String operationKey = (String)commonParam.get((Object)"operationKey");
        String ids = (String)commonParam.get((Object)"ids");
        List idList = JSON.parseArray((String)ids, Object.class);
        RequestContext requestContext = RequestContext.get();
        if (requestContext.getUserId() == null) {
            requestContext.setUserId("1");
        }
        this.addWbTask(idList, entityType, operationKey);
        return null;
    }

    @Override
    public void addWbTask(List<Object> billIds, String billType, String operationKey) {
        DynamicObject[] workBenchConfig = this.loadTaskServiceConfigs(billType, operationKey);
        if (workBenchConfig == null || workBenchConfig.length == 0) {
            logger.info("\u67e5\u8be2\u4efb\u52a1\u670d\u52a1\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\uff0c\u5355\u636e\u7c7b\u578b:" + billType + "\uff0c\u64cd\u4f5c\uff1a" + operationKey);
            return;
        }
        Set<String> needQueryFieldsSet = this.getNeedQueryFields(workBenchConfig, billType);
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        String numberField = ((BillEntityType)billEntityType).getBillNo();
        needQueryFieldsSet.add(numberField);
        ISimpleProperty primaryKey = billEntityType.getPrimaryKey();
        needQueryFieldsSet.add(primaryKey.getName());
        String queryFields = String.join((CharSequence)",", needQueryFieldsSet);
        QFilter bizDataFilter = new QFilter(primaryKey.getName(), "in", billIds);
        DynamicObject[] bizDataArr = BusinessDataServiceHelper.load((String)billType, (String)queryFields, (QFilter[])bizDataFilter.toArray());
        if (bizDataArr == null || bizDataArr.length == 0) {
            logger.info("\u67e5\u8be2\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\uff0c\u5355\u636e\u7c7b\u578b:" + billType + "\uff0cid\uff1a" + JSON.toJSONString(billIds));
            return;
        }
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(bizDataArr.length);
        for (DynamicObject workBenchCf : workBenchConfig) {
            DynamicObject wbTaskServiceGroup = workBenchCf.getDynamicObject("taskservicegroup");
            String domainNumber = wbTaskServiceGroup.getString("domain.number");
            PluginProxy<IWorkBenchPlugin> pluginProxy = this.getWorkBenchPluginProxy(domainNumber);
            String taskSubjectCfg = workBenchCf.getString("tasksubjectcfg");
            List<Map<String, String>> taskSubjectConfList = Collections.emptyList();
            String splitSign = "";
            if (StringUtils.isNotEmpty((CharSequence)taskSubjectCfg)) {
                Map taskSubjectConfMap = (Map)SerializationUtils.fromJsonString((String)taskSubjectCfg, Map.class);
                taskSubjectConfList = taskSubjectConfMap.getOrDefault("config", Collections.emptyList());
                splitSign = taskSubjectConfMap.getOrDefault("split", "");
            }
            boolean genTaskByEntry = workBenchCf.getBoolean("gentaskbyentry");
            QFilter qFilter = this.getTaskServiceConfigFilter(workBenchCf);
            if (genTaskByEntry) {
                String entryKey = workBenchCf.getString("entrykey");
                List<Object> matchedEntryIds = this.getMatchedEntryIds(billType, entryKey, billIds, qFilter);
                DynamicObject[] dynamicObjectArray = bizDataArr;
                int n = dynamicObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject bizData = dynamicObjectArray[i];
                    this.genTaskByEntry(bizData, taskList, workBenchCf, matchedEntryIds, splitSign, taskSubjectConfList, pluginProxy);
                }
                continue;
            }
            List<Object> matchedIds = this.getMatchedBillIds(billType, billIds, qFilter);
            if (matchedIds == null || matchedIds.isEmpty()) continue;
            for (DynamicObject bizData : bizDataArr) {
                if (!matchedIds.contains(bizData.getPkValue())) continue;
                this.genTask(bizData, taskList, workBenchCf, splitSign, taskSubjectConfList, pluginProxy);
            }
        }
        if (!taskList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[0]));
        }
    }

    private void genTask(DynamicObject bizData, List<DynamicObject> taskList, DynamicObject workBenchCf, String splitSign, List<Map<String, String>> taskSubjectConfList, PluginProxy<IWorkBenchPlugin> pluginProxy) {
        DynamicObject wbTaskServiceGroup = workBenchCf.getDynamicObject("taskservicegroup");
        String bizOrgKey = workBenchCf.getString("bizorg");
        IDataEntityType dataEntityType = bizData.getDataEntityType();
        String numberField = ((BillEntityType)dataEntityType).getBillNo();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        DynamicObject taskManage = BusinessDataServiceHelper.newDynamicObject((String)"msbd_wb_task_manage");
        String subject = this.genSubject(splitSign, taskSubjectConfList, false, null, bizData, null, properties);
        taskManage.set("subject", (Object)subject);
        taskManage.set("srcbillno", (Object)(StringUtils.isEmpty((CharSequence)numberField) ? "" : bizData.getString(numberField)));
        taskManage.set("srcid", bizData.getPkValue());
        taskManage.set("org", StringUtils.isNotEmpty((CharSequence)bizOrgKey) ? bizData.get(bizOrgKey) : Long.valueOf(0L));
        taskManage.set("tasktype", (Object)wbTaskServiceGroup);
        taskManage.set("taskstatus", (Object)"A");
        taskManage.set("srcobj", (Object)dataEntityType.getName());
        taskManage.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        this.getBizGroupAndUser(bizData, false, pluginProxy, null, taskManage);
        taskList.add(taskManage);
    }

    private void genTaskByEntry(DynamicObject bizData, List<DynamicObject> taskList, DynamicObject workBenchCf, List<Object> matchedEntryIds, String splitSign, List<Map<String, String>> taskSubjectConfList, PluginProxy<IWorkBenchPlugin> pluginProxy) {
        DynamicObject wbTaskServiceGroup = workBenchCf.getDynamicObject("taskservicegroup");
        String bizOrgKey = workBenchCf.getString("bizorg");
        IDataEntityType dataEntityType = bizData.getDataEntityType();
        String numberField = ((BillEntityType)dataEntityType).getBillNo();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        String[] orgKeySplit = bizOrgKey.split("\\.");
        String entryKey = workBenchCf.getString("entrykey");
        DynamicObjectCollection entryCollection = bizData.getDynamicObjectCollection(entryKey);
        for (DynamicObject entryData : entryCollection) {
            if (matchedEntryIds != null && !matchedEntryIds.contains(entryData.get("id"))) continue;
            DynamicObject taskManage = BusinessDataServiceHelper.newDynamicObject((String)"msbd_wb_task_manage");
            String subject = this.genSubject(splitSign, taskSubjectConfList, true, entryKey, bizData, entryData, properties);
            taskManage.set("subject", (Object)subject);
            taskManage.set("srcbillno", (Object)(StringUtils.isEmpty((CharSequence)numberField) ? "" : bizData.getString(numberField)));
            taskManage.set("srcid", bizData.getPkValue());
            taskManage.set("srcentryid", entryData.getPkValue());
            taskManage.set("srcentrykey", (Object)entryKey);
            Object bizOrg = null;
            bizOrg = orgKeySplit.length == 2 ? entryData.get(orgKeySplit[1]) : bizData.get(bizOrgKey);
            taskManage.set("org", bizOrg);
            taskManage.set("tasktype", (Object)wbTaskServiceGroup);
            taskManage.set("taskstatus", (Object)"A");
            taskManage.set("srcobj", (Object)dataEntityType.getName());
            taskManage.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            this.getBizGroupAndUser(bizData, true, pluginProxy, entryData, taskManage);
            taskList.add(taskManage);
        }
    }

    private PluginProxy<IWorkBenchPlugin> getWorkBenchPluginProxy(String domainNumber) {
        PluginProxy pluginProxy;
        if (this.domainBizPluginMap == null) {
            this.domainBizPluginMap = new HashMap<String, PluginProxy<IWorkBenchPlugin>>(8);
        }
        if ((pluginProxy = this.domainBizPluginMap.get(domainNumber)) != null) {
            return pluginProxy;
        }
        if ("IM".equals(domainNumber)) {
            InvWorkBenchDefaultExpand invWorkBenchDefaultExpand = new InvWorkBenchDefaultExpand();
            pluginProxy = PluginProxy.create((Object)invWorkBenchDefaultExpand, IWorkBenchPlugin.class, (String)"MPSCMM_MSBD_WORKBENCH", null);
        } else {
            pluginProxy = PluginProxy.create(null, IWorkBenchPlugin.class, (String)"MPSCMM_MSBD_WORKBENCH", null);
        }
        this.domainBizPluginMap.put(domainNumber, (PluginProxy<IWorkBenchPlugin>)pluginProxy);
        return pluginProxy;
    }

    private void getBizGroupAndUser(DynamicObject bizData, boolean genTaskByEntry, PluginProxy<IWorkBenchPlugin> pluginProxy, DynamicObject entryData, DynamicObject taskManage) {
        List returnList = null;
        try {
            returnList = pluginProxy.callReplaceIfPresent(p -> p.getBizOperatorAndGroup(bizData, entryData, genTaskByEntry));
        }
        catch (Exception e) {
            logger.error("WorkBenchTaskCreateServiceImpl.getBizGroupAndUser\u8c03\u7528\u6269\u5c55\u70b9\u67e5\u8be2\u4e1a\u52a1\u5458\u548c\u4e1a\u52a1\u7ec4\u5931\u8d25\uff1a", (Throwable)e);
        }
        if (returnList != null && !returnList.isEmpty()) {
            for (BizOperatorAndGroup result : returnList) {
                if (result == null) continue;
                taskManage.set("bizgroup", (Object)result.getGroup());
                taskManage.set("bizuser", (Object)result.getOperator());
                break;
            }
        }
    }

    private DynamicObject[] loadTaskServiceConfigs(String billNumber, String operationKey) {
        QFilter filter = new QFilter("billobj.number", "=", (Object)billNumber);
        filter.and("enable", "=", (Object)"1");
        filter.and("billoperation", "=", (Object)operationKey);
        filter.and("group", "=", (Object)1931298209213604864L);
        return BusinessDataServiceHelper.load((String)"msbd_task_service_conf", (String)"gentaskbyentry,entrykey,bizorg,billobj,billoperation,filterjson_tag,filterformula_tag,taskservicegroup,tasksubjectcfg", (QFilter[])filter.toArray());
    }

    private QFilter getTaskServiceConfigFilter(DynamicObject configObject) {
        String billEntityNumber = configObject.getDynamicObject("billobj").getString("number");
        String filterJson = configObject.getString("filterjson_tag");
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)filterJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)billEntityNumber), filterCondition);
            filterBuilder.buildFilter(false);
            qFilter = filterBuilder.getQFilter();
        }
        return qFilter;
    }

    public List<Object> getMatchedBillIds(String entityNumber, List<Object> billIds, QFilter filter) {
        if (filter == null) {
            return billIds;
        }
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter.and(filter);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])qFilter.toArray(), null);
        return collection.stream().map(item -> item.get("id")).collect(Collectors.toList());
    }

    public List<Object> getMatchedEntryIds(String entityNumber, String entryKey, List<Object> billIds, QFilter filter) {
        if (filter == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter.and(filter);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityNumber, (String)(entryKey + ".id"), (QFilter[])qFilter.toArray(), null);
        return collection.stream().map(item -> item.get(entryKey + ".id")).collect(Collectors.toList());
    }

    private String genSubject(String splitSign, List<Map<String, String>> subjectCfgList, boolean genByEntry, String entryKey, DynamicObject bizData, DynamicObject entryData, DataEntityPropertyCollection properties) {
        StringBuilder appendDataString = new StringBuilder();
        for (int i = 0; i < subjectCfgList.size(); ++i) {
            String billField;
            Map<String, String> cfgMap;
            String constant;
            if (i != 0 && StringUtils.isNotEmpty((CharSequence)splitSign)) {
                appendDataString.append(splitSign);
            }
            if (StringUtils.isNotEmpty((CharSequence)(constant = (cfgMap = subjectCfgList.get(i)).get("const")))) {
                appendDataString.append(constant);
            }
            if (!StringUtils.isNotEmpty((CharSequence)(billField = cfgMap.get("billfield")))) continue;
            try {
                this.buildBillFieldValue(genByEntry, entryKey, bizData, entryData, appendDataString, properties, billField);
                continue;
            }
            catch (Exception e) {
                logger.error("\u6784\u5efa\u4efb\u52a1\u4e3b\u9898\u5931\u8d25\u3002", (Throwable)e);
            }
        }
        String appendNumberString = appendDataString.toString();
        return appendNumberString.length() > 255 ? appendNumberString.substring(0, 255) : appendNumberString;
    }

    private void buildBillFieldValue(boolean genByEntry, String entryKey, DynamicObject bizData, DynamicObject entryData, StringBuilder appendDataString, DataEntityPropertyCollection properties, String billField) {
        String[] billFieldSplit = billField.split("\\.");
        if (billFieldSplit.length < 2) {
            appendDataString.append(this.getFriendlyValue(bizData, billField));
            return;
        }
        String preKey = billFieldSplit[0];
        if (genByEntry && preKey.equals(entryKey)) {
            appendDataString.append(this.getFriendlyValue(entryData, billField.replace(preKey + '.', "")));
            return;
        }
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)preKey);
        if (iDataEntityProperty instanceof EntryProp) {
            DynamicObjectCollection dynamicObjectCollection = bizData.getDynamicObjectCollection(preKey);
            if (!dynamicObjectCollection.isEmpty()) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
                appendDataString.append(this.getFriendlyValue(dynamicObject, billField.replace(preKey + '.', "")));
            }
        } else {
            appendDataString.append(this.getFriendlyValue(bizData, billField));
        }
    }

    private Object getFriendlyValue(DynamicObject data, String key) {
        Object val = data.get(key);
        if (val == null) {
            return "";
        }
        DataEntityPropertyCollection properties = data.getDataEntityType().getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)key);
        if (iDataEntityProperty instanceof QtyProp) {
            if (((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) {
                return "";
            }
        } else {
            ILocaleString localeString;
            if (iDataEntityProperty instanceof ComboProp) {
                return ((ComboProp)iDataEntityProperty).getItemByName(val.toString());
            }
            if (iDataEntityProperty instanceof MuliLangTextProp && ((localeString = data.getLocaleString(key)) == null || localeString.getLocaleValue() == null)) {
                return "";
            }
        }
        return val;
    }

    private Set<String> getNeedQueryFields(DynamicObject[] workBenchConfig, String billType) {
        HashSet<String> fieldSet = new HashSet<String>(16);
        for (DynamicObject wbConfig : workBenchConfig) {
            String bizOrgKey;
            boolean genTaskByEntry = wbConfig.getBoolean("gentaskbyentry");
            String entryKey = wbConfig.getString("entrykey");
            if (genTaskByEntry && StringUtils.isNotBlank((CharSequence)entryKey)) {
                fieldSet.add(entryKey);
            }
            if (StringUtils.isNotBlank((CharSequence)(bizOrgKey = wbConfig.getString("bizorg")))) {
                fieldSet.add(bizOrgKey);
            }
            String taskSubjectCfg = wbConfig.getString("tasksubjectcfg");
            List subjectCfgList = Collections.emptyList();
            if (StringUtils.isNotEmpty((CharSequence)taskSubjectCfg)) {
                Map taskSubjectConfMap = (Map)SerializationUtils.fromJsonString((String)taskSubjectCfg, Map.class);
                subjectCfgList = taskSubjectConfMap.getOrDefault("config", Collections.emptyList());
            }
            for (Map cfgMap : subjectCfgList) {
                String billField = (String)cfgMap.get("billfield");
                if (!StringUtils.isNotBlank((CharSequence)billField)) continue;
                String[] splitFields = billField.split("\\.");
                if (splitFields.length > 2) {
                    String fields = splitFields[0] + "." + splitFields[1];
                    fieldSet.add(fields);
                    continue;
                }
                fieldSet.add(billField);
            }
            DynamicObject wbTaskServiceGroup = wbConfig.getDynamicObject("taskservicegroup");
            String domainNumber = wbTaskServiceGroup.getString("domain.number");
            this.getPrepareFiled(billType, domainNumber, fieldSet);
        }
        return fieldSet;
    }

    private void getPrepareFiled(String billType, String domainNumber, Set<String> fieldSet) {
        PluginProxy<IWorkBenchPlugin> pluginProxy = this.getWorkBenchPluginProxy(domainNumber);
        List prepareFiledSetList = null;
        try {
            prepareFiledSetList = pluginProxy.callReplaceIfPresent(p -> p.preparePropertys(billType, domainNumber));
        }
        catch (Exception e) {
            logger.error("WorkBenchTaskCreateServiceImpl.getNeedQueryFields\u8c03\u7528\u6269\u5c55\u70b9\u67e5\u8be2\u51c6\u5907\u5b57\u6bb5\u5931\u8d25\uff1a", (Throwable)e);
        }
        if (prepareFiledSetList != null && !prepareFiledSetList.isEmpty()) {
            for (Set result : prepareFiledSetList) {
                if (result == null) continue;
                fieldSet.addAll(result);
                break;
            }
        }
    }
}

