/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.workbench;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mpscmm.msbd.business.helper.DefaultEcServiceIdempotentPropHelper;
import kd.mpscmm.msbd.mservice.api.workbench.WorkBenchTaskUnCreateService;
import org.apache.commons.collections4.CollectionUtils;

public class WorkBenchTaskUnCreateServiceImpl
extends BaseECService
implements WorkBenchTaskUnCreateService,
IdempotentService {
    private static final Log logger = LogFactory.getLog(WorkBenchTaskUnCreateServiceImpl.class);

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        long startTime = System.currentTimeMillis();
        return DefaultEcServiceIdempotentPropHelper.generate((String)this.getClass().getName(), (Object)param, (long)startTime);
    }

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        logger.info("WorkBenchTaskListServiceImpl.doExecute()\u5f00\u59cb\u5de5\u4f5c\u53f0\u4efb\u52a1\u6d41\u7a0b\u670d\u52a1:");
        CommonParam commonParam = (CommonParam)param;
        String entityType = (String)commonParam.get((Object)"entitytype");
        String operationKey = (String)commonParam.get((Object)"operationKey");
        String ids = (String)commonParam.get((Object)"ids");
        List idList = JSON.parseArray((String)ids, Object.class);
        RequestContext requestContext = RequestContext.get();
        if (requestContext.getUserId() == null) {
            requestContext.setUserId("1");
        }
        this.removeWbTask(idList, entityType, operationKey);
        return null;
    }

    @Override
    public void removeWbTask(List<Object> billIds, String billType, String operationKey) {
        DynamicObject[] workBenchConfig = this.loadTaskServiceConfigs(billType, operationKey);
        if (workBenchConfig == null || workBenchConfig.length == 0) {
            logger.info("\u67e5\u8be2\u4efb\u52a1\u670d\u52a1\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\uff0c\u5355\u636e\u7c7b\u578b:" + billType + "\uff0c\u64cd\u4f5c\uff1a" + operationKey);
            return;
        }
        ArrayList<Object> srcIdList = new ArrayList<Object>(billIds.size());
        for (DynamicObject workBenchCf : workBenchConfig) {
            QFilter qFilter = this.getTaskServiceConfigFilter(workBenchCf);
            List<Object> filterBillIds = WorkBenchTaskUnCreateServiceImpl.filterBySql(billType, billIds, qFilter);
            if (CollectionUtils.isEmpty(filterBillIds)) continue;
            for (Object billId : billIds) {
                if (!filterBillIds.contains(billId)) continue;
                srcIdList.add(billId);
            }
            if (srcIdList.isEmpty()) continue;
            long taskTypeId = workBenchCf.getLong("taskservicegroup.id");
            QFilter delFilter = new QFilter("srcid", "in", srcIdList);
            delFilter.and("tasktype.id", "=", (Object)taskTypeId);
            try {
                DeleteServiceHelper.delete((String)"msbd_wb_task_manage", (QFilter[])delFilter.toArray());
            }
            catch (Exception e) {
                logger.error("\u5220\u9664\u4efb\u52a1\uff0c\u5355\u636e\u7c7b\u578b:" + billType + "\uff0cid\uff1a" + JSON.toJSONString(srcIdList) + "\u4efb\u52a1\u5206\u7c7bid\uff1a" + taskTypeId + "\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private DynamicObject[] loadTaskServiceConfigs(String billNumber, String operationKey) {
        QFilter filter = new QFilter("billobj.number", "=", (Object)billNumber);
        filter.and("enable", "=", (Object)"1");
        filter.and("billoperation", "=", (Object)operationKey);
        filter.and("group", "=", (Object)1931298413610316800L);
        return BusinessDataServiceHelper.load((String)"msbd_task_service_conf", (String)"gentaskbyentry,entrykey,bizorg,billobj,billoperation,filterjson_tag,filterformula_tag,taskservicegroup", (QFilter[])filter.toArray());
    }

    private QFilter getTaskServiceConfigFilter(DynamicObject configObject) {
        String billEntityNumber = configObject.getDynamicObject("billobj").getString("number");
        String filterJson = configObject.getString("filterjson_tag");
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)filterJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)billEntityNumber), filterCondition);
            filterBuilder.buildFilter(false);
            qFilter = filterBuilder.getQFilter();
        }
        return qFilter;
    }

    public static List<Object> filterBySql(String entityNumber, List<Object> billIds, QFilter filter) {
        if (filter == null) {
            return billIds;
        }
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter.and(filter);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])qFilter.toArray(), null);
        return collection.stream().map(item -> item.get("id")).collect(Collectors.toList());
    }
}

