/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.utils.MetadataUtils;

public class AmountPlanHelper {
    public static final String ENTRY_ID = "entrynum";
    public static final String TOTALALLAMOUNT = "totalallamount";
    public static final String BIZTIME = "biztime";
    public static final String AMOUNTCONDITION = "amountcondition";
    public static final String ISPAYRATE = "ispayrate";
    public static final String SETTLECURRENCY = "settlecurrency";
    public static final String ENTRY_ITEMNAME = "itemname";
    public static final String ENTRY_AMOUNT = "amount";
    public static final String ENTRY_RATE = "rate";
    public static final String ENTRY_ISPREPAY = "isprepay";
    public static final String ENTRY_AMOUNTDATE = "amountdate";
    public static final String CHANGETYPE = "changetype";
    public static final String PLANTYPE = "plantype";
    private static final BigDecimal HUNDRED = new BigDecimal(100);

    public static void changeAmountConditionForView(CommonContext context, IFormView view) {
        int rowIndex;
        int i;
        if (context == null) {
            return;
        }
        Map<String, String> properytMapping = context.getProperytMapping();
        if (properytMapping == null) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject bill = model.getDataEntity(true);
        String entityId = context.getEntityId();
        String entryNoKey = properytMapping.get(ENTRY_ID);
        String isPayRateKey = properytMapping.get(ISPAYRATE);
        String amountConditionKey = properytMapping.get(AMOUNTCONDITION);
        String itemNameKey = properytMapping.get(ENTRY_ITEMNAME);
        String isPrePayKey = properytMapping.get(ENTRY_ISPREPAY);
        String rateKey = properytMapping.get(ENTRY_RATE);
        String amountKey = properytMapping.get(ENTRY_AMOUNT);
        String amountDateKey = properytMapping.get(ENTRY_AMOUNTDATE);
        String changeTypeKey = properytMapping.get(CHANGETYPE);
        DynamicObject amountCondition = (DynamicObject)model.getValue(amountConditionKey);
        if (amountCondition == null) {
            return;
        }
        model.setValue(isPayRateKey, (Object)(!"B".equals(amountCondition.get("basis")) ? 1 : 0));
        int startRowIndex = 0;
        boolean isChangeBill = MetadataUtils.isChangeBill(entityId);
        if (isChangeBill) {
            ArrayList<Integer> newRowIndexs = new ArrayList<Integer>(10);
            int entryRowCount = model.getEntryRowCount(entryNoKey);
            for (int i2 = 0; i2 < entryRowCount; ++i2) {
                String rowChangeType = (String)model.getValue(changeTypeKey, i2);
                if (!"A".equals(rowChangeType)) {
                    model.setValue(changeTypeKey, (Object)"C", i2);
                    ++startRowIndex;
                    continue;
                }
                newRowIndexs.add(i2);
            }
            if (newRowIndexs.size() > 0) {
                model.deleteEntryRows(entryNoKey, newRowIndexs.stream().mapToInt(Integer::valueOf).toArray());
            }
        } else {
            model.deleteEntryData(entryNoKey);
        }
        List<Map<String, Object>> amountConditinoEntryInfo = AmountPlanHelper.getAmountConditinoEntryInfo(properytMapping, bill);
        if (amountConditinoEntryInfo == null || amountConditinoEntryInfo.size() == 0) {
            return;
        }
        model.batchCreateNewEntryRow(entryNoKey, amountConditinoEntryInfo.size());
        for (i = 0; i < amountConditinoEntryInfo.size(); ++i) {
            rowIndex = startRowIndex + i;
            Map<String, Object> amountEntryInfo = amountConditinoEntryInfo.get(i);
            model.beginInit();
            model.setValue(itemNameKey, amountEntryInfo.get(ENTRY_ITEMNAME), rowIndex);
            model.setValue(isPrePayKey, amountEntryInfo.get("ispre"), rowIndex);
            model.setValue(rateKey, amountEntryInfo.get(ENTRY_RATE), rowIndex);
            model.setValue(amountKey, amountEntryInfo.get(ENTRY_AMOUNT), rowIndex);
            Date amountDate = (Date)amountEntryInfo.get("date");
            if (amountDate != null) {
                model.setValue(amountDateKey, (Object)amountDate, rowIndex);
            }
            model.endInit();
        }
        AmountPlanHelper.calAmountPlanForView(context, view);
        for (i = 0; i < amountConditinoEntryInfo.size(); ++i) {
            rowIndex = startRowIndex + i;
            view.updateView(itemNameKey, rowIndex);
            view.updateView(isPrePayKey, rowIndex);
            view.updateView(amountDateKey, rowIndex);
        }
    }

    public static void changeAmountConditionForDynamicObject(CommonContext commonContext, DynamicObject bill) {
        if (bill == null) {
            return;
        }
        Map<String, String> properytMapping = commonContext.getProperytMapping();
        String entryNoKey = properytMapping.get(ENTRY_ID);
        String amountConditionKey = properytMapping.get(AMOUNTCONDITION);
        String itemNameKey = properytMapping.get(ENTRY_ITEMNAME);
        String isPrePayKey = properytMapping.get(ENTRY_ISPREPAY);
        String rateKey = properytMapping.get(ENTRY_RATE);
        String amountKey = properytMapping.get(ENTRY_AMOUNT);
        String amountDateKey = properytMapping.get(ENTRY_AMOUNTDATE);
        DynamicObjectCollection amountPlanEntrys = bill.getDynamicObjectCollection(entryNoKey);
        if (amountPlanEntrys != null && !amountPlanEntrys.isEmpty()) {
            AmountPlanHelper.calAmountPlanForDynamicObject(commonContext, bill);
            return;
        }
        DynamicObject amountCondition = (DynamicObject)bill.get(amountConditionKey);
        if (amountCondition == null) {
            return;
        }
        List<Map<String, Object>> amountConditinoEntryInfos = AmountPlanHelper.getAmountConditinoEntryInfo(properytMapping, bill);
        if (amountConditinoEntryInfos == null || amountConditinoEntryInfos.size() == 0 || amountPlanEntrys == null) {
            return;
        }
        for (Map<String, Object> amountConditionEntry : amountConditinoEntryInfos) {
            DynamicObject amountPlanentry = amountPlanEntrys.addNew();
            amountPlanentry.set(itemNameKey, amountConditionEntry.get(ENTRY_ITEMNAME));
            amountPlanentry.set(isPrePayKey, amountConditionEntry.get("ispre"));
            amountPlanentry.set(rateKey, amountConditionEntry.get(ENTRY_RATE));
            amountPlanentry.set(amountKey, amountConditionEntry.get(ENTRY_AMOUNT));
            Date date = (Date)amountConditionEntry.get("date");
            if (date == null) continue;
            amountPlanentry.set(amountDateKey, (Object)date);
        }
        AmountPlanHelper.calAmountPlanForDynamicObject(commonContext, bill);
    }

    public static void calAmountPlanForView(CommonContext context, IFormView view) {
        if (context == null || view == null) {
            return;
        }
        DynamicObject bill = view.getModel().getDataEntity(true);
        Map<String, String> properytMapping = context.getProperytMapping();
        if (properytMapping == null || properytMapping.isEmpty()) {
            return;
        }
        String amountPlanEntryKey = properytMapping.get(ENTRY_ID);
        String amountKey = properytMapping.get(ENTRY_AMOUNT);
        String rateKey = properytMapping.get(ENTRY_RATE);
        AmountPlanHelper.calAmountPlanForDynamicObject(context, bill);
        int entryRowCount = view.getModel().getEntryRowCount(amountPlanEntryKey);
        for (int i = 0; i < entryRowCount; ++i) {
            view.updateView(amountKey, i);
            view.updateView(rateKey, i);
        }
    }

    public static void calAmountPlanForDynamicObject(CommonContext context, DynamicObject bill) {
        DynamicObject currency;
        int precision;
        if (bill == null || context == null) {
            return;
        }
        Map<String, String> properytMapping = context.getProperytMapping();
        if (properytMapping == null || properytMapping.isEmpty()) {
            return;
        }
        String amountPlanEntryKey = properytMapping.get(ENTRY_ID);
        String amountKey = properytMapping.get(ENTRY_AMOUNT);
        String rateKey = properytMapping.get(ENTRY_RATE);
        String settleCurrencyKey = properytMapping.get(SETTLECURRENCY);
        String isPayRateKey = properytMapping.get(ISPAYRATE);
        String changeTypeKey = properytMapping.get(CHANGETYPE);
        String totalAmountAndTaxKey = properytMapping.get(TOTALALLAMOUNT);
        DynamicObjectCollection amountPlanEntry = bill.getDynamicObjectCollection(amountPlanEntryKey);
        if (amountPlanEntry == null || amountPlanEntry.isEmpty()) {
            return;
        }
        boolean isPayRate = bill.getBoolean(isPayRateKey);
        BigDecimal totalAllAmount = bill.getBigDecimal(totalAmountAndTaxKey);
        if (totalAllAmount == null) {
            totalAllAmount = BigDecimal.ZERO;
        }
        int n = precision = (currency = bill.getDynamicObject(settleCurrencyKey)) == null ? 10 : currency.getInt("amtprecision");
        if (isPayRate) {
            BigDecimal rateTotal = BigDecimal.ZERO;
            for (DynamicObject entry : amountPlanEntry) {
                BigDecimal rate = entry.getBigDecimal(rateKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType) || rate == null) continue;
                rateTotal = rateTotal.add(rate);
            }
            BigDecimal amountTotal = BigDecimal.ZERO;
            for (int i = 0; i < amountPlanEntry.size(); ++i) {
                DynamicObject entry = (DynamicObject)amountPlanEntry.get(i);
                BigDecimal rate = entry.getBigDecimal(rateKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType)) continue;
                BigDecimal amount = rate == null || BigDecimal.ZERO.compareTo(rate) == 0 ? BigDecimal.ZERO : (i == amountPlanEntry.size() - 1 && rateTotal.compareTo(HUNDRED) == 0 ? totalAllAmount.subtract(amountTotal) : totalAllAmount.multiply(rate).divide(HUNDRED, precision, RoundingMode.HALF_UP));
                amountTotal = amountTotal.add(amount);
                entry.set(amountKey, (Object)amount);
            }
        } else {
            BigDecimal amountTotal = BigDecimal.ZERO;
            for (DynamicObject entry : amountPlanEntry) {
                BigDecimal amount = entry.getBigDecimal(amountKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType) || amount == null) continue;
                amount = amount.setScale(precision, RoundingMode.HALF_UP);
                amountTotal = amountTotal.add(amount);
            }
            BigDecimal rateTotal = BigDecimal.ZERO;
            for (int i = 0; i < amountPlanEntry.size(); ++i) {
                BigDecimal rate;
                DynamicObject entry = (DynamicObject)amountPlanEntry.get(i);
                BigDecimal amount = entry.getBigDecimal(amountKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType)) continue;
                if (amount == null || totalAllAmount.compareTo(BigDecimal.ZERO) == 0 || BigDecimal.ZERO.compareTo(amount) == 0) {
                    rate = BigDecimal.ZERO;
                } else if (i == amountPlanEntry.size() - 1 && amountTotal.compareTo(totalAllAmount) == 0) {
                    rate = HUNDRED.subtract(rateTotal);
                } else {
                    amount = amount.setScale(precision, RoundingMode.HALF_UP);
                    rate = amount.multiply(HUNDRED).divide(totalAllAmount, 2, RoundingMode.HALF_UP);
                }
                rateTotal = rateTotal.add(rate);
                entry.set(rateKey, (Object)rate);
                entry.set(amountKey, (Object)amount);
            }
        }
    }

    private static List<Map<String, Object>> getAmountConditinoEntryInfo(Map<String, String> properytMapping, DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        String amountConditionKey = properytMapping.get(AMOUNTCONDITION);
        String totalAmountAndTaxKey = properytMapping.get(TOTALALLAMOUNT);
        String bizTimeKey = properytMapping.get(BIZTIME);
        String planType = properytMapping.get(PLANTYPE);
        String isPayRateKey = properytMapping.get(ISPAYRATE);
        List<Map<String, Object>> amountConditionEntrys = new ArrayList<Map<String, Object>>(10);
        DynamicObject amountCondition = bill.getDynamicObject(amountConditionKey);
        if (amountCondition == null) {
            return null;
        }
        Long amountConditionId = (Long)amountCondition.getPkValue();
        if ("purchase".equals(planType)) {
            BigDecimal totalAllAmount = bill.getBigDecimal(totalAmountAndTaxKey);
            Date bizTime = (Date)bill.get(bizTimeKey);
            amountCondition = BusinessDataServiceHelper.loadSingleFromCache((Object)amountConditionId, (String)"bd_paycondition");
            amountConditionEntrys = (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"PayConditionService", (String)"getPayPlanData", (Object[])new Object[]{amountConditionId, bizTime, null, null, null, totalAllAmount});
            if (amountConditionEntrys == null || amountConditionEntrys.size() == 0) {
                return null;
            }
            HashSet<Long> itemNamePks = new HashSet<Long>();
            for (Map<String, Object> oneEntry : amountConditionEntrys) {
                if (oneEntry.get(ENTRY_ITEMNAME) == null) continue;
                itemNamePks.add((Long)oneEntry.get(ENTRY_ITEMNAME));
            }
            Map itemNameMap = new HashMap(16);
            if (itemNamePks.size() != 0) {
                itemNameMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)itemNamePks.toArray())});
            }
            for (Map map : amountConditionEntrys) {
                Date date = (Date)map.get("date");
                Long itemname = (Long)map.get(ENTRY_ITEMNAME);
                if (date == null) {
                    date = bizTime;
                    map.put("date", date);
                }
                if (itemname == null) continue;
                map.put(ENTRY_ITEMNAME, itemNameMap.get(itemname));
            }
        } else if ("sales".equals(planType)) {
            amountCondition = BusinessDataServiceHelper.loadSingleFromCache((Object)amountConditionId, (String)"bd_reccondition");
            DynamicObjectCollection entitys = amountCondition.getDynamicObjectCollection("entry");
            String basis = amountCondition.getString("basis");
            if (entitys == null || entitys.size() == 0) {
                return null;
            }
            for (int i = 0; i < entitys.size(); ++i) {
                DynamicObject row = (DynamicObject)entitys.get(i);
                HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
                DynamicObject dynamicObject = (DynamicObject)row.get(ENTRY_ITEMNAME);
                boolean ispre = row.getBoolean("ispre");
                map.put("ispre", Boolean.valueOf(ispre));
                map.put(ENTRY_ITEMNAME, (Comparable<Boolean>)(dynamicObject == null ? null : dynamicObject));
                if ("B".equals(basis)) {
                    BigDecimal amount = row.getBigDecimal(ENTRY_AMOUNT);
                    map.put(ENTRY_AMOUNT, amount);
                    map.put(ENTRY_RATE, BigDecimal.ZERO);
                } else {
                    BigDecimal rate = row.getBigDecimal(ENTRY_RATE);
                    map.put(ENTRY_RATE, rate);
                    map.put(ENTRY_AMOUNT, BigDecimal.ZERO);
                }
                amountConditionEntrys.add(map);
            }
        }
        bill.set(isPayRateKey, (Object)(!"B".equals(amountCondition.get("basis")) ? 1 : 0));
        return amountConditionEntrys;
    }
}

