/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.enums.UnitConvertDirEnum;
import kd.mpscmm.msbd.common.pojo.BillQuantityInfo;

public class BillQuantityHelper {
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    public static final String UNIT_PRECISION = "precision";
    public static final String UNIT_PRECISIONTYPE = "precisionaccount";
    public static final String CONV_NUMERATOR = "numerator";
    public static final String CONV_DENOMINATOR = "denominator";

    public static Map<String, Object> calQuantity(BillQuantityInfo quantityInfo) {
        DynamicObject master;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject material = quantityInfo.getMaterial();
        BigDecimal qty = quantityInfo.getQty();
        DynamicObject unit = quantityInfo.getUnit();
        BigDecimal baseQty = quantityInfo.getBaseQty();
        DynamicObject baseUnit = quantityInfo.getBaseUnit();
        BigDecimal auxQty = quantityInfo.getAuxQty();
        DynamicObject auxUnit = quantityInfo.getAuxUnit();
        if (material != null && (master = material.getDynamicObject("masterid")) != null) {
            Long masterId = (Long)master.getPkValue();
            baseUnit = master.getDynamicObject("baseunit");
            baseQty = BillQuantityHelper.getDesQtyConv(masterId, unit, qty, baseUnit);
            String unitConvertDir = master.getString("unitconvertdir");
            if (quantityInfo.getCommonContext().getProperytMapping().get("QTY").equalsIgnoreCase(quantityInfo.getChangePropertyName()) || quantityInfo.getCommonContext().getProperytMapping().get("UNIT").equalsIgnoreCase(quantityInfo.getChangePropertyName())) {
                baseUnit = master.getDynamicObject("baseunit");
                baseQty = BillQuantityHelper.getDesQtyConv(masterId, unit, qty, baseUnit);
                int precision = BillQuantityHelper.getPrecision(unit);
                qty = qty.setScale(precision, BillQuantityHelper.getPrecisionType(unit));
                if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    auxQty = BillQuantityHelper.getDesQtyConv(masterId, baseUnit, baseQty, auxUnit);
                }
            } else if ((quantityInfo.getCommonContext().getProperytMapping().get("AUXQTY").equalsIgnoreCase(quantityInfo.getChangePropertyName()) || quantityInfo.getCommonContext().getProperytMapping().get("AUXUNIT").equalsIgnoreCase(quantityInfo.getChangePropertyName())) && (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir))) {
                baseQty = BillQuantityHelper.getDesQtyConv(masterId, auxUnit, auxQty, baseUnit);
                qty = BillQuantityHelper.getDesQtyConv(masterId, baseUnit, baseQty, unit);
            }
        }
        result.put(quantityInfo.getProperytMappingName("QTY"), qty);
        result.put(quantityInfo.getProperytMappingName("BASEQTY"), baseQty);
        result.put(quantityInfo.getProperytMappingName("AUXQTY"), auxQty);
        return result;
    }

    public static BigDecimal getDesQtyConv(Long materialId, Long srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(ZERO) != 0) {
            Long desUnitID = (Long)desUnit.getPkValue();
            if (srcUnit.equals(desUnitID)) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnitID);
                if (muConv != null) {
                    int numberator = muConv.getInt(CONV_NUMERATOR);
                    int denominator = muConv.getInt(CONV_DENOMINATOR);
                    if (denominator != 0) {
                        desQty = srcQty.multiply(new BigDecimal(numberator)).divide(new BigDecimal(denominator), BillQuantityHelper.getPrecision(desUnit), BillQuantityHelper.getPrecisionType(desUnit));
                    }
                }
            }
        }
        return desQty;
    }

    public static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
                if (muConv != null) {
                    int numberator = muConv.getInt(CONV_NUMERATOR);
                    int denominator = muConv.getInt(CONV_DENOMINATOR);
                    if (denominator != 0) {
                        desQty = srcQty.multiply(new BigDecimal(numberator)).divide(new BigDecimal(denominator), BillQuantityHelper.getPrecision(desUnit), BillQuantityHelper.getPrecisionType(desUnit));
                    }
                }
            }
        }
        return desQty;
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = ZERO;
        } else if (srcUnitId.equals(desUnitId)) {
            unitRate = ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt(CONV_DENOMINATOR) != 0) {
                unitRate = new BigDecimal(muConv.getInt(CONV_NUMERATOR)).divide(new BigDecimal(muConv.getInt(CONV_DENOMINATOR)), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = ZERO;
        }
        return unitRate;
    }

    public static int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt(UNIT_PRECISION);
        }
        return precision;
    }

    public static int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get(UNIT_PRECISIONTYPE))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }

    public static RoundingMode getUnitRoundingMode(DynamicObject unit) {
        RoundingMode roundingMode;
        String precisionAccount;
        if (unit == null || StringUtils.isBlank((Object)unit.get(UNIT_PRECISIONTYPE))) {
            return RoundingMode.HALF_UP;
        }
        switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
            case "2": {
                roundingMode = RoundingMode.DOWN;
                break;
            }
            case "3": {
                roundingMode = RoundingMode.UP;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_UP;
            }
        }
        return roundingMode;
    }
}

