/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mpscmm.msbd.common.enums.BillStatusEnum;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class BillTypeHelper {
    public static boolean checkBillType(String formId, Long billtypeId) {
        if (CommonUtils.isNull(billtypeId)) {
            return false;
        }
        List<Long> billTypeList = BillTypeHelper.getAllBillTypes(formId);
        if (billTypeList == null) {
            return false;
        }
        return billTypeList.contains(billtypeId);
    }

    public static Long getDefaultBillType(String formId) {
        if (CommonUtils.isNull(formId)) {
            return null;
        }
        Long billType = null;
        Map map = BillTypeServiceHelper.getBillTypeObject((String)formId);
        if (CommonUtils.isNull(map)) {
            return null;
        }
        for (DynamicObject dym : map.values()) {
            if (!dym.getBoolean("isdefault")) continue;
            return (Long)dym.getPkValue();
        }
        return billType;
    }

    public static DynamicObject getDefaultBillTypeObject(String formId) {
        if (CommonUtils.isNull(formId)) {
            return null;
        }
        DynamicObject billType = null;
        Map map = BillTypeServiceHelper.getBillTypeObject((String)formId);
        if (CommonUtils.isNull(map)) {
            return null;
        }
        for (DynamicObject dym : map.values()) {
            if (!dym.getBoolean("isdefault")) continue;
            return dym;
        }
        return billType;
    }

    public static List<Long> getAllBillTypes(String formId) {
        if (CommonUtils.isNull(formId)) {
            return null;
        }
        ArrayList<Long> billTypeList = new ArrayList();
        Map map = BillTypeServiceHelper.getBillTypeObject((String)formId);
        if (CommonUtils.isNull(map)) {
            return null;
        }
        billTypeList = map.values().stream().map(dym -> dym.getLong("id")).collect(Collectors.toList());
        return billTypeList;
    }

    public static Object getBillTypeParameter(String formId, long billTypeId, String paramFormId, String propertyName) {
        if (CommonUtils.isNull(formId) || CommonUtils.isNull(billTypeId) || CommonUtils.isNull(paramFormId) || CommonUtils.isNull(propertyName)) {
            return null;
        }
        DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
        if (!CommonUtils.isNull(billTypeParam)) {
            return billTypeParam.get(propertyName);
        }
        return null;
    }

    public static Map<Object, DynamicObject> getBillTypesByEntity(String formid) {
        QFilter qFilter1 = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter qFilter2 = new QFilter("billformid", "=", (Object)formid);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map billTypes = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"billformid,number,name", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, (String)"isdefault desc");
        if (CommonUtils.isNull(billTypes)) {
            return null;
        }
        return billTypes;
    }

    public static DynamicObject getBillTypeByEntity(String formid) {
        Map<Object, DynamicObject> billTypes = BillTypeHelper.getBillTypesByEntity(formid);
        if (billTypes != null && !billTypes.isEmpty()) {
            return (DynamicObject)billTypes.values().toArray()[0];
        }
        return null;
    }
}

