/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.BillTypeHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class BizTypeHelper {
    public static boolean checkBizTypeInBillType(Long bizTypeId, String formId, Long billTypeId, String paramFormId) {
        if (CommonUtils.isNull(bizTypeId) || CommonUtils.isNull(formId) || CommonUtils.isNull(billTypeId) || CommonUtils.isNull(paramFormId)) {
            return false;
        }
        List<Long> bizTypeList = BizTypeHelper.getAllBizTypes(formId, billTypeId, paramFormId);
        if (bizTypeList == null) {
            return false;
        }
        return bizTypeList.contains(bizTypeId);
    }

    public static boolean checkLineTypeInBizType(Long lineTypeId, Long bizTypeId) {
        if (CommonUtils.isNull(lineTypeId) || CommonUtils.isNull(bizTypeId)) {
            return false;
        }
        List<Long> lineTypeList = BizTypeHelper.getAllLineTypes(bizTypeId);
        if (lineTypeId == null) {
            return false;
        }
        return lineTypeList.contains(lineTypeId);
    }

    public static List<Long> getAllLineTypes(Long bizTypeId) {
        List<Long> lineTypeIds = new ArrayList<Long>(16);
        DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)bizTypeId, (String)"bd_biztype");
        if (!CommonUtils.isNull(bizType) && !CommonUtils.isNull(bizType.getDynamicObjectCollection("linetypeentry"))) {
            lineTypeIds = bizType.getDynamicObjectCollection("linetypeentry").stream().map(dym -> dym.getLong("linetypeid.id")).collect(Collectors.toList());
        }
        return lineTypeIds;
    }

    public static Long getDefaultBizType(String formId, Long billTypeId, String paramFormId) {
        List<Long> enableBizTypeIds;
        if (CommonUtils.isNull(formId) || CommonUtils.isNull(billTypeId) || CommonUtils.isNull(paramFormId)) {
            return null;
        }
        Object bizTypes = BillTypeHelper.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity");
        ArrayList<Long> bizTypeList = new ArrayList<Long>();
        if (!CommonUtils.isNull(bizTypes) && bizTypes instanceof DynamicObjectCollection) {
            ((DynamicObjectCollection)bizTypes).stream().forEach(dym -> {
                if (dym.getBoolean("isdefault")) {
                    bizTypeList.add(dym.getLong("biztypenumber.id"));
                }
            });
        }
        return (enableBizTypeIds = BizTypeHelper.getEnableBaseDataIds("bd_biztype", bizTypeList)).size() > 0 ? enableBizTypeIds.get(0) : null;
    }

    public static DynamicObject getDefaultBizTypeObject(String formId, Long billTypeId, String paramFormId) {
        List<DynamicObject> enableList;
        if (CommonUtils.isNull(formId) || CommonUtils.isNull(billTypeId) || CommonUtils.isNull(paramFormId)) {
            return null;
        }
        Object bizTypes = BillTypeHelper.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity");
        ArrayList<DynamicObject> bizTypeList = new ArrayList<DynamicObject>();
        if (!CommonUtils.isNull(bizTypes) && bizTypes instanceof DynamicObjectCollection) {
            ((DynamicObjectCollection)bizTypes).stream().forEach(dym -> {
                if (dym.getBoolean("isdefault")) {
                    bizTypeList.add(dym.getDynamicObject("biztypenumber"));
                }
            });
        }
        return (enableList = BizTypeHelper.getEnableBaseDataObjects("bd_biztype", bizTypeList)).size() > 0 ? enableList.get(0) : null;
    }

    public static Long getDefaultLineType(Long bizTypeId) {
        Optional<DynamicObject> optionalLineType;
        if (CommonUtils.isNull(bizTypeId)) {
            return null;
        }
        Long lineTypeId = null;
        DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)bizTypeId, (String)"bd_biztype");
        if (!CommonUtils.isNull(bizType) && !CommonUtils.isNull(bizType.getDynamicObjectCollection("linetypeentry")) && (optionalLineType = bizType.getDynamicObjectCollection("linetypeentry").stream().filter(dym -> dym.getBoolean("isdefault")).findFirst()).isPresent()) {
            lineTypeId = optionalLineType.get().getLong("linetypeid.id");
            List<Long> linetype = BizTypeHelper.getEnableBaseDataIds("bd_linetype", Collections.singletonList(lineTypeId));
            lineTypeId = linetype.size() > 0 ? linetype.get(0) : null;
        }
        return lineTypeId;
    }

    public static DynamicObject getDefaultLineTypeObject(Long bizTypeId) {
        Optional<DynamicObject> optionalLineType;
        if (CommonUtils.isNull(bizTypeId)) {
            return null;
        }
        DynamicObject lineType = null;
        DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)bizTypeId, (String)"bd_biztype");
        if (!CommonUtils.isNull(bizType) && !CommonUtils.isNull(bizType.getDynamicObjectCollection("linetypeentry")) && (optionalLineType = bizType.getDynamicObjectCollection("linetypeentry").stream().filter(dym -> dym.getBoolean("isdefault")).findFirst()).isPresent()) {
            lineType = optionalLineType.get().getDynamicObject("linetypeid");
            List<DynamicObject> lineTypes = BizTypeHelper.getEnableBaseDataObjects("bd_linetype", Collections.singletonList(lineType));
            lineType = lineTypes.size() > 0 ? lineTypes.get(0) : null;
        }
        return lineType;
    }

    public static List<Long> getAllBizTypes(String formId, Long billTypeId, String paramFormId) {
        if (CommonUtils.isNull(formId) || CommonUtils.isNull(billTypeId) || CommonUtils.isNull(paramFormId)) {
            return null;
        }
        Object bizTypes = BillTypeHelper.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity");
        List<Long> bizTypeList = new ArrayList<Long>();
        if (!CommonUtils.isNull(bizTypes) && bizTypes instanceof DynamicObjectCollection) {
            bizTypeList = ((DynamicObjectCollection)bizTypes).stream().map(dym -> dym.getLong("biztypenumber.id")).collect(Collectors.toList());
        }
        return bizTypeList;
    }

    private static List<Long> getEnableBaseDataIds(String entityNo, List<Long> pks) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter pkFilter = new QFilter("id", "in", pks);
        ArrayList<Long> baseIDs = new ArrayList<Long>(16);
        Map enableBaseDatas = BusinessDataServiceHelper.loadFromCache((String)entityNo, (QFilter[])new QFilter[]{enableFilter, pkFilter});
        if (enableBaseDatas != null) {
            enableBaseDatas.keySet().forEach(id -> baseIDs.add((Long)id));
        }
        return baseIDs;
    }

    private static List<DynamicObject> getEnableBaseDataObjects(String entityNo, List<DynamicObject> dyms) {
        List pks = dyms.stream().map(dym -> (Long)dym.getPkValue()).collect(Collectors.toList());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter pkFilter = new QFilter("id", "in", pks);
        ArrayList<DynamicObject> baseDatas = new ArrayList<DynamicObject>(16);
        Map enableBaseDatas = BusinessDataServiceHelper.loadFromCache((String)entityNo, (QFilter[])new QFilter[]{enableFilter, pkFilter});
        if (enableBaseDatas != null) {
            enableBaseDatas.values().forEach(value -> baseDatas.add((DynamicObject)value));
        }
        return baseDatas;
    }
}

