/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.enums.ExchangeTypeEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;

public class CurrencyHelper {
    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        if (orgId == null) {
            return null;
        }
        Map<String, Object> mapOrg = OrgHelper.getCompanyByOrg(orgId, Boolean.FALSE, Boolean.TRUE);
        Map map = null;
        if (mapOrg != null && mapOrg.get("id") != null) {
            map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
        }
        return map;
    }

    public static DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != null && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null && map.get("exchangeRateTableID") != null) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get("exchangeRateTableID"), (String)"bd_exratetable");
        }
        return null;
    }

    public static BigDecimal getExChangeRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null) {
            return exchangeRate;
        }
        exchangeRate = srcCurId.equals(tarCurId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)tarCurId, (Date)date);
        return exchangeRate;
    }

    public static BigDecimal getExChangeRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date, String exchangeType) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null || exchangeType == null) {
            return exchangeRate;
        }
        if (srcCurId.equals(tarCurId)) {
            exchangeRate = BigDecimal.ONE;
        } else {
            boolean isIndirect = ExchangeTypeEnum.isIndirectRate(exchangeType);
            exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)exRateTableId, (Long)srcCurId, (Long)tarCurId, (Date)date, (boolean)isIndirect);
        }
        return exchangeRate;
    }

    public static Map<String, Object> getExChangeRateMap(Long srcCurId, Long tarCurId, Long exRateTableId, Date date) {
        BigDecimal exRate;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        String exchangeType = ExchangeTypeEnum.DIRECT.getValue();
        HashMap<String, Object> exRateMap = new HashMap<String, Object>(4);
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null) {
            exRateMap.put("exchangerate", exchangeRate);
            exRateMap.put("exchangetype", exchangeType);
            return exRateMap;
        }
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurId, (Long)tarCurId, (Long)exRateTableId, (Date)date);
        Boolean isIndirectRate = (Boolean)exchangeRateMap.get("quoteType");
        if (isIndirectRate != null && isIndirectRate.booleanValue()) {
            exchangeType = ExchangeTypeEnum.INDIRECT.getValue();
        }
        if ((exRate = (BigDecimal)exchangeRateMap.get("exchangeRate")) != null) {
            exchangeRate = exRate;
        }
        exRateMap.put("exchangerate", exchangeRate);
        exRateMap.put("exchangetype", exchangeType);
        return exRateMap;
    }

    public static BigDecimal convert(BigDecimal money, BigDecimal exRate, boolean isIndirectRate, int amtPrecision, RoundingMode roundingMode) {
        if (roundingMode == null) {
            roundingMode = RoundingMode.HALF_UP;
        }
        if (BigDecimalUtil.isZero(exRate)) {
            return BigDecimalUtil.ZERO;
        }
        if (isIndirectRate) {
            return money.divide(exRate, amtPrecision, roundingMode);
        }
        return money.multiply(exRate).setScale(amtPrecision, roundingMode);
    }
}

