/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.format.DateFormat;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class DynamicObjectHelper {
    public static Object getValue4Head(DynamicObject bill, String field) {
        return DynamicObjectHelper.getValue4Head(bill, field, Boolean.FALSE);
    }

    public static List<Object[]> getValue4Entry(DynamicObject bill, String entryKey, List<String> entryFields) {
        return DynamicObjectHelper.getValue4Entry(bill, entryKey, entryFields, Boolean.FALSE);
    }

    public static Object getValue4Head(DynamicObject bill, String field, Boolean isFormat) {
        String[] stringArray;
        if (StringUtils.isEmpty((String)field) || bill == null || isFormat == null) {
            return null;
        }
        if (field.contains(".")) {
            stringArray = field.split("\\.");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = field;
        }
        return DynamicObjectHelper.getValue4Head(bill, stringArray, 0, isFormat);
    }

    public static List<Object[]> getValue4Entry(DynamicObject bill, String entryKey, List<String> entryFields, Boolean isFormat) {
        ArrayList<Object[]> tableData;
        block4: {
            Object[][] value4Entry;
            block5: {
                if (entryFields == null || entryFields.size() == 0 || bill == null || isFormat == null) {
                    return null;
                }
                tableData = new ArrayList<Object[]>(16);
                BillEntityType entityType = (BillEntityType)bill.getDataEntityType();
                IDataEntityProperty entityTypeProperty = entityType.findProperty(entryKey);
                if (entityTypeProperty == null) break block4;
                if (!(entityTypeProperty instanceof SubEntryProp)) break block5;
                DynamicObjectCollection entryRowList = bill.getDynamicObjectCollection(entityTypeProperty.getParent().getName());
                for (DynamicObject entryRow : entryRowList) {
                    Object[][] value4Entry2;
                    DynamicObjectCollection subEntryRowList = entryRow.getDynamicObjectCollection(entryKey);
                    if (subEntryRowList.size() <= 0 || (value4Entry2 = DynamicObjectHelper.getValue4Entry(bill, subEntryRowList, entryFields, isFormat)) == null) continue;
                    for (int i = 0; i < value4Entry2.length; ++i) {
                        tableData.add(value4Entry2[i]);
                    }
                }
                break block4;
            }
            DynamicObjectCollection entryRowList = bill.getDynamicObjectCollection(entryKey);
            if (entryRowList.size() <= 0 || (value4Entry = DynamicObjectHelper.getValue4Entry(bill, entryRowList, entryFields, isFormat)) == null) break block4;
            for (int i = 0; i < value4Entry.length; ++i) {
                tableData.add(value4Entry[i]);
            }
        }
        return tableData;
    }

    private static Object[][] getValue4Entry(DynamicObject bill, DynamicObjectCollection rows, List<String> entryFields, Boolean isFormat) {
        Object[][] data = new Object[rows.size()][entryFields.size()];
        if (isFormat.booleanValue()) {
            data = new String[rows.size()][entryFields.size()];
        }
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            for (int j = 0; j < entryFields.size(); ++j) {
                String[] stringArray;
                String field = entryFields.get(j);
                Object[] objectArray = data[i];
                if (field.contains(".")) {
                    stringArray = field.split("\\.");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = field;
                }
                objectArray[j] = DynamicObjectHelper.getValue4EntryRow(bill, row, stringArray, 0, isFormat);
            }
        }
        return data;
    }

    private static Object getValue4EntryRow(DynamicObject entity, DynamicObject curEntryRow, String[] field, int index, Boolean isFormat) {
        Object value = null;
        DynamicProperty property = curEntryRow.getDynamicObjectType().getProperty(field[index]);
        if (property != null && (value = property.getValueFast((Object)curEntryRow)) != null) {
            if (field.length == index + 1) {
                if (isFormat.booleanValue()) {
                    value = DynamicObjectHelper.valueFmt(entity, curEntryRow, (IDataEntityProperty)property, value);
                }
            } else if (value instanceof DynamicObject) {
                value = DynamicObjectHelper.getValue4Head((DynamicObject)value, field, index + 1, isFormat);
            }
        }
        return isFormat.booleanValue() ? (value != null ? value : "") : value;
    }

    private static Object getValue4Head(DynamicObject entity, String[] field, int index, Boolean isFormat) {
        Object value = null;
        DynamicProperty property = entity.getDynamicObjectType().getProperty(field[index]);
        if (property != null && (value = property.getValueFast((Object)entity)) != null) {
            if (field.length == index + 1) {
                if (isFormat.booleanValue()) {
                    value = DynamicObjectHelper.valueFmt(entity, (IDataEntityProperty)property, value);
                }
            } else if (value instanceof DynamicObject) {
                value = DynamicObjectHelper.getValue4Head((DynamicObject)value, field, index + 1, isFormat);
            }
        }
        return isFormat.booleanValue() ? (value != null ? value : "") : value;
    }

    private static String valueFmt(DynamicObject curEntityValue, IDataEntityProperty curProp, Object curPropValue) {
        Object valueFmt = DynamicObjectHelper.valueFmt(curEntityValue, curEntityValue, curProp, curPropValue);
        return valueFmt != null ? valueFmt.toString() : "";
    }

    private static Object valueFmt(DynamicObject curEntityValue, DynamicObject parentPropValue, IDataEntityProperty curProp, Object curValue) {
        if (curValue == null || curProp == null) {
            return StringUtils.getEmpty();
        }
        if (curProp instanceof BigIntProp) {
            return curValue.toString();
        }
        if (curProp instanceof IntegerProp) {
            return curValue.toString();
        }
        if (curProp instanceof LargeTextProp) {
            return curValue + "\r\n" + parentPropValue.getString(curProp.getName() + "_tag");
        }
        if (curProp instanceof MuliLangTextProp) {
            return ((OrmLocaleValue)curValue).getLocaleValue();
        }
        if (curProp instanceof DecimalProp) {
            return DynamicObjectHelper.decimalFmt(curEntityValue, parentPropValue, (DecimalProp)curProp, curValue);
        }
        if (curProp instanceof DateProp) {
            String fmt = InteServiceHelper.getDateFormat((Long)UserServiceHelper.getCurrentUserId());
            if (StringUtils.isEmpty((String)fmt)) {
                return ((DateProp)curProp).getDateFormat().format(curValue);
            }
            DateFormat df = new DateFormat();
            return df.getDateTimeFormat(fmt).format(curValue);
        }
        if (curProp instanceof DateTimeProp) {
            String fmt = InteServiceHelper.getDateFormat((Long)UserServiceHelper.getCurrentUserId());
            if (StringUtils.isEmpty((String)fmt)) {
                return ((DateTimeProp)curProp).getDateFormat().format(curValue);
            }
            DateFormat df = new DateFormat();
            return df.getDateTimeFormat(fmt).format(curValue);
        }
        if (curProp instanceof FlexProp) {
            return FlexValueFormatUtils.getReportDisplayValue((DynamicObject)parentPropValue, (FlexProp)((FlexProp)curProp));
        }
        if (curProp instanceof BasedataProp) {
            String displayProp = ((BasedataProp)curProp).getDispProp().getName();
            return StringUtils.isEmpty((String)displayProp) ? ((DynamicObject)curValue).getString("name") : ((DynamicObject)curValue).getString(displayProp);
        }
        if (curProp instanceof MulBasedataProp) {
            String displayProp = ((MulBasedataProp)curProp).getDispProp().getName();
            ArrayList names = new ArrayList(((DynamicObjectCollection)curValue).size());
            ((DynamicObjectCollection)curValue).forEach(d -> names.add(((DynamicObject)d.get(1)).getString(displayProp)));
            return String.join((CharSequence)";", names);
        }
        if (curProp instanceof ComboProp) {
            return ((ComboProp)curProp).getItemByName(curValue.toString());
        }
        if (curProp instanceof BooleanProp) {
            return (Boolean)curValue != false ? ResManager.loadKDString((String)"\u662f", (String)"DynamicObjectHelper_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"DynamicObjectHelper_1", (String)"mpscmm-msbd-common", (Object[])new Object[0]);
        }
        return curValue;
    }

    private static Object decimalFmt(DynamicObject parentDym, DynamicObject row, DecimalProp prop, Object value) {
        if (value instanceof BigDecimal) {
            return DynamicObjectHelper.bigDecimalFmt(parentDym, row, prop, (BigDecimal)value);
        }
        return value;
    }

    private static Object bigDecimalFmt(DynamicObject parentDym, DynamicObject row, DecimalProp prop, BigDecimal value) {
        DynamicObject ctlPropValue;
        String ctlPropName;
        int scale = prop.getScale();
        if (scale != 0) {
            value = value.setScale(scale, RoundingMode.HALF_UP);
        }
        if (StringUtils.isEmpty((String)(ctlPropName = prop.getControlPropName()))) {
            return NumberFormat.getNumberInstance().format(value);
        }
        IDataEntityProperty ctlProp = ((BillEntityType)parentDym.getDynamicObjectType()).findProperty(ctlPropName);
        DynamicObject dynamicObject = ctlPropValue = ctlProp.getParent() instanceof EntryType ? (DynamicObject)ctlProp.getValue((Object)row) : (DynamicObject)ctlProp.getValue((Object)parentDym);
        if (ctlPropValue == null) {
            return NumberFormat.getNumberInstance().format(value);
        }
        if (prop instanceof PriceProp) {
            return DynamicObjectHelper.formatBigDecimal(value, ctlPropValue.getInt("priceprecision"), ctlPropValue.getString("sign"));
        }
        if (prop instanceof AmountProp) {
            return DynamicObjectHelper.formatBigDecimal(value, ctlPropValue.getInt("amtprecision"), ctlPropValue.getString("sign"));
        }
        if (prop instanceof QtyProp) {
            return DynamicObjectHelper.formatBigDecimal(value, ctlPropValue.getInt("precision"), "");
        }
        return value;
    }

    private static String formatBigDecimal(BigDecimal value, int precision, String sign) {
        StringBuffer decimal = new StringBuffer();
        if (precision != 0 && value.compareTo(BigDecimal.ZERO) == 0) {
            decimal.append(precision == 0 ? "0" : "0.");
            for (int i = 0; i < precision; ++i) {
                decimal.append('0');
            }
        } else {
            decimal.append(value.setScale(precision, RoundingMode.HALF_UP).toPlainString());
        }
        if (!StringUtils.isEmpty((String)sign)) {
            return sign + decimal;
        }
        return decimal.toString();
    }
}

