/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class FieldMapHelper {
    public static DynamicObject getFieldMapObjById(Long FieldMappingId) {
        QFilter idFltr = new QFilter("id", "=", (Object)FieldMappingId);
        QFilter enableFltr = new QFilter("isenable", "=", (Object)true);
        DynamicObject BFMapping = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billfieldmapping", (QFilter[])new QFilter[]{idFltr.and(enableFltr)});
        return BFMapping;
    }

    public static String getSrcEntityById(Long FieldMappingId) {
        DynamicObject BFMapping = FieldMapHelper.getFieldMapObjById(FieldMappingId);
        if (BFMapping != null) {
            return BFMapping.getString("sourcebill");
        }
        return null;
    }

    public static Map<String, String> getFieldMapById(Long FieldMappingId, String direct) {
        DynamicObject fieldMap = FieldMapHelper.getFieldMapObjById(FieldMappingId);
        if (fieldMap == null) {
            return new LinkedHashMap<String, String>(4);
        }
        DynamicObjectCollection rows = fieldMap.getDynamicObjectCollection("colsmap");
        String keyCol = "targetobjcol";
        String valCol = "sourcebillcol";
        DynamicObject srcBill = fieldMap.getDynamicObject("sourcebill");
        LinkedHashMap<String, String> tempSrcColMap = new LinkedHashMap<String, String>(16);
        LinkedHashMap<String, String> tempTgtColMap = new LinkedHashMap<String, String>(16);
        for (DynamicObject row : rows) {
            String val = row.getString(valCol);
            if (StringUtils.isBlank((CharSequence)val) || !"0".equals(row.getString("selectvalue"))) continue;
            tempTgtColMap.put(row.getString(keyCol), val);
            tempSrcColMap.put(val, row.getString(keyCol));
        }
        if (null != direct && direct.equalsIgnoreCase("target")) {
            return tempTgtColMap;
        }
        return tempSrcColMap;
    }

    public static Map<String, String> getFieldMapBySrcEntity(String srcEntity) {
        QFilter targetobj = new QFilter("targetobj", "=", (Object)"msbd_quotamodel");
        QFilter sourcebill = new QFilter("sourcebill", "=", (Object)srcEntity);
        QFilter enable = new QFilter("isenable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{targetobj, sourcebill, enable};
        Map fieldMapObjs = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])filters);
        for (Map.Entry mapObj : fieldMapObjs.entrySet()) {
            Map<String, String> fldMap = FieldMapHelper.getFieldMapByObj((DynamicObject)mapObj.getValue(), "target");
            if (CommonUtils.isNull(fldMap)) continue;
            return fldMap;
        }
        return null;
    }

    public static Map<String, Map<String, String>> getFieldMapBySrcEntitys(Set<String> srcEntitys) {
        QFilter targetobj = new QFilter("targetobj", "=", (Object)"msbd_quotamodel");
        QFilter sourcebill = new QFilter("sourcebill", "in", srcEntitys);
        QFilter enable = new QFilter("isenable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{targetobj, sourcebill, enable};
        Map fieldMapObj = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])filters);
        HashMap<String, Map<String, String>> srcEntityFieldMap = new HashMap<String, Map<String, String>>(8);
        for (Map.Entry obj : fieldMapObj.entrySet()) {
            if (CommonUtils.isNull(obj.getValue()) || CommonUtils.isNull(((DynamicObject)obj.getValue()).getDynamicObject("sourcebill"))) continue;
            Map<String, String> fieldMap = FieldMapHelper.getFieldMapByObj((DynamicObject)obj.getValue(), "target");
            String srcEntityName = ((DynamicObject)obj.getValue()).getDynamicObject("sourcebill").getString("number");
            srcEntityFieldMap.put(srcEntityName, fieldMap);
        }
        return srcEntityFieldMap;
    }

    public static Map<String, String> getFieldMapByObj(DynamicObject fieldMapObj, String direct) {
        if (fieldMapObj == null) {
            return new HashMap<String, String>(4);
        }
        DynamicObjectCollection rows = fieldMapObj.getDynamicObjectCollection("colsmap");
        String keyCol = "targetobjcol";
        String valCol = "sourcebillcol";
        HashMap<String, String> tempSrcColMap = new HashMap<String, String>(16);
        HashMap<String, String> tempTgtColMap = new HashMap<String, String>(16);
        for (DynamicObject row : rows) {
            String val = row.getString(valCol);
            if (StringUtils.isBlank((CharSequence)val) || !"0".equals(row.getString("selectvalue"))) continue;
            tempTgtColMap.put(row.getString(keyCol), val);
            tempSrcColMap.put(val, row.getString(keyCol));
        }
        if (null != direct && direct.equalsIgnoreCase("target")) {
            return tempTgtColMap;
        }
        return tempSrcColMap;
    }

    public static Set<String> getSrcEntityByTargetEntity(String targetEntity, Set<String> srcEntitys) {
        Map referQuotaMapping = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])new QFilter[]{new QFilter("targetobj.number", "=", (Object)targetEntity)});
        for (DynamicObject value : referQuotaMapping.values()) {
            String number = value.getString("sourcebill.number");
            if (!kd.bos.util.StringUtils.isNotEmpty((String)number)) continue;
            srcEntitys.add(number);
        }
        return srcEntitys;
    }

    public static DynamicObject getFieldMapObj(String srcEntity, String targetEntity) {
        DynamicObject fldMapObj = new DynamicObject();
        QFilter targetobj = new QFilter("targetobj", "=", (Object)targetEntity);
        QFilter sourcebill = new QFilter("sourcebill", "=", (Object)srcEntity);
        QFilter enable = new QFilter("isenable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{targetobj, sourcebill, enable};
        Map fieldMapObjs = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])filters);
        if (fieldMapObjs == null || fieldMapObjs.size() == 0 || fieldMapObjs.size() > 1) {
            return null;
        }
        if (!CommonUtils.isNull(fieldMapObjs)) {
            for (Map.Entry obj : fieldMapObjs.entrySet()) {
                if (obj.getValue() == null) continue;
                fldMapObj = (DynamicObject)obj.getValue();
                break;
            }
        }
        return fldMapObj;
    }
}

