/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class LockHelper {
    public static List<DLock> createDLocks(Set<String> keys, boolean isReentrant) {
        if (CommonUtils.isNull(keys)) {
            return null;
        }
        int size = keys.size();
        ArrayList<DLock> dLocks = new ArrayList<DLock>(size);
        for (String key : keys) {
            DLock dLock = isReentrant ? DLock.createReentrant((String)key) : DLock.create((String)key);
            dLocks.add(dLock);
        }
        return dLocks;
    }

    public static boolean tryDLocks(List<DLock> dLocks, Long timeoutMillis) {
        boolean isSuccess = true;
        if (CommonUtils.isNull(dLocks)) {
            return isSuccess;
        }
        long time = timeoutMillis == null ? 30000L : timeoutMillis;
        try {
            for (DLock dLock : dLocks) {
                if (dLock.tryLock(time)) continue;
                isSuccess = false;
                break;
            }
        }
        catch (Exception e) {
            isSuccess = false;
        }
        if (!isSuccess) {
            LockHelper.unDLocks(dLocks);
            String erromsg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"LockHelper_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]), new Object[0]);
            throw new KDBizException(erromsg);
        }
        return isSuccess;
    }

    public static void unDLocks(List<DLock> dLocks) {
        if (CommonUtils.isNull(dLocks)) {
            return;
        }
        for (DLock dLock : dLocks) {
            dLock.unlock();
        }
    }
}

