/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.utils.AppCacheUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class MaterialHelper {
    public static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit, boolean fromCache) {
        if (CommonUtils.isNull(materialId) || CommonUtils.isNull(srcUnit) || CommonUtils.isNull(desUnit) || srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            return srcQty;
        }
        Map<String, Integer> timelyMuConv = null;
        if (fromCache) {
            String cacheKey = "getMUConv_" + materialId + "_" + srcUnit.getLong("id") + "_" + desUnit.getLong("id");
            Map temp = AppCacheUtils.get(cacheKey, Map.class);
            if (temp instanceof Map) {
                timelyMuConv = temp;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit.getLong("id"), (Long)desUnit.getLong("id"));
                if (muConv != null && muConv.isInitialized()) {
                    timelyMuConv = new HashMap(16);
                    timelyMuConv.put("numerator", muConv.getInt("numerator"));
                    timelyMuConv.put("denominator", muConv.getInt("denominator"));
                    AppCacheUtils.put(cacheKey, timelyMuConv);
                }
            }
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit.getLong("id"), (Long)desUnit.getLong("id"));
            if (muConv != null) {
                timelyMuConv = new HashMap<String, Integer>(16);
                timelyMuConv.put("numerator", muConv.getInt("numerator"));
                timelyMuConv.put("denominator", muConv.getInt("denominator"));
            }
        }
        if (timelyMuConv != null && (Integer)timelyMuConv.get("denominator") != 0) {
            BigDecimal numerator = BigDecimal.valueOf(((Integer)timelyMuConv.get("numerator")).intValue());
            BigDecimal denominator = BigDecimal.valueOf(((Integer)timelyMuConv.get("denominator")).intValue());
            int precision = desUnit.getInt("precision") == 0 ? 10 : desUnit.getInt("precision");
            String precisionAccount = desUnit.getString("precisionaccount");
            RoundingMode roundingMode = RoundingMode.HALF_UP;
            if ("3".equals(precisionAccount)) {
                roundingMode = RoundingMode.UP;
            } else if ("2".equals(precisionAccount)) {
                roundingMode = RoundingMode.DOWN;
            }
            srcQty = srcQty.multiply(numerator).divide(denominator, precision, roundingMode);
        }
        return srcQty;
    }

    public static BigDecimal getMUConv(Long materialId, DynamicObject srcUnit, DynamicObject desUnit, boolean fromCache) {
        BigDecimal unitRate = BigDecimal.ONE;
        if (CommonUtils.isNull(materialId) || CommonUtils.isNull(srcUnit) || CommonUtils.isNull(desUnit) || srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            return unitRate;
        }
        Map<String, Integer> timelyMuConv = null;
        if (fromCache) {
            String cacheKey = "getMUConv_" + materialId + "_" + srcUnit.getLong("id") + "_" + desUnit.getLong("id");
            Map temp = AppCacheUtils.get(cacheKey, Map.class);
            if (temp instanceof Map) {
                timelyMuConv = temp;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit.getLong("id"), (Long)desUnit.getLong("id"));
                if (muConv != null && muConv.isInitialized()) {
                    timelyMuConv = new HashMap(16);
                    timelyMuConv.put("numerator", muConv.getInt("numerator"));
                    timelyMuConv.put("denominator", muConv.getInt("denominator"));
                    AppCacheUtils.put(cacheKey, timelyMuConv);
                }
            }
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit.getLong("id"), (Long)desUnit.getLong("id"));
            if (muConv != null) {
                timelyMuConv = new HashMap<String, Integer>(16);
                timelyMuConv.put("numerator", muConv.getInt("numerator"));
                timelyMuConv.put("denominator", muConv.getInt("denominator"));
            }
        }
        if (timelyMuConv != null && (Integer)timelyMuConv.get("denominator") != 0) {
            BigDecimal numerator = BigDecimal.valueOf(((Integer)timelyMuConv.get("numerator")).intValue());
            BigDecimal denominator = BigDecimal.valueOf(((Integer)timelyMuConv.get("denominator")).intValue());
            unitRate = numerator.divide(denominator, 10, RoundingMode.HALF_UP);
        }
        return unitRate;
    }

    public static BigDecimal getMUConv(Long materialId, Long srcUnit, Long desUnit, boolean fromCache) {
        BigDecimal unitRate = BigDecimal.ONE;
        if (CommonUtils.isNull(materialId) || CommonUtils.isNull(srcUnit) || CommonUtils.isNull(desUnit) || srcUnit.equals(desUnit)) {
            return unitRate;
        }
        Map<String, Integer> timelyMuConv = null;
        if (fromCache) {
            String cacheKey = "getMUConv_" + materialId + "_" + srcUnit + "_" + desUnit;
            Map temp = AppCacheUtils.get(cacheKey, Map.class);
            if (temp instanceof Map) {
                timelyMuConv = temp;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnit);
                if (muConv != null && muConv.isInitialized()) {
                    timelyMuConv = new HashMap(16);
                    timelyMuConv.put("numerator", muConv.getInt("numerator"));
                    timelyMuConv.put("denominator", muConv.getInt("denominator"));
                    AppCacheUtils.put(cacheKey, timelyMuConv);
                }
            }
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnit);
            if (muConv != null) {
                timelyMuConv = new HashMap<String, Integer>(16);
                timelyMuConv.put("numerator", muConv.getInt("numerator"));
                timelyMuConv.put("denominator", muConv.getInt("denominator"));
            }
        }
        if (timelyMuConv != null && (Integer)timelyMuConv.get("denominator") != 0) {
            BigDecimal numerator = BigDecimal.valueOf(((Integer)timelyMuConv.get("numerator")).intValue());
            BigDecimal denominator = BigDecimal.valueOf(((Integer)timelyMuConv.get("denominator")).intValue());
            unitRate = numerator.divide(denominator, 10, RoundingMode.HALF_UP);
        }
        return unitRate;
    }

    public static List<Long> getAllMUList(Long materialId, Long srcmuId, boolean fromCache) {
        if (fromCache) {
            List temp = AppCacheUtils.get("getAllMUList" + materialId + "_" + srcmuId, List.class);
            List list = null;
            if (temp instanceof List && !CommonUtils.isNull(temp)) {
                list = temp;
            } else {
                list = BaseDataServiceHelper.getAssistMUListResult((Long)materialId, (Long)srcmuId, (String)"1");
                AppCacheUtils.put("getAllMUList" + materialId + "_" + srcmuId, list);
            }
            return list;
        }
        return BaseDataServiceHelper.getAssistMUListResult((Long)materialId, (Long)srcmuId, (String)"1");
    }

    public static int[] getMUConvFraction(Long materialId, Long srcUnit, Long desUnit, boolean fromCache) {
        if (CommonUtils.isNull(materialId) || CommonUtils.isNull(srcUnit) || CommonUtils.isNull(desUnit)) {
            return null;
        }
        if (srcUnit.equals(desUnit)) {
            return new int[]{1, 1};
        }
        Map<String, Integer> timelyMuConv = null;
        if (fromCache) {
            String cacheKey = "getMUConv_" + materialId + "_" + srcUnit + "_" + desUnit;
            Map temp = AppCacheUtils.get(cacheKey, Map.class);
            if (temp instanceof Map) {
                timelyMuConv = temp;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnit);
                if (muConv != null && muConv.isInitialized()) {
                    timelyMuConv = new HashMap(16);
                    timelyMuConv.put("numerator", muConv.getInt("numerator"));
                    timelyMuConv.put("denominator", muConv.getInt("denominator"));
                    AppCacheUtils.put(cacheKey, timelyMuConv);
                }
            }
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnit);
            if (muConv != null) {
                timelyMuConv = new HashMap<String, Integer>(16);
                timelyMuConv.put("numerator", muConv.getInt("numerator"));
                timelyMuConv.put("denominator", muConv.getInt("denominator"));
            }
        }
        if (timelyMuConv != null) {
            int numerator = (Integer)timelyMuConv.get("numerator");
            int denominator = (Integer)timelyMuConv.get("denominator");
            return new int[]{numerator, denominator};
        }
        return null;
    }

    public static Boolean checkLineTypeAndMaterial(DynamicObject material, DynamicObject lineType, boolean isMaterialInfo) {
        if (material != null && lineType != null) {
            DynamicObjectCollection materialServiceattribute;
            List ids;
            DynamicObject lineTypeServiceattribute = lineType.getDynamicObject("serviceattribute");
            if (lineTypeServiceattribute == null) {
                return Boolean.FALSE;
            }
            DynamicObject materialmasterid = isMaterialInfo ? material.getDynamicObject("masterid") : material;
            if (materialmasterid != null && (ids = (materialServiceattribute = materialmasterid.getDynamicObjectCollection("serviceattribute")).stream().map(dym -> dym.get("fbasedataid_id")).collect(Collectors.toList())).contains(lineTypeServiceattribute.getPkValue())) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static QFilter[] getQFilterByLineType(Long billTypeId, Long bizTypeId, Long lineTypeId, boolean isMaterialInfo) {
        QFilter[] resultQf = null;
        if (billTypeId == null || bizTypeId == null || lineTypeId == null) {
            return null;
        }
        resultQf = (QFilter[])DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"BillTypeMaterialService", (String)"getQFilterByLineType", (Object[])new Object[]{billTypeId, bizTypeId, lineTypeId, isMaterialInfo});
        return resultQf;
    }

    public static BigDecimal checkMUConv(Long materialId, DynamicObject srcUnit, DynamicObject desUnit, boolean fromCache) {
        BigDecimal unitRate = null;
        if (CommonUtils.isNull(materialId) || CommonUtils.isNull(srcUnit) || CommonUtils.isNull(desUnit) || srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            return unitRate;
        }
        Map<String, Integer> timelyMuConv = null;
        if (fromCache) {
            String cacheKey = "getMUConv_" + materialId + "_" + srcUnit.getLong("id") + "_" + desUnit.getLong("id");
            Map temp = AppCacheUtils.get(cacheKey, Map.class);
            if (temp instanceof Map) {
                timelyMuConv = temp;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit.getLong("id"), (Long)desUnit.getLong("id"));
                if (muConv != null && muConv.isInitialized()) {
                    timelyMuConv = new HashMap(16);
                    timelyMuConv.put("numerator", muConv.getInt("numerator"));
                    timelyMuConv.put("denominator", muConv.getInt("denominator"));
                    AppCacheUtils.put(cacheKey, timelyMuConv);
                }
            }
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit.getLong("id"), (Long)desUnit.getLong("id"));
            if (muConv != null) {
                timelyMuConv = new HashMap<String, Integer>(16);
                timelyMuConv.put("numerator", muConv.getInt("numerator"));
                timelyMuConv.put("denominator", muConv.getInt("denominator"));
            }
        }
        if (timelyMuConv != null && (Integer)timelyMuConv.get("denominator") != 0) {
            BigDecimal numerator = BigDecimal.valueOf(((Integer)timelyMuConv.get("numerator")).intValue());
            BigDecimal denominator = BigDecimal.valueOf(((Integer)timelyMuConv.get("denominator")).intValue());
            unitRate = numerator.divide(denominator, 10, RoundingMode.HALF_UP);
        }
        return unitRate;
    }

    public static boolean checkUnit(Long materialId, Long baseUnitId, Long unitId) {
        String cacheKey = "checkUnit_" + materialId + "_" + baseUnitId;
        List cache = AppCacheUtils.get(cacheKey, List.class);
        if (cache == null) {
            List unitList = BaseDataServiceHelper.getAssistMUListResult((Long)materialId, (Long)baseUnitId, (String)"1");
            AppCacheUtils.put(cacheKey, unitList);
            cache = AppCacheUtils.get(cacheKey, List.class);
        }
        if (cache != null) {
            ArrayList<Long> unitIds = new ArrayList<Long>();
            for (int i = 0; i < cache.size(); ++i) {
                Object value = cache.get(i);
                if (value instanceof Integer) {
                    Integer integer = (Integer)cache.get(i);
                    unitIds.add(integer.longValue());
                    continue;
                }
                unitIds.add((Long)cache.get(i));
            }
            if (unitIds != null && unitIds.contains(unitId)) {
                return true;
            }
        }
        return false;
    }
}

