/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;

public class OperateLogHelper {
    private static final Log log = LogFactory.getLog(OperateLogHelper.class);

    public static AppLogInfo buildAppLogInfo(Long userId, String appId, String entityNo, Long orgId, Date opTime, String opDisPlayName, String msg) {
        AppLogInfo logInfo = new AppLogInfo();
        if (userId != null) {
            logInfo.setUserID(userId);
        } else {
            logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(entityNo);
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        Date operateTime = opTime == null ? TimeServiceHelper.now() : opTime;
        logInfo.setOpTime(operateTime);
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opDisPlayName);
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    public static void saveAppLog(List<AppLogInfo> appLogInfoList) {
        if (appLogInfoList == null || appLogInfoList.isEmpty()) {
            return;
        }
        try {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            logService.addBatchLog(appLogInfoList);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7\u65f6\u53d1\u751f\u9519\u8bef\u3002", (Throwable)e);
        }
    }
}

