/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.BaseDataHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class OperatorGroupFilterHelper {
    private static IAppCache cache = AppCache.get((String)"msbd_operator");
    private static final int MAX_ISOLATE_ORG = 500;
    private static final Log log = LogFactory.getLog(OperatorGroupFilterHelper.class);

    public static QFilter getQFilter(String appId, String entityId, String appParamerKey, String operGrpType, String viewType, Long userId) {
        List<Long> orgs = OperatorGroupFilterHelper.getHasPermissionOrgs(entityId, viewType, userId);
        if (orgs == null || orgs.isEmpty()) {
            return new QFilter("1", "!=", (Object)1);
        }
        return OperatorGroupFilterHelper.getQFilter(appId, entityId, appParamerKey, operGrpType, viewType, userId, orgs);
    }

    public static QFilter getQFilter(String appId, String entityId, String appParamerKey, String operGrpType, String viewType, Long userId, String operatorgroupKey) {
        List<Long> orgs = OperatorGroupFilterHelper.getHasPermissionOrgs(entityId, viewType, userId);
        if (orgs == null || orgs.isEmpty()) {
            return new QFilter("1", "!=", (Object)1);
        }
        return OperatorGroupFilterHelper.getQFilter(appId, entityId, appParamerKey, operGrpType, viewType, userId, orgs, operatorgroupKey);
    }

    public static QFilter getQFilter(String appId, String entityId, String appParamerKey, String operGrpType, String viewType, Long userId, List<Long> orgs) {
        return OperatorGroupFilterHelper.getQFilter(appId, entityId, appParamerKey, operGrpType, viewType, userId, orgs, "operatorgroup");
    }

    public static QFilter getQFilter(String appId, String entityId, String appParamerKey, String operGrpType, String viewType, Long userId, List<Long> orgs, String operatorgroupKey) {
        QFilter qFilter = null;
        long start = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u8fdb\u884c\u4e1a\u52a1\u7ec4\u9694\u79bb\u76f8\u5173\u903b\u8f91\uff0c\u51c6\u5907\u67e5\u8be2\u7528\u6237\u6709\u6743\u9650\u7684\u7ec4\u7ec7\uff0cnowTime:" + start);
        if ((orgs == null || orgs.isEmpty()) && ((orgs = OperatorGroupFilterHelper.getHasPermissionOrgs(entityId, viewType, userId)) == null || orgs.isEmpty())) {
            return new QFilter("1", "!=", (Object)1);
        }
        log.info("\u67e5\u8be2\u7ec4\u7ec7\u5b8c\u6bd5\uff0c\u7ec4\u7ec7\u6570\uff1a" + orgs.size() + "\uff0c\u51c6\u5907\u67e5\u8be2\u7ec4\u7ec7\u7684\u7cfb\u7edf\u53c2\u6570\uff0cnowTime:" + System.currentTimeMillis() + "\uff0c\u76ee\u524d\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        AppParam appParamer = new AppParam(appId, viewType, null, Long.valueOf(0L));
        Map appParams = null;
        try {
            appParams = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParamer, orgs);
        }
        catch (Exception e) {
            return new QFilter("1", "=", (Object)1);
        }
        if (appParams == null || appParams.isEmpty()) {
            return new QFilter("1", "=", (Object)1);
        }
        log.info("\u67e5\u8be2\u7ec4\u7ec7\u7684\u7cfb\u7edf\u53c2\u6570\u5b8c\u6bd5\uff0c\u51c6\u5907\u5faa\u73af\u83b7\u53d6\u6240\u6709\u9694\u79bb\u7684\u7ec4\u7ec7\uff0cnowTime:" + System.currentTimeMillis() + "\uff0c\u76ee\u524d\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        ArrayList<Long> solatedOrgs = new ArrayList<Long>();
        for (Long orgId : orgs) {
            Map appParam = (Map)appParams.get(String.valueOf(orgId));
            if (appParam == null) continue;
            Object operatorGroupIsolate = appParam.get(appParamerKey);
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                solatedOrgs.add(orgId);
            }
            if (solatedOrgs.size() <= 500) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u542f\u7528\u4e1a\u52a1\u7ec4\u9694\u79bb\u7684\u7ec4\u7ec7\u6570\u8fc7\u591a\uff0c\u5c06\u4e0d\u8fdb\u884c\u4e1a\u52a1\u7ec4\u8fc7\u6ee4\u3002\u5982\u9700\u4f7f\u7528\u4e1a\u52a1\u7ec4\u8fc7\u6ee4\uff0c\u8bf7\u51cf\u5c11\u542f\u7528\u4e1a\u52a1\u7ec4\u9694\u79bb\u7684\u7ec4\u7ec7\u3002", (String)"GrpFilterHelper_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]));
        }
        if (solatedOrgs.isEmpty()) {
            return new QFilter("1", "=", (Object)1);
        }
        log.info("\u83b7\u53d6\u6240\u6709\u9694\u79bb\u7684\u7ec4\u7ec7\u5b8c\u6bd5\uff0c\u51c6\u5907\u83b7\u53d6\u6240\u6709\u9694\u79bb\u7ec4\u7ec7\u53ef\u7528\u7684\u4e1a\u52a1\u7ec4\uff0c\u62fc\u63a5sql\uff0c\u9694\u79bb\u7684\u7ec4\u7ec7\u6570\uff1a" + solatedOrgs.size() + "\uff0cnowTime:" + System.currentTimeMillis() + "\uff0c\u76ee\u524d\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        qFilter = new QFilter("org", "not in", solatedOrgs);
        for (Long orgId : solatedOrgs) {
            List<Long> allGroups = OperatorGroupFilterHelper.getHasPermissionOperatorGrp(orgId, operGrpType, userId);
            if (allGroups == null || allGroups.isEmpty()) continue;
            qFilter.or(new QFilter("org", "=", (Object)orgId).and(new QFilter(operatorgroupKey, "in", allGroups)));
        }
        log.info("\u67e5\u8be2\u6240\u6709\u9694\u79bb\u7ec4\u7ec7\u53ef\u7528\u7684\u4e1a\u52a1\u7ec4\uff0c\u62fc\u63a5sql\u5b8c\u6bd5\uff0cnowTime:" + System.currentTimeMillis() + "\uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        return qFilter;
    }

    private static List<Long> getHasPermissionOrgs(String formId, String orgViewType, Long userId) {
        ArrayList<Long> orgs = new ArrayList();
        Object temp = cache.get("permissionOrgs_" + userId + "_" + formId + "_" + orgViewType, List.class);
        if (temp instanceof List) {
            orgs = OperatorGroupFilterHelper.changeToLongList(temp);
        } else {
            List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)formId, (String)orgViewType);
            if (CommonUtils.isNull(hasPermissionOrgs)) {
                return orgs;
            }
            for (Map tempOrg : hasPermissionOrgs) {
                Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
                orgs.add(tempOrgId);
            }
            cache.put("permissionOrgs_" + userId + "_" + formId + "_" + orgViewType, orgs, 3600);
        }
        return orgs;
    }

    private static List<Long> getHasPermissionOperatorGrp(Long orgId, String operGrpType, Long userId) {
        List<Object> groups = new ArrayList();
        log.info("OperatorGroupFilterHelper , cacheAcctId:" + CacheKeyUtil.getAcctId());
        Object temp = cache.get("permissionOperatorGrp_" + userId + "_" + orgId + "_" + operGrpType, List.class);
        if (temp instanceof List && temp != null) {
            groups = OperatorGroupFilterHelper.changeToLongList(temp);
        } else {
            QFilter qf4;
            QFilter qf3;
            QFilter qf2;
            QFilter qf1 = BaseDataHelper.getBaseDataFilterByOrg("bd_operatorgroup", orgId, false);
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{qf1, qf2 = new QFilter("entryentity.operator.id", "=", (Object)userId), qf3 = new QFilter("operatorgrouptype", "=", (Object)operGrpType), qf4 = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE)});
            if (!CommonUtils.isNull(map)) {
                groups = map.values().stream().map(dym -> dym.getLong("id")).collect(Collectors.toList());
            }
            cache.put("permissionOperatorGrp_" + userId + "_" + orgId + "_" + operGrpType, groups, 3600);
        }
        return groups;
    }

    private static List<Long> changeToLongList(Object temp) {
        ArrayList<Long> list = new ArrayList<Long>();
        List changeList = (List)temp;
        for (Object o : changeList) {
            if (o instanceof Integer) {
                list.add(((Integer)o).longValue());
                continue;
            }
            if (!(o instanceof Long)) continue;
            list.add((Long)o);
        }
        return list;
    }

    public static QFilter getQFilterForShare(String appId, String entityId, String appParamerKey, String operGrpType, String viewType, Long userId, List<Long> orgs, String operatorgroupKey, String operatorKey) {
        QFilter qFilter = null;
        long start = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u8fdb\u884c\u4e1a\u52a1\u7ec4\u9694\u79bb\u76f8\u5173\u903b\u8f91\uff0c\u51c6\u5907\u67e5\u8be2\u7528\u6237\u6709\u6743\u9650\u7684\u7ec4\u7ec7\uff0cnowTime:" + start);
        if ((orgs == null || orgs.isEmpty()) && ((orgs = OperatorGroupFilterHelper.getHasPermissionOrgs(entityId, viewType, userId)) == null || orgs.isEmpty())) {
            return new QFilter("1", "!=", (Object)1);
        }
        log.info("\u67e5\u8be2\u7ec4\u7ec7\u5b8c\u6bd5\uff0c\u7ec4\u7ec7\u6570\uff1a" + orgs.size() + "\uff0c\u51c6\u5907\u67e5\u8be2\u7ec4\u7ec7\u7684\u7cfb\u7edf\u53c2\u6570\uff0cnowTime:" + System.currentTimeMillis() + "\uff0c\u76ee\u524d\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        AppParam appParamer = new AppParam(appId, viewType, null, Long.valueOf(0L));
        Map appParams = null;
        try {
            appParams = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParamer, orgs);
        }
        catch (Exception e) {
            return new QFilter("1", "=", (Object)1);
        }
        if (appParams == null || appParams.isEmpty()) {
            return new QFilter("1", "=", (Object)1);
        }
        log.info("\u67e5\u8be2\u7ec4\u7ec7\u7684\u7cfb\u7edf\u53c2\u6570\u5b8c\u6bd5\uff0c\u51c6\u5907\u5faa\u73af\u83b7\u53d6\u6240\u6709\u9694\u79bb\u7684\u7ec4\u7ec7\uff0cnowTime:" + System.currentTimeMillis() + "\uff0c\u76ee\u524d\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        ArrayList<Long> solatedOrgs = new ArrayList<Long>(8);
        for (Long orgId : orgs) {
            Map appParam = (Map)appParams.get(String.valueOf(orgId));
            if (appParam == null) continue;
            Object operatorGroupIsolate = appParam.get(appParamerKey);
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                solatedOrgs.add(orgId);
            }
            if (solatedOrgs.size() <= 500) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u542f\u7528\u4e1a\u52a1\u7ec4\u9694\u79bb\u7684\u7ec4\u7ec7\u6570\u8fc7\u591a\uff0c\u5c06\u4e0d\u8fdb\u884c\u4e1a\u52a1\u7ec4\u8fc7\u6ee4\u3002\u5982\u9700\u4f7f\u7528\u4e1a\u52a1\u7ec4\u8fc7\u6ee4\uff0c\u8bf7\u51cf\u5c11\u542f\u7528\u4e1a\u52a1\u7ec4\u9694\u79bb\u7684\u7ec4\u7ec7\u3002", (String)"GrpFilterHelper_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]));
        }
        if (solatedOrgs.isEmpty()) {
            return new QFilter("1", "=", (Object)1);
        }
        log.info("\u83b7\u53d6\u6240\u6709\u9694\u79bb\u7684\u7ec4\u7ec7\u5b8c\u6bd5\uff0c\u51c6\u5907\u83b7\u53d6\u6240\u6709\u9694\u79bb\u7ec4\u7ec7\u53ef\u7528\u7684\u4e1a\u52a1\u7ec4\uff0c\u62fc\u63a5sql\uff0c\u9694\u79bb\u7684\u7ec4\u7ec7\u6570\uff1a" + solatedOrgs.size() + "\uff0cnowTime:" + System.currentTimeMillis() + "\uff0c\u76ee\u524d\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        qFilter = new QFilter("org", "not in", solatedOrgs);
        ArrayList<Long> userGrpList = new ArrayList<Long>();
        ArrayList<Long> userOperList = new ArrayList<Long>();
        OperatorGroupFilterHelper.getOperatorGroupByUser(solatedOrgs, userId, userGrpList, userOperList, operGrpType);
        userOperList.add(0L);
        userGrpList.add(0L);
        qFilter.or(new QFilter(operatorgroupKey, "in", userGrpList));
        qFilter.or(new QFilter(operatorKey, "in", userOperList));
        log.info("\u67e5\u8be2\u6240\u6709\u9694\u79bb\u7ec4\u7ec7\u53ef\u7528\u7684\u4e1a\u52a1\u7ec4\uff0c\u62fc\u63a5sql\u5b8c\u6bd5\uff0cSQL\uff1a" + qFilter + "\uff0cnowTime:" + System.currentTimeMillis() + "\uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        return qFilter;
    }

    public static QFilter getOperatorGroupByUserForAll(long userId, DynamicObject org, String operatorGroupType) {
        ArrayList<Long> userGrpList = new ArrayList<Long>(8);
        ArrayList<Long> userOperList = new ArrayList<Long>(8);
        ArrayList<Long> orgList = new ArrayList<Long>(8);
        orgList.add(org.getLong("id"));
        OperatorGroupFilterHelper.getOperatorGroupByUser(orgList, userId, userGrpList, userOperList, operatorGroupType);
        QFilter qFilter = new QFilter("operatorgrpid", "in", userGrpList);
        qFilter.or(new QFilter("id", "in", userOperList));
        if (userGrpList.isEmpty() && userOperList.isEmpty()) {
            qFilter = new QFilter("1", "=", (Object)1);
        }
        return qFilter;
    }

    public static void getOperatorGroupByUser(List<Long> orgIds, long userId, List<Long> userGrpList, List<Long> userOperList, String operatorGroupType) {
        if (userGrpList == null || userOperList == null || orgIds == null || StringUtils.isEmpty((String)operatorGroupType)) {
            return;
        }
        QFilter orgQFilter = OperatorGroupFilterHelper.getOrgQFilter(orgIds, operatorGroupType);
        QFilter q1 = new QFilter("entryentity.operator.id", "=", (Object)userId);
        q1.and("entryentity.invalid", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection operatorCollection = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"id,groupdatashare,entryentity.charge charge,entryentity.id entryid", (QFilter[])new QFilter[]{orgQFilter, q1});
        if (operatorCollection != null && operatorCollection.size() > 0) {
            for (DynamicObject operator : operatorCollection) {
                if (operator == null) continue;
                if (operator.getBoolean("groupdatashare") || operator.getBoolean("charge")) {
                    userGrpList.add(operator.getLong("id"));
                    continue;
                }
                userOperList.add(operator.getLong("entryid"));
            }
        }
        if (CollectionUtils.isEmpty(userGrpList) && CollectionUtils.isEmpty(userOperList)) {
            DynamicObjectCollection grpList = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{orgQFilter});
            for (DynamicObject grp : grpList) {
                userGrpList.add(grp.getLong("id"));
            }
        }
    }

    private static QFilter getOrgQFilter(List<Long> orgIds, String operatorGroupType) {
        QFilter orgQ = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIds, (boolean)Boolean.TRUE);
        QFilter qFilterType = new QFilter("operatorgrouptype", "=", (Object)operatorGroupType);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        return orgQ.and(qFilterType).and(enableFilter);
    }
}

