/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.business.helper.BaseDataHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MetadataUtils;

public class OperatorGroupHelper {
    public static boolean checkOperatorGroupByOrgAndUser(Long orgId, String OperatorGrpType, Long userID, Long operatorgroupId) {
        List<Long> operatorGrpList = OperatorGroupHelper.getAllOperatorGroupByOrgAndUser(orgId, OperatorGrpType, userID);
        return operatorGrpList.contains(operatorgroupId);
    }

    public static boolean checkOperatorGroupByOrg(Long orgId, String OperatorGrpType, Long operatorgroupId) {
        List<Object> operatorGrpList = new ArrayList();
        QFilter qf1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qf2 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{qf1, qf2});
        if (!CommonUtils.isNull(map)) {
            operatorGrpList = map.values().stream().map(dym -> dym.getLong("id")).collect(Collectors.toList());
        }
        return operatorGrpList.contains(operatorgroupId);
    }

    public static boolean checkOperator(DynamicObject operator) {
        if (operator == null) {
            return false;
        }
        if (!MetadataUtils.checkProperty(operator, "invalid")) {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator", (String)"invalid");
        }
        return operator != null && !operator.getBoolean("invalid");
    }

    public static List<Long> getAllOperatorGroupByOrgAndUser(Long orgId, String OperatorGrpType, Long userID) {
        List<Long> operatorGrpList = new ArrayList<Long>();
        QFilter qf1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId).and("enable", "=", (Object)Boolean.TRUE).and("entryentity.operator", "=", (Object)userID).and("entryentity.invalid", "=", (Object)Boolean.FALSE);
        Map operatorgroups = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])qf1.toArray());
        QFilter qf2 = new QFilter("operatorid", "=", (Object)userID);
        QFilter qf3 = new QFilter("opergrptype", "=", (Object)OperatorGrpType);
        QFilter qf4 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        QFilter qf5 = new QFilter("operatorgrpid", "in", operatorgroups.keySet());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"id,operatorgrpid", (QFilter[])new QFilter[]{qf2, qf3, qf4, qf5});
        if (!CommonUtils.isNull(map)) {
            operatorGrpList = map.values().stream().map(dym -> dym.getLong("operatorgrpid")).collect(Collectors.toList());
        }
        return operatorGrpList;
    }

    public static List<Long> getAllOperatorGroupByOrgsAndUser(List<Long> orgIds, String OperatorGrpType, Long userID) {
        List<Long> operatorGrpList = new ArrayList<Long>();
        QFilter qf1 = new QFilter("operatorgrpid", "in", OperatorGroupHelper.getAllOperatorGroupByOrgs(orgIds, OperatorGrpType));
        QFilter qf2 = new QFilter("operatorid", "=", (Object)userID);
        QFilter qf3 = new QFilter("opergrptype", "=", (Object)OperatorGrpType);
        QFilter qf4 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"id,operatorgrpid", (QFilter[])new QFilter[]{qf1, qf2, qf3, qf4});
        if (!CommonUtils.isNull(map)) {
            operatorGrpList = map.values().stream().map(dym -> dym.getLong("operatorgrpid")).collect(Collectors.toList());
        }
        return operatorGrpList;
    }

    public static List<Long> getAllOperatorGroupByOrg(Long orgId, String OperatorGrpType) {
        List<Long> operatorGrpList = new ArrayList<Long>();
        QFilter qf1 = BaseDataHelper.getBaseDataFilterByOrg("bd_operatorgroup", orgId, false);
        QFilter qf2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpType);
        QFilter qf3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (!CommonUtils.isNull(map)) {
            operatorGrpList = map.values().stream().map(dym -> dym.getLong("id")).collect(Collectors.toList());
        }
        return operatorGrpList;
    }

    public static List<Long> getAllOperatorGroupByOrgs(List<Long> orgIds, String OperatorGrpType) {
        List<Long> operatorGrpList = new ArrayList<Long>();
        QFilter qf1 = BaseDataHelper.getBaseDataFilterByOrgs("bd_operatorgroup", orgIds, false);
        QFilter qf2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpType);
        QFilter qf3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (!CommonUtils.isNull(map)) {
            operatorGrpList = map.values().stream().map(dym -> dym.getLong("id")).collect(Collectors.toList());
        }
        return operatorGrpList;
    }

    public static DynamicObject getDefaultOperatorObject(Long orgId, String OperatorGrpType, Long userID) {
        List<Long> operatorGroupList = OperatorGroupHelper.getAllOperatorGroupByOrg(orgId, OperatorGrpType);
        if (operatorGroupList.isEmpty()) {
            return null;
        }
        QFilter qf1 = new QFilter("operatorgrpid", "in", operatorGroupList);
        QFilter qf2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        QFilter qf3 = new QFilter("operatorid", "=", (Object)userID);
        QFilter qf4 = new QFilter("opergrptype", "=", (Object)OperatorGrpType);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qf1, qf2, qf3, qf4});
        if (map == null || map.isEmpty()) {
            return null;
        }
        return (DynamicObject)map.entrySet().iterator().next().getValue();
    }

    public static Map<String, DynamicObject> getDefaultOperatorAndGroupByOrg(Long orgId, Long userId, String operatorGrpType) {
        QFilter qFilter04;
        QFilter qFilter03;
        QFilter qFilter02;
        Map<Object, DynamicObject> operatorGroupDynamicObjectMap = OperatorGroupHelper.getOperatorGroupDynamicObjectMap(orgId, operatorGrpType);
        HashMap<String, DynamicObject> defaultOperatorAndGroup = new HashMap<String, DynamicObject>(4);
        if (operatorGroupDynamicObjectMap == null || operatorGroupDynamicObjectMap.size() == 0) {
            return defaultOperatorAndGroup;
        }
        QFilter qFilter01 = new QFilter("operatorgrpid", "in", operatorGroupDynamicObjectMap.keySet());
        Map operatorMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype,invalid", (QFilter[])new QFilter[]{qFilter01, qFilter02 = new QFilter("opergrptype", "=", (Object)operatorGrpType), qFilter03 = new QFilter("operatorid", "=", (Object)userId), qFilter04 = new QFilter("invalid", "=", (Object)Boolean.FALSE)});
        if (operatorMap != null && !operatorMap.isEmpty()) {
            for (DynamicObject operator : operatorMap.values()) {
                if (operator == null) continue;
                defaultOperatorAndGroup.put("operator", operator);
                defaultOperatorAndGroup.put("operatorgroup", operatorGroupDynamicObjectMap.get(operator.get("operatorgrpid")));
                break;
            }
        }
        return defaultOperatorAndGroup;
    }

    public static Map<Object, DynamicObject> getOperatorGroupDynamicObjectMap(Long orgId, String operatorGrpType) {
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        return BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
    }

    public static boolean isOperatorGroupIsolate(Long orgId, String appNumber) {
        Object param = SysParamHelper.getSysParamByAppNumber(appNumber, null, orgId, "foperatorgroupisolate");
        if (param instanceof Boolean) {
            return (Boolean)param;
        }
        return false;
    }
}

