/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.enums.BillStatusEnum;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.pojo.SCMCBomEntryData;
import kd.mpscmm.msbd.common.pojo.SCMCBomExpandData;
import kd.mpscmm.msbd.common.pojo.SCMCBomHeadData;

public class SCMCBomHelper {
    private static final int maxExpandLevel = 100;
    private static final int kitExpandLevel = 1;
    private static final String kitEntityName = "msbd_kitbom";

    public static SCMCBomExpandData expandSCMCBOM(Long bomId, String entityName, Map<String, Object> parameters) {
        DynamicObject scmcBomFiltered;
        QFilter idFilter;
        DynamicObject scmcBom;
        SCMCBomExpandData scmcBomExpandData = new SCMCBomExpandData();
        if (bomId == null || entityName == null || StringUtils.isEmpty((CharSequence)entityName)) {
            scmcBomExpandData.setResultStatusFail();
            String msg = ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5fc5\u5f55\u53c2\u6570\u3002", (String)"SCMCBomHelper_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]);
            scmcBomExpandData.setResultMsg(msg);
            return scmcBomExpandData;
        }
        int expandLevel = 100;
        Date expandDate = new Date();
        BigDecimal parentQty = BigDecimal.ONE;
        Long orgId = 0L;
        ArrayList<String> customEntryFields = new ArrayList(10);
        if (parameters != null) {
            if (parameters.get("expandLevel") != null && (Integer)parameters.get("expandLevel") < expandLevel && (expandLevel = ((Integer)parameters.get("expandLevel")).intValue()) <= 0) {
                expandLevel = 1;
            }
            if (parameters.get("expandDate") != null) {
                expandDate = (Date)parameters.get("expandDate");
            }
            if (parameters.get("parentQty") != null) {
                parentQty = (BigDecimal)parameters.get("parentQty");
            }
            if (parameters.get("expandOrgId") != null) {
                orgId = (Long)parameters.get("expandOrgId");
            }
            if (parameters.get("customEntryFields") != null) {
                customEntryFields = (List)parameters.get("customEntryFields");
            }
        }
        if ((scmcBom = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (QFilter[])new QFilter[]{idFilter = new QFilter("id", "=", (Object)bomId)})) == null) {
            scmcBomExpandData.setBomId(bomId);
            scmcBomExpandData.setResultStatusFail();
            String msg = String.format(ResManager.loadKDString((String)"BomId\u201c%1$s\u201d\uff0c\u672a\u627e\u5230\u53ef\u7528\u7684BOM\u6570\u636e\u3002", (String)"SCMCBomHelper_1", (String)"mpscmm-msbd-common", (Object[])new Object[0]), bomId);
            scmcBomExpandData.setResultMsg(msg);
            return scmcBomExpandData;
        }
        String bomNumber = scmcBom.getString("number");
        QFilter statusFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        if (orgId != null && orgId != 0L) {
            enableFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)orgId));
        }
        if ((scmcBomFiltered = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (QFilter[])new QFilter[]{idFilter, statusFilter, enableFilter})) == null) {
            scmcBomExpandData.setBomId(bomId);
            scmcBomExpandData.setBomNumber(bomNumber);
            scmcBomExpandData.setResultStatusFail();
            String msg = String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\u201c%1$s\u201d\uff0c\u672a\u627e\u5230\u53ef\u7528\u7684BOM\u6570\u636e\u3002", (String)"SCMCBomHelper_3", (String)"mpscmm-msbd-common", (Object[])new Object[0]), bomNumber);
            scmcBomExpandData.setResultMsg(msg);
            return scmcBomExpandData;
        }
        scmcBomExpandData = SCMCBomHelper.setScmcAndHeadData(scmcBomExpandData, scmcBom, orgId, entityName, parentQty, expandLevel, 1, expandDate, new HashSet<Long>(8), customEntryFields);
        return scmcBomExpandData;
    }

    public static SCMCBomExpandData expandOneKitBOM(Long bomId, Map<String, Object> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, Object>(8);
        }
        if (parameters.get("expandLevel") == null) {
            parameters.put("expandLevel", 1);
        }
        SCMCBomExpandData data = SCMCBomHelper.expandSCMCBOM(bomId, kitEntityName, parameters);
        return data;
    }

    public static List<SCMCBomExpandData> expandKitBOM(List<Long> bomIdList, Map<String, Object> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, Object>(8);
        }
        if (parameters.get("expandLevel") == null) {
            parameters.put("expandLevel", 1);
        }
        ArrayList<SCMCBomExpandData> dataList = new ArrayList<SCMCBomExpandData>();
        for (Long bomId : bomIdList) {
            try {
                SCMCBomExpandData data = SCMCBomHelper.expandSCMCBOM(bomId, kitEntityName, parameters);
                dataList.add(data);
            }
            catch (KDBizException e) {
                SCMCBomExpandData result = new SCMCBomExpandData();
                result.setResultStatusFail();
                result.setBomId(bomId);
                result.setResultMsg(e.getMessage());
                dataList.add(result);
            }
        }
        return dataList;
    }

    private static SCMCBomExpandData setScmcAndHeadData(SCMCBomExpandData scmcBomExpandData, DynamicObject scmcBom, Long orgId, String entityName, BigDecimal parentQty, int expandLevel, int nowLevel, Date expandDate, Set<Long> bomPath, List<String> customEntryFields) {
        DynamicObject version;
        DynamicObject material;
        DynamicObject createOrg;
        DynamicObject bomGroup;
        DynamicObject bomType;
        if (scmcBom == null || scmcBomExpandData == null || scmcBom.getPkValue() == null || nowLevel > expandLevel) {
            return scmcBomExpandData;
        }
        if (!bomPath.add((Long)scmcBom.getPkValue())) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524dBOM\u7ed3\u6784\u51fa\u73b0\u5faa\u73af\u6570\u636e\uff0cBOM\u7ed3\u6784\u9519\u8bef\uff0c\u5c55\u5f00\u5931\u8d25\u3002", (String)"SCMCBomHelper_2", (String)"mpscmm-msbd-common", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        scmcBomExpandData.setBomId((Long)scmcBom.getPkValue());
        if (scmcBom.containsProperty("number")) {
            scmcBomExpandData.setBomNumber(scmcBom.getString("number"));
        }
        if (scmcBom.containsProperty("type") && (bomType = scmcBom.getDynamicObject("type")) != null) {
            if (bomType.getPkValue() != null) {
                scmcBomExpandData.setBomTypeId((Long)bomType.getPkValue());
            }
            if (bomType.containsProperty("number")) {
                scmcBomExpandData.setBomTypeNumber(bomType.getString("number"));
            }
            if (bomType.containsProperty("name")) {
                scmcBomExpandData.setBomTypeName(bomType.getString("name"));
            }
        }
        if (scmcBom.containsProperty("group") && (bomGroup = scmcBom.getDynamicObject("group")) != null) {
            if (bomGroup.getPkValue() != null) {
                scmcBomExpandData.setBomGroupId((Long)bomGroup.getPkValue());
            }
            if (bomGroup.containsProperty("number")) {
                scmcBomExpandData.setBomGroupNumber(bomGroup.getString("number"));
            }
            if (bomGroup.containsProperty("name")) {
                scmcBomExpandData.setBomGroupName(bomGroup.getString("name"));
            }
        }
        if (scmcBom.containsProperty("createorg") && (createOrg = scmcBom.getDynamicObject("createorg")) != null) {
            if (createOrg.getPkValue() != null) {
                scmcBomExpandData.setCreateOrgId((Long)createOrg.getPkValue());
            }
            if (createOrg.containsProperty("number")) {
                scmcBomExpandData.setCreateOrgNumber(createOrg.getString("number"));
            }
            if (createOrg.containsProperty("name")) {
                scmcBomExpandData.setCreateOrgName(createOrg.getString("name"));
            }
        }
        if (scmcBom.containsProperty("status")) {
            scmcBomExpandData.setStatus(scmcBom.getString("status"));
        }
        if (scmcBom.containsProperty("enable")) {
            scmcBomExpandData.setEnable(scmcBom.getString("enable"));
        }
        SCMCBomHeadData headData = new SCMCBomHeadData();
        if (scmcBom.containsProperty("material") && (material = scmcBom.getDynamicObject("material")) != null) {
            DynamicObject baseUnit;
            if (material.getPkValue() != null) {
                headData.setMaterialId((Long)material.getPkValue());
            }
            if (material.containsProperty("number")) {
                headData.setMaterialNumber(material.getString("number"));
            }
            if (material.containsProperty("name")) {
                headData.setMaterialName(material.getString("name"));
            }
            if (material.containsProperty("baseunit") && (baseUnit = material.getDynamicObject("baseunit")) != null) {
                if (baseUnit.getPkValue() != null) {
                    headData.setBaseUnitId((Long)baseUnit.getPkValue());
                }
                if (baseUnit.containsProperty("number")) {
                    headData.setBaseUnitNumber(baseUnit.getString("number"));
                }
                if (baseUnit.containsProperty("name")) {
                    headData.setBaseUnitName(baseUnit.getString("name"));
                }
            }
        }
        if (scmcBom.containsProperty("version") && (version = scmcBom.getDynamicObject("version")) != null) {
            if (version.getPkValue() != null) {
                headData.setVersionId((Long)version.getPkValue());
            }
            if (version.containsProperty("number")) {
                headData.setVersionNumber(version.getString("number"));
            }
            if (version.containsProperty("name")) {
                headData.setVersionName(version.getString("name"));
            }
        }
        if (parentQty != null) {
            headData.setQty(parentQty);
        }
        scmcBomExpandData.setHeadData(headData);
        DynamicObjectCollection scmcBomEntrys = scmcBom.getDynamicObjectCollection("entry");
        if (scmcBomEntrys == null) {
            return scmcBomExpandData;
        }
        ArrayList<SCMCBomEntryData> entryDataList = new ArrayList<SCMCBomEntryData>(8);
        for (DynamicObject scmcBomEntry : scmcBomEntrys) {
            DynamicObject entryUnit;
            BigDecimal entryQtyDenominator;
            DynamicObject entryMaterial;
            if (!scmcBomEntry.containsProperty("entryvaliddate") || !scmcBomEntry.containsProperty("entryinvaliddate")) continue;
            Date validDate = scmcBomEntry.getDate("entryvaliddate");
            Date invalidDate = scmcBomEntry.getDate("entryinvaliddate");
            if (validDate == null || invalidDate == null) continue;
            SCMCBomEntryData scmcBomEntryData = new SCMCBomEntryData();
            if (scmcBomEntry.containsProperty("entrymaterial") && (entryMaterial = scmcBomEntry.getDynamicObject("entrymaterial")) != null) {
                if (entryMaterial.getPkValue() != null) {
                    scmcBomEntryData.setEntryMaterialId((Long)entryMaterial.getPkValue());
                }
                if (entryMaterial.containsProperty("number")) {
                    scmcBomEntryData.setEntryMaterialNumber(entryMaterial.getString("number"));
                }
                if (entryMaterial.containsProperty("name")) {
                    scmcBomEntryData.setEntryMaterialName(entryMaterial.getString("name"));
                }
            }
            if (scmcBomEntry.containsProperty("entryqtynumerator")) {
                scmcBomEntryData.setEntryQtyNumerator(scmcBomEntry.getBigDecimal("entryqtynumerator"));
            }
            if (scmcBomEntry.containsProperty("entryqtydenominator")) {
                scmcBomEntryData.setEntryQtyDenominator(scmcBomEntry.getBigDecimal("entryqtydenominator"));
            }
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal entryQtyNumerator = scmcBomEntryData.getEntryQtyNumerator() == null ? BigDecimal.ZERO : scmcBomEntryData.getEntryQtyNumerator();
            BigDecimal bigDecimal = entryQtyDenominator = scmcBomEntryData.getEntryQtyDenominator() == null ? BigDecimal.ZERO : scmcBomEntryData.getEntryQtyDenominator();
            if (scmcBomEntry.containsProperty("entryunit") && (entryUnit = scmcBomEntry.getDynamicObject("entryunit")) != null) {
                if (entryUnit.getPkValue() != null) {
                    scmcBomEntryData.setEntryUnitId((Long)entryUnit.getPkValue());
                }
                if (entryUnit.containsProperty("number")) {
                    scmcBomEntryData.setEntryUnitNumber(entryUnit.getString("number"));
                }
                if (entryUnit.containsProperty("name")) {
                    scmcBomEntryData.setEntryUnitName(entryUnit.getString("name"));
                }
                if (entryQtyDenominator.compareTo(BigDecimal.ZERO) != 0) {
                    int precision = 10;
                    Object roundingMode = RoundingMode.HALF_UP;
                    if (entryUnit.containsProperty("precision") && (precision = entryUnit.getInt("precision")) == 0) {
                        precision = 10;
                    }
                    if (entryUnit.containsProperty("precisionaccount")) {
                        String precisionAccount = entryUnit.getString("precisionaccount");
                        if ("3".equals(precisionAccount)) {
                            roundingMode = RoundingMode.UP;
                        } else if ("2".equals(precisionAccount)) {
                            roundingMode = RoundingMode.DOWN;
                        }
                    }
                    qty = parentQty.multiply(entryQtyNumerator).divide(entryQtyDenominator, precision, (RoundingMode)((Object)roundingMode));
                }
            }
            scmcBomEntryData.setQty(qty);
            if (scmcBomEntry.containsProperty("entryqtytype")) {
                scmcBomEntryData.setEntryQtyType(scmcBomEntry.getString("entryqtytype"));
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            scmcBomEntryData.setEntryValidDate(validDate);
            scmcBomEntryData.setEntryValidDateStr(formatter.format(validDate.getTime()));
            scmcBomEntryData.setEntryInvalidDate(invalidDate);
            scmcBomEntryData.setEntryInvalidDateStr(formatter.format(invalidDate.getTime()));
            if (customEntryFields != null && !customEntryFields.isEmpty()) {
                HashMap<String, Object> customParam = new HashMap<String, Object>(customEntryFields.size());
                for (String field : customEntryFields) {
                    if (!scmcBomEntry.containsProperty(field)) continue;
                    customParam.put(field, scmcBomEntry.get(field));
                }
                scmcBomEntryData.setCustParam(customParam);
            }
            if (scmcBomEntryData.getEntryMaterialId() != null) {
                Map nextLevelScmcBoms;
                QFilter materialIdFilter = new QFilter("material.id", "=", (Object)scmcBomEntryData.getEntryMaterialId());
                QFilter statusFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
                QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
                if (orgId != null && orgId != 0L) {
                    enableFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)orgId));
                }
                if ((nextLevelScmcBoms = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,number,type,group,createorg,status,enable,material,material.baseunit,version,entry.entrymaterial,entry.entryunit,entry.entryqtytype,entry.entryqtynumerator,entry.entryqtydenominator,entry.entryvaliddate,entry.entryinvaliddate,createtime", (QFilter[])new QFilter[]{materialIdFilter, statusFilter, enableFilter}, (String)"createtime desc")) != null && !nextLevelScmcBoms.isEmpty()) {
                    scmcBomEntryData.setHasExpandData(Boolean.TRUE);
                    DynamicObject nextLevelScmcBom = (DynamicObject)nextLevelScmcBoms.entrySet().iterator().next().getValue();
                    SCMCBomExpandData expandData = new SCMCBomExpandData();
                    expandData = SCMCBomHelper.setScmcAndHeadData(expandData, nextLevelScmcBom, orgId, entityName, qty, expandLevel, nowLevel + 1, expandDate, new HashSet<Long>(bomPath), customEntryFields);
                    scmcBomEntryData.setExpandData(expandData);
                } else {
                    scmcBomEntryData.setHasExpandData(Boolean.FALSE);
                }
            } else {
                scmcBomEntryData.setHasExpandData(Boolean.FALSE);
            }
            entryDataList.add(scmcBomEntryData);
        }
        scmcBomExpandData.setEntryDataList(entryDataList);
        return scmcBomExpandData;
    }
}

