/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.botp.AmountPropertyKey;
import kd.mpscmm.msbd.business.helper.botp.POAmountInfo;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;

public class PurOrderDefValueHelper {
    private static final Log log = LogFactory.getLog(PurOrderDefValueHelper.class);
    private static final String PMAPPID = "/JJVO8XV9MVB";
    private static final String PMVIEWTYPE = "02";
    private Map<String, DynamicObject> bizSettleOrg4PurMap = new HashMap<String, DynamicObject>();
    private Map<String, Object> payOrgDefault4PurMap = new HashMap<String, Object>();
    private Map<String, Long> bizSettleOrgMap = new HashMap<String, Long>();
    private Map<String, DynamicObject> bizOwnerMap = new HashMap<String, DynamicObject>();
    private Map<String, DynamicObject> cacheDymMap = new HashMap<String, DynamicObject>(10);
    private Map<String, Object> cacheUnitConvertFactor = new HashMap<String, Object>(10);
    private Map<Long, String> cacheSupplierDefAddressMap = new HashMap<Long, String>(10);
    private Map<Long, Long> cacheBizUserDeptMap = new HashMap<Long, Long>(10);
    private Map<String, Map<String, DynamicObject>> cacheDefOperatorAndGroupMap = new HashMap<String, Map<String, DynamicObject>>(10);
    private static final int POINT_MOVE = 2;
    private static final String BIZ_FUNCTION_KEY = "bizfunction";
    private static final String DELIVER_SUPPLIER_KEY = "deliversupplierid";
    private static final String INVOICE_SUPPLIER_KEY = "invoicesupplierid";
    private static final String RECEIVING_SUPPLIER_KEY = "receivingsupplierid";
    private static final String CUR_AMTPRECISION = "amtprecision";
    private static final String CUR_PRICEPRECISION = "priceprecision";
    private static final String ENTRY_ID = "entrynum";
    private static final String TOTALALLAMOUNT = "totalallamount";
    private static final String BIZTIME = "biztime";
    private static final String AMOUNTCONDITION = "amountcondition";
    private static final String ISPAYRATE = "ispayrate";
    private static final String SETTLECURRENCY = "settlecurrency";
    private static final String ENTRY_ITEMNAME = "itemname";
    private static final String ENTRY_AMOUNT = "amount";
    private static final String ENTRY_RATE = "rate";
    private static final String ENTRY_ISPREPAY = "isprepay";
    private static final String ENTRY_AMOUNTDATE = "amountdate";
    private static final String CHANGETYPE = "changetype";
    private static final String PLANTYPE = "plantype";
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final long INVOICEBIZTYPEID = 1533341968170710016L;
    private static final String ENTITYNAME = "bd_invoicebiztype";
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";
    private static final String CONV_NUMERATOR = "numerator";
    private static final String CONV_DENOMINATOR = "denominator";
    private static final String CURRENCY_DT = "bd_currency";
    private static final String EXRATETABLE_DT = "bd_exratetable";
    private static final String BASECURRRENCY = "baseCurrencyID";
    private static final String EXRATETABLE = "exchangeRateTableID";

    private PurOrderDefValueHelper() {
    }

    public static List<DynamicObject> batchSetPurOrderDefValue(List<DynamicObject> bills) {
        if (bills == null || bills.size() == 0) {
            return bills;
        }
        PurOrderDefValueHelper helper = new PurOrderDefValueHelper();
        return helper.batchSetDefValue(bills);
    }

    private List<DynamicObject> batchSetDefValue(List<DynamicObject> bills) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        AmountPropertyKey amountPropertyKey = AmountPropertyKey.getInstance();
        if (bills == null || bills.size() == 0) {
            return null;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject bill : bills) {
            DynamicObject billType;
            DynamicObject dept;
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) {
                log.info("\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a");
                continue;
            }
            Long orgId = (Long)org.getPkValue();
            DynamicObject operator = bill.getDynamicObject("operator");
            DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
            if ((operator == null || operatorGroup == null) && 0L != userId) {
                this.initOperatorGroup(orgId, operator, userId, operatorGroup, bill);
            }
            if ((dept = bill.getDynamicObject("dept")) == null) {
                this.initDept(bill);
            }
            if ((billType = bill.getDynamicObject("billtype")) == null) {
                log.info("\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a");
                continue;
            }
            DynamicObject bizType = bill.getDynamicObject("biztype");
            if (bizType == null) {
                bizType = this.getDefaultBizType(billType);
                bill.set("biztype", (Object)bizType);
            }
            DynamicObject settleOrg = this.initSettleOrg(orgId, bill, this.bizSettleOrg4PurMap);
            DynamicObject payOrg = this.getPayOrgDefault(settleOrg, this.payOrgDefault4PurMap);
            DynamicObject supplier = bill.getDynamicObject("supplier");
            this.setDefaultSupplier(bill);
            DynamicObject currency = bill.getDynamicObject("currency");
            DynamicObject settleCurrency = bill.getDynamicObject(SETTLECURRENCY);
            DynamicObject exRateTable = bill.getDynamicObject("exratetable");
            BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
            Date exRateTime = bill.getDate("exratedate");
            String exchangeType = bill.getString("exchangetype");
            if (currency == null) {
                currency = this.getCurrency(orgId);
                bill.set("currency", (Object)currency);
            }
            if (settleCurrency == null) {
                settleCurrency = currency;
                bill.set(SETTLECURRENCY, (Object)currency);
            }
            if (exRateTable == null) {
                exRateTable = this.getExRateTable(orgId);
                bill.set("exratetable", (Object)exRateTable);
            }
            if (currency != null && exRateTable != null) {
                BigDecimal exRate = null;
                if (StringUtils.isEmpty((CharSequence)exchangeType)) {
                    Map<String, Object> exRateMap = this.getExRateMap((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), exRateTime);
                    exRate = (BigDecimal)exRateMap.get("exchangerate");
                    exchangeType = (String)exRateMap.get("exchangetype");
                    bill.set("exchangetype", (Object)exchangeType);
                }
                if (PurOrderDefValueHelper.isBlank(exchangeRate)) {
                    exchangeRate = exRate != null ? exRate : this.getExRate((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), exRateTime, exchangeType);
                    bill.set("exchangerate", (Object)exchangeRate);
                }
            }
            boolean isTax = bill.getBoolean("istax");
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            BigDecimal totalAmountAndTax = BigDecimal.ZERO;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            DynamicObject defLineType = null;
            for (int i = 0; i < entries.size(); ++i) {
                Map<String, BigDecimal> entryAmountMap;
                DynamicObject entry = (DynamicObject)entries.get(i);
                if (bizType != null && entry.get("linetype") == null) {
                    Long lineTypeId;
                    if (defLineType == null && (lineTypeId = this.getDefaultLineType((Long)bizType.getPkValue())) != null) {
                        defLineType = this.loadSingleFromCache(lineTypeId, "bd_linetype");
                    }
                    if (defLineType != null) {
                        entry.set("linetype", defLineType);
                    }
                }
                if (entry.get("entrysettleorg") == null) {
                    entry.set("entrysettleorg", (Object)settleOrg);
                }
                if (entry.get("entrypayorg") == null) {
                    entry.set("entrypayorg", (Object)payOrg);
                }
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject masterMaterial = entry.getDynamicObject("materialmasterid");
                if (masterMaterial == null && material != null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
                    entry.set("materialmasterid", (Object)masterMaterial);
                }
                this.initOwner(orgId, bizType, supplier, entry, this.bizSettleOrgMap, this.bizOwnerMap);
                this.initQty(entry);
                PurOrderDefValueHelper.initMaterialControlDay(entry);
                if (StringUtils.isEmpty((CharSequence)entry.getString("discounttype"))) {
                    entry.set("discounttype", (Object)"NULL");
                }
                BigDecimal amount = entry.getBigDecimal(ENTRY_AMOUNT);
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                BigDecimal taxAmount = entry.getBigDecimal("taxamount");
                BigDecimal qty = entry.getBigDecimal("qty");
                if ((PurOrderDefValueHelper.isBlank(amount) || PurOrderDefValueHelper.isBlank(amountAndTax)) && !PurOrderDefValueHelper.isBlank(qty) && !(entryAmountMap = this.calcAmount(bill, amountPropertyKey, i)).isEmpty()) {
                    amount = entryAmountMap.get(amountPropertyKey.getAmount());
                    taxAmount = entryAmountMap.get(amountPropertyKey.getTaxAmount());
                    amountAndTax = entryAmountMap.get(amountPropertyKey.getAmountAndTax());
                }
                if (amount != null) {
                    totalAmount = totalAmount.add(amount);
                }
                if (taxAmount != null) {
                    totalTaxAmount = totalTaxAmount.add(taxAmount);
                }
                if (amountAndTax != null) {
                    totalAmountAndTax = totalAmountAndTax.add(amountAndTax);
                }
                BigDecimal curAmountAndTax = entry.getBigDecimal("curamountandtax");
                BigDecimal curAmount = entry.getBigDecimal("curamount");
                BigDecimal curTaxAmount = entry.getBigDecimal("curtaxamount");
                if (PurOrderDefValueHelper.isBlank(exchangeRate) || !PurOrderDefValueHelper.isBlank(curAmountAndTax) && !PurOrderDefValueHelper.isBlank(curAmount) && !PurOrderDefValueHelper.isBlank(curTaxAmount)) continue;
                int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
                boolean indirectRate = this.isIndirectRate(exchangeType);
                curTaxAmount = this.convertByExRate(taxAmount, exchangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                if (isTax) {
                    curAmountAndTax = this.convertByExRate(amountAndTax, exchangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                    curAmount = curAmountAndTax.subtract(curTaxAmount);
                } else {
                    curAmount = this.convertByExRate(amount, exchangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                    curAmountAndTax = curAmount.add(curTaxAmount);
                }
                entry.set("curamountandtax", (Object)curAmountAndTax);
                entry.set("curamount", (Object)curAmount);
                entry.set("curtaxamount", (Object)curTaxAmount);
            }
            bill.set("totalamount", (Object)totalAmount);
            bill.set("totaltaxamount", (Object)totalTaxAmount);
            bill.set(TOTALALLAMOUNT, (Object)totalAmountAndTax);
            this.changeAmountConditionForDynamicObject(this.getPlanCommonFieldMapping(), bill);
            DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("purbillentry_pay");
            for (DynamicObject entry : payEntrys) {
                Boolean isPreRec = entry.getBoolean(ENTRY_ISPREPAY);
                if (isPreRec == null || isPreRec.booleanValue()) continue;
                entry.set("pretimepoint", (Object)"");
            }
            result.add(bill);
        }
        return result;
    }

    private void initDept(DynamicObject bill) {
        DynamicObject bizUser;
        DynamicObject operator = bill.getDynamicObject("operator");
        if (operator != null && (bizUser = operator.getDynamicObject("operatorid")) != null) {
            Long bizUserPkValue = (Long)bizUser.getPkValue();
            Long deptId = this.cacheBizUserDeptMap.get(bizUserPkValue);
            if (deptId == null) {
                deptId = UserServiceHelper.getUserMainOrgId((long)bizUserPkValue);
                this.cacheBizUserDeptMap.put(bizUserPkValue, deptId);
            }
            if (deptId != null) {
                DynamicObject deptDefault = this.loadSingleFromCache(deptId, "bos_org");
                bill.set("dept", (Object)deptDefault);
            }
        }
    }

    private DynamicObject loadSingleFromCache(Object pkId, String entityNo) {
        if (this.isNull(entityNo) || this.isNull(pkId)) {
            return null;
        }
        if (this.cacheDymMap == null) {
            this.cacheDymMap = new HashMap<String, DynamicObject>(8);
        }
        String key = entityNo.concat("_").concat(pkId.toString());
        Set<String> uniqueKeys = this.cacheDymMap.keySet();
        if (uniqueKeys.contains(key)) {
            DynamicObject dymObj = this.cacheDymMap.get(key);
            return dymObj;
        }
        DynamicObject dym = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)entityNo);
        this.cacheDymMap.put(key, dym);
        return dym;
    }

    private void initOperatorGroup(Long orgId, DynamicObject operator, long userId, DynamicObject operatorGroup, DynamicObject bill) {
        StringBuilder sb = new StringBuilder();
        StringBuilder defOperatorKey = sb.append(orgId).append('_').append(userId);
        Map<String, DynamicObject> operatorAndGroup = this.cacheDefOperatorAndGroupMap.get(defOperatorKey.toString());
        if (operatorAndGroup == null) {
            operatorAndGroup = this.getDefaultOperatorAndGroupByOrg(orgId, userId, "CGZ");
            if (operatorAndGroup == null) {
                operatorAndGroup = new HashMap<String, DynamicObject>(3);
            }
            this.cacheDefOperatorAndGroupMap.put(defOperatorKey.toString(), operatorAndGroup);
        }
        if (operatorAndGroup.isEmpty()) {
            return;
        }
        if (operator == null) {
            bill.set("operator", (Object)operatorAndGroup.get("operator"));
        }
        if (operatorGroup == null) {
            bill.set("operatorgroup", (Object)operatorAndGroup.get("operatorgroup"));
        }
    }

    private DynamicObject getDefaultBizType(DynamicObject billType) {
        DynamicObject bizType = null;
        Long bizTypeId = this.getDefaultBizType("pm_purorderbill", (Long)billType.getPkValue(), "pm_billtypeparameter");
        if (bizTypeId != null) {
            bizType = this.loadSingleFromCache(bizTypeId, "bd_biztype");
        }
        return bizType;
    }

    private void initOwner(Long orgId, DynamicObject bizType, DynamicObject supplier, DynamicObject entry, Map<String, Long> bizSettleOrgMap, Map<String, DynamicObject> bizOwnerMap) {
        if (entry.get("owner") == null) {
            if (bizType != null && ("130".equals(bizType.getString("number")) || "1301".equals(bizType.getString("number")))) {
                entry.set("ownertype", (Object)"bd_supplier");
                entry.set("owner", (Object)supplier);
                return;
            }
            entry.set("ownertype", (Object)"bos_org");
            DynamicObject entryReqOrg = (DynamicObject)entry.get("entryreqorg");
            DynamicObject entryRecOrg = (DynamicObject)entry.get("entryrecorg");
            if (entryReqOrg != null && entryRecOrg != null && entryReqOrg.getPkValue() != null && entryRecOrg.getPkValue() != null) {
                Map<String, Object> orgRelation;
                Long entryReqOrgId = (Long)entryReqOrg.getPkValue();
                Long entryRecOrgId = (Long)entryRecOrg.getPkValue();
                String ownerCacheKey = entryReqOrgId + "&" + entryRecOrgId + "&owner";
                Set<String> bizOwnerKeySet = bizOwnerMap.keySet();
                if (bizOwnerKeySet.contains(ownerCacheKey)) {
                    entry.set("owner", (Object)bizOwnerMap.get(ownerCacheKey));
                    return;
                }
                Long ownerId = null;
                String settleCacheKey = entryReqOrgId + "&settleorg4org";
                Long reqSettleId = bizSettleOrgMap.get(settleCacheKey);
                if (reqSettleId == null) {
                    Map<String, Object> reqSettleMap = this.getCompanyByOrg(entryReqOrgId, Boolean.FALSE, Boolean.TRUE);
                    if (reqSettleMap != null) {
                        reqSettleId = (Long)reqSettleMap.get("id");
                        if (reqSettleId == null) {
                            bizSettleOrgMap.put(settleCacheKey, 0L);
                        } else {
                            bizSettleOrgMap.put(settleCacheKey, reqSettleId);
                        }
                    } else {
                        bizSettleOrgMap.put(settleCacheKey, 0L);
                    }
                }
                if ((orgRelation = this.getOrgRelation(entryRecOrgId, "10", "05", "fromorg")) != null) {
                    List settleOrg4Rec = (List)orgRelation.get("orgId");
                    if (reqSettleId != null && settleOrg4Rec != null && settleOrg4Rec.contains(reqSettleId)) {
                        ownerId = reqSettleId;
                    } else {
                        List detailList = (List)orgRelation.get("data");
                        if (detailList != null) {
                            for (Map detailMap : detailList) {
                                Boolean isDefault = (Boolean)detailMap.get("isDefault");
                                if (isDefault == null || !isDefault.booleanValue()) continue;
                                ownerId = (Long)detailMap.get("orgId");
                                break;
                            }
                        }
                    }
                }
                if (ownerId == null) {
                    bizOwnerMap.put(ownerCacheKey, null);
                } else {
                    DynamicObject owner = this.loadSingleFromCache(ownerId, "bos_org");
                    bizOwnerMap.put(ownerCacheKey, owner);
                    entry.set("owner", (Object)owner);
                }
            }
        }
    }

    private void initQty(DynamicObject entry) {
        boolean isControlQty;
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            log.info("\u7269\u6599\u4e3a\u7a7a");
            return;
        }
        DynamicObject master = material.getDynamicObject("masterid");
        if (master == null) {
            log.info("\u4e3b\u7269\u6599\u4e3a\u7a7a");
            return;
        }
        DynamicObject unit = entry.getDynamicObject("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        if (PurOrderDefValueHelper.isBlank(qty) && PurOrderDefValueHelper.isBlank(baseQty)) {
            log.info("\u6570\u91cf\u90fd\u6ca1\u503c");
            return;
        }
        if (baseUnit == null) {
            baseUnit = master.getDynamicObject("baseunit");
            entry.set("baseunit", (Object)baseUnit);
        }
        if (unit == null) {
            unit = material.getDynamicObject("purchaseunit");
            entry.set("unit", (Object)unit);
        }
        if (unit == null || baseUnit == null) {
            log.info("\u5355\u4f4d\u6ca1\u503c");
            return;
        }
        if (PurOrderDefValueHelper.isBlank(qty) && !PurOrderDefValueHelper.isBlank(baseQty)) {
            qty = this.getDesQtyConv((Long)master.getPkValue(), baseUnit, baseQty, unit);
            entry.set("qty", (Object)qty);
        } else if (PurOrderDefValueHelper.isBlank(baseQty) && !PurOrderDefValueHelper.isBlank(qty)) {
            baseQty = this.getDesQtyConv((Long)master.getPkValue(), unit, qty, baseUnit);
            entry.set("baseqty", (Object)baseQty);
        }
        BigDecimal receiveqtyup = entry.getBigDecimal("receiveqtyup");
        BigDecimal receiveqtydown = entry.getBigDecimal("receiveqtydown");
        BigDecimal receivebaseqtyup = entry.getBigDecimal("receivebaseqtyup");
        BigDecimal receivebaseqtydown = entry.getBigDecimal("receivebaseqtydown");
        if (!(PurOrderDefValueHelper.isBlank(receiveqtyup) || PurOrderDefValueHelper.isBlank(receiveqtydown) || PurOrderDefValueHelper.isBlank(receivebaseqtyup) || PurOrderDefValueHelper.isBlank(receivebaseqtydown))) {
            return;
        }
        BigDecimal receiveRateUp = entry.getBigDecimal("receiverateup");
        BigDecimal receiveRateDown = entry.getBigDecimal("receiveratedown");
        boolean iscontrolqty = entry.getBoolean("iscontrolqty");
        if (!(PurOrderDefValueHelper.isBlank(receiveRateUp) && PurOrderDefValueHelper.isBlank(receiveRateDown) || PurOrderDefValueHelper.isBlank(qty) || PurOrderDefValueHelper.isBlank(baseQty))) {
            BigDecimal receiveQtyUp = this.getByGrowRate(qty, PurOrderDefValueHelper.div100(receiveRateUp)).setScale(this.getPrecision(unit), this.getUnitRoundingMode(unit));
            BigDecimal receiveQtyDown = this.getByReduceRate(qty, PurOrderDefValueHelper.div100(receiveRateDown)).setScale(this.getPrecision(unit), this.getUnitRoundingMode(unit));
            BigDecimal receiveBaseQtyUp = this.getByGrowRate(baseQty, PurOrderDefValueHelper.div100(receiveRateUp)).setScale(this.getPrecision(baseUnit), this.getUnitRoundingMode(baseUnit));
            BigDecimal receiveBaseQtyDown = this.getByReduceRate(baseQty, PurOrderDefValueHelper.div100(receiveRateDown)).setScale(this.getPrecision(baseUnit), this.getUnitRoundingMode(baseUnit));
            entry.set("receiveqtyup", (Object)receiveQtyUp);
            entry.set("receiveqtydown", (Object)receiveQtyDown);
            entry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
            entry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
            return;
        }
        if (!iscontrolqty && PurOrderDefValueHelper.isBlank(receiveRateUp) && PurOrderDefValueHelper.isBlank(receiveRateDown) && !PurOrderDefValueHelper.isBlank(qty) && !PurOrderDefValueHelper.isBlank(baseQty) && (isControlQty = material.getBoolean("iscontrolqty"))) {
            receiveRateUp = material.getBigDecimal("receiverateup");
            receiveRateDown = material.getBigDecimal("receiveratedown");
            if (receiveRateUp != null && receiveRateDown != null) {
                BigDecimal receiveQtyUp = this.getByGrowRate(qty, PurOrderDefValueHelper.div100(receiveRateUp)).setScale(this.getPrecision(unit), this.getUnitRoundingMode(unit));
                BigDecimal receiveQtyDown = this.getByReduceRate(qty, PurOrderDefValueHelper.div100(receiveRateDown)).setScale(this.getPrecision(unit), this.getUnitRoundingMode(unit));
                BigDecimal receiveBaseQtyUp = this.getByGrowRate(baseQty, receiveRateUp).setScale(this.getPrecision(baseUnit), this.getUnitRoundingMode(baseUnit));
                BigDecimal receiveBaseQtyDown = this.getByReduceRate(baseQty, PurOrderDefValueHelper.div100(receiveRateDown)).setScale(this.getPrecision(baseUnit), this.getUnitRoundingMode(baseUnit));
                entry.set("iscontrolqty", (Object)Boolean.TRUE);
                entry.set("receiverateup", (Object)receiveRateUp);
                entry.set("receiveratedown", (Object)receiveRateDown);
                entry.set("receiveqtyup", (Object)receiveQtyUp);
                entry.set("receiveqtydown", (Object)receiveQtyDown);
                entry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
                entry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
                return;
            }
        }
        entry.set("receiveqtyup", (Object)qty);
        entry.set("receiveqtydown", (Object)qty);
        entry.set("receivebaseqtyup", (Object)baseQty);
        entry.set("receivebaseqtydown", (Object)baseQty);
    }

    private static void initMaterialControlDay(DynamicObject entry) {
        boolean isControlDay;
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            log.info("\u7269\u6599\u4e3a\u7a7a");
            return;
        }
        int receiveDayUp = entry.getInt("receivedayup");
        int receiveDayDown = entry.getInt("receivedaydown");
        if ((receiveDayUp == 0 || receiveDayDown == 0) && (isControlDay = material.getBoolean("iscontrolday"))) {
            receiveDayUp = material.getInt("receivedayup");
            receiveDayDown = material.getInt("receivedaydown");
            entry.set("receivedayup", (Object)receiveDayUp);
            entry.set("receivedaydown", (Object)receiveDayDown);
            entry.set("iscontrolday", (Object)isControlDay);
        }
    }

    private DynamicObject initSettleOrg(Long orgId, DynamicObject bill, Map<String, DynamicObject> bizSettleOrg4PurMap) {
        DynamicObject settleOrg = bill.getDynamicObject("settleorg");
        if (orgId != null && settleOrg == null) {
            String settleCacheKey = orgId + "&settleorg4pur";
            Set<String> bizSettleOrg4PurKeySet = bizSettleOrg4PurMap.keySet();
            if (bizSettleOrg4PurKeySet.contains(settleCacheKey)) {
                DynamicObject load = bizSettleOrg4PurMap.get(settleCacheKey);
                bill.set("settleorg", (Object)load);
                return load;
            }
            Long settleOrgId = this.getOrgForFormDefValue(orgId, PMVIEWTYPE, "10", "toorg");
            if (settleOrgId == null || settleOrgId == 0L) {
                bizSettleOrg4PurMap.put(settleCacheKey, null);
                return null;
            }
            DynamicObject load = this.loadSingleFromCache(settleOrgId, "bos_org");
            bizSettleOrg4PurMap.put(settleCacheKey, load);
            bill.set("settleorg", (Object)load);
            return load;
        }
        return settleOrg;
    }

    private DynamicObject getPayOrgDefault(DynamicObject settleOrg, Map<String, Object> payOrgDefault4PurMap) {
        if (settleOrg == null) {
            return null;
        }
        Object settleOrgID = settleOrg.getPkValue();
        if (settleOrgID == null) {
            return null;
        }
        String settleOrgKey = settleOrgID + "PayOrg";
        if (this.isCached(payOrgDefault4PurMap, settleOrgKey)) {
            return (DynamicObject)payOrgDefault4PurMap.get(settleOrgKey);
        }
        DynamicObject payOrg = this.getOrgForFormDefObjValue((Long)settleOrgID, "10", "08", "toorg");
        if (payOrg == null) {
            payOrgDefault4PurMap.put(settleOrgKey, null);
            return null;
        }
        payOrgDefault4PurMap.put(settleOrgKey, payOrg);
        return payOrg;
    }

    private DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != null && (map = this.getCurrencyAndExRateTable(orgId)) != null && map.get(EXRATETABLE) != null) {
            return this.loadSingleFromCache(map.get(EXRATETABLE), EXRATETABLE_DT);
        }
        return null;
    }

    private Map<String, String> getPlanCommonFieldMapping() {
        HashMap<String, String> properytMapping = new HashMap<String, String>();
        properytMapping.put("appid", PMAPPID);
        properytMapping.put("viewtype", PMVIEWTYPE);
        properytMapping.put(PLANTYPE, "purchase");
        properytMapping.put(TOTALALLAMOUNT, TOTALALLAMOUNT);
        properytMapping.put(AMOUNTCONDITION, "paycondition");
        properytMapping.put(SETTLECURRENCY, SETTLECURRENCY);
        properytMapping.put(ISPAYRATE, ISPAYRATE);
        properytMapping.put(BIZTIME, BIZTIME);
        properytMapping.put(ENTRY_ID, "purbillentry_pay");
        properytMapping.put(ENTRY_AMOUNT, "payamount");
        properytMapping.put(CHANGETYPE, "payentrychangetype");
        properytMapping.put(ENTRY_RATE, "payrate");
        properytMapping.put(ENTRY_ITEMNAME, "payname");
        properytMapping.put(ENTRY_ISPREPAY, ENTRY_ISPREPAY);
        properytMapping.put(ENTRY_AMOUNTDATE, "paydate");
        return properytMapping;
    }

    private BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = BigDecimal.ZERO;
        if (materialId == null || srcUnit == null || desUnit == null || srcQty == null) {
            return BigDecimal.ZERO;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(materialId).append("_").append(srcUnit.getPkValue()).append("_").append(desUnit.getPkValue());
        String uniquekey = sb.toString();
        if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            desQty = srcQty;
        } else if (this.isCached(this.cacheUnitConvertFactor, uniquekey)) {
            Object conv = this.cacheUnitConvertFactor.get(uniquekey);
            if (conv != null) {
                ConversionFactor factor = (ConversionFactor)conv;
                int denominator = factor.getDenominator();
                int numerator = factor.getNumerator();
                if (denominator != 0) {
                    int unitPrecision = desUnit.getInt(UNIT_PRECISION);
                    RoundingMode unitPrecisionType = this.getUnitRoundingMode(desUnit);
                    desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, unitPrecisionType);
                }
            }
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null) {
                int numerator = muConv.getInt(CONV_NUMERATOR);
                int denominator = muConv.getInt(CONV_DENOMINATOR);
                this.cacheUnitConvertFactor.put(uniquekey, new ConversionFactor(numerator, denominator));
                if (denominator != 0) {
                    int unitPrecision = desUnit.getInt(UNIT_PRECISION);
                    RoundingMode unitPrecisionType = this.getUnitRoundingMode(desUnit);
                    desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, unitPrecisionType);
                }
            }
        }
        return desQty;
    }

    private boolean isCached(Map<String, Object> map, String key) {
        return map.containsKey(key);
    }

    private boolean isIndirectRate(Object value) {
        if (value instanceof String) {
            return "1".equals(value);
        }
        return false;
    }

    private Map<String, DynamicObject> getDefaultOperatorAndGroupByOrg(Long orgId, Long userId, String operatorGrpType) {
        QFilter qFilter04;
        QFilter qFilter03;
        QFilter qFilter02;
        Map<Object, DynamicObject> operatorGroupDynamicObjectMap = this.getOperatorGroupDynamicObjectMap(orgId, operatorGrpType);
        HashMap<String, DynamicObject> defaultOperatorAndGroup = new HashMap<String, DynamicObject>(4);
        if (operatorGroupDynamicObjectMap == null || operatorGroupDynamicObjectMap.size() == 0) {
            return defaultOperatorAndGroup;
        }
        QFilter qFilter01 = new QFilter("operatorgrpid", "in", operatorGroupDynamicObjectMap.keySet());
        Map operatorMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype,invalid", (QFilter[])new QFilter[]{qFilter01, qFilter02 = new QFilter("opergrptype", "=", (Object)operatorGrpType), qFilter03 = new QFilter("operatorid", "=", (Object)userId), qFilter04 = new QFilter("invalid", "=", (Object)Boolean.FALSE)});
        if (operatorMap != null && !operatorMap.isEmpty()) {
            for (DynamicObject operator : operatorMap.values()) {
                if (operator == null) continue;
                defaultOperatorAndGroup.put("operator", operator);
                defaultOperatorAndGroup.put("operatorgroup", operatorGroupDynamicObjectMap.get(operator.get("operatorgrpid")));
                break;
            }
        }
        return defaultOperatorAndGroup;
    }

    private Map<Object, DynamicObject> getOperatorGroupDynamicObjectMap(Long orgId, String operatorGrpType) {
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        return BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
    }

    private static boolean isBlank(BigDecimal num) {
        if (num == null) {
            return true;
        }
        return PurOrderDefValueHelper.isZero(num);
    }

    private static boolean isZero(BigDecimal num) {
        if (num == null) {
            return false;
        }
        return BigDecimal.ZERO.compareTo(num) == 0;
    }

    private static BigDecimal div100(BigDecimal num) {
        return num.movePointLeft(2);
    }

    private BigDecimal getByGrowRate(BigDecimal num, BigDecimal growRate) {
        return num.add(num.multiply(growRate));
    }

    private BigDecimal getByReduceRate(BigDecimal num, BigDecimal reduceRate) {
        return num.subtract(num.multiply(reduceRate));
    }

    protected void setDefaultSupplier(DynamicObject bill) {
        DynamicObject supplier = bill.getDynamicObject("supplier");
        if (supplier != null) {
            DynamicObject payCond;
            DynamicObject providerSupplier;
            if (bill.getDynamicObject("linkman") == null) {
                bill.set("linkman", (Object)this.getDefaultLinkManObj(supplier));
            }
            if (StringUtils.isBlank((CharSequence)bill.getString("address"))) {
                bill.set("address", (Object)this.getDefaultAddressString(supplier));
            }
            if ((providerSupplier = bill.getDynamicObject("providersupplier")) == null) {
                providerSupplier = this.getOtherSupplierObj(supplier, DELIVER_SUPPLIER_KEY, "4");
                bill.set("providersupplier", (Object)providerSupplier);
            }
            if (providerSupplier != null) {
                DynamicObject providerLinkman = bill.getDynamicObject("providerlinkman");
                String providerAddress = bill.getString("provideraddress");
                if (providerLinkman == null || StringUtils.isBlank((CharSequence)providerAddress)) {
                    if (providerLinkman == null) {
                        bill.set("providerlinkman", (Object)this.getDefaultLinkManObj(providerSupplier));
                    }
                    if (StringUtils.isBlank((CharSequence)providerAddress)) {
                        bill.set("provideraddress", (Object)this.getDefaultAddressString(providerSupplier));
                    }
                }
            }
            if (bill.get("invoicesupplier") == null) {
                bill.set("invoicesupplier", (Object)this.getOtherSupplierObj(supplier, INVOICE_SUPPLIER_KEY, "2"));
            }
            if (bill.get("receivesupplier") == null) {
                bill.set("receivesupplier", (Object)this.getOtherSupplierObj(supplier, RECEIVING_SUPPLIER_KEY, "3"));
            }
            if (bill.getDynamicObject("paycondition") == null && (payCond = supplier.getDynamicObject("paycond")) != null && Boolean.TRUE.equals((payCond = BusinessDataServiceHelper.loadSingleFromCache((Object)payCond.getPkValue(), (String)"bd_paycondition", (String)"id,orderbill")).getBoolean("orderbill"))) {
                bill.set("paycondition", (Object)payCond);
            }
            if (bill.getDynamicObject("settletype") == null) {
                bill.set("settletype", (Object)this.getDefaultSettleTypeObj(supplier));
            }
            if (bill.getDynamicObject(SETTLECURRENCY) == null) {
                DynamicObject settlementCurrency = supplier.getDynamicObject("settlementcyid");
                bill.set(SETTLECURRENCY, (Object)settlementCurrency);
            }
            if (bill.getDynamicObject("invoicebiztype") == null) {
                bill.set("invoicebiztype", (Object)this.getInvoiceType(supplier, "pm"));
            }
        }
    }

    private DynamicObject getDefaultSettleTypeObj(DynamicObject supplier) {
        DynamicObject settleType;
        if (supplier != null && (settleType = supplier.getDynamicObject("settlementtypeid")) != null) {
            return settleType;
        }
        QFilter isDefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isEnable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isDefault.and(isEnable);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"id,isdefault,enable", (QFilter[])filter.toArray());
    }

    private DynamicObject getInvoiceType(DynamicObject supplier, String appNmuber) {
        if (supplier != null) {
            Object invoicetype = supplier.get("invoicecategory");
            Long invoicetypeId = 0L;
            if (invoicetype != null) {
                invoicetypeId = (Long)((DynamicObject)invoicetype).getPkValue();
            }
            return this.getInvoiceBizType(invoicetypeId, appNmuber);
        }
        return null;
    }

    private DynamicObject getDefaultLinkManObj(DynamicObject supplier) {
        Long defaultLinkManId = this.getDefaultLinkManId(supplier);
        if (defaultLinkManId == null) {
            return null;
        }
        return this.loadSingleFromCache(defaultLinkManId, "bd_supplierlinkman");
    }

    private Long getDefaultLinkManId(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        Long defaultLinkManId = null;
        DynamicObjectCollection linkmans = supplier.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                return (Long)linkman.getPkValue();
            }
            if (defaultLinkManId != null || invalid) continue;
            defaultLinkManId = (Long)linkman.getPkValue();
        }
        return defaultLinkManId;
    }

    private String getDefaultAddressString(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        Long supplierId = (Long)supplier.getPkValue();
        String defAddressStr = this.cacheSupplierDefAddressMap.get(supplierId);
        if (defAddressStr == null) {
            ILocaleString defaultAddress = this.getDefaultAddressLocaleString(supplier);
            defAddressStr = defaultAddress != null ? defaultAddress.toString() : "";
            this.cacheSupplierDefAddressMap.put(supplierId, defAddressStr);
        }
        return defAddressStr;
    }

    private ILocaleString getDefaultAddressLocaleString(DynamicObject supplier) {
        return PurOrderDefValueHelper.getDetailAddress(this.getDefaultAddressObj(supplier));
    }

    private static ILocaleString getDetailAddress(DynamicObject address) {
        if (address == null) {
            return null;
        }
        return address.getLocaleString("detailaddress");
    }

    private DynamicObject getDefaultAddressObj(DynamicObject supplier) {
        return this.getDefaultAddress(supplier, "id,default,invalid,detailaddress");
    }

    private DynamicObject getDefaultAddress(DynamicObject supplier, String selectProperties) {
        QFilter invalid;
        QFilter supplierId;
        DynamicObject[] load;
        if (supplier != null && StringUtils.isNotBlank((Object)supplier.getPkValue()) && (load = BusinessDataServiceHelper.load((String)"bd_address", (String)selectProperties, (QFilter[])new QFilter[]{supplierId = new QFilter("supplierid", "=", (Object)supplier.getPkValue().toString()), invalid = new QFilter("invalid", "=", (Object)Boolean.FALSE)}, (String)"default desc", (int)1)) != null && load.length > 0) {
            return load[0];
        }
        return null;
    }

    private DynamicObject getOtherSupplierObj(DynamicObject supplier, String otherSupplierKey, String function) {
        DynamicObject otherCus = supplier.getDynamicObject(otherSupplierKey);
        if (otherCus != null ? this.validBizFunction(otherCus = BusinessDataServiceHelper.loadSingleFromCache((Object)otherCus.getPkValue(), (String)"bd_supplier", (String)"id,bizfunction,entry_linkman.isdefault_linkman, entry_linkman.invalid"), function) : this.validBizFunction(otherCus, function)) {
            return otherCus;
        }
        return null;
    }

    private boolean validBizFunction(DynamicObject supplier, String function) {
        String bizFunction;
        if (supplier == null) {
            return false;
        }
        if (!this.checkProperty(supplier, BIZ_FUNCTION_KEY)) {
            supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"id,bizfunction");
        }
        if ((bizFunction = PurOrderDefValueHelper.getBizFunction(supplier)) == null) {
            return false;
        }
        return function != null && bizFunction.contains(function);
    }

    private static String getBizFunction(DynamicObject supplier) {
        return supplier.getString(BIZ_FUNCTION_KEY);
    }

    private Long getDefaultLineType(Long bizTypeId) {
        Optional<DynamicObject> optionalLineType;
        if (this.isNull(bizTypeId)) {
            return null;
        }
        Long lineTypeId = null;
        DynamicObject bizType = this.loadSingleFromCache(bizTypeId, "bd_biztype");
        if (!this.isNull(bizType) && !this.isNull(bizType.getDynamicObjectCollection("linetypeentry")) && (optionalLineType = bizType.getDynamicObjectCollection("linetypeentry").stream().filter(dym -> dym.getBoolean("isdefault")).findFirst()).isPresent()) {
            lineTypeId = optionalLineType.get().getLong("linetypeid.id");
            List<Long> linetype = PurOrderDefValueHelper.getEnableBaseDataIds("bd_linetype", Collections.singletonList(lineTypeId));
            lineTypeId = linetype.size() > 0 ? linetype.get(0) : null;
        }
        return lineTypeId;
    }

    private Long getDefaultBizType(String formId, Long billTypeId, String paramFormId) {
        List<Long> enableBizTypeIds;
        if (this.isNull(formId) || this.isNull(billTypeId) || this.isNull(paramFormId)) {
            return null;
        }
        Object bizTypes = this.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity");
        ArrayList<Long> bizTypeList = new ArrayList<Long>();
        if (!this.isNull(bizTypes) && bizTypes instanceof DynamicObjectCollection) {
            ((DynamicObjectCollection)bizTypes).stream().forEach(dym -> {
                if (dym.getBoolean("isdefault")) {
                    bizTypeList.add(dym.getLong("biztypenumber.id"));
                }
            });
        }
        return (enableBizTypeIds = PurOrderDefValueHelper.getEnableBaseDataIds("bd_biztype", bizTypeList)).size() > 0 ? enableBizTypeIds.get(0) : null;
    }

    private static List<Long> getEnableBaseDataIds(String entityNo, List<Long> pks) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter pkFilter = new QFilter("id", "in", pks);
        ArrayList<Long> baseIDs = new ArrayList<Long>(16);
        Map enableBaseDatas = BusinessDataServiceHelper.loadFromCache((String)entityNo, (QFilter[])new QFilter[]{enableFilter, pkFilter});
        if (enableBaseDatas != null) {
            enableBaseDatas.keySet().forEach(id -> baseIDs.add((Long)id));
        }
        return baseIDs;
    }

    private Map<String, BigDecimal> calcAmount(DynamicObject bill, AmountPropertyKey propertyKey, int index) {
        HashMap<String, BigDecimal> totalAmountMap = new HashMap<String, BigDecimal>(8);
        if (bill == null) {
            return totalAmountMap;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null || entry.size() - 1 < index) {
            return totalAmountMap;
        }
        if (propertyKey == null) {
            propertyKey = AmountPropertyKey.getInstance();
        }
        DynamicObject row = (DynamicObject)entry.get(index);
        Map<String, DynamicProperty> headPropertyMap = PurOrderDefValueHelper.getAmountProperties(bill, propertyKey.getHeadPropertyKeyArray());
        Map<String, DynamicProperty> entryPropertyMap = PurOrderDefValueHelper.getAmountProperties(row, propertyKey.getEntryPropertyKeyArray());
        if (headPropertyMap.isEmpty() || entryPropertyMap.isEmpty()) {
            return totalAmountMap;
        }
        Boolean isTax = (Boolean)PurOrderDefValueHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getIsTax()));
        BigDecimal exRate = (BigDecimal)PurOrderDefValueHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getExChangeRate()));
        DynamicObject settleCurrency = (DynamicObject)PurOrderDefValueHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getSettleCurrency()));
        Integer settleAmtPrecision = settleCurrency == null ? null : Integer.valueOf(settleCurrency.getInt(CUR_AMTPRECISION));
        Integer settlePricePrecision = settleCurrency == null ? null : Integer.valueOf(settleCurrency.getInt(CUR_PRICEPRECISION));
        DynamicObject currency = (DynamicObject)PurOrderDefValueHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getCurrency()));
        Integer currencyAmtPrecision = currency == null ? null : Integer.valueOf(currency.getInt(CUR_AMTPRECISION));
        String exchangeType = (String)PurOrderDefValueHelper.getValueFast(bill, headPropertyMap.get(propertyKey.getExchangeType()));
        boolean isDirectRate = this.isIndirectRate(exchangeType);
        BigDecimal qty = (BigDecimal)PurOrderDefValueHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getQty()));
        BigDecimal price = (BigDecimal)PurOrderDefValueHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getPrice()));
        BigDecimal priceAndTax = (BigDecimal)PurOrderDefValueHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getPriceAndTax()));
        BigDecimal taxRate = (BigDecimal)PurOrderDefValueHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getTaxRate()));
        String discountType = (String)PurOrderDefValueHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getDiscountType()));
        BigDecimal discountRate = (BigDecimal)PurOrderDefValueHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getDiscountRate()));
        POAmountInfo amountInfo = this.getAmount(isTax, qty, price, priceAndTax, taxRate, discountType, discountRate, exRate, settlePricePrecision, settleAmtPrecision, currencyAmtPrecision, isDirectRate, propertyKey);
        PurOrderDefValueHelper.batchSetAmountValue(row, entryPropertyMap, amountInfo.getAmountKV());
        String changeType = (String)PurOrderDefValueHelper.getValueFast(row, entryPropertyMap.get(propertyKey.getChangeType()));
        if (!"C".equals(changeType)) {
            PurOrderDefValueHelper.mapPutNotNull(totalAmountMap, propertyKey.getAmount(), amountInfo.getAmount());
            PurOrderDefValueHelper.mapPutNotNull(totalAmountMap, propertyKey.getTaxAmount(), amountInfo.getTaxAmount());
            PurOrderDefValueHelper.mapPutNotNull(totalAmountMap, propertyKey.getAmountAndTax(), amountInfo.getAmountAndTax());
        }
        return totalAmountMap;
    }

    private static Map<String, DynamicProperty> getAmountProperties(DynamicObject dynamicObject, String[] propertyKeys) {
        HashMap<String, DynamicProperty> propertyMap = new HashMap<String, DynamicProperty>(16);
        DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
        for (String propertyKey : propertyKeys) {
            PurOrderDefValueHelper.mapPutNotNull(propertyMap, propertyKey, dynamicObjectType.getProperty(propertyKey));
        }
        return propertyMap;
    }

    private static void batchSetAmountValue(DynamicObject dynamicObject, Map<String, DynamicProperty> propertyMap, Map<String, Object> amountKV) {
        if (amountKV == null || amountKV.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : amountKV.entrySet()) {
            PurOrderDefValueHelper.setValueFast(dynamicObject, propertyMap.get(entry.getKey()), entry.getValue());
        }
    }

    private static void setValueFast(DynamicObject dynamicObject, DynamicProperty property, Object value) {
        if (property == null) {
            return;
        }
        property.setValueFast((Object)dynamicObject, value);
    }

    private static Object getValueFast(DynamicObject dynamicObject, DynamicProperty property) {
        if (property == null) {
            return null;
        }
        return property.getValueFast((Object)dynamicObject);
    }

    private static <T> void mapPutNotNull(Map<String, T> map, String key, T value) {
        if (key == null || value == null) {
            return;
        }
        map.put(key, value);
    }

    private POAmountInfo getAmount(Boolean isTax, BigDecimal qty, BigDecimal price, BigDecimal priceAndTax, BigDecimal taxRate, String discountType, BigDecimal discountRate, BigDecimal exRate, Integer settlePricePrecision, Integer settleAmtPrecision, Integer currencyAmtPrecision, Boolean isIndirectExRate, AmountPropertyKey propertyKey) {
        POAmountInfo amountInfo = new POAmountInfo();
        if (isTax != null) {
            amountInfo.setTax(isTax);
        }
        if (qty != null) {
            amountInfo.setQty(qty);
        }
        if (price != null) {
            amountInfo.setPrice(price);
        }
        if (priceAndTax != null) {
            amountInfo.setPriceAndTax(priceAndTax);
        }
        if (taxRate != null) {
            amountInfo.setTaxRate(taxRate);
        }
        if (!StringUtils.isEmpty((CharSequence)discountType)) {
            amountInfo.setDiscountType(discountType);
        }
        if (discountRate != null) {
            amountInfo.setDiscountRate(discountRate);
        }
        if (exRate != null) {
            amountInfo.setExChangeRate(exRate);
        }
        if (settlePricePrecision != null) {
            amountInfo.setSettlePricePrecision(settlePricePrecision);
        }
        if (settleAmtPrecision != null) {
            amountInfo.setSettleAmtPrecision(settleAmtPrecision);
        }
        if (currencyAmtPrecision != null) {
            amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
        }
        if (isIndirectExRate != null) {
            amountInfo.setIndirectExRate(isIndirectExRate);
        }
        if (propertyKey != null) {
            amountInfo.setPropertyKey(propertyKey);
        }
        return this.getAmount(amountInfo);
    }

    private POAmountInfo getAmount(POAmountInfo amountInfo) {
        boolean isTax = amountInfo.isTax();
        BigDecimal qty = amountInfo.getQty();
        BigDecimal price = amountInfo.getPrice();
        BigDecimal priceAndTax = amountInfo.getPriceAndTax();
        BigDecimal taxRate = PurOrderDefValueHelper.div100(amountInfo.getTaxRate());
        String discountType = amountInfo.getDiscountType();
        BigDecimal discountRate = amountInfo.getDiscountRate();
        int settleAmtPrecision = amountInfo.getSettleAmtPrecision();
        int settlePricePrecision = 10;
        AmountPropertyKey propertyKey = amountInfo.getPropertyKey();
        if (propertyKey == null) {
            propertyKey = AmountPropertyKey.getInstance();
        }
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal amountAndTax = BigDecimal.ZERO;
        if (!PurOrderDefValueHelper.isBlank(qty)) {
            if (isTax && !PurOrderDefValueHelper.isBlank(priceAndTax)) {
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                if (PurOrderDefValueHelper.isBlank(discountRate) || StringUtils.isBlank((CharSequence)discountType) || "NULL".equals(discountType)) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if ("A".equals(discountType)) {
                    discountRate = PurOrderDefValueHelper.div100(discountRate);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    amountAndTax = BigDecimal.ONE.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if ("B".equals(discountType) || "C".equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    amountAndTax = priceAndTax.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amountAndTax.divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP).multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else if (!isTax && !PurOrderDefValueHelper.isBlank(price)) {
                priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
                if (PurOrderDefValueHelper.isBlank(discountRate) || StringUtils.isBlank((CharSequence)discountType) || "NULL".equals(discountType)) {
                    amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if ("A".equals(discountType)) {
                    discountRate = PurOrderDefValueHelper.div100(discountRate);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).multiply(BigDecimal.ONE.subtract(discountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if ("B".equals(discountType) || "C".equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).multiply(BigDecimal.ONE.add(taxRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount);
                amountAndTax = amountAndTax.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else {
                priceAndTax = BigDecimal.ZERO;
                price = BigDecimal.ZERO;
            }
            this.setCurrencyAmount(isTax, amount, taxAmount, amountAndTax, amountInfo, propertyKey);
        } else {
            if (isTax && !PurOrderDefValueHelper.isBlank(priceAndTax)) {
                priceAndTax = priceAndTax.setScale(settlePricePrecision, RoundingMode.HALF_UP);
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
            } else if (!isTax && !PurOrderDefValueHelper.isBlank(price)) {
                price = price.setScale(settlePricePrecision, RoundingMode.HALF_UP);
                priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
            } else {
                priceAndTax = BigDecimal.ZERO;
                price = BigDecimal.ZERO;
            }
            amountInfo.put(propertyKey.getCurAmount(), BigDecimal.ZERO);
            amountInfo.put(propertyKey.getCurTaxAmount(), BigDecimal.ZERO);
            amountInfo.put(propertyKey.getCurAmountAndTax(), BigDecimal.ZERO);
        }
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setAmount(amount);
        amountInfo.setDiscountAmount(discountAmount);
        amountInfo.setTaxAmount(taxAmount);
        amountInfo.setAmountAndTax(amountAndTax);
        if (isTax) {
            amountInfo.put(propertyKey.getPrice(), price);
        } else {
            amountInfo.put(propertyKey.getPriceAndTax(), priceAndTax);
        }
        amountInfo.put(propertyKey.getAmount(), amount);
        amountInfo.put(propertyKey.getDiscountAmount(), discountAmount);
        amountInfo.put(propertyKey.getTaxAmount(), taxAmount);
        amountInfo.put(propertyKey.getAmountAndTax(), amountAndTax);
        return amountInfo;
    }

    private void setCurrencyAmount(boolean isTax, BigDecimal amount, BigDecimal taxAmount, BigDecimal amountAndTax, POAmountInfo amountInfo, AmountPropertyKey propertyKey) {
        BigDecimal exChangeRate = amountInfo.getExChangeRate();
        BigDecimal curAmount = BigDecimal.ZERO;
        BigDecimal curAmountAndTax = BigDecimal.ZERO;
        BigDecimal curTaxAmount = BigDecimal.ZERO;
        if (!PurOrderDefValueHelper.isBlank(exChangeRate)) {
            int currencyAmtPrecision = amountInfo.getCurrencyAmtPrecision();
            boolean indirectRate = amountInfo.getIndirectExRate();
            curTaxAmount = this.convertByExRate(taxAmount, exChangeRate, indirectRate, currencyAmtPrecision);
            if (isTax) {
                curAmountAndTax = this.convertByExRate(amountAndTax, exChangeRate, indirectRate, currencyAmtPrecision);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = this.convertByExRate(amount, exChangeRate, indirectRate, currencyAmtPrecision);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
            amountInfo.setCurAmount(curAmount);
            amountInfo.setCurTaxAmount(curTaxAmount);
            amountInfo.setCurAmountAndTax(curAmountAndTax);
        }
        amountInfo.put(propertyKey.getCurAmount(), curAmount);
        amountInfo.put(propertyKey.getCurTaxAmount(), curTaxAmount);
        amountInfo.put(propertyKey.getCurAmountAndTax(), curAmountAndTax);
    }

    private BigDecimal convertByExRate(BigDecimal money, BigDecimal exRate, boolean isIndirectRate, int amtPrecision) {
        return this.convertByExRate(money, exRate, isIndirectRate, amtPrecision, RoundingMode.HALF_UP);
    }

    private BigDecimal convertByExRate(BigDecimal money, BigDecimal exRate, boolean isIndirectRate, int amtPrecision, RoundingMode roundingMode) {
        if (PurOrderDefValueHelper.isZero(exRate)) {
            isIndirectRate = false;
        }
        if (isIndirectRate) {
            return money.divide(exRate, amtPrecision, roundingMode);
        }
        return money.multiply(exRate).setScale(amtPrecision, roundingMode);
    }

    private void changeAmountConditionForDynamicObject(Map<String, String> properytMapping, DynamicObject bill) {
        if (bill == null) {
            return;
        }
        String entryNoKey = properytMapping.get(ENTRY_ID);
        String amountConditionKey = properytMapping.get(AMOUNTCONDITION);
        String itemNameKey = properytMapping.get(ENTRY_ITEMNAME);
        String isPrePayKey = properytMapping.get(ENTRY_ISPREPAY);
        String rateKey = properytMapping.get(ENTRY_RATE);
        String amountKey = properytMapping.get(ENTRY_AMOUNT);
        String amountDateKey = properytMapping.get(ENTRY_AMOUNTDATE);
        DynamicObjectCollection amountPlanEntrys = bill.getDynamicObjectCollection(entryNoKey);
        if (amountPlanEntrys != null && !amountPlanEntrys.isEmpty()) {
            PurOrderDefValueHelper.calAmountPlanForDynamicObject(properytMapping, bill);
            return;
        }
        DynamicObject amountCondition = (DynamicObject)bill.get(amountConditionKey);
        if (amountCondition == null) {
            return;
        }
        List<Map<String, Object>> amountConditinoEntryInfos = this.getAmountConditinoEntryInfo(properytMapping, bill);
        if (amountConditinoEntryInfos == null || amountConditinoEntryInfos.size() == 0 || amountPlanEntrys == null) {
            return;
        }
        for (Map<String, Object> amountConditionEntry : amountConditinoEntryInfos) {
            DynamicObject amountPlanentry = amountPlanEntrys.addNew();
            amountPlanentry.set(itemNameKey, amountConditionEntry.get(ENTRY_ITEMNAME));
            amountPlanentry.set(isPrePayKey, amountConditionEntry.get("ispre"));
            amountPlanentry.set(rateKey, amountConditionEntry.get(ENTRY_RATE));
            amountPlanentry.set(amountKey, amountConditionEntry.get(ENTRY_AMOUNT));
            Date date = (Date)amountConditionEntry.get("date");
            if (date == null) continue;
            amountPlanentry.set(amountDateKey, (Object)date);
        }
        PurOrderDefValueHelper.calAmountPlanForDynamicObject(properytMapping, bill);
    }

    private static void calAmountPlanForDynamicObject(Map<String, String> properytMapping, DynamicObject bill) {
        DynamicObject currency;
        int precision;
        if (bill == null) {
            return;
        }
        if (properytMapping == null || properytMapping.isEmpty()) {
            return;
        }
        String amountPlanEntryKey = properytMapping.get(ENTRY_ID);
        String amountKey = properytMapping.get(ENTRY_AMOUNT);
        String rateKey = properytMapping.get(ENTRY_RATE);
        String settleCurrencyKey = properytMapping.get(SETTLECURRENCY);
        String isPayRateKey = properytMapping.get(ISPAYRATE);
        String changeTypeKey = properytMapping.get(CHANGETYPE);
        String totalAmountAndTaxKey = properytMapping.get(TOTALALLAMOUNT);
        DynamicObjectCollection amountPlanEntry = bill.getDynamicObjectCollection(amountPlanEntryKey);
        if (amountPlanEntry == null || amountPlanEntry.isEmpty()) {
            return;
        }
        boolean isPayRate = bill.getBoolean(isPayRateKey);
        BigDecimal totalAllAmount = bill.getBigDecimal(totalAmountAndTaxKey);
        if (totalAllAmount == null) {
            totalAllAmount = BigDecimal.ZERO;
        }
        int n = precision = (currency = bill.getDynamicObject(settleCurrencyKey)) == null ? 10 : currency.getInt(CUR_AMTPRECISION);
        if (isPayRate) {
            BigDecimal rateTotal = BigDecimal.ZERO;
            for (DynamicObject entry : amountPlanEntry) {
                BigDecimal rate = entry.getBigDecimal(rateKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType) || rate == null) continue;
                rateTotal = rateTotal.add(rate);
            }
            BigDecimal amountTotal = BigDecimal.ZERO;
            for (int i = 0; i < amountPlanEntry.size(); ++i) {
                DynamicObject entry = (DynamicObject)amountPlanEntry.get(i);
                BigDecimal rate = entry.getBigDecimal(rateKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType)) continue;
                BigDecimal amount = rate == null || BigDecimal.ZERO.compareTo(rate) == 0 ? BigDecimal.ZERO : (i == amountPlanEntry.size() - 1 && rateTotal.compareTo(HUNDRED) == 0 ? totalAllAmount.subtract(amountTotal) : totalAllAmount.multiply(rate).divide(HUNDRED, precision, RoundingMode.HALF_UP));
                amountTotal = amountTotal.add(amount);
                entry.set(amountKey, (Object)amount);
            }
        } else {
            BigDecimal amountTotal = BigDecimal.ZERO;
            for (DynamicObject entry : amountPlanEntry) {
                BigDecimal amount = entry.getBigDecimal(amountKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType) || amount == null) continue;
                amount = amount.setScale(precision, RoundingMode.HALF_UP);
                amountTotal = amountTotal.add(amount);
            }
            BigDecimal rateTotal = BigDecimal.ZERO;
            for (int i = 0; i < amountPlanEntry.size(); ++i) {
                BigDecimal rate;
                DynamicObject entry = (DynamicObject)amountPlanEntry.get(i);
                BigDecimal amount = entry.getBigDecimal(amountKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType)) continue;
                if (amount == null || totalAllAmount.compareTo(BigDecimal.ZERO) == 0 || BigDecimal.ZERO.compareTo(amount) == 0) {
                    rate = BigDecimal.ZERO;
                } else if (i == amountPlanEntry.size() - 1 && amountTotal.compareTo(totalAllAmount) == 0) {
                    rate = HUNDRED.subtract(rateTotal);
                } else {
                    amount = amount.setScale(precision, RoundingMode.HALF_UP);
                    rate = amount.multiply(HUNDRED).divide(totalAllAmount, 2, RoundingMode.HALF_UP);
                }
                rateTotal = rateTotal.add(rate);
                entry.set(rateKey, (Object)rate);
                entry.set(amountKey, (Object)amount);
            }
        }
    }

    private List<Map<String, Object>> getAmountConditinoEntryInfo(Map<String, String> properytMapping, DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        String amountConditionKey = properytMapping.get(AMOUNTCONDITION);
        String totalAmountAndTaxKey = properytMapping.get(TOTALALLAMOUNT);
        String bizTimeKey = properytMapping.get(BIZTIME);
        String planType = properytMapping.get(PLANTYPE);
        String isPayRateKey = properytMapping.get(ISPAYRATE);
        List<Map<String, Object>> amountConditionEntrys = new ArrayList<Map<String, Object>>(10);
        DynamicObject amountCondition = bill.getDynamicObject(amountConditionKey);
        if (amountCondition == null) {
            return null;
        }
        Long amountConditionId = (Long)amountCondition.getPkValue();
        if ("purchase".equals(planType)) {
            BigDecimal totalAllAmount = bill.getBigDecimal(totalAmountAndTaxKey);
            Date bizTime = (Date)bill.get(bizTimeKey);
            amountCondition = this.loadSingleFromCache(amountConditionId, "bd_paycondition");
            if (amountCondition == null) {
                return null;
            }
            amountConditionEntrys = (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"PayConditionService", (String)"getPayPlanData", (Object[])new Object[]{amountConditionId, bizTime, null, null, null, totalAllAmount});
            if (amountConditionEntrys == null || amountConditionEntrys.size() == 0) {
                return null;
            }
            HashSet<Long> itemNamePks = new HashSet<Long>();
            for (Map<String, Object> oneEntry : amountConditionEntrys) {
                if (oneEntry.get(ENTRY_ITEMNAME) == null) continue;
                itemNamePks.add((Long)oneEntry.get(ENTRY_ITEMNAME));
            }
            Map itemNameMap = new HashMap(16);
            if (itemNamePks.size() != 0) {
                itemNameMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)itemNamePks.toArray())});
            }
            for (Map map : amountConditionEntrys) {
                Date date = (Date)map.get("date");
                Long itemname = (Long)map.get(ENTRY_ITEMNAME);
                if (date == null) {
                    date = bizTime;
                    map.put("date", date);
                }
                if (itemname == null) continue;
                map.put(ENTRY_ITEMNAME, itemNameMap.get(itemname));
            }
        } else if ("sales".equals(planType)) {
            amountCondition = this.loadSingleFromCache(amountConditionId, "bd_reccondition");
            if (amountCondition == null) {
                return null;
            }
            DynamicObjectCollection entitys = amountCondition.getDynamicObjectCollection("entry");
            String basis = amountCondition.getString("basis");
            if (entitys == null || entitys.size() == 0) {
                return null;
            }
            for (int i = 0; i < entitys.size(); ++i) {
                DynamicObject row = (DynamicObject)entitys.get(i);
                HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
                DynamicObject dynamicObject = (DynamicObject)row.get(ENTRY_ITEMNAME);
                boolean ispre = row.getBoolean("ispre");
                map.put("ispre", Boolean.valueOf(ispre));
                map.put(ENTRY_ITEMNAME, (Comparable<Boolean>)(dynamicObject == null ? null : dynamicObject));
                if ("B".equals(basis)) {
                    BigDecimal amount = row.getBigDecimal(ENTRY_AMOUNT);
                    map.put(ENTRY_AMOUNT, amount);
                    map.put(ENTRY_RATE, BigDecimal.ZERO);
                } else {
                    BigDecimal rate = row.getBigDecimal(ENTRY_RATE);
                    map.put(ENTRY_RATE, rate);
                    map.put(ENTRY_AMOUNT, BigDecimal.ZERO);
                }
                amountConditionEntrys.add(map);
            }
        }
        bill.set(isPayRateKey, (Object)(!"B".equals(amountCondition.get("basis")) ? 1 : 0));
        return amountConditionEntrys;
    }

    private Object getBillTypeParameter(String formId, long billTypeId, String paramFormId, String propertyName) {
        if (this.isNull(formId) || this.isNull(billTypeId) || this.isNull(paramFormId) || this.isNull(propertyName)) {
            return null;
        }
        DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
        if (!this.isNull(billTypeParam)) {
            return billTypeParam.get(propertyName);
        }
        return null;
    }

    private DynamicObject getInvoiceBizType(Long invoicetypeId, String appNmuber) {
        DynamicObject invoicebiztype = null;
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        if (invoicetypeId == null || invoicetypeId == 0L || this.isNull(appNmuber) || appNmuber == null) {
            QFilter qFilter1 = new QFilter("id", "=", (Object)1533341968170710016L);
            invoicebiztype = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITYNAME, (QFilter[])new QFilter[]{qFilter1.and(qFilterEnable)});
            return invoicebiztype;
        }
        QFilter qFilter = new QFilter("mulinvoicetype.fbasedataid.masterid", "=", (Object)invoicetypeId);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNmuber);
        String bizCloudId = appInfo.getCloudId();
        QFilter qFilterNmuber = new QFilter("mulbiz.fbasedataid.id", "=", (Object)bizCloudId);
        invoicebiztype = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITYNAME, (QFilter[])new QFilter[]{qFilter.and(qFilterNmuber).and(qFilterEnable)});
        if (invoicebiztype == null) {
            QFilter qFilter1 = new QFilter("id", "=", (Object)1533341968170710016L);
            invoicebiztype = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITYNAME, (QFilter[])new QFilter[]{qFilter1.and(qFilterEnable)});
        }
        return invoicebiztype;
    }

    private boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).isEmpty()) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    private int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt(UNIT_PRECISION);
        }
        return precision;
    }

    private int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get(UNIT_PRECISIONTYPE))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }

    private RoundingMode getUnitRoundingMode(DynamicObject unit) {
        RoundingMode roundingMode;
        String precisionAccount;
        if (unit == null || StringUtils.isBlank((Object)unit.get(UNIT_PRECISIONTYPE))) {
            return RoundingMode.HALF_UP;
        }
        switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
            case "2": {
                roundingMode = RoundingMode.DOWN;
                break;
            }
            case "3": {
                roundingMode = RoundingMode.UP;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_UP;
            }
        }
        return roundingMode;
    }

    private Map<String, Object> getExRateMap(Long srcCurId, Long tarCurId, Long exRateTableId, Date date) {
        BigDecimal exRate;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        String exchangeType = "0";
        HashMap<String, Object> exRateMap = new HashMap<String, Object>(4);
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null) {
            exRateMap.put("exchangerate", exchangeRate);
            exRateMap.put("exchangetype", exchangeType);
            return exRateMap;
        }
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurId, (Long)tarCurId, (Long)exRateTableId, (Date)date);
        Boolean isIndirectRate = (Boolean)exchangeRateMap.get("quoteType");
        if (isIndirectRate != null && isIndirectRate.booleanValue()) {
            exchangeType = "1";
        }
        if ((exRate = (BigDecimal)exchangeRateMap.get("exchangeRate")) != null) {
            exchangeRate = exRate;
        }
        exRateMap.put("exchangerate", exchangeRate);
        exRateMap.put("exchangetype", exchangeType);
        return exRateMap;
    }

    private BigDecimal getExRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date, String exchangeType) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null || exchangeType == null) {
            return exchangeRate;
        }
        if (srcCurId.equals(tarCurId)) {
            exchangeRate = BigDecimal.ONE;
        } else {
            boolean isIndirect = this.isIndirectRate(exchangeType);
            exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)exRateTableId, (Long)srcCurId, (Long)tarCurId, (Date)date, (boolean)isIndirect);
        }
        return exchangeRate;
    }

    private DynamicObject getCurrency(Long orgId) {
        Long currencyId;
        Map<String, Long> map;
        if (orgId != 0L && (map = this.getCurrencyAndExRateTable(orgId)) != null && (currencyId = map.get(BASECURRRENCY)) != null && currencyId != 0L) {
            return this.loadSingleFromCache(currencyId, CURRENCY_DT);
        }
        return null;
    }

    private Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map<String, Object> mapOrg;
        if (orgId != null && (mapOrg = this.getCompanyByOrg(orgId, Boolean.FALSE, Boolean.TRUE)) != null && mapOrg.get("id") != null) {
            log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + mapOrg);
            Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
            if (map != null && map.size() != 0) {
                log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a" + map);
                return map;
            }
        }
        return null;
    }

    private Map<String, Object> getCompanyByOrg(Long orgId, Boolean isBizUnit, Boolean isSerrchUpward) {
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)isBizUnit, (Boolean)isSerrchUpward);
        return map;
    }

    private Map<String, Object> getOrgRelation(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        if (orgId == null) {
            return null;
        }
        OrgRelationParam orgRelationParam = this.buildOrgRelationParam(orgId, fromViewType, toViewType, getDirectOrgType);
        Map orgRelation = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)orgRelationParam);
        return orgRelation;
    }

    private OrgRelationParam buildOrgRelationParam(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        param.setDirectViewType(getDirectOrgType);
        return param;
    }

    private Long getOrgForFormDefValue(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        if (orgId == null) {
            return null;
        }
        OrgRelationParam orgRelationParam = this.buildOrgRelationParam(orgId, fromViewType, toViewType, getDirectOrgType);
        long defaultOrgId = OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)orgRelationParam);
        return defaultOrgId;
    }

    private boolean checkProperty(DynamicObject data, String propertyName) {
        DynamicProperty property;
        boolean isExistProperty = false;
        DynamicObjectType dynamicObjectType = data.getDynamicObjectType();
        if (dynamicObjectType != null && (property = dynamicObjectType.getProperty(propertyName)) != null) {
            isExistProperty = true;
        }
        return isExistProperty;
    }

    private DynamicObject getOrgForFormDefObjValue(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        if (orgId == null) {
            return null;
        }
        OrgRelationParam orgRelationParam = this.buildOrgRelationParam(orgId, fromViewType, toViewType, getDirectOrgType);
        Long defaultOrgId = OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)orgRelationParam);
        if (defaultOrgId != null && !defaultOrgId.equals(0L)) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)defaultOrgId, (String)"bos_org");
        }
        return null;
    }

    static class ConversionFactor {
        int numerator;
        int denominator;

        public ConversionFactor(int numerator, int denominator) {
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public int getNumerator() {
            return this.numerator;
        }

        public int getDenominator() {
            return this.denominator;
        }
    }
}

