/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class SalContractDefValueHelper {
    private static final Log LOGGER = LogFactory.getLog(SalContractDefValueHelper.class);
    private Map<String, DynamicObject> cacheDymMap = new HashMap<String, DynamicObject>(10);
    private Map<Object, DynamicObject> contpartiesMap = new HashMap<Object, DynamicObject>(10);
    public static final String ENTRY_ID = "entrynum";
    public static final String TOTALALLAMOUNT = "totalallamount";
    public static final String BIZTIME = "biztime";
    public static final String AMOUNTCONDITION = "amountcondition";
    public static final String ISPAYRATE = "ispayrate";
    public static final String SETTLECURRENCY = "settlecurrency";
    public static final String ENTRY_ITEMNAME = "itemname";
    public static final String ENTRY_AMOUNT = "amount";
    public static final String ENTRY_RATE = "rate";
    public static final String ENTRY_ISPREPAY = "isprepay";
    public static final String ENTRY_AMOUNTDATE = "amountdate";
    public static final String CHANGETYPE = "changetype";
    public static final String PLANTYPE = "plantype";
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";
    private static final String UnitConvertDir_UINV_U2ND = "A";
    private static final String UnitConvertDir_U2ND_UINV = "B";
    private static final String UnitConvertDir_UINVANDU2ND = "C";
    private static final String UnitConvertDir_NONE = "D";

    private SalContractDefValueHelper() {
    }

    public static List<DynamicObject> batchSetSalContractDefValue(List<DynamicObject> bills) {
        if (bills == null || bills.isEmpty()) {
            return bills;
        }
        SalContractDefValueHelper helper = new SalContractDefValueHelper();
        return helper.batchSetDefValue(bills);
    }

    private List<DynamicObject> batchSetDefValue(List<DynamicObject> bills) {
        bills.forEach(bill -> {
            this.contractHeadDefValue((DynamicObject)bill);
            this.setSalConparties((DynamicObject)bill);
            this.setCustomerInfo((DynamicObject)bill);
            this.setSettletype((DynamicObject)bill, "customer");
            this.setOperatorGrp((DynamicObject)bill, "XSZ");
            this.setDept((DynamicObject)bill);
            this.setEntry((DynamicObject)bill);
            this.setSalEntry((DynamicObject)bill);
            this.calAmountPlanForDynamicObject(this.getProFiles(), (DynamicObject)bill);
        });
        return bills;
    }

    private void contractHeadDefValue(DynamicObject bill) {
        Date biztime;
        QFilter enableQF;
        QFilter isdefaultQF;
        QFilter contcategoryQF;
        Map contType;
        Optional type;
        MainEntityType entityType = (MainEntityType)bill.getDataEntityType();
        Long billTypeID = (Long)bill.get("billtype.id");
        DynamicObject category = null;
        if (bill.getDynamicObject("category") == null) {
            category = (DynamicObject)this.getBillTypeParameterValue(entityType, billTypeID, "category");
            bill.set("category", (Object)category);
        }
        if (bill.getDynamicObject("type") == null && category != null && (type = (contType = BusinessDataServiceHelper.loadFromCache((String)"conm_type", (String)"conmprop,activesign,activereview,activearchive,pretimepoint", (QFilter[])new QFilter[]{contcategoryQF = new QFilter("contcategory", "=", category.getPkValue()), isdefaultQF = new QFilter("isdefault", "=", (Object)Boolean.TRUE), enableQF = new QFilter("enable", "=", (Object)"1")})).values().stream().findFirst()).isPresent()) {
            bill.set("type", type.get());
            bill.set("conmprop", (Object)((DynamicObject)type.get()).getString("conmprop"));
        }
        Map<String, Object> res4P = this.get4P(bill);
        bill.set("currency", res4P.get("currency"));
        bill.set(SETTLECURRENCY, res4P.get(SETTLECURRENCY));
        bill.set("exratetable", res4P.get("exratetable"));
        bill.set("exratedate", res4P.get("exratedate"));
        bill.set("exchangerate", res4P.get("exchangerate"));
        bill.set("exchangetype", res4P.get("exchangetype"));
        this.setConmType(bill);
        DynamicObject type2 = bill.getDynamicObject("type");
        if (type2 != null) {
            bill.set("conmprop", (Object)type2.getString("conmprop"));
        }
        if ((biztime = bill.getDate(BIZTIME)) == null) {
            bill.set(BIZTIME, (Object)TimeServiceHelper.now());
        }
    }

    private void setSalConparties(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject contParties = bill.getDynamicObject("contparties");
        if (contParties == null) {
            contParties = this.loadContParties(org);
            if (contParties == null) {
                return;
            }
            bill.set("contparties", (Object)contParties);
        }
        if (StringUtils.isEmpty((String)bill.getString("party2nd")) || bill.getString("party2nd") == null) {
            String party1st = contParties.getLocaleString("name").getLocaleValue();
            bill.set("party2nd", (Object)party1st);
        }
        if (StringUtils.isEmpty((String)bill.getString("contactperson2nd")) || bill.getString("contactperson2nd") == null) {
            String contacts = contParties.getString("contacts");
            bill.set("contactperson2nd", (Object)contacts);
        }
        if (StringUtils.isEmpty((String)bill.getString("phone2nd")) || bill.getString("phone2nd") == null) {
            String phone = contParties.getString("phone");
            bill.set("phone2nd", (Object)phone);
        }
    }

    private void setCustomerInfo(DynamicObject bill) {
        DynamicObject customer = bill.getDynamicObject("customer");
        if (customer == null) {
            return;
        }
        DynamicObject reccustomer = bill.getDynamicObject("reccustomer");
        if (reccustomer == null) {
            bill.set("reccustomer", (Object)this.getCustomerOriginal(customer, "delivercustomerid"));
        }
        if ((reccustomer = bill.getDynamicObject("reccustomer")) != null) {
            if (StringUtils.isEmpty((String)bill.getString("reclinkman"))) {
                bill.set("reclinkman", (Object)this.getLinkmanObject(reccustomer));
            }
            if (StringUtils.isEmpty((String)bill.getString("receiveaddress"))) {
                bill.set("receiveaddress", (Object)this.getAddress(reccustomer));
            }
        }
        if (bill.getDynamicObject("payingcustomer") == null) {
            bill.set("payingcustomer", (Object)this.getCustomerOriginal(customer, "paymentcustomerid"));
        }
        if (bill.getDynamicObject("settlecustomer") == null) {
            bill.set("settlecustomer", (Object)this.getCustomerOriginal(customer, "invoicecustomerid"));
        }
        if (bill.getString("party1st") == null || StringUtils.isEmpty((String)bill.getString("party1st"))) {
            bill.set("party1st", (Object)customer.getLocaleString("name"));
        }
        if (bill.getString("contactperson1st") == null || StringUtils.isEmpty((String)bill.getString("contactperson1st"))) {
            bill.set("contactperson1st", (Object)customer.getString("linkman"));
        }
        if (bill.getString("phone1st") == null || StringUtils.isEmpty((String)bill.getString("phone1st"))) {
            bill.set("phone1st", customer.get("bizpartner_phone"));
        }
    }

    private void setSettletype(DynamicObject bill, String clientType) {
        if (bill.getDynamicObject("settletype") == null) {
            bill.set("settletype", (Object)this.getSettletype(bill.getDynamicObject(clientType)));
        }
    }

    private void setOperatorGrp(DynamicObject bill, String grptype) {
        QFilter qFilter04;
        QFilter qFilter03;
        QFilter qFilter02;
        QFilter qFilter01;
        DynamicObject[] operators;
        QFilter qFilter3;
        QFilter qFilter2;
        DynamicObject operator = bill.getDynamicObject("operator");
        DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null || operator != null && operatorGroup != null) {
            return;
        }
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)((Long)org.getPkValue()));
        Map operatorGroupDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("operatorgrouptype", "=", (Object)grptype), qFilter3 = new QFilter("enable", "=", (Object)"1")});
        if (operatorGroupDynamicObjectMap != null && operatorGroupDynamicObjectMap.size() > 0 && (operators = BusinessDataServiceHelper.load((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype,invalid", (QFilter[])new QFilter[]{qFilter01 = new QFilter("operatorgrpid", "in", operatorGroupDynamicObjectMap.keySet()), qFilter02 = new QFilter("opergrptype", "=", (Object)grptype), qFilter03 = new QFilter("operatorid", "=", (Object)UserServiceHelper.getCurrentUserId()), qFilter04 = new QFilter("invalid", "=", (Object)Boolean.FALSE)})) != null && operators.length > 0 && operators[0] != null) {
            bill.set("operator", (Object)operators[0]);
            bill.set("operatorgroup", operatorGroupDynamicObjectMap.get(operators[0].get("operatorgrpid")));
        }
    }

    private void setDept(DynamicObject bill) {
        DynamicObject dept = bill.getDynamicObject("dept");
        DynamicObject operator = bill.getDynamicObject("operator");
        if (dept != null) {
            return;
        }
        if (operator == null) {
            return;
        }
        DynamicObject user = (DynamicObject)operator.get("operatorid");
        if (user == null) {
            return;
        }
        Long deptId = UserServiceHelper.getUserMainOrgId((long)((Long)user.getPkValue()));
        dept = this.loadSingleFromCache(deptId, "bos_org");
        bill.set("dept", (Object)dept);
    }

    private void setEntry(DynamicObject bill) {
        BigDecimal allAmount = BigDecimal.ZERO;
        BigDecimal allAmountAndTax = BigDecimal.ZERO;
        BigDecimal allTaxAmount = BigDecimal.ZERO;
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject row : entry) {
            DynamicObject material = row.getDynamicObject("material");
            DynamicObject masterMaterial = row.getDynamicObject("materialmasterid");
            if (masterMaterial == null) {
                DynamicObject masterid = (DynamicObject)this.getMatPropValue(material, "masterid");
                row.set("materialmasterid", (Object)masterid);
            }
            Map<String, BigDecimal> amountMap = this.getAmount(bill, row);
            BigDecimal amount = amountMap.get(ENTRY_AMOUNT);
            BigDecimal taxAmount = amountMap.get("taxamount");
            BigDecimal amountAndTax = amountMap.get("amountandtax");
            allAmount = allAmount.add(amount);
            allAmountAndTax = allAmountAndTax.add(amountAndTax);
            allTaxAmount = allTaxAmount.add(taxAmount);
            this.setEntryRow(bill, row, amountMap);
        }
        Boolean isEntrySumAmt = bill.getBoolean("isentrysumamt");
        if (isEntrySumAmt.booleanValue()) {
            bill.set(TOTALALLAMOUNT, (Object)allAmountAndTax);
            bill.set("totalamount", (Object)allAmount);
            bill.set("totaltaxamount", (Object)allTaxAmount);
        }
    }

    private void setSalEntry(DynamicObject bill) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject row : entry) {
            DynamicObject material;
            if (row.getDynamicObject("productline") != null || (material = row.getDynamicObject("material")) == null || material.getDynamicObject("masterid") == null) continue;
            DynamicObject productLine = material.getDynamicObject("masterid").getDynamicObject("productline");
            row.set("productline", (Object)productLine);
        }
    }

    private void setConmType(DynamicObject bill) {
        DynamicObject type = bill.getDynamicObject("type");
        if (type != null) {
            bill.set("signstatus", (Object)(type.getBoolean("activesign") ? UnitConvertDir_UINV_U2ND : UnitConvertDir_UINVANDU2ND));
            bill.set("reviewstatus", (Object)(type.getBoolean("activereview") ? UnitConvertDir_UINV_U2ND : "E"));
            bill.set("filingstatus", (Object)(type.getBoolean("activearchive") ? UnitConvertDir_UINV_U2ND : UnitConvertDir_UINVANDU2ND));
        }
    }

    private DynamicObject loadContParties(DynamicObject org) {
        if (org == null) {
            return null;
        }
        DynamicObject contparties = this.contpartiesMap.get(org.getPkValue());
        if (contparties == null) {
            QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", org.getPkValue()), new QFilter("enable", "=", (Object)"1"), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
            contparties = BusinessDataServiceHelper.loadSingleFromCache((String)"conm_contparties", (QFilter[])filters);
            this.contpartiesMap.put(org.getPkValue(), contparties);
        }
        return contparties;
    }

    private void setEntryRow(DynamicObject bill, DynamicObject row, Map<String, BigDecimal> amountMap) {
        DynamicObject org;
        Long entryreqorgId;
        DynamicObject entryreqorg;
        DynamicProperty entryReqOrgProp;
        DynamicObject org2;
        Long entryinvorgId;
        DynamicObject entryinvorg;
        DynamicObject org3;
        Long defaultOrgId;
        DynamicObject settleOrg;
        DynamicObject materialInfo;
        BigDecimal baseQty;
        BigDecimal amount = amountMap.get(ENTRY_AMOUNT);
        BigDecimal taxAmount = amountMap.get("taxamount");
        BigDecimal amountAndTax = amountMap.get("amountandtax");
        row.set(ENTRY_AMOUNT, (Object)amount);
        row.set("taxamount", (Object)taxAmount);
        row.set("amountandtax", (Object)amountAndTax);
        row.set("price", (Object)amountMap.get("price"));
        row.set("priceandtax", (Object)amountMap.get("priceandtax"));
        row.set("discountamount", (Object)amountMap.get("discountamount"));
        row.set("curamount", (Object)amountMap.get("curamount"));
        row.set("curtaxamount", (Object)amountMap.get("curtaxamount"));
        row.set("curamountandtax", (Object)amountMap.get("curamountandtax"));
        DynamicObject baseUnit = row.getDynamicObject("baseunit");
        if (baseUnit == null) {
            baseUnit = row.getDynamicObject("material.masterid.baseunit");
            row.set("baseunit", (Object)baseUnit);
        }
        if ((baseQty = row.getBigDecimal("baseqty")) == null || baseQty.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal qty = row.getBigDecimal("qty");
            DynamicObject unit = row.getDynamicObject("unit");
            DynamicObject masterid = row.getDynamicObject("material.masterid");
            baseQty = this.getDesQtyConv(masterid, unit, qty, baseUnit);
            row.set("baseqty", (Object)baseQty);
        }
        if ((materialInfo = row.getDynamicObject("material")) != null) {
            DynamicObject auxUnit;
            if (row.get("auxunit") == null) {
                auxUnit = materialInfo.getDynamicObject("masterid.auxptyunit");
                row.set("auxunit", (Object)auxUnit);
            }
            if (row.getBigDecimal("auxqty").compareTo(BigDecimal.ZERO) == 0) {
                auxUnit = row.getDynamicObject("auxunit");
                row.set("auxqty", (Object)this.getAuxQty(materialInfo, auxUnit, baseUnit, baseQty));
            }
        }
        if ((settleOrg = row.getDynamicObject("entrysettleorg")) == null && (defaultOrgId = this.getOrgRelationParam((Long)(org3 = bill.getDynamicObject("org")).getPkValue(), "03", "10", "toorg")) != null) {
            row.set("entrysettleorg", (Object)this.loadSingleFromCache(defaultOrgId, "bos_org"));
        }
        if ((entryinvorg = row.getDynamicObject("entryinvorg")) == null && (entryinvorgId = this.getOrgRelationParam((Long)(org2 = bill.getDynamicObject("org")).getPkValue(), "03", "05", "toorg")) != null) {
            row.set("entryinvorg", (Object)this.loadSingleFromCache(entryinvorgId, "bos_org"));
        }
        if ((entryReqOrgProp = row.getDynamicObjectType().getProperty("entryreqorg")) != null && (entryreqorg = row.getDynamicObject("entryreqorg")) == null && (entryreqorgId = this.getOrgRelationParam((Long)(org = bill.getDynamicObject("org")).getPkValue(), null, "03", "fromorg")) != null) {
            row.set("entryreqorg", (Object)this.loadSingleFromCache(entryreqorgId, "bos_org"));
        }
    }

    private Long getOrgRelationParam(Long org, String fromViewType, String orgViewType, String directViewType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(org.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(orgViewType);
        if ("fromorg".equals(directViewType)) {
            param.setDirectViewType("fromorg");
        } else if ("toorg".equals(directViewType)) {
            param.setDirectViewType("toorg");
        }
        return OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)param);
    }

    private Object getMatPropValue(DynamicObject material, String key) {
        if (material == null) {
            return null;
        }
        String tyepName = material.getDataEntityType().getName();
        if ("masterid".equals(key)) {
            return "bd_material".equals(tyepName) ? material : material.get("masterid");
        }
        return "bd_material".equals(tyepName) ? material.get(key) : material.get("masterid." + key);
    }

    private boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).isEmpty()) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    private DynamicObject loadSingleFromCache(Object pkId, String entityNo) {
        String key;
        DynamicObject dymObj;
        if (this.isNull(entityNo) || this.isNull(pkId)) {
            return null;
        }
        if (this.cacheDymMap == null) {
            this.cacheDymMap = new HashMap<String, DynamicObject>(8);
        }
        if ((dymObj = this.cacheDymMap.get(key = entityNo.concat("_").concat(pkId.toString()))) == null) {
            DynamicObject dym = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)entityNo);
            this.cacheDymMap.put(key, dym);
            return dym;
        }
        return dymObj;
    }

    private Map<String, String> getProFiles() {
        HashMap<String, String> proFilesMap = new HashMap<String, String>();
        proFilesMap.put(ENTRY_ID, "payentry");
        proFilesMap.put(TOTALALLAMOUNT, TOTALALLAMOUNT);
        proFilesMap.put(ENTRY_AMOUNT, "payamount");
        proFilesMap.put(ENTRY_RATE, "payrate");
        proFilesMap.put(SETTLECURRENCY, SETTLECURRENCY);
        proFilesMap.put(ISPAYRATE, ISPAYRATE);
        proFilesMap.put(CHANGETYPE, "payentrychangetype");
        return proFilesMap;
    }

    private Map<String, BigDecimal> getAmount(DynamicObject bill, DynamicObject entryRow) {
        if (entryRow == null || bill == null) {
            return null;
        }
        BigDecimal qty = entryRow.getBigDecimal("qty");
        BigDecimal price = entryRow.getBigDecimal("price");
        BigDecimal priceAndTax = entryRow.getBigDecimal("priceandtax");
        BigDecimal taxRate = entryRow.getBigDecimal("taxrate");
        String discountType = entryRow.getString("discounttype");
        BigDecimal discountRate = entryRow.getBigDecimal("discountrate");
        boolean isTax = bill.getBoolean("istax");
        Map<String, Object> res4P = this.get4P(bill);
        DynamicObject settleCurrency = (DynamicObject)res4P.get(SETTLECURRENCY);
        int settlePrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        int settlePricePrecision = 10;
        BigDecimal ZERO = BigDecimal.ZERO;
        BigDecimal ONE = BigDecimal.ONE;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        BigDecimal hundred = new BigDecimal(100);
        BigDecimal bigDecimal = taxRate = taxRate == null ? ZERO : taxRate.divide(hundred).setScale(10, 4);
        if (qty != null && qty.compareTo(ZERO) != 0) {
            if (discountRate == null || StringUtils.isEmpty((String)discountType) || "NULL".equals(discountType) || discountRate.compareTo(ZERO) == 0) {
                if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                    price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                    amountAndTax = qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP);
                    taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amount = amountAndTax.subtract(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                } else if (price != null && price.compareTo(ZERO) != 0) {
                    priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).setScale(settlePrecision, RoundingMode.HALF_UP);
                    taxAmount = amount.multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = amount.add(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                }
            } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                if (UnitConvertDir_UINV_U2ND.equals(discountType)) {
                    discountRate = discountRate.divide(hundred).setScale(10, 4);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = BigDecimal.ONE.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                } else if (UnitConvertDir_U2ND_UINV.equals(discountType) || UnitConvertDir_UINVANDU2ND.equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = priceAndTax.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
            } else if (price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
                if (UnitConvertDir_UINV_U2ND.equals(discountType)) {
                    discountRate = discountRate.divide(hundred, 10, 4);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).setScale(settlePrecision, RoundingMode.HALF_UP).multiply(ONE.subtract(discountRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                } else if (UnitConvertDir_U2ND_UINV.equals(discountType) || UnitConvertDir_UINVANDU2ND.equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).multiply(ONE.add(taxRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price.subtract(discountRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amount.multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
            }
        }
        BigDecimal exChangeRate = (BigDecimal)res4P.get("exchangerate");
        DynamicObject currency = (DynamicObject)res4P.get("currency");
        String exchangeType = (String)res4P.get("exchangetype");
        BigDecimal curAmount = BigDecimal.ZERO;
        BigDecimal curTaxAmount = BigDecimal.ZERO;
        BigDecimal curAmountAndTax = BigDecimal.ZERO;
        int currencyPrecision = 10;
        if (currency != null) {
            currencyPrecision = currency.getInt("amtprecision");
        }
        if (exChangeRate != null && exChangeRate.compareTo(ZERO) != 0) {
            curTaxAmount = this.getCurAmountByRate(taxAmount, exChangeRate, currencyPrecision, exchangeType);
            if (isTax) {
                curAmountAndTax = this.getCurAmountByRate(amountAndTax, exChangeRate, currencyPrecision, exchangeType);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = this.getCurAmountByRate(amount, exChangeRate, currencyPrecision, exchangeType);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
        }
        map.put("curamount", curAmount);
        map.put("curtaxamount", curTaxAmount);
        map.put("curamountandtax", curAmountAndTax);
        map.put("price", price);
        map.put("priceandtax", priceAndTax);
        map.put("discountamount", discountAmount);
        map.put(ENTRY_AMOUNT, amount);
        map.put("taxamount", taxAmount);
        map.put("amountandtax", amountAndTax);
        return map;
    }

    private BigDecimal getCurAmountByRate(BigDecimal amount, BigDecimal exChangeRate, int currencyPrecision, String exChangeType) {
        BigDecimal curAmount = BigDecimal.ZERO;
        if (amount == null) {
            return curAmount;
        }
        if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
            return curAmount;
        }
        curAmount = exChangeType != null && "1".equals(exChangeType) ? amount.divide(exChangeRate, currencyPrecision, RoundingMode.HALF_UP) : amount.multiply(exChangeRate).setScale(currencyPrecision, RoundingMode.HALF_UP);
        return curAmount;
    }

    private void calAmountPlanForDynamicObject(Map<String, String> properytMapping, DynamicObject bill) {
        DynamicObject currency;
        int precision;
        if (bill == null || properytMapping == null || properytMapping.isEmpty()) {
            return;
        }
        String amountPlanEntryKey = properytMapping.get(ENTRY_ID);
        String amountKey = properytMapping.get(ENTRY_AMOUNT);
        String rateKey = properytMapping.get(ENTRY_RATE);
        String settleCurrencyKey = properytMapping.get(SETTLECURRENCY);
        String isPayRateKey = properytMapping.get(ISPAYRATE);
        String changeTypeKey = properytMapping.get(CHANGETYPE);
        String totalAmountAndTaxKey = properytMapping.get(TOTALALLAMOUNT);
        DynamicObjectCollection amountPlanEntry = bill.getDynamicObjectCollection(amountPlanEntryKey);
        if (amountPlanEntry == null || amountPlanEntry.isEmpty()) {
            return;
        }
        boolean isPayRate = bill.getBoolean(isPayRateKey);
        BigDecimal totalAllAmount = bill.getBigDecimal(totalAmountAndTaxKey);
        if (totalAllAmount == null) {
            totalAllAmount = BigDecimal.ZERO;
        }
        int n = precision = (currency = bill.getDynamicObject(settleCurrencyKey)) == null ? 10 : currency.getInt("amtprecision");
        if (isPayRate) {
            BigDecimal rateTotal = BigDecimal.ZERO;
            for (DynamicObject entry : amountPlanEntry) {
                BigDecimal rate = entry.getBigDecimal(rateKey);
                String changeType = entry.getString(changeTypeKey);
                if (UnitConvertDir_UINVANDU2ND.equals(changeType) || rate == null) continue;
                rateTotal = rateTotal.add(rate);
            }
            BigDecimal amountTotal = BigDecimal.ZERO;
            for (int i = 0; i < amountPlanEntry.size(); ++i) {
                DynamicObject entry = (DynamicObject)amountPlanEntry.get(i);
                BigDecimal rate = entry.getBigDecimal(rateKey);
                String changeType = entry.getString(changeTypeKey);
                if (UnitConvertDir_UINVANDU2ND.equals(changeType)) continue;
                BigDecimal amount = rate == null || BigDecimal.ZERO.compareTo(rate) == 0 ? BigDecimal.ZERO : (i == amountPlanEntry.size() - 1 && rateTotal.compareTo(HUNDRED) == 0 ? totalAllAmount.subtract(amountTotal) : totalAllAmount.multiply(rate).divide(HUNDRED, precision, RoundingMode.HALF_UP));
                amountTotal = amountTotal.add(amount);
                entry.set(amountKey, (Object)amount);
            }
        } else {
            BigDecimal amountTotal = BigDecimal.ZERO;
            for (DynamicObject entry : amountPlanEntry) {
                BigDecimal amount = entry.getBigDecimal(amountKey);
                String changeType = entry.getString(changeTypeKey);
                if (UnitConvertDir_UINVANDU2ND.equals(changeType) || amount == null) continue;
                amount = amount.setScale(precision, RoundingMode.HALF_UP);
                amountTotal = amountTotal.add(amount);
            }
            BigDecimal rateTotal = BigDecimal.ZERO;
            for (int i = 0; i < amountPlanEntry.size(); ++i) {
                BigDecimal rate;
                DynamicObject entry = (DynamicObject)amountPlanEntry.get(i);
                BigDecimal amount = entry.getBigDecimal(amountKey);
                String changeType = entry.getString(changeTypeKey);
                if (UnitConvertDir_UINVANDU2ND.equals(changeType)) continue;
                if (amount == null || totalAllAmount.compareTo(BigDecimal.ZERO) == 0 || BigDecimal.ZERO.compareTo(amount) == 0) {
                    rate = BigDecimal.ZERO;
                } else if (i == amountPlanEntry.size() - 1 && amountTotal.compareTo(totalAllAmount) == 0) {
                    rate = HUNDRED.subtract(rateTotal);
                } else {
                    amount = amount.setScale(precision, RoundingMode.HALF_UP);
                    rate = amount.multiply(HUNDRED).divide(totalAllAmount, 2, RoundingMode.HALF_UP);
                }
                rateTotal = rateTotal.add(rate);
                entry.set(rateKey, (Object)rate);
                entry.set(amountKey, (Object)amount);
            }
        }
    }

    private DynamicObject getBillTypeParameter(String formId, String paramFormId, long billTypeId) {
        DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
        return billTypeParam;
    }

    private Object getBillTypeParameterValue(MainEntityType entity, long billTypeId, String propertyName) {
        if (entity instanceof BillEntityType) {
            String paramFormId = ((BillEntityType)entity).getBillTypePara();
            DynamicObject billTypeParam = this.getBillTypeParameter(entity.getName(), paramFormId, billTypeId);
            if (!this.isNull(billTypeParam) && !this.isNull(billTypeParam.get(propertyName))) {
                return billTypeParam.get(propertyName);
            }
        }
        return null;
    }

    private Map<String, Object> get4P(DynamicObject bill) {
        Boolean quoteType;
        Map<String, Object> exchangeRateMap;
        Map<String, Long> cur;
        Long orgID = (Long)bill.get("org.id");
        BigDecimal exrateRate = bill.getBigDecimal("exchangerate");
        Date exrateDate = bill.getDate("exratedate");
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject(SETTLECURRENCY);
        DynamicObject exratetable = bill.getDynamicObject("exratetable");
        String exchangeType = bill.getString("exchangetype");
        if (currency == null && (cur = this.getCurrencyAndExRateTable(orgID)) != null) {
            currency = this.loadSingleFromCache(cur.get("baseCurrencyID"), "bd_currency");
        }
        if (exratetable == null && (cur = this.getCurrencyAndExRateTable(orgID)) != null) {
            exratetable = this.loadSingleFromCache(cur.get("exchangeRateTableID"), "bd_exratetable");
        }
        if (settleCurrency == null) {
            settleCurrency = currency;
        }
        if (exrateDate == null) {
            exrateDate = TimeServiceHelper.now();
        }
        if ((exrateRate == null || exrateRate.compareTo(BigDecimal.ZERO) == 0) && settleCurrency != null && currency != null && exratetable != null && exrateDate != null) {
            if (exchangeType != null) {
                exrateRate = this.getExRate((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exratetable.getPkValue(), exrateDate, exchangeType);
            } else {
                exchangeRateMap = this.getExchangeRateMap((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exratetable.getPkValue(), exrateDate);
                if (exchangeRateMap != null && exchangeRateMap.size() > 0) {
                    exrateRate = (BigDecimal)exchangeRateMap.get("exchangeRate");
                    quoteType = (Boolean)exchangeRateMap.get("quoteType");
                    exchangeType = quoteType != null && quoteType == false ? "0" : "1";
                }
            }
        }
        if ((exchangeType == null || "".equals(exchangeType)) && settleCurrency != null && currency != null && exratetable != null && exrateDate != null && (exchangeRateMap = this.getExchangeRateMap((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exratetable.getPkValue(), exrateDate)) != null && exchangeRateMap.size() > 0) {
            quoteType = (Boolean)exchangeRateMap.get("quoteType");
            exchangeType = quoteType != null && quoteType == false ? "0" : "1";
        }
        HashMap<String, Object> res4P = new HashMap<String, Object>();
        res4P.put("currency", currency);
        res4P.put(SETTLECURRENCY, settleCurrency);
        res4P.put("exratedate", exrateDate);
        res4P.put("exchangerate", exrateRate);
        res4P.put("exratetable", exratetable);
        res4P.put("exchangetype", exchangeType);
        return res4P;
    }

    private Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null) {
            LOGGER.info(ResManager.loadKDString((String)"\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a", (String)"CurrencyHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]) + mapOrg);
            Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
            if (map != null && map.size() != 0) {
                LOGGER.info(ResManager.loadKDString((String)"\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a", (String)"CurrencyHelper_1", (String)"scmc-conm-business", (Object[])new Object[0]) + map);
                return map;
            }
        }
        return null;
    }

    private DynamicObject getSettletype(DynamicObject role) {
        if (role != null && role.getDynamicObject("settlementtypeid") != null) {
            return role.getDynamicObject("settlementtypeid");
        }
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{isdefault, isenable});
    }

    private BigDecimal getExRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date, String exchangeType) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null || exchangeType == null) {
            return exchangeRate;
        }
        if (srcCurId.equals(tarCurId)) {
            exchangeRate = BigDecimal.ONE;
        } else {
            boolean isIndirect = false;
            if ("1".equals(exchangeType)) {
                isIndirect = true;
            }
            exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)srcCurId, (Long)tarCurId, (Long)exRateTableId, (Date)date, (boolean)isIndirect);
        }
        return exchangeRate;
    }

    private Map<String, Object> getExchangeRateMap(Long settleCurrency, Long currency, Long exRateTable, Date bizTime) {
        if (settleCurrency == null || currency == null || exRateTable == null) {
            return null;
        }
        return BaseDataServiceHelper.getExchangeRateMap((Long)settleCurrency, (Long)currency, (Long)exRateTable, (Date)bizTime);
    }

    private DynamicObject getCustomerOriginal(DynamicObject customer, String otherCustomer) {
        if (customer == null) {
            return null;
        }
        DynamicObject dynamicObject = customer.getDynamicObject(otherCustomer);
        return dynamicObject;
    }

    private DynamicObject getLinkmanObject(DynamicObject customer) {
        DynamicObject customerLinkMans = this.loadSingleFromCache(customer.getPkValue(), "bd_customer");
        if (customerLinkMans == null) {
            return null;
        }
        DynamicObjectCollection linkmans = customerLinkMans.getDynamicObjectCollection("entry_linkman");
        DynamicObject customerLinkmanId = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                customerLinkmanId = linkman;
                break;
            }
            if (customerLinkmanId != null || invalid) continue;
            customerLinkmanId = linkman;
        }
        DynamicObject linkmanObject = null;
        if (customerLinkmanId != null) {
            linkmanObject = this.loadSingleFromCache(customerLinkmanId.getPkValue(), "bd_customerlinkman");
        }
        return linkmanObject;
    }

    private String getAddress(DynamicObject customer) {
        QFilter id2;
        QFilter id1 = new QFilter("customerid", "in", (Object)customer.getPkValue().toString());
        Map bd_address = BusinessDataServiceHelper.loadFromCache((String)"bd_address", (QFilter[])new QFilter[]{id1.and(id2 = new QFilter("invalid", "=", (Object)"0"))});
        if (bd_address.size() <= 0) {
            return "";
        }
        String validAddress = "";
        for (Map.Entry entry : bd_address.entrySet()) {
            DynamicObject add = (DynamicObject)entry.getValue();
            boolean isDefault = add.getBoolean("default");
            if (isDefault) {
                return add.getString("detailaddress");
            }
            if (!"".equalsIgnoreCase(validAddress)) continue;
            validAddress = add.getString("detailaddress");
        }
        return "".equalsIgnoreCase(validAddress) ? customer.getString("bizpartner_address") : validAddress;
    }

    private BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("denominator") != 0) {
                int precision = desUnit.getInt(UNIT_PRECISION);
                return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, this.getRoundMode(desUnit));
            }
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getAuxQty(DynamicObject materialInfo, DynamicObject auxptyUnit, DynamicObject baseUnit, BigDecimal baseQty) {
        if (materialInfo == null || auxptyUnit == null || baseUnit == null) {
            return null;
        }
        if (baseQty == null) {
            return BigDecimal.ZERO;
        }
        String unitConvertDir = materialInfo.getString("masterid.unitconvertdir");
        if (UnitConvertDir_NONE.equals(unitConvertDir)) {
            return null;
        }
        if (UnitConvertDir_UINV_U2ND.equals(unitConvertDir) || UnitConvertDir_UINVANDU2ND.equals(unitConvertDir)) {
            return this.getDesQtyConv(materialInfo.getDynamicObject("masterid"), baseUnit, baseQty, auxptyUnit);
        }
        return null;
    }

    private int getRoundMode(DynamicObject unit) {
        String precisionaccount = unit.getString(UNIT_PRECISIONTYPE);
        int baseUnitPrecisionType = 4;
        if ("2".equals(precisionaccount)) {
            baseUnitPrecisionType = 1;
        } else if ("3".equals(precisionaccount)) {
            baseUnitPrecisionType = 0;
        }
        return baseUnitPrecisionType;
    }
}

