/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.service;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.mpscmm.msbd.common.enums.CacheOperateEnum;
import kd.mpscmm.msbd.common.utils.CacheSyncOperator;

public abstract class AbstractMServiceAsyncHandler {
    private static final Log log = LogFactory.getLog(AbstractMServiceAsyncHandler.class);
    private static final String PROPERTY_QUEUE_CACHE_KEY_SUFFIX = "PROPERTY_QUEUE";
    private static final String CONSUMER_START_KEY = "CONSUMER_START";
    private static final String CONSUMER_START = "start";
    private static final String KV_JOINER = "#";
    private CacheSyncOperator cacheOperator;

    public abstract String getResultCacheKey();

    public abstract String serviceResult2PageCache(Object var1);

    public abstract Object invokeService();

    public abstract void dualException(Exception var1);

    public void propertyChanged(PropertyChangedArgs e, IPageCache pageCache) {
        List<Integer> indexList;
        if (this.cacheOperator == null) {
            this.cacheOperator = new CacheSyncOperator(pageCache, this.getQueueCacheKey());
        }
        if ((indexList = this.getPropertyChangedIndexArray(e)) == null || indexList.isEmpty()) {
            return;
        }
        String propertyName = e.getProperty().getName();
        log.info("\u3010\u81ea\u52a8\u670d\u52a1\u3011 pageId=" + pageCache.getPageId() + ",\u3010" + propertyName + "\u3011\u89e6\u53d1\u81ea\u52a8\u670d\u52a1");
        this.writeCache(propertyName, indexList);
        String consumerStartCache = pageCache.getBigObject(CONSUMER_START_KEY);
        if (!CONSUMER_START.equals(consumerStartCache)) {
            this.startConsumer(pageCache);
        }
    }

    public String getResultFromCache(IPageCache pageCache) {
        String cacheKey = this.getResultCacheKey();
        String result = pageCache.getBigObject(cacheKey);
        if (StringUtils.isEmpty((CharSequence)result) || result.equals("null")) {
            return null;
        }
        pageCache.removeBigObject(cacheKey);
        return result;
    }

    private String getQueueCacheKey() {
        return this.getResultCacheKey() + "_" + PROPERTY_QUEUE_CACHE_KEY_SUFFIX;
    }

    private void startConsumer(IPageCache pageCache) {
        log.info("\u542f\u52a8\u5f02\u6b65\u7ebf\u7a0b\u8c03\u7528\u5fae\u670d\u52a1\uff1apageId=" + pageCache.getPageId());
        RequestContext rc = RequestContextCreator.createForThreadPool();
        Object runnable = new RequestContextRunnable(() -> {
            long threadStartTime = System.currentTimeMillis();
            pageCache.putBigObject(CONSUMER_START_KEY, CONSUMER_START);
            while (this.consumeCache() != null) {
                Exception mServiceException = null;
                Object mServiceResult = null;
                try {
                    long serviceStartTime = System.currentTimeMillis();
                    mServiceResult = this.invokeService();
                    log.info("pageId=" + pageCache.getPageId() + "\uff0c\u8c03\u7528\u5fae\u670d\u52a1\u8017\u65f6\uff1a" + (System.currentTimeMillis() - serviceStartTime));
                }
                catch (Exception e) {
                    mServiceException = e;
                }
                long cacheStartTime = System.currentTimeMillis();
                this.afterInvokeMService(pageCache, mServiceResult, mServiceException);
                log.info("pageId=" + pageCache.getPageId() + "\uff0c\u7f13\u5b58\u5fae\u670d\u52a1\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - cacheStartTime));
            }
            pageCache.removeBigObject(CONSUMER_START_KEY);
            log.info("\u81ea\u52a8\u670d\u52a1\u5f02\u6b65\u6267\u884c\u7ed3\u675f\uff0cpageId=" + pageCache.getPageId() + "\uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - threadStartTime));
        }, rc);
        runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
        ThreadPools.executeOnce((String)(this.getClass().getName() + "#consumer"), (Runnable)runnable);
    }

    private void afterInvokeMService(IPageCache pageCache, Object mServiceResult, Exception mServiceException) {
        if (mServiceException != null) {
            log.info("\u81ea\u52a8\u670d\u52a1\u8c03\u7528\u5f02\u5e38 pageId=" + pageCache.getPageId() + "\uff0ckey=" + this.getResultCacheKey(), (Object)mServiceException);
            this.dualException(mServiceException);
            return;
        }
        if (mServiceResult != null) {
            log.info("\u83b7\u53d6\u81ea\u52a8\u670d\u52a1\u6570\u636e\uff1a pageId=" + pageCache.getPageId() + "\uff0cresult=" + mServiceResult);
            this.updateResultCache(pageCache, this.serviceResult2PageCache(mServiceResult));
        }
    }

    private void updateResultCache(IPageCache pageCache, String serviceResultCacheStr) {
        if (serviceResultCacheStr != null) {
            log.info("\u5c06\u5fae\u670d\u52a1\u5904\u7406\u6570\u636e\u653e\u5165cache\uff1a pageId=" + pageCache.getPageId() + "\uff0cresult=" + serviceResultCacheStr);
            pageCache.putBigObject(this.getResultCacheKey(), serviceResultCacheStr);
        }
    }

    private String consumeCache() {
        return this.cacheOperator.doOperate(CacheOperateEnum.SPOP_ALL, null);
    }

    private void writeCache(String propertyName, List<Integer> indexList) {
        long startTime = System.currentTimeMillis();
        this.cacheOperator.doOperate(CacheOperateEnum.SPUSH, this.joinIndex(propertyName, indexList));
        log.info("\u81ea\u52a8\u670d\u52a1\u7f13\u5b58\u5b57\u6bb5\u961f\u5217\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
    }

    private List<Integer> getPropertyChangedIndexArray(PropertyChangedArgs e) {
        if (e == null) {
            return null;
        }
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null) {
            return null;
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(changeSet.length);
        for (ChangeData changeData : changeSet) {
            indexList.add(changeData.getRowIndex());
        }
        return indexList;
    }

    private String joinIndex(String propertyName, List<Integer> indexList) {
        if (indexList == null || indexList.isEmpty() || StringUtils.isEmpty((CharSequence)propertyName)) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(String.valueOf(','), "", "");
        for (int index : indexList) {
            joiner.add(propertyName + KV_JOINER + index);
        }
        return joiner.toString();
    }
}

