/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.service;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;

public class TrackLogService {
    private static final Log log = LogFactory.getLog(TrackLogService.class);
    private static final String START = "start";
    private static final String MID = "mid";
    private static final String END = "end";
    private static final String INFO = "info";
    private static final String WARN = "warn";
    private static final String ERROR = "error";
    private Class<?> classValue = null;
    private String appId = "";

    public TrackLogService(Class<?> classValue, String appId) {
        this.classValue = classValue;
        this.appId = appId;
    }

    public void startInfo(String methodParams) {
        TrackLogInfo trackLogInfo = new TrackLogInfo();
        trackLogInfo.setType(START);
        trackLogInfo.setLevel(INFO);
        trackLogInfo.setMethodParams(methodParams);
        this.saveTrackLog(trackLogInfo);
    }

    public void info(String trackLog) {
        TrackLogInfo trackLogInfo = new TrackLogInfo();
        trackLogInfo.setType(MID);
        trackLogInfo.setLevel(INFO);
        trackLogInfo.setTrackLog(trackLog);
        this.saveTrackLog(trackLogInfo);
    }

    public void warn(String trackLog) {
        TrackLogInfo trackLogInfo = new TrackLogInfo();
        trackLogInfo.setType(MID);
        trackLogInfo.setLevel(WARN);
        trackLogInfo.setTrackLog(trackLog);
        this.saveTrackLog(trackLogInfo);
    }

    public void error(String trackLog) {
        TrackLogInfo trackLogInfo = new TrackLogInfo();
        trackLogInfo.setType(MID);
        trackLogInfo.setLevel(ERROR);
        trackLogInfo.setTrackLog(trackLog);
        this.saveTrackLog(trackLogInfo);
    }

    public void endInfo(String trackLog) {
        TrackLogInfo trackLogInfo = new TrackLogInfo();
        trackLogInfo.setType(END);
        trackLogInfo.setLevel(INFO);
        trackLogInfo.setTrackLog(trackLog);
        this.saveTrackLog(trackLogInfo);
    }

    private void saveTrackLog(final TrackLogInfo trackLogInfo) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String level = trackLogInfo.getLevel();
                    if (!TrackLogService.this.checkEnableLogging(TrackLogService.this.appId, TrackLogService.this.classValue.getName(), level)) {
                        log.info("\u672a\u5728\u65e5\u5fd7\u7ba1\u7406\u4e2d\u6ce8\u518c\u5e94\u7528\uff1a{}\u4e2d\u7684\u670d\u52a1\uff1a{}", (Object)TrackLogService.this.appId, (Object)TrackLogService.this.classValue.getName());
                        return;
                    }
                    DynamicObject trackLogDyn = trackLogInfo.seriaTrackLogInfo();
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trackLogDyn});
                }
                catch (Exception e) {
                    log.error("msbd_tracklog seria and save failer", (Throwable)e);
                }
            }
        };
        try {
            ThreadPools.executeOnce((String)"msbd_tracklog", (Runnable)runnable);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private boolean checkEnableLogging(String appNumber, String msKey, String level) {
        QFilter filter = new QFilter("appnumber", "=", (Object)appNumber);
        filter.and("entry.mskey", "=", (Object)msKey);
        filter.and("entry.logwritelevel", "match", (Object)level);
        Map logManageData = BusinessDataServiceHelper.loadFromCache((String)"msbd_logmanage", (String)"id", (QFilter[])filter.toArray());
        boolean flag = false;
        if (logManageData != null && logManageData.size() > 0) {
            flag = true;
        }
        return flag;
    }

    public class TrackLogInfo {
        private String type;
        private Date dateTime;
        private Long user;
        private String appId;
        private String invokedCodePosition;
        private String codePosition;
        private String className;
        private String methodName;
        private String methodParams;
        private String trackLog;
        private String traceId;
        private String level;

        public TrackLogInfo() {
            if (TrackLogService.this.classValue == null) {
                return;
            }
            String classValueName = TrackLogService.this.classValue.getName();
            if (StringUtils.isBlank((CharSequence)classValueName)) {
                return;
            }
            String classNameStr = "";
            String methodNameStr = "";
            String codePositionStr = "";
            String invokedCodePositionStr = "";
            StackTraceElement[] stackTraces = null;
            try {
                stackTraces = Thread.currentThread().getStackTrace();
            }
            catch (Exception e) {
                log.error("msbd_tracklog Thread getStackTrace failer", (Throwable)e);
            }
            if (stackTraces == null || stackTraces.length == 0) {
                return;
            }
            for (int i = 0; i < stackTraces.length; ++i) {
                StackTraceElement stackTrace = stackTraces[i];
                if (stackTrace == null) continue;
                String className = stackTrace.getClassName();
                String methodName = stackTrace.getMethodName();
                if (!classValueName.equals(className)) continue;
                classNameStr = className;
                methodNameStr = methodName;
                codePositionStr = classNameStr + '.' + methodNameStr + "()[" + stackTrace.getLineNumber() + ']';
                break;
            }
            Long userID = 0L;
            String traceID = " ";
            try {
                RequestContext requestContext = RequestContext.get();
                if (requestContext != null) {
                    String userId = requestContext.getUserId();
                    if (StringUtils.isNotBlank((CharSequence)userId)) {
                        userID = Long.valueOf(userId);
                    }
                    traceID = requestContext.getTraceId();
                }
            }
            catch (Exception e) {
                log.error("RequestContext exception", (Throwable)e);
            }
            this.user = userID;
            this.traceId = traceID;
            this.dateTime = new Date();
            this.appId = TrackLogService.this.appId;
            this.invokedCodePosition = invokedCodePositionStr;
            this.codePosition = codePositionStr;
            this.className = classNameStr;
            this.methodName = methodNameStr;
        }

        public DynamicObject seriaTrackLogInfo() {
            String substring;
            DynamicObject trackLogDyn = BusinessDataServiceHelper.newDynamicObject((String)"msbd_tracklog");
            trackLogDyn.set("type", (Object)this.getType());
            trackLogDyn.set("datetime", (Object)this.getDateTime());
            trackLogDyn.set("user", (Object)this.getUser());
            trackLogDyn.set("appid", (Object)this.getAppId());
            trackLogDyn.set("traceid", (Object)this.getTraceId());
            trackLogDyn.set("invokedcodeposition", (Object)this.getInvokedCodePosition());
            trackLogDyn.set("codeposition", (Object)this.getCodePosition());
            trackLogDyn.set("classname", (Object)this.getClassName());
            trackLogDyn.set("methodname", (Object)this.getMethodName());
            trackLogDyn.set("level", (Object)this.getLevel());
            String methodParams = this.getMethodParams();
            String trackLog = this.getTrackLog();
            if (methodParams != null) {
                if (methodParams.length() < 500) {
                    if (methodParams.length() > 50) {
                        trackLogDyn.set("methodparam", (Object)(methodParams.substring(0, 50) + "..."));
                    } else {
                        trackLogDyn.set("methodparam", (Object)methodParams);
                    }
                    trackLogDyn.set("methodparam_tag", (Object)methodParams);
                } else {
                    substring = methodParams.substring(0, 500) + "...";
                    trackLogDyn.set("methodparam", (Object)(substring.substring(0, 50) + "..."));
                    trackLogDyn.set("methodparam_tag", (Object)substring);
                }
            }
            if (trackLog != null) {
                if (trackLog.length() < 500) {
                    if (trackLog.length() > 50) {
                        trackLogDyn.set("tracklog", (Object)(trackLog.substring(0, 50) + "..."));
                    } else {
                        trackLogDyn.set("tracklog", (Object)trackLog);
                    }
                    trackLogDyn.set("tracklog_tag", (Object)trackLog);
                } else {
                    substring = trackLog.substring(0, 500) + "...";
                    trackLogDyn.set("tracklog", (Object)(substring.substring(0, 50) + "..."));
                    trackLogDyn.set("tracklog_tag", (Object)substring);
                }
            }
            return trackLogDyn;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Date getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(Date dateTime) {
            this.dateTime = dateTime;
        }

        public Long getUser() {
            return this.user;
        }

        public void setUser(Long user) {
            this.user = user;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getCodePosition() {
            return this.codePosition;
        }

        public void setCodePosition(String codePosition) {
            this.codePosition = codePosition;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodParams() {
            return this.methodParams;
        }

        public void setMethodParams(String methodParams) {
            this.methodParams = methodParams;
        }

        public String getTrackLog() {
            return this.trackLog;
        }

        public void setTrackLog(String trackLog) {
            this.trackLog = trackLog;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getInvokedCodePosition() {
            return this.invokedCodePosition;
        }

        public void setInvokedCodePosition(String invokedCodePosition) {
            this.invokedCodePosition = invokedCodePosition;
        }
    }
}

