/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.common.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.baserecordset.exportandimport.BaseDataSetDao;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.GroupField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.form.FormMetadata;

public class AnalysisEntitySqlInfo {
    public static final String PRIVATE_KEY_FIELD = "PrivateKeyField";
    private static final String LINE_SEPARATOR = "line.separator";
    private String metaSymbol;
    private String unitId;
    private DBRoute dbRoute;
    private String sqlSelect;

    private AnalysisEntitySqlInfo(String metaSymbol, String unitId, String sqlSelect) {
        this.metaSymbol = metaSymbol;
        this.unitId = unitId;
        this.sqlSelect = sqlSelect;
    }

    public static AnalysisEntitySqlInfo getInstance(String metaSympol, String unitId, String sqlSelect) {
        return new AnalysisEntitySqlInfo(metaSympol, unitId, sqlSelect);
    }

    private AnalysisEntitySqlInfo() {
    }

    public Map<String, Object> analysisMetaSqlInfo() {
        Map<String, Map<String, Object>> allTableFieldMap = this.getAllTableMap();
        HashMap<String, Object> sqlMap = new HashMap<String, Object>(16);
        for (Map.Entry<String, Map<String, Object>> table : allTableFieldMap.entrySet()) {
            String tableName = table.getKey();
            Map<String, Object> tableFields = table.getValue();
            this.initTableSqlWithIds(tableName, tableFields, sqlMap);
        }
        return sqlMap;
    }

    private void initTableSqlWithIds(String tableName, Map<String, Object> tableFields, Map<String, Object> mapContext) {
        ArrayList<String> listFields = new ArrayList<String>(10);
        String sPKey = "FID";
        for (Map.Entry<String, Object> fieldNameColl : tableFields.entrySet()) {
            String fieldTypeName = (String)fieldNameColl.getValue();
            String fieldNameSymbol = fieldNameColl.getKey();
            if ("BasedataPropField".equals(fieldTypeName)) continue;
            if (fieldTypeName.equals(PRIVATE_KEY_FIELD)) {
                sPKey = fieldNameSymbol;
            }
            if (tableName.contains("_L")) {
                listFields.add(fieldNameSymbol);
                continue;
            }
            if ("".equals(fieldTypeName) && !"FID".equals(fieldNameSymbol) && !"FSEQ".equals(fieldNameSymbol) && !"FENTRYID".equals(fieldNameSymbol)) {
                if (!"FPARENTENTRYID".equals(fieldNameSymbol)) continue;
                listFields.add(fieldNameSymbol);
                continue;
            }
            if (fieldTypeName.equals("LargeTextField")) {
                listFields.add(fieldNameSymbol.concat("_TAG"));
            }
            listFields.add(fieldNameSymbol);
        }
        if (sPKey.equals("FDETAILID")) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>(16);
        idList.add(this.unitId);
        List listItems = BaseDataSetDao.getItemsByIds((DBRoute)this.dbRoute, (String)tableName, listFields, idList, (String)"FID");
        if (listItems == null || listItems.size() <= 0) {
            return;
        }
        StringBuilder sbSql = new StringBuilder();
        Object obSql = mapContext.get("sql");
        if (obSql != null) {
            sbSql.append(obSql);
        }
        HashMap<String, Field> currentFieldMap = new HashMap<String, Field>(16);
        Entity currentEntity = this.getCurrentEntity(tableName);
        if (currentEntity != null) {
            List entityItemList = currentEntity.getItems();
            for (EntityItem entityItem : entityItemList) {
                Field itemField;
                String fieldName;
                if (!(entityItem instanceof Field) || (fieldName = (itemField = (Field)entityItem).getFieldName()) == null) continue;
                currentFieldMap.put(fieldName.toUpperCase(), itemField);
            }
        }
        for (Object item : listItems) {
            Map mapItem = (Map)item;
            String sPKeyValue = (String)mapItem.get(sPKey);
            StringBuilder sqlFields = new StringBuilder();
            StringBuilder sqlFieldValues = new StringBuilder();
            for (int i = 0; i < listFields.size(); ++i) {
                String field = (String)listFields.get(i);
                String fieldClassType = (String)tableFields.get(field);
                Object obItemValue = mapItem.get(field);
                String sTempValue = obItemValue == null ? "" : obItemValue.toString();
                if (field.equals("FDISABLEDATE") || field.equals("FDISABLERID")) continue;
                sqlFields.append(String.format(" %s,", field));
                if ("DateTimeField".equals(fieldClassType) || "DateField".equals(fieldClassType) || "CreateDateField".equals(fieldClassType) || "ModifyDateField".equals(fieldClassType)) {
                    sqlFieldValues.append("{ts'2018-08-08  00:00:00'}").append(',');
                    continue;
                }
                if (field.equals("FMODIFIERID") || field.equals("FCREATORID")) {
                    sqlFieldValues.append(String.format("%s,", 1));
                    continue;
                }
                if (sTempValue.isEmpty()) {
                    sqlFieldValues.append(" ' ',");
                    continue;
                }
                if ("MasterIdField".equals(fieldClassType) || "UserField".equals(fieldClassType) || "BigIntField".equals(fieldClassType) || "IntegerField".equals(fieldClassType)) {
                    sqlFieldValues.append(String.format(" %s,", sTempValue));
                    continue;
                }
                if ("BasedataField".equals(fieldClassType)) {
                    Field baseDataField = (Field)currentFieldMap.get(field);
                    int fieldDBType = baseDataField.getFieldDBType();
                    if (fieldDBType == -5) {
                        sqlFieldValues.append(String.format(" %s,", sTempValue));
                        continue;
                    }
                    sqlFieldValues.append(String.format(" '%s',", sTempValue));
                    continue;
                }
                if ("FID".equals(field) || "FSEQ".equals(field) || "FENTRYID".equals(field) || "FPARENTENTRYID".equals(field)) {
                    sqlFieldValues.append(String.format(" %s,", sTempValue));
                    continue;
                }
                sqlFieldValues.append(String.format(" '%s',", sTempValue));
            }
            sqlFields.deleteCharAt(sqlFields.length() - 1);
            sqlFieldValues.deleteCharAt(sqlFieldValues.length() - 1);
            if ("A".equals(this.sqlSelect)) {
                if (tableName.contains("_L")) {
                    sbSql.append("DELETE ".concat(String.format("FROM %1$s WHERE %2$s = '%3$s';", tableName.toUpperCase(), sPKey, sPKeyValue)));
                } else {
                    sbSql.append("DELETE ".concat(String.format("FROM %1$s WHERE %2$s = %3$s;", tableName.toUpperCase(), sPKey, sPKeyValue)));
                }
            } else if (tableName.contains("_L")) {
                sbSql.append(String.format("IF NOT EXISTS (SELECT 1 FROM %1$s WHERE %2$s = '%3$s')", tableName.toUpperCase(), sPKey, sPKeyValue));
            } else {
                sbSql.append(String.format("IF NOT EXISTS (SELECT 1 FROM %1$s WHERE %2$s = %3$s)", tableName.toUpperCase(), sPKey, sPKeyValue));
            }
            String lineProperty = System.getProperty(LINE_SEPARATOR);
            sbSql.append(lineProperty);
            sbSql.append(String.format("INSERT INTO %s (%s) VALUES (%s);", tableName.toUpperCase(), sqlFields, sqlFieldValues));
            sbSql.append(lineProperty);
        }
        mapContext.put("sql", sbSql.toString());
    }

    private Entity getCurrentEntity(String tableName) {
        List entityList = this.getEntityMetadata().getEntitys();
        Entity currentEntity = null;
        for (Entity entity : entityList) {
            String table = entity.getTableName();
            if (table.equals(tableName)) {
                currentEntity = entity;
                break;
            }
            List splitTableList = entity.getSplitTables();
            boolean flag = false;
            for (SplitTable splitTable : splitTableList) {
                String splitTableName;
                String suffix = splitTable.getSuffix();
                if (suffix == null || !StringUtils.isNotEmpty((CharSequence)suffix) || !(splitTableName = String.format("%s_%s", table, suffix)).equals(tableName)) continue;
                currentEntity = entity;
                flag = true;
                break;
            }
            if (!flag) continue;
            break;
        }
        return currentEntity;
    }

    private void getEntityTables(EntityMetadata entityMetadata, Entity<?, ?> entity, Map<String, Map<String, Object>> mapTables) {
        List splitTables = entity.getSplitTables();
        if (StringUtils.isBlank((CharSequence)entity.getTableName())) {
            return;
        }
        String pkFieldName = "FID";
        if (entity instanceof BillEntity) {
            pkFieldName = ((BillEntity)entity).getPkFieldName();
        } else if (entity instanceof SubEntryEntity) {
            EntryEntity parentEntry = entityMetadata.getEntryById(((SubEntryEntity)entity).getParentId());
            pkFieldName = parentEntry.getEntryPkFieldName();
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
            pkFieldName = ((EntryEntity)entity).getEntryPkFieldName();
        }
        ArrayList<String> suffixList = new ArrayList<String>();
        String suffix = null;
        for (SplitTable s : splitTables) {
            suffix = s.getSuffix();
            if (suffix == null || !StringUtils.isNotEmpty((CharSequence)suffix)) continue;
            suffixList.add(suffix);
        }
        ArrayList<String> tableNameSuffix = new ArrayList<String>();
        tableNameSuffix.add("");
        tableNameSuffix.addAll(suffixList);
        for (String t_suffix : tableNameSuffix) {
            DbMetadataTable tableSchema;
            String tableName = entity.getTableName();
            if (StringUtils.isNotBlank((CharSequence)t_suffix)) {
                tableName = String.format("%s_%s", tableName, t_suffix);
            }
            if ((tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName)) == null) break;
            HashMap<String, String> mapFields = new HashMap<String, String>();
            mapTables.put(tableName, mapFields);
            DbMetadataColumnCollection cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                String sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if (sFieldName.equalsIgnoreCase(pkFieldName)) {
                    mapFields.put(sFieldName.toUpperCase(), PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName.toUpperCase(), "");
            }
            ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>(16);
            ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>(16);
            List entityItem = entity.getItems();
            for (EntityItem item : entityItem) {
                String sFieldName;
                if (!(item instanceof Field)) continue;
                if (item instanceof MuliLangTextField) {
                    mulLangFields.add((MuliLangTextField)(item instanceof MuliLangTextField ? item : null));
                    continue;
                }
                if (item instanceof MulBasedataField) {
                    mulBDFields.add((MulBasedataField)(item instanceof MulBasedataField ? item : null));
                    continue;
                }
                Field itemField = (Field)item;
                if (!itemField.getTableName(entity).equalsIgnoreCase(tableName) || !StringUtils.isNotBlank((CharSequence)(sFieldName = itemField.getFieldName()))) continue;
                String fieldName = itemField.getFieldName().toUpperCase();
                String classTypeName = item.getClass().getSimpleName();
                mapFields.put(fieldName, classTypeName);
            }
            if (!mulLangFields.isEmpty() && tableName.equalsIgnoreCase(entity.getTableName())) {
                this.toGetMulLangTable(entity, mapTables);
            }
            if (mulBDFields.isEmpty() || !tableName.equalsIgnoreCase(entity.getTableName())) continue;
            this.toGetMulBaseDateTable(entity, mulBDFields, mapTables);
        }
    }

    private Map<String, Map<String, Object>> getAllTableMap() {
        HashMap<String, Map<String, Object>> tableFieldMap = new HashMap<String, Map<String, Object>>(16);
        EntityMetadata entityMetadata = this.getEntityMetadata();
        if (entityMetadata == null) {
            return tableFieldMap;
        }
        String dbRoueKey = entityMetadata.getRootEntity().buildDataEntityType().getDBRouteKey();
        this.dbRoute = new DBRoute(dbRoueKey);
        if (!(entityMetadata.getRootEntity() instanceof BillEntity)) {
            return tableFieldMap;
        }
        List entityList = entityMetadata.getEntitys();
        for (Entity entity : entityList) {
            this.getEntityTables(entityMetadata, entity, tableFieldMap);
            if (!(entity instanceof MainEntity)) continue;
            for (EntityItem item : entity.getItems()) {
                if (!(item instanceof GroupField)) continue;
                this.getGroupTables(item, tableFieldMap);
            }
        }
        return tableFieldMap;
    }

    private EntityMetadata getEntityMetadata() {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)this.metaSymbol, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String entityId = formMeta.getEntityId();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        return entityMetadata;
    }

    private void getGroupTables(EntityItem<?> item, Map<String, Map<String, Object>> mapTables) {
        String sFieldName;
        DbMetadataColumnCollection cols;
        HashMap<String, String> mapFields;
        String tableName = ((GroupField)item).getGroupTableName();
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName);
        if (tableSchema != null) {
            mapFields = new HashMap<String, String>(16);
            mapTables.put(tableName, mapFields);
            cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if ("FID".equalsIgnoreCase(sFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, "");
            }
        }
        tableName = tableName + "_L";
        tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName);
        if (tableSchema != null) {
            mapFields = new HashMap();
            mapTables.put(tableName, mapFields);
            cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if ("FID".equalsIgnoreCase(sFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, "");
            }
        }
    }

    private void toGetMulLangTable(Entity<?, ?> entity, Map<String, Map<String, Object>> mapTables) {
        String pkFieldName = "FPKID";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        String tableName = entity.getTableName() + "_L";
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName);
        if (null != tableSchema) {
            HashMap<String, String> mapFields = new HashMap<String, String>();
            mapTables.put(tableName, mapFields);
            DbMetadataColumnCollection cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                String sFieldName = dbMetadataColumn.getName().toUpperCase();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if (sFieldName.equalsIgnoreCase(pkFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, "");
            }
        }
    }

    private void toGetMulBaseDateTable(Entity<?, ?> entity, List<MulBasedataField> mulBasedataFields, Map<String, Map<String, Object>> mapTables) {
        String pkFieldName = "FPKID";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (MulBasedataField mulBsdfield : mulBasedataFields) {
            String tableName = mulBsdfield.getTableName();
            DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName);
            if (null == tableSchema) continue;
            HashMap<String, String> mapFields = new HashMap<String, String>();
            mapTables.put(tableName, mapFields);
            DbMetadataColumnCollection cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                String sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if (sFieldName.equalsIgnoreCase(pkFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, "");
            }
        }
    }
}

