/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.common.trans;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;

public abstract class AbstractFormTranslator {
    protected final IDataModel model;
    protected final String langName;

    protected AbstractFormTranslator(IDataModel model, String langName) {
        this.model = model;
        this.langName = langName;
    }

    protected String getBillEntity(DynamicObject srcObj) {
        return srcObj.getString("number");
    }

    public void entryToEntryTranslate(String entryKey, String billEntityKey, String fieldkey, String displayKey) {
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            DynamicObject srcObj = (DynamicObject)this.model.getValue(billEntityKey, i);
            if (srcObj == null) continue;
            String billEntity = this.getBillEntity(srcObj);
            MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
            this.bindEntryColNames(i, billEntityType, fieldkey, displayKey);
        }
    }

    public void headToEntryTranslate(String entryKey, String billEntityKey, String fieldkey, String displayKey) {
        int count = this.model.getEntryRowCount(entryKey);
        DynamicObject srcObj = (DynamicObject)this.model.getValue(billEntityKey);
        if (srcObj == null) {
            return;
        }
        String billEntity = this.getBillEntity(srcObj);
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
        for (int i = 0; i < count; ++i) {
            this.bindEntryColNames(i, billEntityType, fieldkey, displayKey);
        }
    }

    public void entryTranslate(String entryKey, MainEntityType billEntityType, String fieldkey, String displayKey) {
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            this.bindEntryColNames(i, billEntityType, fieldkey, displayKey);
        }
    }

    public void headToSubEntryTranslate(String billEntity, String entryKey, String subEntryKey, String fieldkey, String displayKey) {
        if (StringUtils.isEmpty((CharSequence)billEntity)) {
            return;
        }
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            this.subEntryFieldTranslate(entryKey, subEntryKey, i, billEntity, fieldkey, displayKey);
        }
    }

    public void entryToSubEntryTranslate(String entryKey, String billEntityKey, String subEntryKey, String fieldkey, String displayKey) {
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            DynamicObject srcObj = (DynamicObject)this.model.getValue(billEntityKey, i);
            if (srcObj == null) continue;
            this.subEntryFieldTranslate(entryKey, subEntryKey, i, this.getBillEntity(srcObj), fieldkey, displayKey);
        }
    }

    public void entryFieldTranslate(String entryKey, String billEntity, String key, String displayKey) {
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            this.bindEntryColNames(i, billEntityType, key, displayKey);
        }
    }

    public void subEntryFieldTranslate(String entryKey, String subEntryKey, int entryIndex, String billEntity, String key, String displayKey) {
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
        int count = ((DynamicObject)this.model.getEntryEntity(entryKey).get(entryIndex)).getDynamicObjectCollection(subEntryKey).size();
        for (int i = 0; i < count; ++i) {
            this.bindSubColNames(i, entryIndex, billEntityType, key, displayKey);
        }
    }

    private void bindEntryColNames(int index, MainEntityType billEntityType, String key, String displayKey) {
        String sourceValue = String.valueOf(this.model.getValue(key, index));
        if (billEntityType != null && StringUtils.isNotBlank((CharSequence)sourceValue)) {
            String sourceColName = this.translate(this.langName, billEntityType, sourceValue);
            if (sourceValue.equals(sourceColName)) {
                return;
            }
            this.model.setValue(displayKey, (Object)sourceColName, index);
        }
    }

    private void bindSubColNames(int index, int entryIndex, MainEntityType billEntityType, String key, String displayKey) {
        String sourceValue = String.valueOf(this.model.getValue(key, index, entryIndex));
        if (billEntityType != null && StringUtils.isNotBlank((CharSequence)sourceValue)) {
            String sourceColName = this.translate(this.langName, billEntityType, sourceValue);
            this.model.setValue(displayKey, (Object)sourceColName, index, entryIndex);
        }
    }

    protected abstract String translate(String var1, MainEntityType var2, String var3);
}

