/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.common.utils;

import java.util.Date;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.common.enums.CacheOperateEnum;

public class CacheSyncOperator {
    private static final Log log = LogFactory.getLog(CacheSyncOperator.class);
    public static final char SEPARATOR = ',';
    private static final int WAIT_TIME = 500;
    private static final int OPERATE_TIME_OUT = 300000;
    private final String key;
    private final IPageCache pageCache;

    public String operateCache(CacheOperateEnum cacheOperateEnum, String value) {
        long startTime = System.currentTimeMillis();
        if (cacheOperateEnum == null) {
            throw new IllegalArgumentException();
        }
        String operateResult = null;
        String lockKey = this.pageCache.getPageId() + ',' + this.key;
        try (DLock dLock = DLock.create((String)lockKey).fastMode();){
            if (dLock.tryLock(500L)) {
                operateResult = this.doOperate(cacheOperateEnum, value);
            } else {
                long now;
                Date createTime;
                log.info("\u5206\u5e03\u5f0f\u9501\u7b49\u5f85\u8d85\u65f6\uff1akey=" + lockKey);
                DLockInfo lockInfo = DLock.getLockInfo((String)lockKey);
                if (lockInfo != null && (createTime = lockInfo.getCreateTime()) != null && 300000L > (now = System.currentTimeMillis()) - createTime.getTime()) {
                    DLock.forceUnlock((String[])new String[]{lockKey});
                    operateResult = this.doOperate(cacheOperateEnum, value);
                }
            }
        }
        log.info("\u5206\u5e03\u5f0f\u9501\u6027\u80fd\uff1a" + (System.currentTimeMillis() - startTime));
        return operateResult;
    }

    public String doOperate(CacheOperateEnum cacheOperateEnum, String value) {
        switch (cacheOperateEnum) {
            case GET: {
                return this.getFromCache();
            }
            case PUT: {
                this.putCache(value);
                return null;
            }
            case REMOVE: {
                this.removeCache();
                return null;
            }
            case SPUSH: {
                this.sPushCache(value);
                return null;
            }
            case SPOP: {
                return this.sPopCache();
            }
            case SPOP_ALL: {
                return this.sPopAllCache();
            }
        }
        return null;
    }

    private String sPopAllCache() {
        String allValue = this.getFromCache();
        if (StringUtils.isEmpty((CharSequence)allValue)) {
            return null;
        }
        int lastIndex = allValue.lastIndexOf(44);
        String value = lastIndex == -1 ? allValue : allValue.substring(lastIndex + 1);
        this.removeCache();
        return value;
    }

    private String sPopCache() {
        String allValue = this.getFromCache();
        if (StringUtils.isEmpty((CharSequence)allValue)) {
            return null;
        }
        int firstWordIndexEnd = allValue.indexOf(44);
        String firstValue = allValue.substring(0, firstWordIndexEnd);
        int secondWordIndexStart = firstWordIndexEnd + 1;
        if (secondWordIndexStart == allValue.length()) {
            this.removeCache();
        } else {
            this.putCache(allValue.substring(secondWordIndexStart));
        }
        return firstValue;
    }

    private void sPushCache(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        String allValue = this.getFromCache();
        if (StringUtils.isEmpty((CharSequence)allValue)) {
            this.putCache(value);
        } else {
            this.putCache(allValue + ',' + value);
        }
    }

    private String getFromCache() {
        return this.pageCache.getBigObject(this.key);
    }

    private void putCache(String value) {
        this.pageCache.putBigObject(this.key, value);
    }

    private void removeCache() {
        this.pageCache.removeBigObject(this.key);
    }

    public CacheSyncOperator(IPageCache pageCache, String key) {
        if (pageCache == null || StringUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException();
        }
        this.key = key;
        this.pageCache = pageCache;
    }
}

