/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opplugin.integration;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;

public class PmSmBaseDataIntegrationSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PmSmBaseDataIntegrationSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        if ("pm_sourcelist".equals(this.billEntityType.getName())) {
            List<String> fields = Arrays.asList("purchaseunit", "baseunit", "materialmasterid", "maxbillqty", "minbillqty", "maxbillbaseqty", "minbillbaseqty", "packingqty", "packingbaseqty");
            fields.forEach(f -> e.getFieldKeys().add(f));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills != null && bills.length > 0 && "pm_sourcelist".equals(this.billEntityType.getName())) {
            List<String> fromFields = Arrays.asList("maxbillqty", "minbillqty", "packingqty");
            List<String> toFields = Arrays.asList("maxbillbaseqty", "minbillbaseqty", "packingbaseqty");
            for (DynamicObject bill : bills) {
                DynamicObjectCollection billentry = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryInfo : billentry) {
                    if (entryInfo.getDynamicObject("materialmasterid") == null) continue;
                    Long materialID = entryInfo.getDynamicObject("materialmasterid").getLong("id");
                    DynamicObject purchaseUnit = entryInfo.getDynamicObject("purchaseunit");
                    DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
                    for (int index = 0; index < fromFields.size(); ++index) {
                        BigDecimal fromQty = entryInfo.getBigDecimal(fromFields.get(index));
                        BigDecimal toQty = BillQuantityHelper.getDesQtyConv(materialID, purchaseUnit, fromQty, baseUnit);
                        entryInfo.set(toFields.get(index), (Object)toQty);
                    }
                }
            }
        }
        super.beginOperationTransaction(e);
    }
}

