/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.assigncfg.business.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.assigncfg.business.helper.AssignCfgHelper;
import kd.mpscmm.msbd.assigncfg.common.utils.DymUtils;

public class ApplyOrgFilter {
    private static final Log log = LogFactory.getLog(ApplyOrgFilter.class);

    public static List<DynamicObject> filterByApplyOrg(String entityNumber, DynamicObject dataEntity, Collection<DynamicObject> assignCfgList) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        String mainOrgField = mainEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrgField) || null == DymUtils.getPropValue(mainEntityType, dataEntity, mainOrgField)) {
            log.info(ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"AssignCfgHelper_0", (String)"mpscmm-msbd-assigncfg", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        DynamicObject org = (DynamicObject)DymUtils.getPropValue(mainEntityType, dataEntity, mainOrgField);
        Map<Long, String> orgLotNum = ApplyOrgFilter.getOrgLotNumMap(org, assignCfgList);
        return assignCfgList.stream().filter(assignCfg -> ApplyOrgFilter.checkApplyOrg(assignCfg, (Long)org.getPkValue(), orgLotNum)).collect(Collectors.toList());
    }

    private static boolean checkApplyOrg(DynamicObject assignCfg, Long orgId, Map<Long, String> orgLotNum) {
        DynamicObject orgentry;
        Long entryOrgId;
        boolean isMatch = false;
        DynamicObjectCollection orgentrys = assignCfg.getDynamicObjectCollection("orgentry");
        if (orgentrys.isEmpty()) {
            return true;
        }
        Iterator iterator = orgentrys.iterator();
        while (iterator.hasNext() && !(isMatch = orgId.equals(entryOrgId = Long.valueOf((orgentry = (DynamicObject)iterator.next()).getLong("orgid.id"))))) {
            boolean isInclude = orgentry.getBoolean("isincludesuborg");
            if (isInclude) {
                String subOrgLongNum = orgLotNum.get(orgId);
                String supOrgLongNum = orgLotNum.get(entryOrgId);
                if (!StringUtils.isEmpty((CharSequence)subOrgLongNum) && !StringUtils.isEmpty((CharSequence)supOrgLongNum)) {
                    isMatch = subOrgLongNum.startsWith(supOrgLongNum + '!');
                }
            }
            if (!isMatch) continue;
            break;
        }
        return isMatch;
    }

    private static Map<Long, String> getOrgLotNumMap(DynamicObject org, Collection<DynamicObject> assignCfgList) {
        HashMap<Long, String> orgLongNumMap = new HashMap<Long, String>(16);
        if (org == null) {
            return orgLongNumMap;
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (DynamicObject assignCfg : assignCfgList) {
            DynamicObjectCollection orgList = assignCfg.getDynamicObjectCollection("orgentry");
            if (orgList.isEmpty()) continue;
            for (DynamicObject orgRow : orgList) {
                boolean isInclude = orgRow.getBoolean("isincludesuborg");
                if (!isInclude) continue;
                DynamicObject orgDym = orgRow.getDynamicObject("orgid");
                orgIds.add((Long)orgDym.getPkValue());
            }
        }
        if (orgIds.isEmpty()) {
            return orgLongNumMap;
        }
        orgIds.add((Long)org.getPkValue());
        QFilter qFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        qFilter = qFilter.and("org", "in", orgIds);
        qFilter = qFilter.and("view.number", "=", (Object)"15");
        qFilter = qFilter.and("view.isdefault", "=", (Object)"1");
        try (DataSet orgData = QueryServiceHelper.queryDataSet((String)AssignCfgHelper.class.getName(), (String)"bos_org_structure", (String)"org,longnumber", (QFilter[])qFilter.toArray(), null);){
            while (orgData.hasNext()) {
                Row row = orgData.next();
                orgLongNumMap.put(row.getLong("org"), row.getString("longnumber"));
            }
        }
        return orgLongNumMap;
    }
}

