/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.assigncfg.business.match;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.assigncfg.common.utils.DymUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class QFilterMatcher {
    public static DynamicObjectCollection match(String entityNumber, QFilter qFilter, String srcEntryName) {
        QFilter srcFilter = QFilter.of((String)qFilter.toString(), (Object[])new Object[0]);
        Set<Object> entryIdSet = new HashSet(16);
        if (StringUtils.isNotBlank((CharSequence)srcEntryName)) {
            DynamicObjectCollection entryIdCollection = QueryServiceHelper.query((String)entityNumber, (String)(srcEntryName + ".id as entryid"), (QFilter[])srcFilter.toArray());
            entryIdSet = entryIdCollection.stream().map(item -> item.getLong("entryid")).collect(Collectors.toSet());
        }
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])QFilter.of((String)qFilter.toString(), (Object[])new Object[0]).toArray());
        List keyList = dynamicObjectMap.keySet().stream().sorted().collect(Collectors.toList());
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (Object key : keyList) {
            DynamicObject value = (DynamicObject)dynamicObjectMap.get(key);
            if (StringUtils.isNotBlank((CharSequence)srcEntryName)) {
                for (DynamicObject entry : value.getDynamicObjectCollection(srcEntryName)) {
                    if (!entryIdSet.contains(entry.getPkValue())) continue;
                    collection.add((Object)entry);
                }
                continue;
            }
            collection.add((Object)value);
        }
        return collection;
    }

    public static QFilter generateQFilter(DynamicObject entryEntity, DynamicObject assignCfg) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection matchEntry = assignCfg.getDynamicObjectCollection("matchentry");
        if (ObjectUtils.isEmpty((Object)matchEntry)) {
            return qFilter;
        }
        QFilter subFilter = QFilterMatcher.buildQFilter(entryEntity, matchEntry);
        return qFilter.and(subFilter);
    }

    private static QFilter buildQFilter(DynamicObject entryEntity, DynamicObjectCollection matchEntry) {
        StringBuilder exp = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>(matchEntry.size());
        String logic = "";
        for (DynamicObject row : matchEntry) {
            exp.append(' ').append(logic).append(' ');
            String leftBracket = row.getString("leftbracket");
            if (StringUtils.isNotBlank((CharSequence)leftBracket)) {
                exp.append(leftBracket);
            }
            String srcMatchField = row.getString("srcmatchfieldkey");
            String tgtMatchField = row.getString("tgtmatchfieldkey");
            String matchType = row.getString("matchtype");
            if ("B".equals(matchType)) {
                DynamicObject groupEntity;
                Long bdId = (Long)DymUtils.getMasterId(entryEntity, tgtMatchField);
                Map<Long, List<Long>> groupMap = QFilterMatcher.groupMatch(bdId, groupEntity = row.getDynamicObject("matchgroup"));
                List<Long> groupValues = groupMap.get(bdId);
                if (ObjectUtils.isNotEmpty(groupValues)) {
                    exp.append(srcMatchField).append(" in (?) ");
                    params.add(groupValues.toArray());
                } else {
                    exp.append(" 1 = 2 ");
                }
            } else {
                exp.append(srcMatchField).append(" = ? ");
                params.add(DymUtils.getPropSimpleValue(entryEntity, tgtMatchField));
            }
            String rightBracket = row.getString("rightbracket");
            if (StringUtils.isNotBlank((CharSequence)rightBracket)) {
                exp.append(rightBracket);
            }
            logic = row.getString("logic");
        }
        return QFilter.of((String)exp.toString(), (Object[])params.toArray());
    }

    private static Map<Long, List<Long>> groupMatch(Long bdId, DynamicObject groupEntity) {
        if (null == groupEntity) {
            return Collections.emptyMap();
        }
        String groupType = (String)groupEntity.getDynamicObject("groupobj").getPkValue();
        String dataType = (String)groupEntity.getDynamicObject("dataobj").getPkValue();
        return (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"DataGroupService", (String)"getGroupIds", (Object[])new Object[]{dataType, Collections.singleton(bdId), groupType});
    }
}

