/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.ReserveServiceCfgFilterHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.helper.ReserveOpLogHelper;
import kd.mpscmm.msbd.reserve.business.record.BalanceHelper;
import kd.mpscmm.msbd.reserve.business.record.RecordReleaseModle;
import kd.mpscmm.msbd.reserve.business.record.ReleaseRecordHelper;
import kd.mpscmm.msbd.reserve.business.record.ReserveRecordHelper;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;

public class ReleaseHelper {
    private static final Log logger = LogFactory.getLog(ReleaseHelper.class);

    private ReleaseHelper() {
    }

    public static void removeReserveByReserveRecord(List<DynamicObject> reserveRecordList) {
        if (reserveRecordList == null || reserveRecordList.isEmpty()) {
            return;
        }
        ReleaseHelper.checkOverRemove(reserveRecordList);
        ReserveRecordHelper.removeReserveRecord(reserveRecordList);
        ArrayList<DynamicObject> balReserveRecords = new ArrayList<DynamicObject>();
        for (DynamicObject record : reserveRecordList) {
            if (record.getBoolean("ispredict")) continue;
            balReserveRecords.add(record);
        }
        ArrayList<String> idList = new ArrayList<String>(reserveRecordList.size());
        String billName = reserveRecordList.get(0).getDataEntityType().getName();
        if (!balReserveRecords.isEmpty()) {
            for (DynamicObject reserveRecord : balReserveRecords) {
                idList.add(reserveRecord.getString("id"));
            }
            Set<String> hasOpIds = ReserveService.getRemoveOpRecordDataId(billName, idList);
            balReserveRecords.removeIf(p -> hasOpIds.contains(p.getString("id")));
        }
        ReserveOpLogHelper.createNewLogByRecord(reserveRecordList, true);
        BalanceHelper.removeReservedBalance(balReserveRecords);
        ReleaseRecordHelper.createByReserveRecord(reserveRecordList, false);
        ReserveService.deleteRemoveOpRecordByReserveRecord(reserveRecordList);
    }

    public static void rmReserveByRecordNotSup(List<DynamicObject> reserveRecordList) {
        if (reserveRecordList == null || reserveRecordList.isEmpty()) {
            return;
        }
        ReleaseHelper.checkOverRemove(reserveRecordList);
        ReserveRecordHelper.removeReserveRecord(reserveRecordList);
        ArrayList<DynamicObject> balReserveRecords = new ArrayList<DynamicObject>();
        for (DynamicObject record : reserveRecordList) {
            if (record.getBoolean("ispredict")) continue;
            balReserveRecords.add(record);
        }
        ArrayList<String> idList = new ArrayList<String>(reserveRecordList.size());
        String billName = reserveRecordList.get(0).getDataEntityType().getName();
        if (!balReserveRecords.isEmpty()) {
            for (DynamicObject reserveRecord : balReserveRecords) {
                idList.add(reserveRecord.getString("id"));
            }
            Set<String> hasOpIds = ReserveService.getRemoveOpRecordDataId(billName, idList);
            balReserveRecords.removeIf(p -> hasOpIds.contains(p.getString("id")));
        }
        ReserveOpLogHelper.createNewLogByRecord(reserveRecordList, true);
        BalanceHelper.removeReservedBalanceNotSup(balReserveRecords);
        ReleaseRecordHelper.createByReserveRecord(reserveRecordList, false);
        ReserveService.deleteRemoveOpRecordByReserveRecord(reserveRecordList);
    }

    private static void checkOverRemove(List<DynamicObject> reserveRecordList) {
        Object[] ids = new Object[reserveRecordList.size()];
        for (int i = 0; i < reserveRecordList.size(); ++i) {
            ids[i] = reserveRecordList.get(i).getPkValue();
        }
        QFilter filter = new QFilter("id", "in", (Object)ids);
        String selectProperties = "base_qty, qty, qty2nd";
        Map values = BusinessDataServiceHelper.loadFromCache((String)"msmod_reserve_record", (String)selectProperties, (QFilter[])filter.toArray());
        reserveRecordList.forEach(recordForRemove -> {
            DynamicObject recordInDB = (DynamicObject)values.get(recordForRemove.getPkValue());
            if (recordInDB != null && ReleaseHelper.isOverRemove(recordInDB, recordForRemove)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u8d85\u989d\u5ea6\u89e3\u9664\u9884\u7559\uff0c\u5426\u5219\u4f1a\u4ea7\u751f\u8d1f\u6570\u3002", (String)"ReleaseHelper_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            }
        });
    }

    private static boolean isOverRemove(DynamicObject recordInDB, DynamicObject recordForRemove) {
        int baseQty = recordInDB.getBigDecimal("base_qty").compareTo(recordForRemove.getBigDecimal("base_qty"));
        if (baseQty < 0) {
            return true;
        }
        int qty = recordInDB.getBigDecimal("qty").compareTo(recordForRemove.getBigDecimal("qty"));
        if (qty < 0) {
            return true;
        }
        int qty2end = recordInDB.getBigDecimal("qty2nd").compareTo(recordForRemove.getBigDecimal("qty2nd"));
        return qty2end < 0;
    }

    public static OperationResult reserveReleaseByBill(String billName, String ids, String releaseType, String releaseReserved, String opName, boolean canRepeatable, String entryIds) {
        ArrayList<DynamicObject> matchReleaseRecord;
        Throwable throwable;
        TXHandle tx;
        OperationResult result;
        block43: {
            OperationResult operationResult;
            block44: {
                block45: {
                    List<DynamicObject> realReleaseBillList;
                    List<Object> entryIdList;
                    block40: {
                        OperationResult operationResult2;
                        block41: {
                            block42: {
                                block37: {
                                    OperationResult operationResult3;
                                    block38: {
                                        block39: {
                                            Long[] idArr;
                                            block34: {
                                                OperationResult operationResult4;
                                                block35: {
                                                    block36: {
                                                        result = new OperationResult();
                                                        if (ids.length() < 1) {
                                                            result.setSuccess(false);
                                                            result.setMessage(ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u64cd\u4f5c\u5931\u8d25\uff1a\u6ca1\u6709\u9009\u62e9\u5355\u636e\u3002", (String)"ReserveService_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                                                            return result;
                                                        }
                                                        tx = TX.requiresNew((String)"MpsReserveService-release");
                                                        throwable = null;
                                                        idArr = (Long[])JSON.parseObject((String)ids, Long[].class);
                                                        Long[] entryArr = null;
                                                        entryIdList = null;
                                                        if (entryIds != null) {
                                                            entryArr = (Long[])JSON.parseObject((String)entryIds, Long[].class);
                                                            entryIdList = Arrays.asList(entryArr);
                                                        }
                                                        QFilter releaseFilter = new QFilter("billid", "in", (Object)idArr);
                                                        releaseFilter = releaseFilter.and("deletestatus", "!=", (Object)"1");
                                                        if (canRepeatable) {
                                                            if (entryIdList != null) {
                                                                releaseFilter = releaseFilter.and("entryid", "in", entryIdList);
                                                            }
                                                            DeleteServiceHelper.delete((String)"msmod_release_record", (QFilter[])releaseFilter.toArray());
                                                            break block34;
                                                        }
                                                        if (!QueryServiceHelper.exists((String)"msmod_release_record", (QFilter[])releaseFilter.toArray())) break block34;
                                                        operationResult4 = result;
                                                        if (tx == null) break block35;
                                                        if (throwable == null) break block36;
                                                        try {
                                                            tx.close();
                                                        }
                                                        catch (Throwable throwable2) {
                                                            throwable.addSuppressed(throwable2);
                                                        }
                                                        break block35;
                                                    }
                                                    tx.close();
                                                }
                                                return operationResult4;
                                            }
                                            realReleaseBillList = ReleaseHelper.getValidateReleaseBillList(billName, releaseReserved, opName, idArr, canRepeatable);
                                            if (realReleaseBillList.size() != 0) break block37;
                                            operationResult3 = result;
                                            if (tx == null) break block38;
                                            if (throwable == null) break block39;
                                            try {
                                                tx.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            break block38;
                                        }
                                        tx.close();
                                    }
                                    return operationResult3;
                                }
                                if (ReleaseHelper.checkReleaseCfg(billName, result)) break block40;
                                operationResult2 = result;
                                if (tx == null) break block41;
                                if (throwable == null) break block42;
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                break block41;
                            }
                            tx.close();
                        }
                        return operationResult2;
                    }
                    matchReleaseRecord = new ArrayList(8);
                    logger.info("reserveReleaseByBill===\u5f00\u59cb\u67e5\u8be2\u9884\u7559\u91ca\u653e\u89c4\u5219");
                    QFilter fs = new QFilter("release_bill", "=", (Object)billName);
                    fs.and("enable", "=", (Object)"1");
                    Map releaseRuleMap = BusinessDataServiceHelper.loadFromCache((String)"msmod_release_rule", (QFilter[])fs.toArray());
                    if (releaseRuleMap == null || releaseRuleMap.size() == 0) {
                        ArrayList<Object> realIdList = new ArrayList<Object>(realReleaseBillList.size());
                        for (DynamicObject dynamicObject : realReleaseBillList) {
                            realIdList.add(dynamicObject.getPkValue());
                        }
                        matchReleaseRecord = ReleaseHelper.matchReleaseRecord(billName, releaseType, entryIdList, null, realIdList);
                    } else {
                        Map<Object, List<Object>> ruleBillListMap = ReleaseHelper.getValidateReleaseIdListMap(realReleaseBillList, releaseRuleMap);
                        for (Map.Entry entry : ruleBillListMap.entrySet()) {
                            Object ruleId = entry.getKey();
                            matchReleaseRecord.addAll(ReleaseHelper.matchReleaseRecord(billName, releaseType, entryIdList, (DynamicObject)releaseRuleMap.get(ruleId), (List)entry.getValue()));
                        }
                    }
                    if (matchReleaseRecord.size() != 0) break block43;
                    logger.info("reserveReleaseByBill===\u6ca1\u6709\u5339\u914d\u5230\u53ef\u91ca\u653e\u7684\u9884\u7559\u8bb0\u5f55");
                    operationResult = result;
                    if (tx == null) break block44;
                    if (throwable == null) break block45;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block44;
                }
                tx.close();
            }
            return operationResult;
        }
        try {
            try {
                ThreadCache.put((Object)"ReserveOpType", (Object)"release");
                ReserveRecordHandler.reserveReleaseQty(matchReleaseRecord);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                result.setMessage(ReleaseHelper.getMsgReleaseServiceFailOp() + e.getMessage() + ReleaseHelper.getMsgGetCheckRuleConfig());
                logger.error((Throwable)e);
            }
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        catch (Throwable throwable7) {
            throw throwable7;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }

    private static List<DynamicObject> matchReleaseRecord(String billName, String releaseType, List<Object> entryIdList, DynamicObject releaseRule, List<Object> realIdList) {
        List<Object> matchReleaseRecord = new ArrayList(8);
        DataSet releaseRuleDataSet = null;
        if (releaseRule != null) {
            Object pkValue = releaseRule.getPkValue();
            QFilter qFilter = new QFilter("id", "=", pkValue);
            releaseRuleDataSet = QueryServiceHelper.queryDataSet((String)ReserveService.class.getName(), (String)"msmod_release_rule", (String)"entryentity.releasetype as releasetype,entryentity.priority as priority", (QFilter[])qFilter.toArray(), null);
        }
        RecordReleaseModle releaseModel = RecordReleaseModle.getInstance(billName, realIdList, releaseRule, entryIdList);
        matchReleaseRecord = "trans".equals(releaseType) ? releaseModel.matchTransReleaseRecord(releaseRuleDataSet) : releaseModel.matchReleaseRecord(releaseRuleDataSet);
        return matchReleaseRecord;
    }

    private static List<DynamicObject> getValidateReleaseBillList(String billName, String releaseReserved, String opName, Long[] idArr, boolean canRepeatable) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billName);
        StringBuilder selFieldSb = new StringBuilder();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty po : properties) {
            if (po instanceof EntryProp) continue;
            if (selFieldSb.length() > 0) {
                selFieldSb.append(",");
            }
            selFieldSb.append(po.getName());
        }
        QFilter qFilter = new QFilter("id", "in", (Object)idArr);
        DynamicObject[] releaseBillArray = BusinessDataServiceHelper.load((String)billName, (String)selFieldSb.toString(), (QFilter[])qFilter.toArray());
        DynamicObject[] validateReleaseBillArray = null;
        validateReleaseBillArray = canRepeatable || opName == null ? releaseBillArray : ReserveServiceCfgFilterHelper.canReserveBillIdDynamic(releaseReserved, billName, releaseBillArray, opName);
        if (validateReleaseBillArray != null && validateReleaseBillArray.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> realReleaseBillList = new ArrayList<DynamicObject>(8);
        DynamicObject[] validateTransBillArray = ReserveServiceCfgFilterHelper.canReserveBillIdDynamic("ReserveReplace", billName, validateReleaseBillArray, opName);
        if (validateReleaseBillArray == null) {
            return new ArrayList<DynamicObject>(0);
        }
        if (validateTransBillArray.length > 0) {
            for (DynamicObject release : validateReleaseBillArray) {
                boolean isFind = false;
                for (DynamicObject trans : validateTransBillArray) {
                    if (release.getLong("id") != trans.getLong("id")) continue;
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                realReleaseBillList.add(release);
            }
        } else {
            for (DynamicObject release : validateReleaseBillArray) {
                realReleaseBillList.add(release);
            }
        }
        return realReleaseBillList;
    }

    public static List<Object> getValidateReleaseIdList(List<DynamicObject> reserveBill, DynamicObject releaseRule) {
        ArrayList<Object> realIdList = new ArrayList<Object>(reserveBill.size());
        if (releaseRule == null) {
            for (DynamicObject releaseBill : reserveBill) {
                realIdList.add(releaseBill.getPkValue());
            }
        } else {
            StringBuilder errSb = new StringBuilder();
            String schemeFilterStr = releaseRule.getString("filter_value_tag");
            for (DynamicObject releaseBill : reserveBill) {
                try {
                    if (!FilterParser.execExcelFormula(schemeFilterStr, releaseBill)) continue;
                    realIdList.add(releaseBill.getPkValue());
                }
                catch (Exception e) {
                    realIdList.add(releaseBill.getPkValue());
                    errSb.append(e.getMessage()).append(",");
                }
            }
            if (errSb.length() > 0) {
                logger.info(errSb.toString());
            }
        }
        return realIdList;
    }

    public static Map<Object, List<Object>> getValidateReleaseIdListMap(List<DynamicObject> reserveBill, Map<Object, DynamicObject> releaseRuleMap) {
        HashMap<Object, List<Object>> ruleBillListMap = new HashMap<Object, List<Object>>(8);
        StringBuilder errSb = new StringBuilder();
        block2: for (DynamicObject releaseBill : reserveBill) {
            for (Map.Entry<Object, DynamicObject> entry : releaseRuleMap.entrySet()) {
                Object ruleId = entry.getKey();
                String schemeFilterStr = entry.getValue().getString("filter_value_tag");
                boolean isMatch = true;
                try {
                    isMatch = FilterParser.execExcelFormula(schemeFilterStr, releaseBill);
                }
                catch (Exception e) {
                    errSb.append(e.getMessage()).append(",");
                }
                if (!isMatch) continue;
                ArrayList<Object> realIdList = (ArrayList<Object>)ruleBillListMap.get(ruleId);
                if (realIdList == null) {
                    realIdList = new ArrayList<Object>(8);
                    ruleBillListMap.put(ruleId, realIdList);
                }
                realIdList.add(releaseBill.getPkValue());
                continue block2;
            }
        }
        if (errSb.length() > 0) {
            logger.info(errSb.toString());
        }
        return ruleBillListMap;
    }

    private static boolean checkReleaseCfg(String billName, OperationResult result) {
        ColsMap releaseBillColMap = ColsMapHelper.findReleaseBillColMap(billName);
        Map<String, String> balColMap = releaseBillColMap.getBalColMap();
        List<String> mustSetFieldList = Collections.singletonList("entryentity.baseqty");
        StringBuilder sb = new StringBuilder();
        for (String field : mustSetFieldList) {
            if (balColMap.get(field) != null) continue;
            sb.append(field).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            result.setSuccess(false);
            result.setMessage(String.format(ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u6620\u5c04\u914d\u7f6e\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u5b57\u6bb5\uff1a%1$s", (String)"ReserveService_7", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), sb));
            return false;
        }
        return true;
    }

    private static String getMsgReleaseServiceFailOp() {
        return ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u64cd\u4f5c\u5931\u8d25\u3002", (String)"MpsReserveService_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
    }

    private static String getMsgGetCheckRuleConfig() {
        return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u91ca\u653e\u6a21\u578b\uff09\u6216\u9884\u7559\u91ca\u653e\u89c4\u5219\u3002", (String)"MpsReserveService_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
    }
}

