/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveCommonHelper;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.SchemeHelper;
import kd.mpscmm.msbd.reserve.business.StrategyHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.record.RequestBillEntryParam;
import kd.mpscmm.msbd.reserve.business.strategy.StrategyEngine;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;
import kd.mpscmm.msbd.reserve.business.strategy.engine.scene.ReserveForSuit;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;
import kd.mpscmm.msbd.reserve.business.strategy.result.handler.billresult.BillResultHandlerFactory;
import kd.mpscmm.msbd.reserve.common.colsAssist.SelectParams;
import kd.mpscmm.msbd.reserve.common.constant.ReserveSpuDiff;
import kd.mpscmm.msbd.reserve.common.constant.StdRequestBillConst;
import kd.mpscmm.msbd.reserve.common.util.FormUtil;
import kd.mpscmm.msbd.reserve.common.util.ResUtil;

public class ReserveHelper {
    private static final Log logger = LogFactory.getLog(ReserveHelper.class);

    public static BillReserveResult reserveBill(DynamicObject requestBill) {
        ReserveContext context = new ReserveContext(requestBill, ReserveAggregateHelper.getAggregateConfig());
        BillReserveResult result = ReserveHelper.reserve(context);
        ReserveHelper.validateBillResult(result);
        ReserveHelper.handleBillResult(result, context);
        return result;
    }

    public static BillReserveResult reserveOneBill(DynamicObject requestBill) {
        return ReserveHelper.reserveSingleBillForBatch(requestBill, true, null, null);
    }

    public static BillReserveResult reserveBill(DynamicObject requestBill, QFilter filter, ReserveContext parentContext) {
        ReserveContext context;
        context.setSchemeFilter((context = new ReserveContext(requestBill, parentContext)).getSchemeFilter() == null ? filter : context.getSchemeFilter().and(filter));
        BillReserveResult result = ReserveHelper.reserve(context);
        ReserveHelper.validateBillResult(result);
        parentContext.getExtensionContext().putAll(context.getExtensionContext());
        return result;
    }

    private static BillReserveResult reserveSingleBillForBatch(DynamicObject requestBill, boolean needSaveResult, DynamicObject usableScheme, Map<String, Object> aggregateCfg) {
        ReserveCommonHelper.dealHighHotInfo(requestBill.getDynamicObjectType().getName());
        BillReserveResult result = new BillReserveResult();
        boolean isTryFlag = true;
        int tryCount = 0;
        while (isTryFlag) {
            ReserveContext context;
            if (usableScheme == null) {
                aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
                if (((Boolean)aggregateCfg.get("isAggregate")).booleanValue() && !((Boolean)aggregateCfg.get("isAggregateInit")).booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u603b\u91cf\u9884\u7559\u8bbe\u7f6e\u542f\u7528\u540e\u672a\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u8bf7\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"ReserveHelper_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                }
                context = new ReserveContext(requestBill, aggregateCfg);
            } else {
                context = new ReserveContext(requestBill, usableScheme, aggregateCfg);
            }
            ThreadCache.put((Object)"ReserveOpType", (Object)"delete");
            HashSet<Object> idSet = new HashSet<Object>(1);
            idSet.add(requestBill.getLong("id"));
            if (ThreadCache.get((Object)"reserveHighHotTransId") == null) {
                ReserveRecordHandler.batchReserveRemoveByBillId(idSet);
            } else {
                long transId = (Long)ThreadCache.get((Object)"reserveHighHotTransId");
                ThreadCache.remove((Object)"reserveHighHotTransId");
                ReserveRecordHandler.batchReserveRemoveByBillId(idSet);
                ThreadCache.put((Object)"reserveHighHotTransId", (Object)transId);
            }
            ThreadCache.put((Object)"ReserveOpType", (Object)"autoreserve");
            result = ReserveHelper.batchEntryReserve(context);
            ReserveHelper.validateBillResult(result);
            if (needSaveResult) {
                try {
                    ReserveHelper.handleBillResult(result, context);
                    isTryFlag = false;
                    continue;
                }
                catch (Exception e) {
                    if (++tryCount <= 4) continue;
                    isTryFlag = false;
                    throw e;
                }
            }
            isTryFlag = false;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static BillReserveResult reserve(ReserveContext context) {
        var3_2 = billResultHandler = context.getSchemeResultHandlerType();
        var4_3 = -1;
        switch (var3_2.hashCode()) {
            case 52: {
                if (!var3_2.equals("4")) break;
                var4_3 = 0;
                break;
            }
            case 54: {
                if (!var3_2.equals("6")) break;
                var4_3 = 1;
            }
        }
        switch (var4_3) {
            case 0: 
            case 1: {
                reserveForSuitSpan = Tracer.create((String)"ReserveHelper", (String)"reserveForSuit");
                var6_6 = null;
                result = ReserveForSuit.reserve(context);
                if (reserveForSuitSpan == null) break;
                if (var6_6 == null) ** GOTO lbl25
                try {
                    reserveForSuitSpan.close();
                }
                catch (Throwable var7_9) {
                    var6_6.addSuppressed(var7_9);
                }
                break;
lbl25:
                // 1 sources

                reserveForSuitSpan.close();
                break;
                catch (Throwable var7_10) {
                    try {
                        var6_6 = var7_10;
                        throw var7_10;
                    }
                    catch (Throwable var8_13) {
                        if (reserveForSuitSpan != null) {
                            if (var6_6 != null) {
                                try {
                                    reserveForSuitSpan.close();
                                }
                                catch (Throwable var9_14) {
                                    var6_6.addSuppressed(var9_14);
                                }
                            } else {
                                reserveForSuitSpan.close();
                            }
                        }
                        throw var8_13;
                    }
                }
            }
            default: {
                reserveForEntryListSpan = Tracer.create((String)"ReserveHelper", (String)"reserveForEntryList");
                var6_7 = null;
                result = ReserveHelper.reserveForEntryList(context);
                if (reserveForEntryListSpan == null) break;
                if (var6_7 == null) ** GOTO lbl55
                try {
                    reserveForEntryListSpan.close();
                }
                catch (Throwable var7_11) {
                    var6_7.addSuppressed(var7_11);
                }
                break;
lbl55:
                // 1 sources

                reserveForEntryListSpan.close();
                break;
                catch (Throwable var7_12) {
                    try {
                        var6_7 = var7_12;
                        throw var7_12;
                    }
                    catch (Throwable var10_15) {
                        if (reserveForEntryListSpan != null) {
                            if (var6_7 != null) {
                                try {
                                    reserveForEntryListSpan.close();
                                }
                                catch (Throwable var11_16) {
                                    var6_7.addSuppressed(var11_16);
                                }
                            } else {
                                reserveForEntryListSpan.close();
                            }
                        }
                        throw var10_15;
                    }
                }
            }
        }
        result.setSupDiff(context.getScheme().getString("supdiff"));
        result.setBillResultHandler(billResultHandler);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static BillReserveResult batchEntryReserve(ReserveContext context) {
        var3_2 = billResultHandler = context.getSchemeResultHandlerType();
        var4_3 = -1;
        switch (var3_2.hashCode()) {
            case 52: {
                if (!var3_2.equals("4")) break;
                var4_3 = 0;
                break;
            }
            case 54: {
                if (!var3_2.equals("6")) break;
                var4_3 = 1;
            }
        }
        switch (var4_3) {
            case 0: 
            case 1: {
                reserveForSuitSpan = Tracer.create((String)"ReserveHelper", (String)"reserveForSuit");
                var6_6 = null;
                result = ReserveForSuit.reserve(context);
                if (reserveForSuitSpan == null) break;
                if (var6_6 == null) ** GOTO lbl25
                try {
                    reserveForSuitSpan.close();
                }
                catch (Throwable var7_9) {
                    var6_6.addSuppressed(var7_9);
                }
                break;
lbl25:
                // 1 sources

                reserveForSuitSpan.close();
                break;
                catch (Throwable var7_10) {
                    try {
                        var6_6 = var7_10;
                        throw var7_10;
                    }
                    catch (Throwable var8_13) {
                        if (reserveForSuitSpan != null) {
                            if (var6_6 != null) {
                                try {
                                    reserveForSuitSpan.close();
                                }
                                catch (Throwable var9_14) {
                                    var6_6.addSuppressed(var9_14);
                                }
                            } else {
                                reserveForSuitSpan.close();
                            }
                        }
                        throw var8_13;
                    }
                }
            }
            default: {
                reserveForEntryListSpan = Tracer.create((String)"ReserveHelper", (String)"reserveForStrategy");
                var6_7 = null;
                result = ReserveHelper.reserveForStrategy(context);
                if (reserveForEntryListSpan == null) break;
                if (var6_7 == null) ** GOTO lbl55
                try {
                    reserveForEntryListSpan.close();
                }
                catch (Throwable var7_11) {
                    var6_7.addSuppressed(var7_11);
                }
                break;
lbl55:
                // 1 sources

                reserveForEntryListSpan.close();
                break;
                catch (Throwable var7_12) {
                    try {
                        var6_7 = var7_12;
                        throw var7_12;
                    }
                    catch (Throwable var10_15) {
                        if (reserveForEntryListSpan != null) {
                            if (var6_7 != null) {
                                try {
                                    reserveForEntryListSpan.close();
                                }
                                catch (Throwable var11_16) {
                                    var6_7.addSuppressed(var11_16);
                                }
                            } else {
                                reserveForEntryListSpan.close();
                            }
                        }
                        throw var10_15;
                    }
                }
            }
        }
        result.setSupDiff(context.getScheme().getString("supdiff"));
        result.setBillResultHandler(billResultHandler);
        return result;
    }

    private static BillReserveResult reserveForEntryList(ReserveContext context) {
        BillReserveResult result = context.getCurBillResult();
        DynamicObjectCollection requestEntryList = context.getRequestEntryList();
        result.setBillId(context.getRequestBillId());
        List<EntryReserveResult> entryReserveResultList = result.getEntryResultList();
        for (int i = 0; i < requestEntryList.size(); ++i) {
            DynamicObject requestEntry = (DynamicObject)requestEntryList.get(i);
            try (TraceSpan entrySpan = Tracer.create((String)"ReserveHelper", (String)"reserveEntry");){
                EntryReserveResult entryResult = ReserveHelper.reserveEntry(context, requestEntry);
                entryReserveResultList.add(entryResult);
                continue;
            }
        }
        return result;
    }

    private static BillReserveResult reserveForStrategy(ReserveContext context) {
        BillReserveResult result = context.getCurBillResult();
        result.setBillId(context.getRequestBillId());
        DynamicObjectCollection strategyList = context.getScheme().getDynamicObjectCollection("strategy_entry");
        List<EntryReserveResult> entryReserveResultList = result.getEntryResultList();
        DynamicObjectCollection orderStrategyCollection = SchemeHelper.sortCollectionByField(strategyList, "strategy_seq");
        Map<Object, List<RequestBillEntryParam>> strategyToEntrysMap = ReserveHelper.getStrategyToEntriesMap(context.getRequestBillEntryParams(), orderStrategyCollection);
        HashMap<Long, EntryReserveResult> entryResultMap = new HashMap<Long, EntryReserveResult>();
        for (DynamicObject orderStrategy : orderStrategyCollection) {
            DynamicObject strategy = orderStrategy.getDynamicObject("strategy");
            List<RequestBillEntryParam> entryParams = strategyToEntrysMap.get(strategy.getPkValue());
            if (entryParams.isEmpty()) continue;
            ReserveHelper.checkAggregateConfig(context, strategy);
            ReserveHelper.reserveStrategyEntrys(context, entryParams, strategy);
            for (RequestBillEntryParam entryParam : entryParams) {
                entryResultMap.put(entryParam.getPkvalue(), entryParam.getResult());
            }
        }
        entryReserveResultList.clear();
        entryReserveResultList.addAll(entryResultMap.values());
        return result;
    }

    public static void checkAggregateConfig(ReserveContext context, DynamicObject strategy) {
        ArrayList<String> compareList = new ArrayList<String>(Arrays.asList("=", "A", "F"));
        if (context.isAggregate() && !context.getScheme().getBoolean("aggregate")) {
            boolean allFind = true;
            StringBuilder errSb = new StringBuilder();
            errSb.append(strategy.getString("number")).append('.');
            DynamicObjectCollection ruleList = strategy.getDynamicObjectCollection("rule_entry");
            Map<Object, DynamicObject> ruleMap = StrategyEngine.getRuleMap(ruleList);
            for (DynamicObject rule : ruleMap.values()) {
                if (!rule.getBoolean("ispredict")) {
                    DynamicObjectCollection ruleEntryList = rule.getDynamicObjectCollection("rule_entry");
                    errSb.append(rule.getString("number")).append(": ");
                    for (String field : context.getAggregateField()) {
                        boolean isFind = false;
                        for (DynamicObject ruleRow : ruleEntryList) {
                            if (!compareList.contains(ruleRow.getString("compare_type")) || !field.equals(ruleRow.getString("std_inv_col_no"))) continue;
                            isFind = true;
                            break;
                        }
                        if (isFind) continue;
                        errSb.append(field).append(", ");
                        allFind = false;
                    }
                }
                if (allFind) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25\uff0c\u9884\u7559\u89c4\u5219\u6ca1\u6709\u914d\u7f6e\u603b\u91cf\u9884\u7559\u7ef4\u5ea6\u7684\u4f9b\u9700\u5339\u914d\u5173\u7cfb\uff1a%1$s\u8bf7\u68c0\u67e5\u9884\u7559\u65b9\u6848.\u9884\u7559\u7b56\u7565.\u975e\u9884\u8ba1\u5165\u9884\u7559\u89c4\u5219\u3002", (String)"ReserveHelper_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), errSb.toString()));
            }
        }
    }

    private static void reserveStrategyEntrys(ReserveContext context, List<RequestBillEntryParam> entryParams, DynamicObject strategy) {
        StrategyEngine.execute(context, entryParams, strategy);
    }

    public static Map<Object, List<RequestBillEntryParam>> getStrategyToEntriesMap(List<RequestBillEntryParam> billEntryParams, DynamicObjectCollection orderStrategyCollection) {
        HashMap<Object, List<RequestBillEntryParam>> strategyToEntriesMap = new HashMap<Object, List<RequestBillEntryParam>>();
        if (orderStrategyCollection.size() > 0) {
            Map<Object, DynamicObject> strategyMap = ReserveHelper.getStrategyMap(orderStrategyCollection);
            for (int i = 0; i < orderStrategyCollection.size(); ++i) {
                DynamicObject orderStrategyCol = (DynamicObject)orderStrategyCollection.get(i);
                DynamicObject strategy = strategyMap.get(orderStrategyCol.getDynamicObject("strategy").getPkValue());
                orderStrategyCol.set("strategy", (Object)strategy);
                String strategyFilter = strategy.getString("filter_value_tag");
                ArrayList<RequestBillEntryParam> strategyToEntries = new ArrayList<RequestBillEntryParam>(billEntryParams.size());
                for (RequestBillEntryParam entryParam : billEntryParams) {
                    if (!FilterParser.execExcelFormulaHasNoEntry(strategyFilter, entryParam.getBillEntry())) continue;
                    strategyToEntries.add(entryParam);
                }
                strategyToEntriesMap.put(strategy.getPkValue(), strategyToEntries);
            }
        }
        return strategyToEntriesMap;
    }

    public static Map<Object, DynamicObject> getStrategyMap(DynamicObjectCollection orderStrategyCollection) {
        Object[] idArray = new Object[orderStrategyCollection.size()];
        for (int i = 0; i < orderStrategyCollection.size(); ++i) {
            DynamicObject orderStrategyCol = (DynamicObject)orderStrategyCollection.get(i);
            DynamicObject strategy = orderStrategyCol.getDynamicObject("strategy");
            idArray[i] = strategy.getPkValue();
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])idArray, (String)"msmod_reserve_strategy");
    }

    public static void validateBillResult(BillReserveResult result) {
        List<EntryReserveResult> entryReserveResultList = result.getEntryResultList();
        int fullSuccessCount = 0;
        int partSuccessCount = 0;
        for (int i = 0; i < entryReserveResultList.size(); ++i) {
            if (ReserveResultType.FullSuccess == entryReserveResultList.get(i).getReserveResultType()) {
                ++fullSuccessCount;
                continue;
            }
            if (ReserveResultType.PartSuccess != entryReserveResultList.get(i).getReserveResultType()) continue;
            ++partSuccessCount;
        }
        if (fullSuccessCount == 0 && partSuccessCount == 0) {
            result.setReserveResultType(ReserveResultType.Failed);
        } else if (fullSuccessCount != entryReserveResultList.size()) {
            result.setErrorMsg("");
            result.setReserveResultType(ReserveResultType.PartSuccess);
        } else {
            result.setReserveResultType(ReserveResultType.FullSuccess);
            result.setErrorMsg("");
        }
    }

    public static void handleBillResult(BillReserveResult result, ReserveContext context) {
        boolean usePlugin = context.getScheme().getBoolean("custom_result_plugin");
        BillResultHandlerFactory.getDefaultResultHandler(context).handle(result, context);
        if (usePlugin) {
            BillResultHandlerFactory.getResultHandlerPlugin(context).handle(result, context);
        }
    }

    public static EntryReserveResult reserveEntry(ReserveContext context, DynamicObject requestEntry) {
        DynamicObjectCollection strategyList = context.getScheme().getDynamicObjectCollection("strategy_entry");
        DynamicObjectCollection orderStrategyCollection = SchemeHelper.sortCollectionByField(strategyList, "strategy_seq");
        EntryReserveResult entryResult = new EntryReserveResult();
        for (int i = 0; i < orderStrategyCollection.size(); ++i) {
            DynamicObject strategy = ((DynamicObject)orderStrategyCollection.get(i)).getDynamicObject("strategy");
            if (!StrategyHelper.isUsable(strategy = BusinessDataServiceHelper.loadSingleFromCache((Object)strategy.getPkValue(), (String)strategy.getDynamicObjectType().getName()), context.getRequestBill())) continue;
            EntryReserveResult entryStrategyResult = StrategyEngine.execute(context, strategy, requestEntry);
            if (entryResult == null || ReserveResultType.FullSuccess == entryStrategyResult.getReserveResultType() && ReserveResultType.PartSuccess != entryResult.getReserveResultType() || ReserveResultType.PartSuccess == entryStrategyResult.getReserveResultType() && ReserveResultType.Failed == entryResult.getReserveResultType()) {
                entryResult = entryStrategyResult;
            }
            if (ReserveResultType.FullSuccess == entryResult.getReserveResultType()) break;
        }
        entryResult.setEntryId(context.getEntryId(requestEntry));
        entryResult.setSeq(requestEntry.getInt("seq"));
        return entryResult;
    }

    @Deprecated
    public static Map<Object, List<Object>> getBotpUpPath4BillIds(String entityNumber, String entryKey, Long[] entryIds) {
        return ReserveHelper.getBotpUpPath(entityNumber, entryKey, entryIds, true);
    }

    @Deprecated
    public static Map<Object, List<Object>> getBotpUpPath4EntryId(String entityNumber, String entryKey, Long[] entryIds) {
        return ReserveHelper.getBotpUpPath(entityNumber, entryKey, entryIds, false);
    }

    public static Map<Object, List<Object>> getBotpUpPath4EntryId(String entityNumber, String entryKey, Long[] entryIds, Long[] billIds) {
        return ReserveHelper.getBotpUpPath(entityNumber, entryKey, entryIds, billIds, false);
    }

    @Deprecated
    private static Map<Object, List<Object>> getBotpUpPath(String entityNumber, String entryKey, Long[] entryIds, boolean isBillIdPath) {
        List rows = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)entryKey, (Long[])entryIds);
        HashMap<Object, List<Object>> map = new HashMap<Object, List<Object>>(rows.size());
        for (BFRowLinkUpNode row : rows) {
            List nodes = row.findAllSourceNodes();
            ArrayList<Object> ids = new ArrayList<Object>(nodes.size());
            for (BFRowLinkUpNode node : nodes) {
                ids.add(ReserveHelper.getNodeId(node, isBillIdPath));
            }
            map.put(ReserveHelper.getNodeId(row, isBillIdPath), ids);
        }
        return map;
    }

    private static Map<Object, List<Object>> getBotpUpPath(String entityNumber, String entryKey, Long[] entryIds, Long[] billIds, boolean isBillIdPath) {
        List rows = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)entryKey, (Long[])billIds, (Long[])entryIds, (OperateOption)OperateOption.create());
        HashMap<Object, List<Object>> map = new HashMap<Object, List<Object>>(rows.size());
        for (BFRowLinkUpNode row : rows) {
            List nodes = row.findAllSourceNodes();
            ArrayList<Object> ids = new ArrayList<Object>(nodes.size());
            for (BFRowLinkUpNode node : nodes) {
                ids.add(ReserveHelper.getNodeId(node, isBillIdPath));
            }
            map.put(ReserveHelper.getNodeId(row, isBillIdPath), ids);
        }
        return map;
    }

    public static Set<Object> getBotpLinkBillIds(String billName, Long[] idArr) {
        HashSet<Object> ids = new HashSet<Object>(16);
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)billName, (Long[])idArr);
        for (HashSet srcId : srcBills.values()) {
            ids.addAll(srcId);
        }
        ids.addAll(Arrays.asList(idArr));
        return ids;
    }

    private static Object getNodeId(BFRowLinkUpNode node, boolean isBillIdPath) {
        return isBillIdPath ? node.getRowId().getBillId() : node.getRowId().getEntryId();
    }

    public static void showColsTreePage(IFormView formView, IFormPlugin formPlugin, String entityNumber, String key) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode node = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        SelectParams params = new SelectParams();
        params.setJsonTree(SerializationUtils.toJsonString((Object)node));
        FormShowParameter fp = FormUtil.readyColsTreePage(params, new CloseCallBack(formPlugin, key));
        formView.showForm(fp);
    }

    public static DataSet queryObjData(String algoKey, Map<String, Set<Object>> objIdMap, Map<String, String> objSelectMap) {
        ArrayList<OrmInput> ormList = new ArrayList<OrmInput>(objSelectMap.size());
        for (Map.Entry<String, String> selectEntry : objSelectMap.entrySet()) {
            String formId = selectEntry.getKey();
            String selectField = selectEntry.getValue();
            Set<Object> ids = objIdMap.get(formId);
            if (ids == null || ids.isEmpty()) continue;
            OrmInput orm = new OrmInput(algoKey, formId, selectField, new QFilter("id", "in", ids).toArray());
            ormList.add(orm);
        }
        if (ormList.isEmpty()) {
            return null;
        }
        Algo algo = Algo.create((String)algoKey);
        DataSet data = algo.createDataSet((Input[])ormList.toArray(new OrmInput[ormList.size()]));
        return data;
    }

    public static BigDecimal getUnitRateConv(DynamicObject materialDyc, DynamicObject srcUnitDyc, DynamicObject desUnitDyc) {
        BigDecimal unitRate = BigDecimal.ZERO;
        if (materialDyc != null && srcUnitDyc != null && desUnitDyc != null) {
            Long srcUnitId = (Long)srcUnitDyc.getPkValue();
            Long desUnitId = (Long)desUnitDyc.getPkValue();
            if (srcUnitId.longValue() == desUnitId.longValue()) {
                unitRate = BigDecimal.ONE;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)materialDyc.getPkValue()), (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
                }
            }
        }
        return unitRate;
    }

    public static Map<String, Object> getBalDefaultMap() {
        HashMap<String, Object> fieldCloneMap = new HashMap<String, Object>(8);
        fieldCloneMap.put("id", "id");
        return fieldCloneMap;
    }

    public static Map<String, Object> getBillDefaultMap() {
        HashMap<String, Object> fieldCloneMap = new HashMap<String, Object>(8);
        fieldCloneMap.put("sale_org", 0L);
        fieldCloneMap.put("sale_dept", 0L);
        fieldCloneMap.put("customer", 0L);
        fieldCloneMap.put("sale_operator", 0L);
        fieldCloneMap.put("bill_entry", 0L);
        return fieldCloneMap;
    }

    public static Object getProValue(String var, DynamicObject requestBill, DynamicObject requestEntry) {
        Object value = ReserveHelper.getSpiltValue(var, requestBill, requestEntry);
        if (value instanceof DynamicObject) {
            value = ((DynamicObject)value).getPkValue();
        }
        return value;
    }

    public static Object getSpiltValue(String var, DynamicObject requestBill, DynamicObject requestEntry) {
        String[] sp = var.split("\\.");
        if (sp.length == 1) {
            return requestBill.get(sp[0]);
        }
        Object value = null;
        for (int i = 1; i < sp.length; ++i) {
            if (i == 1) {
                value = requestEntry.get(sp[i]);
                continue;
            }
            if (value == null) {
                return value;
            }
            value = ((DynamicObject)value).get(sp[i]);
        }
        if (value instanceof OrmLocaleValue) {
            value = ((OrmLocaleValue)value).getLocaleValue();
        }
        return value;
    }

    public static Map<String, Boolean> getIsPredictMap(Collection<String> formIds) {
        Map objMap = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"id,modeltype", (QFilter[])new QFilter("id", "in", formIds).toArray());
        HashMap<String, Boolean> isPredictMap = new HashMap<String, Boolean>(objMap.size());
        for (DynamicObject obj : objMap.values()) {
            String modelType = obj.getString("modeltype");
            isPredictMap.put(obj.getString("id"), !"BalanceModel".equals(modelType));
        }
        return isPredictMap;
    }

    public static DynamicObject[] filterValidateReserveBills(String formId, DynamicObject[] reserveBills, StringBuilder tipSb) {
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        HashSet<Long> reserveBillIdsSet = new HashSet<Long>(16);
        for (DynamicObject reserveBill : reserveBills) {
            Long pkValue = (Long)reserveBill.getPkValue();
            reserveBillIdsSet.add(pkValue);
        }
        Map<Long, Set<Long>> srcIdsMap = ReserveHelper.getSrcBotpIds(formId, reserveBillIdsSet.toArray(new Long[reserveBillIdsSet.size()]));
        for (Set<Long> srcIds : srcIdsMap.values()) {
            srcBillIds.addAll(srcIds);
        }
        if (srcBillIds.isEmpty()) {
            return reserveBills;
        }
        QFilter reF = new QFilter("bill_id", "in", srcBillIds);
        reF = reF.and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
        DynamicObjectCollection reserveRecords = QueryServiceHelper.query((String)"msmod_reserve_record", (String)"bill_id,bill_no", (QFilter[])reF.toArray());
        HashSet<Long> reserveBillIds = new HashSet<Long>(16);
        HashMap<Long, String> srcBillNoMap = new HashMap<Long, String>(16);
        for (DynamicObject reserveRecord : reserveRecords) {
            reserveBillIds.add(reserveRecord.getLong("bill_id"));
            srcBillNoMap.put(reserveRecord.getLong("bill_id"), reserveRecord.getString("bill_no"));
        }
        if (reserveBillIds.isEmpty()) {
            return reserveBills;
        }
        ArrayList<DynamicObject> resBillDynamic = new ArrayList<DynamicObject>(reserveRecords.size());
        StringBuilder errSb = new StringBuilder();
        for (DynamicObject reserveBill : reserveBills) {
            Long pkValue = (Long)reserveBill.getPkValue();
            Set<Long> srcIds = srcIdsMap.get(pkValue);
            if (srcIds == null || srcIds.isEmpty()) {
                resBillDynamic.add(reserveBill);
                continue;
            }
            errSb.append("srcIds:").append(srcIds).append(",");
            errSb.append("reserveBillIds:").append(reserveBillIds).append(",");
            Set<Long> intersectionSet = srcIds.stream().filter(reserveBillIds::contains).collect(Collectors.toSet());
            if (srcIds.removeAll(reserveBillIds)) {
                errSb.append("Src have reserve record");
                String tips = ReserveHelper.buildListBOTPExitRecordTips(srcBillNoMap, reserveBill, intersectionSet);
                tipSb.append(tips);
                tipSb.append('\n');
                continue;
            }
            resBillDynamic.add(reserveBill);
        }
        if (errSb.length() > 0) {
            errSb.append('\n');
            errSb.append((CharSequence)tipSb);
            logger.info(errSb.toString());
        }
        return resBillDynamic.toArray(new DynamicObject[resBillDynamic.size()]);
    }

    private static String buildListBOTPExitRecordTips(Map<Long, String> srcBillNoMap, DynamicObject reserveBill, Set<Long> srcIds) {
        IDataEntityType dataEntityType = reserveBill.getDataEntityType();
        String numberField = ((BillEntityType)dataEntityType).getBillNo();
        if (StringUtils.isEmpty((CharSequence)numberField)) {
            numberField = "billno";
        }
        String number = null;
        try {
            number = reserveBill.getString(numberField);
        }
        catch (Exception e) {
            number = reserveBill.getString("id");
        }
        ArrayList<String> srcBillNoList = new ArrayList<String>(srcIds.size());
        for (Long srcId : srcIds) {
            String srcBillNo = srcBillNoMap.get(srcId);
            if (!StringUtils.isNotEmpty((CharSequence)srcBillNo)) continue;
            srcBillNoList.add(srcBillNo);
        }
        return ResManager.loadKDString((String)"{0}\uff1a\u4e0a\u6e38\u5355\u636e{1}\u5b58\u5728\u9884\u7559\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u9884\u7559\u3002", (String)"MSCOMMON-P-061856", (String)"mpscmm-mscommon-reserve", (Object[])new Object[]{number, String.join((CharSequence)",", srcBillNoList)});
    }

    public static Map<Long, Set<Long>> getSrcBotpIds(String formId, Long[] billIds) {
        HashMap<Long, Set<Long>> srcBillIds = new HashMap<Long, Set<Long>>(16);
        Map linkUpNodes = BFTrackerServiceHelper.loadBillLinkUpNodes((String)formId, (Long[])billIds, (boolean)false);
        for (Map.Entry UpNode : linkUpNodes.entrySet()) {
            List srcNodes = ((BFRowLinkUpNode)UpNode.getValue()).findAllSourceNodes();
            HashSet<Long> ids = new HashSet<Long>(srcNodes.size());
            for (BFRowLinkUpNode row : srcNodes) {
                ids.add(row.getRowId().getBillId());
            }
            srcBillIds.put((Long)UpNode.getKey(), (Set<Long>)ids);
        }
        return srcBillIds;
    }

    public static String checkBOTPExitReserveRecord(String billName, long billId) {
        Set<Object> srcIds = ReserveHelper.getBotpLinkBillIds(billName, new Long[]{billId});
        Iterator<Object> it = srcIds.iterator();
        while (it.hasNext()) {
            if (billId != (Long)it.next()) continue;
            it.remove();
        }
        QFilter recordFilter = new QFilter("bill_id", "in", srcIds);
        recordFilter = recordFilter.and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)"ReserveHelper:checkBOTPExitReserveRecord", (String)"msmod_reserve_record", (String)"bill_no", (QFilter[])recordFilter.toArray(), null);
        String exitReserveRecordMsg = null;
        StringBuilder upperBillNoSb = new StringBuilder();
        HashSet<String> billNoSet = new HashSet<String>(16);
        while (recordDataSet.hasNext()) {
            String bill_no = recordDataSet.next().getString("bill_no");
            billNoSet.add(bill_no);
        }
        for (String billNo : billNoSet) {
            upperBillNoSb.append(billNo).append(',');
        }
        if (upperBillNoSb.length() > 0) {
            exitReserveRecordMsg = String.format(ReserveHelper.getBOTPExitRecordErrMsg(), upperBillNoSb.deleteCharAt(upperBillNoSb.length() - 1));
        }
        return exitReserveRecordMsg;
    }

    private static String getBOTPExitRecordErrMsg() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7684\u4e0a\u6e38\u5355\u636e%s\u5b58\u5728\u9884\u7559\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u9884\u7559\u3002", (String)"ManualReserveMainPlugin_15", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
    }

    public static Set<Long> filterNoBOTPReserveBill(String billName, Set<Long> billIdSet) {
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        Map<Long, Set<Long>> srcIdsMap = ReserveHelper.getSrcBotpIds(billName, billIdSet.toArray(new Long[billIdSet.size()]));
        for (Set<Long> srcIds : srcIdsMap.values()) {
            srcBillIds.addAll(srcIds);
        }
        if (srcBillIds.isEmpty()) {
            return new HashSet<Long>(16);
        }
        QFilter reF = new QFilter("bill_id", "in", srcBillIds);
        DynamicObjectCollection reserveRecords = QueryServiceHelper.query((String)"msmod_reserve_record", (String)"bill_id", (QFilter[])reF.toArray());
        for (DynamicObject reserveRecord : reserveRecords) {
            billIdSet.remove(reserveRecord.getLong("bill_id"));
        }
        return billIdSet;
    }

    private static ColsMap getColsMapForAutoReserve(String billName) {
        ColsMap colMap = ColsMapHelper.findBillColMap(billName, "msmod_std_request_bill");
        if (colMap == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff1a%1$s\u3002", (String)"ReserveContext_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), billName));
        }
        Map<String, String> balColMap = colMap.getBalColMap();
        List<String> mustSetFieldList = Arrays.asList("bill_entry.base_qty", "bill_entry.unit");
        StringBuilder sb = new StringBuilder();
        for (String field : mustSetFieldList) {
            if (balColMap.get(field) != null) continue;
            sb.append(field).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25\uff0c%1$s\u6ca1\u6709\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u9700\u6c42\u5355\u636e\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u9700\u6c42\u6a21\u578b\uff09\u3002", (String)"ReserveService_8", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), sb));
        }
        return colMap;
    }

    public static List<BillReserveResult> autoReservePredict(String billName, DynamicObject[] requestBillList) {
        ArrayList<BillReserveResult> resultList = new ArrayList<BillReserveResult>(requestBillList.length);
        ColsMap colMap = ReserveHelper.getColsMapForAutoReserve(billName);
        Map<Long, DynamicObject> schemeBillMap = SchemeHelper.getBillSchemeMap(billName, requestBillList);
        Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
        if (((Boolean)aggregateCfg.get("isAggregate")).booleanValue() && !((Boolean)aggregateCfg.get("isAggregateInit")).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u603b\u91cf\u9884\u7559\u8bbe\u7f6e\u542f\u7528\u540e\u672a\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u8bf7\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"ReserveHelper_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        Map<Object, DynamicObject> schemeMap = null;
        Map<Long, List<DynamicObject>> schemeBillListMap = null;
        try {
            schemeMap = SchemeHelper.getAllSchemeByBillType(billName);
            ReserveHelper.getAllStrategyForScheme(schemeMap);
            schemeBillListMap = SchemeHelper.getSortRequestBillList(requestBillList, schemeMap);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return resultList;
        }
        StringBuilder errSb = new StringBuilder();
        for (Map.Entry<Long, List<DynamicObject>> entry2 : schemeBillListMap.entrySet()) {
            long schemeId = entry2.getKey();
            List<DynamicObject> billList = entry2.getValue();
            DynamicObject usableScheme = schemeMap.get(schemeId);
            for (DynamicObject requestBill : billList) {
                try {
                    if (usableScheme == null) {
                        throw new KDBizException(ResUtil.formatMsg(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u9884\u7559\u65b9\u6848\uff0c\u8bf7\u5148\u589e\u52a0\u9884\u7559\u65b9\u6848\u3002", (String)"ReserveContext_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveContext_0", requestBill.getPkValue()));
                    }
                    BillReserveResult reserveResult = ReserveHelper.reserveSingleBillForBatch(requestBill, false, usableScheme, aggregateCfg);
                    if (ReserveResultType.FullSuccess == reserveResult.getReserveResultType()) {
                        reserveResult.setEntryResultList(null);
                    } else {
                        Map<Long, DynamicObject> entryMap = ReserveHelper.getEntryMap(requestBill, colMap);
                        ArrayList<EntryReserveResult> entryList = new ArrayList<EntryReserveResult>(reserveResult.getEntryResultList());
                        String baseQtyKey = colMap.getByBalCol(StdRequestBillConst.getEntryField("base_qty"));
                        for (EntryReserveResult entryResult : entryList) {
                            String error = (String)entryResult.getErrorMsg();
                            if (StringUtils.isBlank((CharSequence)error)) {
                                Object entryId = entryResult.getEntryId();
                                DynamicObject entry = entryMap.get(entryId);
                                BigDecimal baseQty = ColsMapHelper.getMpingQty(entry, baseQtyKey);
                                BigDecimal reservedBaseQty = entryResult.getReservedBaseQty();
                                BigDecimal subQty = baseQty.subtract(reservedBaseQty).abs();
                                entryResult.setReservedQty(baseQty);
                                entryResult.setReservedQty2nd(subQty);
                            }
                            entryResult.setStdInvResultList(null);
                        }
                    }
                    resultList.add(reserveResult);
                }
                catch (Exception e) {
                    if (e.getStackTrace() == null) continue;
                    errSb.append(Arrays.toString(e.getStackTrace())).append(",");
                }
            }
        }
        if (errSb.length() > 0) {
            logger.info(errSb.toString());
        }
        return resultList;
    }

    private static List<String> getReserveMsg(BillReserveResult reserveResult, DynamicObject requestBill, ColsMap colMap, String entryMsg) {
        ArrayList<String> msgList = new ArrayList<String>(16);
        Map<Long, DynamicObject> entryMap = ReserveHelper.getEntryMap(requestBill, colMap);
        List<EntryReserveResult> entryResultList = reserveResult.getEntryResultList();
        ArrayList<EntryReserveResult> entryList = new ArrayList<EntryReserveResult>(entryResultList);
        entryList.sort(new Comparator<EntryReserveResult>(){

            @Override
            public int compare(EntryReserveResult o1, EntryReserveResult o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        String materialKey = colMap.getByBalCol(StdRequestBillConst.getEntryField("material"));
        String baseQtyKey = colMap.getByBalCol(StdRequestBillConst.getEntryField("base_qty"));
        String billNoKey = colMap.getByBalCol("bill_no");
        if (StringUtils.isEmpty((CharSequence)materialKey) || StringUtils.isEmpty((CharSequence)baseQtyKey)) {
            return msgList;
        }
        String billNo = "";
        if (StringUtils.isNotEmpty((CharSequence)billNoKey)) {
            billNo = requestBill.getString(billNoKey);
        }
        for (EntryReserveResult entryResult : entryList) {
            BigDecimal reservedBaseQty;
            BigDecimal baseQty;
            BigDecimal subQty;
            String error = (String)entryResult.getErrorMsg();
            if (StringUtils.isNotBlank((CharSequence)error)) {
                msgList.add(error);
                continue;
            }
            Object entryId = entryResult.getEntryId();
            DynamicObject entry = entryMap.get(entryId);
            DynamicObject material = (DynamicObject)ReserveHelper.getSpiltValue(materialKey, requestBill, entry);
            if (material == null) continue;
            if (!"bd_material".equals(material.getDynamicObjectType().getName())) {
                material = material.getDynamicObject("masterid");
            }
            if (BigDecimal.ZERO.compareTo(subQty = (baseQty = ColsMapHelper.getMpingQty(entry, baseQtyKey).abs()).subtract(reservedBaseQty = entryResult.getReservedBaseQty().abs()).abs()) == 0) continue;
            msgList.add(String.format(entryMsg, billNo, entryResult.getSeq(), material.getString("number"), material.getString("name"), baseQty.stripTrailingZeros().toPlainString(), reservedBaseQty.stripTrailingZeros().toPlainString(), subQty.stripTrailingZeros().toPlainString()));
        }
        return msgList;
    }

    private static Map<Long, DynamicObject> getEntryMap(DynamicObject requestBill, ColsMap colMap) {
        String matrial = colMap.getBalColMap().get("bill_entry.material");
        String[] materials = matrial.split("\\.");
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(6);
        if (materials.length == 1) {
            entryMap.put(requestBill.getLong("id"), requestBill);
        } else {
            String entryKey = colMap.getByBalCol("bill_entry");
            DynamicObjectCollection entrys = requestBill.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entrys) {
                entryMap.put(entry.getLong("id"), entry);
            }
        }
        return entryMap;
    }

    public static void mergeQtyForHighHot(String barNumber, DynamicObjectCollection col) {
        if (!ReserveCommonHelper.getScmParam("INV0007")) {
            return;
        }
        ArrayList<Long> invIdList = new ArrayList<Long>(col.size());
        HashMap<Long, DynamicObject> invMap = new HashMap<Long, DynamicObject>(col.size());
        for (DynamicObject obj : col) {
            invIdList.add(obj.getLong("id"));
            invMap.put(obj.getLong("id"), obj);
        }
        if (invIdList.size() == 0) {
            return;
        }
        QFilter spFilter = new QFilter("invid", "in", invIdList);
        DataSet spDataSet = QueryServiceHelper.queryDataSet((String)"getDetailInventoryAvbQty", (String)"msmod_reserve_bal_sp", (String)"invid,baseqty,qty,qty2nd", (QFilter[])spFilter.toArray(), null);
        spDataSet = spDataSet.groupBy(new String[]{"invid"}).sum("baseqty").sum("qty").sum("qty2nd").finish();
        ColsMap colsMap = ColsMapHelper.findBillColMaps(barNumber, "msmod_std_inv_field");
        Map<String, String> balColMap = colsMap.getBalColMap();
        while (spDataSet.hasNext()) {
            Row row = spDataSet.next();
            long invId = row.getLong("invid");
            DynamicObject invObj = (DynamicObject)invMap.get(invId);
            if (invObj == null) continue;
            BigDecimal baseQty = row.getBigDecimal("baseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("baseqty");
            BigDecimal qty = row.getBigDecimal("qty") == null ? BigDecimal.ZERO : row.getBigDecimal("qty");
            BigDecimal qty2nd = row.getBigDecimal("qty2nd") == null ? BigDecimal.ZERO : row.getBigDecimal("qty2nd");
            invObj.set(balColMap.get("reserve_base_qty"), (Object)invObj.getBigDecimal(balColMap.get("reserve_base_qty")).add(baseQty));
            if (balColMap.get("reserve_qty") != null) {
                invObj.set(balColMap.get("reserve_qty"), (Object)invObj.getBigDecimal(balColMap.get("reserve_qty")).add(qty));
            }
            if (balColMap.get("reserve_qty2nd") == null) continue;
            invObj.set(balColMap.get("reserve_qty2nd"), (Object)invObj.getBigDecimal(balColMap.get("reserve_qty2nd")).add(qty2nd));
        }
    }

    public static OperationResult autoReserve(String billName, DynamicObject[] requestBillArray) {
        OperationResult result = new OperationResult();
        Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
        if (((Boolean)aggregateCfg.get("isAggregate")).booleanValue() && !((Boolean)aggregateCfg.get("isAggregateInit")).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u603b\u91cf\u9884\u7559\u8bbe\u7f6e\u542f\u7528\u540e\u672a\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u8bf7\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"ReserveHelper_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        ColsMap colMap = ReserveHelper.getColsMapForAutoReserve(billName);
        ArrayList<String> showMsgList = new ArrayList<String>();
        ArrayList<String> errMsgList = new ArrayList<String>();
        Map<Object, DynamicObject> schemeMap = null;
        Map<Long, List<DynamicObject>> schemeBillListMap = null;
        try {
            schemeMap = SchemeHelper.getAllSchemeByBillType(billName);
            ReserveHelper.getAllStrategyForScheme(schemeMap);
            schemeBillListMap = SchemeHelper.getSortRequestBillList(requestBillArray, schemeMap);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            return result;
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : schemeBillListMap.entrySet()) {
            long schemeId = entry.getKey();
            List<DynamicObject> billList = entry.getValue();
            DynamicObject usableScheme = schemeMap.get(schemeId);
            for (DynamicObject requestBill : billList) {
                BillReserveResult reserveResult = null;
                try {
                    reserveResult = ReserveHelper.reserveSingleBillForBatch(requestBill, true, usableScheme, aggregateCfg);
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    if (usableScheme != null) {
                        String supDiff = usableScheme.getString("supdiff");
                        if (ReserveSpuDiff.ERRORMSG_OP.getValue().equals(supDiff)) {
                            throw new KDBizException(e.getMessage());
                        }
                    }
                    logger.error((Throwable)e);
                    showMsgList.add(e.getMessage());
                    continue;
                }
                ReserveHelper.dealResultForAutoReserve(result, colMap, showMsgList, errMsgList, requestBill, reserveResult);
            }
        }
        if (showMsgList.size() > 0) {
            StringBuilder showMsyStringBuilder = new StringBuilder();
            for (String s : showMsgList) {
                showMsyStringBuilder.append(s);
            }
            result.setMessage(showMsyStringBuilder.toString());
        } else {
            result.setSuccess(true);
        }
        return result;
    }

    private static void getAllStrategyForScheme(Map<Object, DynamicObject> schemeMap) {
        DynamicObjectCollection allStrategyList = new DynamicObjectCollection();
        for (DynamicObject scheme : schemeMap.values()) {
            DynamicObjectCollection strategyList = scheme.getDynamicObjectCollection("strategy_entry");
            allStrategyList.addAll((Collection)strategyList);
        }
        Map<Object, DynamicObject> strategyMap = ReserveHelper.getStrategyMap(allStrategyList);
        for (DynamicObject scheme : schemeMap.values()) {
            DynamicObjectCollection strategyList = scheme.getDynamicObjectCollection("strategy_entry");
            for (DynamicObject strategy : strategyList) {
                DynamicObject temp = strategyMap.get(strategy.getDynamicObject("strategy").getPkValue());
                strategy.set("strategy", (Object)temp);
            }
        }
    }

    private static void dealResultForAutoReserve(OperationResult result, ColsMap colMap, List<String> showMsgList, List<String> errMsgList, DynamicObject requestBill, BillReserveResult reserveResult) {
        if (reserveResult == null) {
            return;
        }
        if (reserveResult.getErrorMsg() != null && reserveResult.getErrorMsg().contains("msmod_reserveaggre")) {
            if (ReserveSpuDiff.ERRORMSG_OP.getValue().equals(reserveResult.getSupDiff())) {
                throw new KDBizException(reserveResult.getErrorMsg());
            }
            result.setSuccess(false);
            showMsgList.add(reserveResult.getErrorMsg());
            return;
        }
        ReserveResultType resultType = reserveResult.getReserveResultType();
        if (ReserveResultType.FullSuccess == resultType) {
            return;
        }
        String supDiff = reserveResult.getSupDiff();
        try {
            String entryMsg;
            if (ReserveSpuDiff.SHOWMSG_NORESERVE.getValue().equals(supDiff)) {
                entryMsg = ResManager.loadKDString((String)"\u5355\u636e%1$s\uff1a\u5206\u5f55%2$s\uff0c\u7269\u6599\uff08%3$s\u3001%4$s\uff09\u9700\u6c42\u57fa\u672c\u6570\u91cf%5$s\uff0c\u53ef\u7528\u57fa\u672c\u6570\u91cf%6$s\uff0c\u5dee\u5f02%7$s\uff0c\u6574\u5355\u9884\u7559\u5904\u7406\u5931\u8d25\u3002", (String)"MpsReserveService_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
                showMsgList.addAll(ReserveHelper.getReserveMsg(reserveResult, requestBill, colMap, entryMsg));
            } else if (ReserveSpuDiff.SHOWMSG_RESERVE.getValue().equals(supDiff)) {
                entryMsg = ResManager.loadKDString((String)"\u5355\u636e%1$s\uff1a\u5206\u5f55%2$s\uff0c\u7269\u6599\uff08%3$s\u3001%4$s\uff09\u9700\u6c42\u57fa\u672c\u6570\u91cf%5$s\uff0c\u5df2\u9884\u7559\u57fa\u672c\u6570\u91cf%6$s\uff0c\u5dee\u5f02%7$s\u3002", (String)"MpsReserveService_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
                showMsgList.addAll(ReserveHelper.getReserveMsg(reserveResult, requestBill, colMap, entryMsg));
            } else if (ReserveSpuDiff.ERRORMSG_OP.getValue().equals(supDiff)) {
                entryMsg = ResManager.loadKDString((String)"\u5355\u636e%1$s\uff1a\u5206\u5f55%2$s\uff0c\u7269\u6599\uff08%3$s\u3001%4$s\uff09\u9700\u6c42\u57fa\u672c\u6570\u91cf%5$s\uff0c\u53ef\u7528\u57fa\u672c\u6570\u91cf%6$s\uff0c\u5dee\u5f02%7$s\uff0c\u6574\u5355\u9884\u7559\u5904\u7406\u5931\u8d25\u3002", (String)"MpsReserveService_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
                errMsgList.addAll(ReserveHelper.getReserveMsg(reserveResult, requestBill, colMap, entryMsg));
            }
        }
        catch (Exception e) {
            errMsgList.add(e.getMessage());
        }
        if (!errMsgList.isEmpty()) {
            errMsgList.addAll(showMsgList);
            StringBuilder errMsyStringBuilder = new StringBuilder();
            for (String s : errMsgList) {
                errMsyStringBuilder.append(s);
            }
            throw new KDBizException(errMsyStringBuilder.toString());
        }
    }
}

