/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ReserveOpLogHelper;
import kd.mpscmm.msbd.reserve.business.record.BalanceHelper;
import kd.mpscmm.msbd.reserve.business.record.ReleaseData;
import kd.mpscmm.msbd.reserve.business.record.ReserveRecordHelper;
import kd.mpscmm.msbd.reserve.common.util.ResUtil;
import org.apache.commons.lang3.StringUtils;

public class ReserveRecordHandler {
    @Deprecated
    public static void createReserveRecord(String balName, Collection<DynamicObject> records) {
        ReserveRecordHandler.checkReserveRecord(balName, records);
        ReserveRecordHandler.saveReserveRecord(records);
        ReserveOpLogHelper.createNewLogByRecord(records, false);
        ReserveRecordHandler.writeBackBalQty(balName, records);
    }

    private static void checkReserveRecord(String balName, Collection<DynamicObject> records) {
    }

    public static void createReserveRecord(Collection<DynamicObject> records) {
        if (records == null || records.size() == 0) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"createReserveRecord");){
            try {
                ReserveRecordHandler.createReserveRecordNew(records);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    @Deprecated
    public static void saveReserveRecordNoTrans(Collection<DynamicObject> records) {
        ReserveRecordHandler.saveReserveRecord(records);
        ReserveOpLogHelper.createNewLogByRecord(records, false);
        Map<String, List<DynamicObject>> params = ReserveRecordHandler.groupByBalanceTable(records);
        for (Map.Entry<String, List<DynamicObject>> param : params.entrySet()) {
            Map<String, ColsMap> colsMap = BalanceHelper.provideColsMapNew((Collection<DynamicObject>)param.getValue(), param.getKey());
            ReserveRecordHandler.writeBackBalQty4Release(param.getKey(), (Collection<DynamicObject>)param.getValue(), colsMap);
        }
    }

    public static void saveNewReserveRecord(Collection<DynamicObject> records) {
        ReserveRecordHandler.saveReserveRecord(records);
        Map<String, List<DynamicObject>> params = ReserveRecordHandler.groupByBalanceTable(records);
        for (Map.Entry<String, List<DynamicObject>> param : params.entrySet()) {
            Map<String, ColsMap> colsMap = BalanceHelper.provideColsMapNew((Collection<DynamicObject>)param.getValue(), param.getKey());
            ReserveRecordHandler.writeBackBalQty4Release(param.getKey(), (Collection<DynamicObject>)param.getValue(), colsMap);
        }
    }

    public static void createReserveRecordNew(Collection<DynamicObject> records) {
        try (TXHandle tx = TX.required((String)"createReserveRecordNew");){
            try {
                ReserveRecordHandler.saveReserveRecord(records);
                ReserveOpLogHelper.createNewLogByRecord(records, false);
                Map<String, List<DynamicObject>> params = ReserveRecordHandler.groupByBalanceTable(records);
                for (Map.Entry<String, List<DynamicObject>> param : params.entrySet()) {
                    Map<String, ColsMap> colsMap = BalanceHelper.provideColsMapNew((Collection<DynamicObject>)param.getValue(), param.getKey());
                    ReserveRecordHandler.writeBackBalQty4Create(param.getKey(), (Collection<DynamicObject>)param.getValue(), colsMap);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void releaseReserveRecord(Collection<DynamicObject> records) {
        Map<String, List<DynamicObject>> groupedRecordMap = ReserveRecordHandler.groupByBalanceTable(records);
        for (Map.Entry<String, List<DynamicObject>> recordEntry : groupedRecordMap.entrySet()) {
            Map<String, ColsMap> colsMap = BalanceHelper.provideColsMapNew((Collection<DynamicObject>)recordEntry.getValue(), recordEntry.getKey());
            ReserveRecordHandler.writeBackBalQty4Release(recordEntry.getKey(), (Collection<DynamicObject>)recordEntry.getValue(), colsMap);
        }
    }

    public static void unReleaseReserveRecord(Collection<DynamicObject> records) {
        Map<String, List<DynamicObject>> groupedRecordMap = ReserveRecordHandler.groupByBalanceTable(records);
        for (Map.Entry<String, List<DynamicObject>> recordEntry : groupedRecordMap.entrySet()) {
            Map<String, ColsMap> colsMap = BalanceHelper.provideColsMapNew((Collection<DynamicObject>)recordEntry.getValue(), recordEntry.getKey());
            BalanceHelper.writeBackBalQty(recordEntry.getKey(), (Collection<DynamicObject>)recordEntry.getValue(), colsMap, true);
        }
    }

    private static void saveReserveRecord(Collection<DynamicObject> records) {
        try (TXHandle tx = TX.required((String)"saveReserveRecord");){
            try {
                SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                String msg = ResUtil.formatMsg(ResManager.loadKDString((String)"\u4fdd\u5b58\u4f59\u989d\u8bb0\u5f55\u5931\u8d25\u3002", (String)"ReserveRecordHandler_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveRecordHandler_1", new Object[0]);
                throw new KDBizException(msg);
            }
        }
    }

    private static void writeBackBalQty(String bal, Collection<DynamicObject> records) {
        Map<String, ColsMap> colsMap = BalanceHelper.provideColsMap(records);
        ReserveRecordHandler.writeBackBalQty4Create(bal, records, colsMap);
    }

    private static void writeBackBalQty4Create(String bal, Collection<DynamicObject> records, Map<String, ColsMap> colsMap) {
        BalanceHelper.writeBackBalQty(bal, records, colsMap, true);
    }

    private static void writeBackBalQty4Release(String bal, Collection<DynamicObject> records, Map<String, ColsMap> colsMap) {
        BalanceHelper.writeBackBalQty(bal, records, colsMap, false);
    }

    private static Map<String, List<DynamicObject>> groupByBalanceTable(Collection<DynamicObject> records) {
        HashMap<String, List<DynamicObject>> paramGroup = new HashMap<String, List<DynamicObject>>(8);
        for (DynamicObject record : records) {
            String balObjId = record.getString("bal_obj");
            boolean isWeak = record.getBoolean("isweak");
            boolean isPredict = record.getBoolean("ispredict");
            if (isWeak || isPredict) continue;
            ArrayList<DynamicObject> params = (ArrayList<DynamicObject>)paramGroup.get(balObjId);
            if (params == null) {
                params = new ArrayList<DynamicObject>();
                paramGroup.put(balObjId, params);
            }
            params.add(record);
        }
        return paramGroup;
    }

    private static List<Object[]> getParam4Reserve(Collection<ReleaseData> releaseDatas) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(releaseDatas.size());
        for (ReleaseData data : releaseDatas) {
            Object[] param = new Object[]{data.getBaseQty(), data.getQty(), data.getQty2nd(), data.getReserveId()};
            params.add(param);
        }
        return params;
    }

    private static void initReleaseDatas(List<DynamicObject> releaseDatas) {
        Date now = TimeServiceHelper.now();
        Long creator = RequestContext.get().getCurrUserId();
        long[] ids = DB.genGlobalLongIds((int)releaseDatas.size());
        int count = 0;
        for (DynamicObject releaseData : releaseDatas) {
            releaseData.set("creater", (Object)creator);
            releaseData.set("create_date", (Object)now);
            releaseData.set("id", (Object)ids[count++]);
        }
    }

    private static void reserveReleaseQty(List<DynamicObject> releaseDatas, boolean isUnDo, boolean checkNegative, boolean needTransAction) {
        block19: {
            if (releaseDatas == null || releaseDatas.isEmpty()) {
                return;
            }
            if (isUnDo) {
                for (DynamicObject releaseData : releaseDatas) {
                    releaseData.set("base_qty", (Object)releaseData.getBigDecimal("base_qty").negate());
                    releaseData.set("qty", (Object)releaseData.getBigDecimal("qty").negate());
                    releaseData.set("qty2nd", (Object)releaseData.getBigDecimal("qty2nd").negate());
                }
            } else {
                ReserveRecordHandler.initReleaseDatas(releaseDatas);
            }
            Map<Object, ReleaseData> releaseDataMap = ReserveRecordHandler.groupReleaseData(releaseDatas);
            if (needTransAction) {
                try (TXHandle tx = TX.requiresNew((String)"reserveReleaseQty");){
                    try {
                        ReserveRecordHandler.releaseQty(releaseDatas, releaseDataMap, isUnDo, true);
                        ReserveOpLogHelper.createNewLogByReleaseRecord(releaseDatas);
                        ReserveRecordHandler.writeBackBal(releaseDataMap, checkNegative);
                        break block19;
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            ReserveRecordHandler.releaseQty(releaseDatas, releaseDataMap, isUnDo, true);
            ReserveOpLogHelper.createNewLogByReleaseRecord(releaseDatas);
            ReserveRecordHandler.writeBackBal(releaseDataMap, checkNegative);
        }
    }

    public static void unReleaseReserveQty(List<DynamicObject> releaseDataList, boolean checkNegative, boolean realDelete) {
        if (releaseDataList == null || releaseDataList.isEmpty()) {
            return;
        }
        for (DynamicObject releaseData : releaseDataList) {
            releaseData.set("base_qty", (Object)releaseData.getBigDecimal("base_qty").negate());
            releaseData.set("qty", (Object)releaseData.getBigDecimal("qty").negate());
            releaseData.set("qty2nd", (Object)releaseData.getBigDecimal("qty2nd").negate());
        }
        Map<Object, ReleaseData> releaseDataMap = ReserveRecordHandler.groupReleaseData(releaseDataList);
        ReserveRecordHandler.releaseQty(releaseDataList, releaseDataMap, true, realDelete);
        ReserveOpLogHelper.createNewLogByReleaseRecord(releaseDataList);
        ReserveRecordHandler.writeBackBal(releaseDataMap, checkNegative);
    }

    public static void reserveReleaseQty(List<DynamicObject> releaseDatas) {
        ReserveRecordHandler.reserveReleaseQty(releaseDatas, false, false, true);
    }

    public static void unDoReserveReleaseQty(List<DynamicObject> releaseDatas, boolean checkNegative) {
        ReserveRecordHandler.reserveReleaseQty(releaseDatas, true, checkNegative, true);
    }

    public static void releaseReserveRollBackQty(List<DynamicObject> releaseData) {
        ThreadCache.put((Object)"ReserveOpType", (Object)"releaseback");
        ReserveRecordHandler.reserveReleaseQty(releaseData, true, false, false);
    }

    public static void unDoReserveReleaseQty(List<DynamicObject> releaseDatas) {
        ReserveRecordHandler.reserveReleaseQty(releaseDatas, true, true, true);
    }

    private static void writeBackBal(Map<Object, ReleaseData> releaseDataMap, Boolean checkNegative) {
        QFilter idF = new QFilter("id", "in", releaseDataMap.keySet());
        QFilter predictF = new QFilter("ispredict", "=", (Object)Boolean.FALSE);
        QFilter weakF = new QFilter("isweak", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection records = ReserveRecordHelper.queryReserveRecordList(idF.and(predictF).and(weakF));
        for (DynamicObject record : records) {
            ReleaseData releaseData = releaseDataMap.get(record.get("id"));
            record.set("base_qty", (Object)releaseData.getBaseQty().negate());
            record.set("qty", (Object)releaseData.getQty().negate());
            record.set("qty2nd", (Object)releaseData.getQty2nd().negate());
        }
        if (checkNegative.booleanValue()) {
            ReserveRecordHandler.unReleaseReserveRecord((Collection<DynamicObject>)records);
        } else {
            ReserveRecordHandler.releaseReserveRecord((Collection<DynamicObject>)records);
        }
    }

    private static Map<Object, ReleaseData> groupReleaseData(List<DynamicObject> releaseDatas) {
        HashMap<Object, ReleaseData> releaseDataMap = new HashMap<Object, ReleaseData>();
        for (DynamicObject releaseData : releaseDatas) {
            ReleaseData tempRecord = new ReleaseData();
            long reserveId = releaseData.getLong("reserve_record");
            tempRecord.setReserveId(reserveId);
            tempRecord.setBaseQty(releaseData.getBigDecimal("base_qty"));
            tempRecord.setQty(releaseData.getBigDecimal("qty"));
            tempRecord.setQty2nd(releaseData.getBigDecimal("qty2nd"));
            ReleaseData release = (ReleaseData)releaseDataMap.get(reserveId);
            if (release != null) {
                ReserveRecordHandler.mergeReleaseData(release, tempRecord);
                continue;
            }
            releaseDataMap.put(tempRecord.getReserveId(), tempRecord);
        }
        return releaseDataMap;
    }

    /*
     * WARNING - void declaration
     */
    private static void releaseQty(List<DynamicObject> releaseDatas, Map<Object, ReleaseData> releaseDataMap, boolean isUnDo, boolean realDelete) {
        List<Object[]> params = ReserveRecordHandler.getParam4Reserve(releaseDataMap.values());
        MainEntityType metaData = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record");
        String baseQtyCol = metaData.findProperty("base_qty").getAlias();
        String qtyCol = metaData.findProperty("qty").getAlias();
        String qty2ndCol = metaData.findProperty("qty2nd").getAlias();
        String routeKey = metaData.getDBRouteKey();
        String tb = metaData.getAlias();
        StringBuilder sql = new StringBuilder(" UPDATE ");
        sql.append(tb).append(" SET ");
        sql.append(baseQtyCol).append(" = ").append(baseQtyCol).append(" - ?,");
        sql.append(qtyCol).append(" = ").append(qtyCol).append(" - ?,");
        sql.append(qty2ndCol).append(" = ").append(qty2ndCol).append(" - ? WHERE FID = ?");
        if (isUnDo) {
            ArrayList<Object> ids = new ArrayList<Object>(releaseDatas.size());
            IDataEntityType dataEntityType = null;
            for (DynamicObject releaseData : releaseDatas) {
                ids.add(releaseData.getPkValue());
                dataEntityType = releaseData.getDataEntityType();
            }
            if (realDelete) {
                DeleteServiceHelper.delete(dataEntityType, (Object[])ids.toArray());
            } else {
                String updateSql = "update t_msmod_release_record set fdeletestatus ='1' where fid =?";
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(ids.size());
                for (Object e : ids) {
                    paramList.add(new Object[]{e});
                }
                if (paramList.size() > 0 && dataEntityType != null) {
                    DB.executeBatch((DBRoute)new DBRoute(dataEntityType.getDBRouteKey()), (String)updateSql, BalanceHelper.sortSqlParamList(paramList));
                }
            }
        } else {
            SaveServiceHelper.save((DynamicObject[])releaseDatas.toArray(new DynamicObject[0]));
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)routeKey), (String)sql.toString(), params);
        QFilter fs = new QFilter("id", "in", releaseDataMap.keySet());
        QFilter negativeFs = new QFilter("base_qty", "<", (Object)0);
        negativeFs.or("qty", "<", (Object)0);
        negativeFs.or("qty2nd", "<", (Object)0);
        fs.and(negativeFs);
        String selectFields = "id,base_qty,qty,qty2nd";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ReserveRecordHandler:releaseQty", (String)"msmod_reserve_record", (String)selectFields, (QFilter[])fs.toArray(), null);
        StringBuilder msg = new StringBuilder();
        boolean bl = false;
        for (Row row : dataSet) {
            void var17_19;
            if (++var17_19 > 0) {
                msg.append('\uff0c');
            }
            msg.append(row.get("id"));
        }
        if (msg.length() > 0) {
            String msgHead = ResUtil.formatMsg(ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u9884\u7559\u6570\u91cf\uff0c\u9884\u7559\u8bb0\u5f55ID", (String)"ReserveRecordHandler_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveRecordHandler_3", new Object[0]);
            throw new KDBizException(msgHead + msg + " ");
        }
    }

    private static void mergeReleaseData(ReleaseData targetRelease, ReleaseData release) {
        targetRelease.setBaseQty(targetRelease.getBaseQty().add(release.getBaseQty()));
        targetRelease.setQty(targetRelease.getQty().add(release.getQty()));
        targetRelease.setQty2nd(targetRelease.getQty2nd().add(release.getQty2nd()));
    }

    public static DynamicObjectCollection getReserveData(Object billId, Object billEntryId) {
        if (billId == null) {
            return null;
        }
        QFilter fs = new QFilter("bill_id", "=", billId);
        if (billEntryId != null) {
            fs.and("billentry_id", "=", billEntryId);
        }
        DynamicObjectCollection recordList = ReserveRecordHelper.queryReserveRecordList(fs);
        return recordList;
    }

    public static void reserveRemoveByBillId(Object billId, Object billEntryId, String systemId, boolean queryCheck) {
        ReserveRecordHandler.reserveRemoveByBillId(billId, billEntryId, null, systemId, queryCheck);
    }

    public static void reserveRemoveByBillId(Object billId, Object billEntryId, Object billEntrySeq, String systemId, boolean queryCheck) {
        QFilter fs = ReserveRecordHandler.getQueryReserveRecordFilter(billId, billEntryId, billEntrySeq);
        if (fs == null) {
            return;
        }
        DynamicObjectCollection recordList = ReserveRecordHelper.queryReserveRecordList(fs);
        if (recordList == null || recordList.isEmpty()) {
            if (queryCheck) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5206\u5f55\u201c%2$s\u201d\u7684\u5206\u5f55\u5e8f\u53f7\u201c%3$s\u201d\u6ca1\u6709\u9884\u7559\u8bb0\u5f55\u3002", (String)"ReserveRecordHandler_10", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), billId, billEntryId, billEntrySeq));
            }
            return;
        }
        ReserveRecordHandler.removeRecord((List<DynamicObject>)recordList);
    }

    public static void batchReserveRemoveByBillId(Set<Object> billIds) {
        QFilter filter = new QFilter("bill_id", "in", billIds);
        DynamicObjectCollection recordList = ReserveRecordHelper.queryReserveRecordList(filter);
        ReserveRecordHandler.removeRecord((List<DynamicObject>)recordList);
    }

    public static void reserveRemoveByRecordList(List<DynamicObject> recordList) {
        ThreadCache.put((Object)"ReserveOpName", (Object)"Extension");
        ThreadCache.put((Object)"ReserveOpType", (Object)"delete");
        ReserveRecordHandler.removeRecord(recordList);
    }

    private static QFilter getQueryReserveRecordFilter(Object billId, Object billEntryId, Object billEntrySeq) {
        if (billId == null) {
            return null;
        }
        QFilter fs = new QFilter("bill_id", "=", billId);
        if (billEntryId != null) {
            fs.and("billentry_id", "=", billEntryId);
        }
        if (billEntrySeq != null) {
            fs.and("billentry_seq", "=", billEntrySeq);
        }
        return fs;
    }

    public static void reserveRemoveByBillNo(String billNo, String sysId, boolean queryCheck) {
        if (StringUtils.isBlank((CharSequence)billNo)) {
            return;
        }
        QFilter fs = new QFilter("bill_no", "=", (Object)billNo);
        DynamicObjectCollection recordList = ReserveRecordHelper.queryReserveRecordList(fs);
        if (recordList.isEmpty()) {
            if (queryCheck) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u6ca1\u6709\u9884\u7559\u8bb0\u5f55\u3002", (String)"ReserveRecordHandler_11", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), billNo));
            }
            return;
        }
        ReserveRecordHandler.removeRecord((List<DynamicObject>)recordList);
    }

    private static void removeRecord(List<DynamicObject> recordList) {
        if (recordList == null || recordList.size() == 0) {
            return;
        }
        Object[] recordIds = new Object[recordList.size()];
        for (int i = 0; i < recordList.size(); ++i) {
            DynamicObject record = recordList.get(i);
            recordIds[i] = record.get("id");
        }
        try (TXHandle tx = TX.requiresNew((String)"DeleteReserveRecord");){
            try {
                ReserveRecordHandler.removeReserveBalance(recordList);
                ReserveOpLogHelper.createNewLogByRecord(recordList, false);
                QFilter filter = new QFilter("id", "in", (Object)recordIds);
                DeleteServiceHelper.delete((String)"msmod_reserve_record", (QFilter[])filter.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                String msg = StringUtils.join((Object[])new String[]{ResManager.loadKDString((String)"\u9884\u7559\u8bb0\u5f55\u89e3\u9664\u5931\u8d25\u3002", (String)"ReserveRecordHandler_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), e.getMessage()});
                throw new KDBizException(msg);
            }
        }
    }

    private static void removeReserveBalance(List<DynamicObject> recordList) {
        for (int i = 0; i < recordList.size(); ++i) {
            DynamicObject record = recordList.get(i);
            record.set("base_qty", (Object)record.getBigDecimal("base_qty").negate());
            record.set("qty", (Object)record.getBigDecimal("qty").negate());
            record.set("qty2nd", (Object)record.getBigDecimal("qty2nd").negate());
        }
        ReserveRecordHandler.releaseReserveRecord(recordList);
    }

    public static void reserveRemoveById(Long reserveId, boolean queryCheck) {
    }

    public static void reserveRemoveByBalId(Long billId, boolean queryCheck) {
    }

    public static void createReserveRecordNotSup(List<DynamicObject> records) {
        try (TXHandle tx = TX.required((String)"createReserveRecordNew");){
            try {
                ReserveRecordHandler.saveReserveRecord(records);
                ReserveOpLogHelper.createNewLogByRecord(records, false);
                Map<String, List<DynamicObject>> params = ReserveRecordHandler.groupByBalanceTable(records);
                for (Map.Entry<String, List<DynamicObject>> param : params.entrySet()) {
                    Map<String, ColsMap> colsMap = BalanceHelper.provideColsMapNew((Collection<DynamicObject>)param.getValue(), param.getKey());
                    BalanceHelper.writeBackDetailBalNotSup(param.getKey(), (Collection<DynamicObject>)param.getValue(), colsMap, true);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }
}

