/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;
import kd.mpscmm.msbd.reserve.common.util.ListSortUtils;
import kd.mpscmm.msbd.reserve.common.util.ResUtil;

public class SchemeHelper {
    public static DynamicObject getUsableSchemeForReqBill(DynamicObject bill) {
        MainEntityType billType = (MainEntityType)bill.getDataEntityType();
        String billName = billType.getName();
        Map<Object, DynamicObject> schemeMap = SchemeHelper.getAllSchemeByBillType(billName);
        return SchemeHelper.getScheme(schemeMap, bill);
    }

    public static Map<Object, DynamicObject> getAllSchemeByBillType(String billName) {
        QFilter fs = new QFilter("require_bill", "=", (Object)billName);
        fs = fs.and(new QFilter("status", "=", (Object)"A"));
        fs = fs.and(new QFilter("autoreserve", "=", (Object)Boolean.TRUE));
        Map<String, Object> aggCfg = ReserveAggregateHelper.getAggregateConfig();
        if (((Boolean)aggCfg.get("isAggregate")).booleanValue()) {
            if (!((Boolean)aggCfg.get("compatibleDetail")).booleanValue()) {
                fs = fs.and(new QFilter("aggregate", "=", (Object)Boolean.TRUE));
            }
        } else {
            fs = fs.and(new QFilter("aggregate", "!=", (Object)Boolean.TRUE));
        }
        return BusinessDataServiceHelper.loadFromCache((String)"msmod_reserve_scheme", (QFilter[])fs.toArray());
    }

    public static Map<Long, DynamicObject> getBillSchemeMap(String billName, DynamicObject[] requestBillArray) {
        Map<Object, DynamicObject> schemeMap = SchemeHelper.getAllSchemeByBillType(billName);
        HashMap<Long, DynamicObject> schemeBillMap = new HashMap<Long, DynamicObject>(requestBillArray.length);
        for (DynamicObject requestBill : requestBillArray) {
            schemeBillMap.put(requestBill.getLong("id"), SchemeHelper.getScheme(schemeMap, requestBill));
        }
        return schemeBillMap;
    }

    public static void groupRequestBillByScheme(String billName, DynamicObject[] requestBillArray) {
        Map<Object, DynamicObject> schemeMap = SchemeHelper.getAllSchemeByBillType(billName);
    }

    public static DynamicObject getScheme(Map<Object, DynamicObject> schemeMap, DynamicObject requestBill) {
        MainEntityType billType = (MainEntityType)requestBill.getDataEntityType();
        String mainOrg = billType.getMainOrg();
        DynamicObject org = null;
        if (mainOrg != null) {
            org = requestBill.getDynamicObject(mainOrg);
        }
        Map<Long, String> orgLotNum = SchemeHelper.getOrgLotNumMap(org, schemeMap.values());
        for (DynamicObject scheme : schemeMap.values()) {
            String schemeFilterStr;
            if (org != null && !SchemeHelper.checkApplyorg(scheme, (Long)org.getPkValue(), orgLotNum) || !FilterParser.execExcelFormula(schemeFilterStr = scheme.getString("req_filter_value"), requestBill)) continue;
            return scheme;
        }
        return null;
    }

    public static Map<Long, String> getOrgLotNumMap(DynamicObject org, Collection<DynamicObject> values) {
        HashMap<Long, String> orgLongNumMap = new HashMap<Long, String>(16);
        if (org == null) {
            return orgLongNumMap;
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (DynamicObject scheme : values) {
            DynamicObjectCollection orgentrys = scheme.getDynamicObjectCollection("orgentry");
            if (orgentrys.isEmpty()) continue;
            for (DynamicObject orgentry : orgentrys) {
                DynamicObject entryOrg;
                boolean isInclude = orgentry.getBoolean("isincludesuborg");
                if (!isInclude || (entryOrg = orgentry.getDynamicObject("orgid")) == null || entryOrg.getPkValue() == null) continue;
                orgIds.add((Long)entryOrg.getPkValue());
            }
        }
        if (orgIds.isEmpty()) {
            return orgLongNumMap;
        }
        orgIds.add((Long)org.getPkValue());
        QFilter qFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        qFilter = qFilter.and(new QFilter("org", "in", orgIds));
        qFilter = qFilter.and(new QFilter("view.number", "=", (Object)"15"));
        qFilter = qFilter.and(new QFilter("view.isdefault", "=", (Object)"1"));
        DataSet orgData = QueryServiceHelper.queryDataSet((String)"SchemeHelper:getOrgLotNumMap()", (String)"bos_org_structure", (String)"org,longnumber", (QFilter[])qFilter.toArray(), null);
        while (orgData.hasNext()) {
            Row row = orgData.next();
            orgLongNumMap.put(row.getLong("org"), row.getString("longnumber"));
        }
        return orgLongNumMap;
    }

    public static boolean checkApplyorg(DynamicObject scheme, Long orgId, Map<Long, String> orgLotNum) {
        DynamicObject orgentry;
        Long entryOrgId;
        boolean isMatch = false;
        DynamicObjectCollection orgentrys = scheme.getDynamicObjectCollection("orgentry");
        if (orgentrys.isEmpty()) {
            return true;
        }
        Iterator iterator = orgentrys.iterator();
        while (iterator.hasNext() && !(isMatch = orgId.equals(entryOrgId = Long.valueOf((orgentry = (DynamicObject)iterator.next()).getLong("orgid.id"))))) {
            boolean isInclude = orgentry.getBoolean("isincludesuborg");
            if (isInclude) {
                String subOrgLongNum = orgLotNum.get(orgId);
                String supOrgLongNum = orgLotNum.get(entryOrgId);
                if (!StringUtils.isEmpty((CharSequence)subOrgLongNum) && !StringUtils.isEmpty((CharSequence)supOrgLongNum)) {
                    isMatch = subOrgLongNum.startsWith(supOrgLongNum + '!');
                }
            }
            if (!isMatch) continue;
            break;
        }
        return isMatch;
    }

    public static DynamicObjectCollection sortCollectionByField(DynamicObjectCollection collection, final String field) {
        DynamicObjectCollection cloneStrategyCollection = (DynamicObjectCollection)collection.clone();
        cloneStrategyCollection.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject arg0, DynamicObject arg1) {
                return arg0.getInt(field) - arg1.getInt(field);
            }
        });
        return cloneStrategyCollection;
    }

    public static DynamicObject getFirstRule(DynamicObject scheme) {
        DynamicObjectCollection strategyColl = scheme.getDynamicObjectCollection("strategy_entry");
        if (strategyColl != null && strategyColl.size() > 0) {
            DynamicObject strategy = ((DynamicObject)strategyColl.get(0)).getDynamicObject("strategy");
            DynamicObjectCollection ruleColl = (strategy = BusinessDataServiceHelper.loadSingleFromCache((Object)strategy.getPkValue(), (String)strategy.getDynamicObjectType().getName())).getDynamicObjectCollection("rule_entry");
            if (ruleColl != null && ruleColl.size() > 0) {
                DynamicObject value = ((DynamicObject)ruleColl.get(0)).getDynamicObject("reserve_inv_rule");
                DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)value.getPkValue(), (String)"msmod_reserve_inv_rule");
                return rule;
            }
        }
        return null;
    }

    static Map<Long, List<DynamicObject>> getSortRequestBillList(DynamicObject[] requestBillArray, Map<Object, DynamicObject> schemeMap) {
        HashMap<Long, List<DynamicObject>> schemeBillListMap = new HashMap<Long, List<DynamicObject>>(8);
        for (DynamicObject requestBill : requestBillArray) {
            DynamicObject usableScheme = SchemeHelper.getScheme(schemeMap, requestBill);
            if (usableScheme == null) {
                throw new KDBizException(ResUtil.formatMsg(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u9884\u7559\u65b9\u6848\uff0c\u8bf7\u5148\u589e\u52a0\u9884\u7559\u65b9\u6848\u3002", (String)"ReserveContext_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveContext_0", requestBill.getPkValue()));
            }
            long schemeId = usableScheme.getLong("id");
            ArrayList<DynamicObject> billList = (ArrayList<DynamicObject>)schemeBillListMap.get(schemeId);
            if (billList == null) {
                billList = new ArrayList<DynamicObject>(8);
                schemeBillListMap.put(schemeId, billList);
            }
            billList.add(requestBill);
        }
        for (Map.Entry entry : schemeBillListMap.entrySet()) {
            long schemeId = (Long)entry.getKey();
            List billList = (List)entry.getValue();
            DynamicObject usableScheme = schemeMap.get(schemeId);
            DynamicObjectCollection sortRuleCol = usableScheme.getDynamicObjectCollection("sort_entry");
            if (sortRuleCol == null || sortRuleCol.size() <= 0) continue;
            String[] sortNameArr = new String[sortRuleCol.size()];
            boolean[] ascArr = new boolean[sortRuleCol.size()];
            for (int i = 0; i < sortRuleCol.size(); ++i) {
                DynamicObject sortRule = (DynamicObject)sortRuleCol.get(i);
                sortNameArr[i] = sortRule.getString("sort_field_no");
                ascArr[i] = "asc".equals(sortRule.getString("sort_way"));
            }
            ListSortUtils.sort(billList, sortNameArr, ascArr);
        }
        return schemeBillListMap;
    }
}

