/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.SchemeHelper;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;

public class StrategyHelper {
    public static boolean isUsable(DynamicObject strategy, DynamicObject requestBill) {
        String billName = requestBill.getDynamicObjectType().getName();
        String strategyFilter = strategy.getString("filter_value_tag");
        QFilter qFilter = FilterParser.parseFilter(strategyFilter, billName);
        qFilter.and(new QFilter("id", "=", requestBill.getPkValue()));
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)billName, (QFilter[])qFilter.toArray());
        return data != null;
    }

    public static DynamicObjectCollection getRuleList(DynamicObject strategy) {
        DynamicObjectCollection ruleList = new DynamicObjectCollection();
        if (strategy != null) {
            strategy = strategy.getDynamicObject("strategy");
            strategy = BusinessDataServiceHelper.loadSingleFromCache((Object)strategy.getPkValue(), (String)strategy.getDynamicObjectType().getName());
            DynamicObjectCollection ruleColl = strategy.getDynamicObjectCollection("rule_entry");
            if ((ruleColl = SchemeHelper.sortCollectionByField(ruleColl, "rule_seq")) != null && ruleColl.size() > 0) {
                ruleColl.forEach(value -> {
                    DynamicObject tmpRule = value.getDynamicObject("reserve_inv_rule");
                    DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)tmpRule.getPkValue(), (String)"msmod_reserve_inv_rule");
                    ruleList.add((Object)rule);
                });
            }
        }
        return ruleList;
    }
}

