/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ConvRate;

public class UnitHelper {
    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.equals(desUnitId)) {
            unitRate = BigDecimal.ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt("numerator") != 0) {
                unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    public static ConvRate getConvRate(Long materialId, Long srcUnitId, Long desUnitId) {
        if (materialId == null || srcUnitId == null || desUnitId == null || srcUnitId.equals(desUnitId)) {
            return ConvRate.getInstance();
        }
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        if (muConv == null || muConv.getInt("numerator") == 0) {
            return ConvRate.getInstance();
        }
        return ConvRate.getInstance(muConv.getInt("numerator"), muConv.getInt("denominator"));
    }

    public static boolean isExistField(IDataModel bill, String fieldName) {
        Map type = bill.getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)type.get("billentry");
        Map map = entityType.getFields();
        boolean isExist = false;
        for (Map.Entry field : map.entrySet()) {
            if (!fieldName.equals(field.getKey())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public static boolean isExistField(IDataModel bill, String entryName, String fieldName) {
        Map type = bill.getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)type.get(entryName);
        Map map = entityType.getFields();
        boolean isExist = false;
        for (Map.Entry field : map.entrySet()) {
            if (!fieldName.equals(field.getKey())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }
}

