/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.datasource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class ColsMap {
    private static final String F_DATA_SOURCE = "data_source";
    private static final String F_COLS_MAP = "cols_map";
    private Map<String, String> balColMap = null;
    private Map<String, String> billColMap = null;
    private String mapNumber = null;
    private String mapName = null;
    private long mapId = 0L;
    private static ColsMap realBalanceColsMap;

    private ColsMap() {
    }

    public ColsMap(DynamicObject dbColsMap) {
        DynamicObjectCollection rows = dbColsMap.getDynamicObjectCollection("colsmap");
        String keyCol = "targetobjcol";
        String valCol = "sourcebillcol";
        DynamicObject srcBill = dbColsMap.getDynamicObject("sourcebill");
        MainEntityType billType = MetadataServiceHelper.getDataEntityType((String)((String)srcBill.getPkValue()));
        HashedMap tempBillColMap = new HashedMap(16);
        HashedMap tempBalColMap = new HashedMap(16);
        for (DynamicObject row : rows) {
            String val = row.getString(valCol);
            if (StringUtils.isBlank((CharSequence)val) || "1".equals(row.getString("selectvalue"))) {
                String formula = row.getString("formula_tag");
                Map formulaMap = (Map)SerializationUtils.fromJsonString((String)formula, Map.class);
                val = (String)formulaMap.get("expression");
                if (StringUtils.isBlank((CharSequence)val)) {
                    tempBalColMap.put(row.getString(keyCol), val);
                    tempBillColMap.put(val, row.getString(keyCol));
                    continue;
                }
                val = this.handleForMulaField(billType, val, null);
            }
            tempBalColMap.put(row.getString(keyCol), val);
            tempBillColMap.put(val, row.getString(keyCol));
        }
        this.billColMap = Collections.unmodifiableMap(tempBillColMap);
        this.balColMap = Collections.unmodifiableMap(tempBalColMap);
        this.mapNumber = dbColsMap.getString("number");
        this.mapName = dbColsMap.getString("name");
        this.mapId = dbColsMap.getLong("id");
    }

    private String handleForMulaField(MainEntityType billType, String val, String sym) {
        if (StringUtils.isBlank((CharSequence)sym)) {
            sym = "\\+";
        }
        String[] addSpl = val.split(sym);
        for (int i = 0; i < addSpl.length; ++i) {
            IDataEntityType parent;
            String key = addSpl[i].trim();
            String[] split = key.split("-");
            if (split.length > 1) {
                addSpl[i] = this.handleForMulaField(billType, key, "-");
                continue;
            }
            IDataEntityProperty prop = billType.findProperty(key);
            if (prop == null || !((parent = prop.getParent()) instanceof EntryType)) continue;
            addSpl[i] = parent.getName() + '.' + key;
        }
        StringBuilder sb = new StringBuilder(addSpl[0]);
        for (int i = 1; i < addSpl.length; ++i) {
            sb.append(sym).append(addSpl[i]);
        }
        String sbString = sb.toString();
        sbString = sbString.replace("\\", "");
        return sbString;
    }

    public static ColsMap getColsMap(DynamicObject sourceConf) {
        ColsMap cols = new ColsMap();
        cols.init(sourceConf);
        return cols;
    }

    public static ColsMap getDefaultColsMap(String balName) {
        switch (balName) {
            case "im_inv_realbalance": {
                return ColsMap.getInvColsMap();
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"ColsMap\u4e0d\u652f\u6301\u4f59\u989d\u8868\u201c%1$s\u201d\u7684\u9ed8\u8ba4\u5b57\u6bb5\u914d\u7f6e\u3002", (String)"ColsMap_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), balName));
    }

    private static ColsMap getInvColsMap() {
        if (realBalanceColsMap == null) {
            ColsMap cols = new ColsMap();
            HashMap<String, String> balColMap = new HashMap<String, String>(32);
            HashMap<String, String> billColMap = new HashMap<String, String>(32);
            cols.balColMap = balColMap;
            cols.billColMap = billColMap;
            balColMap.put("lockbaseqty", "reserve_base_qty");
            balColMap.put("lockqty", "reserve_qty");
            balColMap.put("lockqty2nd", "reserve_qty2nd");
            balColMap.put("baseqty", "baseqty");
            balColMap.put("qty", "qty");
            balColMap.put("qty2nd", "qty2nd");
            for (Map.Entry entry : balColMap.entrySet()) {
                billColMap.put((String)entry.getValue(), (String)entry.getKey());
            }
            realBalanceColsMap = cols;
        }
        return realBalanceColsMap;
    }

    private void init(DynamicObject sourceConf) {
        String actualBalEntity = sourceConf.getDynamicObject(F_DATA_SOURCE).getPkValue().toString();
        DynamicObject colsMap = sourceConf.getDynamicObject(F_COLS_MAP);
        DynamicObject dbColsMap = BusinessDataServiceHelper.loadSingleFromCache((Object)colsMap.getPkValue(), (String)colsMap.getDynamicObjectType().getName());
        DynamicObjectCollection rows = dbColsMap.getDynamicObjectCollection("colsmap");
        String keyCol = "targetobjcol";
        String valCol = "sourcebillcol";
        HashedMap tempBillColMap = new HashedMap(16);
        HashedMap tempBalColMap = new HashedMap(16);
        for (DynamicObject row : rows) {
            tempBalColMap.put(row.getString(keyCol), row.getString(valCol));
            tempBillColMap.put(row.getString(valCol), row.getString(keyCol));
        }
        boolean balIsSourceCol = actualBalEntity.equals(dbColsMap.getDynamicObject("sourcebill").getPkValue());
        this.billColMap = Collections.unmodifiableMap(balIsSourceCol ? tempBillColMap : tempBalColMap);
        this.balColMap = Collections.unmodifiableMap(balIsSourceCol ? tempBalColMap : tempBillColMap);
    }

    public Map<String, String> getBalColMap() {
        return this.balColMap;
    }

    public Map<String, String> getBillColMap() {
        return this.billColMap;
    }

    public String getByBalCol(String balCol) {
        return this.balColMap.get(balCol);
    }

    public String getByBillCol(String billCol) {
        return this.billColMap.get(billCol);
    }

    public String getMapNumber() {
        return this.mapNumber;
    }

    public String getMapName() {
        return this.mapName;
    }

    public long getMapId() {
        return this.mapId;
    }
}

