/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.datasource;

import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.datasource.DataReader;
import kd.mpscmm.msbd.reserve.business.datasource.DataReaderFactory;
import kd.mpscmm.msbd.reserve.business.datasource.DefaultDataReader;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.RuleParser;

public class DataSourceHelper {
    private static final Log logger = LogFactory.getLog(DataSourceHelper.class);

    public static DataSet getUsableDataByRule(ReserveContext context, DynamicObject rule, DynamicObject requestEntry) {
        DynamicObject supSrcObj = rule.getDynamicObject("supsrcobj");
        String supBillFormId = supSrcObj == null ? "im_inv_realbalance" : (String)supSrcObj.getPkValue();
        DataSet totalData = null;
        try (TraceSpan batchSpan = Tracer.create((String)"DataSourceHelper", (String)"getUsableDataByRule");){
            DataSet dataSet;
            logger.info("\u8bfb\u53d6\u6570\u636e\uff0c entryId\uff1a" + context.getEntryId(requestEntry));
            DataReader dataReader = DataReaderFactory.getDataReader();
            logger.info("\u4ecedatasource\uff1a \u3010" + supBillFormId + "\u3011\uff0c\u8bfb\u53d6\u6570\u636e.");
            ColsMap cols = context.getSupColsMap(supBillFormId);
            QFilter filter = RuleParser.toQFilter(rule, cols.getBalColMap(), context.getRequestBill(), requestEntry).and(context.getSchemeFilter());
            logger.info("\u8fc7\u6ee4\u6570\u636e\u7684Filter\u4e3a\uff1a " + filter);
            totalData = dataSet = dataReader.readData(supBillFormId, filter, cols, rule.getBoolean("ispredict"));
        }
        return totalData;
    }

    public static DataSet getUsableDataByRule(ReserveContext context, DynamicObject rule, DynamicObject requestEntry, QFilter additionalFilter) {
        if (additionalFilter == null) {
            additionalFilter = new QFilter("1", "=", (Object)1);
        }
        DataSet totalData = null;
        DynamicObject supSrcObj = rule.getDynamicObject("supsrcobj");
        String supBillFormId = supSrcObj == null ? "im_inv_realbalance" : (String)supSrcObj.getPkValue();
        try (TraceSpan batchSpan = Tracer.create((String)"DataSourceHelper", (String)"getUsableDataByRule");){
            DataSet dataSet;
            logger.info("\u8bfb\u53d6\u6570\u636e\uff0c entryId\uff1a" + context.getEntryId(requestEntry));
            DefaultDataReader dataReader = new DefaultDataReader();
            logger.info("\u4ecedatasource\uff1a \u3010" + supBillFormId + "\u3011\uff0c\u8bfb\u53d6\u6570\u636e.");
            ColsMap cols = context.getSupColsMap(supBillFormId);
            QFilter filter = RuleParser.toQFilter(rule, cols.getBalColMap(), context.getRequestBill(), requestEntry).and(context.getSchemeFilter()).and(additionalFilter);
            logger.info("\u8fc7\u6ee4\u6570\u636e\u7684Filter\u4e3a\uff1a " + filter);
            totalData = dataSet = dataReader.readData(supBillFormId, filter, cols, rule.getBoolean("ispredict"));
        }
        return totalData;
    }
}

