/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.decision.warehouse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.decision.Node;
import kd.mpscmm.msbd.reserve.business.decision.NodeFactory;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;

public class WarehouseNodeFactory
implements NodeFactory {
    @Override
    public Node newNode(Node parent, Map<Object, Object> args) {
        if (args == null || args.size() <= 0) {
            return null;
        }
        Node node = new Node();
        node.setParent(parent);
        this.setWarehouse(node, args);
        this.callReserveService(node, args);
        return node;
    }

    private void setWarehouse(Node curNode, Map<Object, Object> args) {
        if (curNode.getParent() == null) {
            ArrayList warehouseList = (ArrayList)args.get("warehouse_list");
            if (warehouseList == null) {
                warehouseList = new ArrayList();
            }
            curNode.getValueMap().put("warehouse_list", args.get("warehouse_list"));
            if (!warehouseList.isEmpty()) {
                curNode.getValueMap().put("cur_warehouse", warehouseList.get(0));
            }
        } else {
            List parentList = (List)curNode.getParent().getValueMap().get("warehouse_list");
            ArrayList warehouseList = new ArrayList(parentList.size());
            warehouseList.addAll(parentList);
            if (!warehouseList.isEmpty()) {
                warehouseList.remove(0);
            }
            curNode.getValueMap().put("warehouse_list", warehouseList);
            if (!warehouseList.isEmpty()) {
                curNode.getValueMap().put("cur_warehouse", warehouseList.get(0));
            }
        }
        curNode.getValueMap().put("compare_property", args.get("compare_property"));
    }

    private void callReserveService(Node curNode, Map<Object, Object> args) {
        ReserveContext parentContext;
        if (args == null || args.size() <= 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u9700\u6c42\u5355\u636e\u3002", (String)"WarehouseNodeFactory_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        Object warehouseId = curNode.getValueMap().get("cur_warehouse");
        String compareProperty = (String)curNode.getValueMap().get("compare_property");
        DynamicObject reserveRequestBill = null;
        if (curNode.getValueMap().get("cur_request_bill") == null) {
            curNode.getValueMap().put("cur_request_bill", args.get("cur_request_bill"));
        }
        if (curNode.getValueMap().get("request_bill") == null) {
            curNode.getValueMap().put("request_bill", args.get("request_bill"));
        }
        if (curNode.getValueMap().get("cur_request_bill") != null) {
            reserveRequestBill = (DynamicObject)curNode.getValueMap().get("cur_request_bill");
        } else {
            reserveRequestBill = (DynamicObject)curNode.getValueMap().get("request_bill");
            curNode.getValueMap().put("cur_request_bill", reserveRequestBill);
        }
        if (compareProperty == null) {
            compareProperty = "warehouse";
        }
        QFilter filter = new QFilter(compareProperty, "=", (Object)Long.valueOf(warehouseId.toString()));
        ReserveContext reserveContext = parentContext = curNode.getParent() != null ? (ReserveContext)curNode.getParent().getValueMap().get("context") : null;
        if (parentContext == null) {
            parentContext = (ReserveContext)args.get("context");
        }
        curNode.getValueMap().put("context", parentContext);
        BillReserveResult result = ReserveHelper.reserveBill(reserveRequestBill, filter, parentContext);
        curNode.getValueMap().put("reserve_result", result);
    }
}

