/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.reserve.common.constant.NegativeTipConfConst;

public class NegativeTipHelper {
    public static String dealSimpleMsg(String negativeMsg) {
        if (StringUtils.isEmpty((String)negativeMsg)) {
            return null;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)negativeMsg);
        Map<Long, DynamicObject> dataMap = NegativeTipHelper.getBalData(jsonArray);
        return NegativeTipHelper.getMsg(jsonArray, dataMap);
    }

    private static Map<Long, DynamicObject> getBalData(JSONArray jsonArray) {
        JSONArray configFields = jsonArray.getJSONObject(0).getJSONArray("config");
        if (configFields == null || configFields.size() == 0) {
            return null;
        }
        String entityName = jsonArray.getJSONObject(0).getString("balentityname");
        ArrayList<Long> balIds = new ArrayList<Long>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            balIds.add(jsonArray.getJSONObject(i).getLong("balId"));
        }
        StringBuilder buffer = new StringBuilder();
        BalanceTB tb = BalanceTB.getBalanceTB((String)entityName);
        List keyCols = tb.getKeyCols();
        keyCols.forEach(field -> buffer.append((String)field).append(","));
        buffer.append("keycol").append(",");
        buffer.append("id");
        QFilter qFilter = new QFilter("id", "in", balIds);
        DynamicObject[] data = BusinessDataServiceHelper.load((String)entityName, (String)buffer.toString(), (QFilter[])qFilter.toArray());
        Map<Long, DynamicObject> dataMap = Arrays.asList(data).stream().collect(Collectors.toMap(item -> item.getLong("id"), k -> k));
        return dataMap;
    }

    private static String getMsg(JSONArray jsonArray, Map<Long, DynamicObject> dataMap) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            builder.append(jsonObject.getString("bill")).append("\uff0c");
            if (dataMap != null) {
                builder.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3\u3002", (String)"NegativeTipHelper_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                DynamicObject dynamicObject = dataMap.get(jsonObject.getLong("balId"));
                JSONArray configFields = jsonArray.getJSONObject(0).getJSONArray("config");
                for (int j = 0; j < configFields.size(); ++j) {
                    JSONObject configField = configFields.getJSONObject(j);
                    String field = configField.getString("field");
                    if (dynamicObject.get(field) == null || Long.valueOf(0L).equals(dynamicObject.get(field))) continue;
                    builder.append(configField.getString("fieldName")).append("\uff1a");
                    builder.append(NegativeTipHelper.getShowValue(dynamicObject, field, configField.getInteger("showprop"))).append("\uff0c");
                }
            }
            String qtyStr = jsonObject.getString("qty");
            builder.append(qtyStr);
        }
        return builder.toString();
    }

    public static Object getSpecialType(String field, Integer showProp) {
        if ("bos_org".equals(field)) {
            String loadKDString = ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7", (String)"NegativeTipHelper_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            return NegativeTipHelper.getTypeValue(field, showProp, loadKDString);
        }
        if ("bd_customer".equals(field)) {
            String loadKDString = ResManager.loadKDString((String)"\u5ba2\u6237", (String)"NegativeTipHelper_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            return NegativeTipHelper.getTypeValue(field, showProp, loadKDString);
        }
        if ("bd_supplier".equals(field)) {
            String loadKDString = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"NegativeTipHelper_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            return NegativeTipHelper.getTypeValue(field, showProp, loadKDString);
        }
        return null;
    }

    private static String getTypeValue(String field, Integer showProp, String loadKDString) {
        if (NegativeTipConfConst.SHOWPROP_BOTH.equals(showProp)) {
            StringBuilder showValue = new StringBuilder();
            showValue.append(field).append("\uff08").append(loadKDString).append("\uff09");
            return showValue.toString();
        }
        if (NegativeTipConfConst.SHOWPROP_NAME.equals(showProp)) {
            return loadKDString;
        }
        return field;
    }

    public static Object getShowValue(DynamicObject dynamicObject, String field, Integer showProp) {
        if (Arrays.asList(NegativeTipConfConst.SPECIAL_FIELD_TYPE).contains(field)) {
            return NegativeTipHelper.getSpecialType(dynamicObject.getString(field), showProp);
        }
        Object obj = dynamicObject.get(field);
        StringBuilder showValue = new StringBuilder();
        if (obj instanceof DynamicObject) {
            DynamicObject fieldDym = (DynamicObject)obj;
            boolean containsNum = fieldDym.containsProperty("number");
            boolean containsName = fieldDym.containsProperty("name");
            if (NegativeTipConfConst.SHOWPROP_BOTH.equals(showProp) && containsNum) {
                if (containsName) {
                    showValue.append(fieldDym.getString("number")).append("\uff08").append(fieldDym.getString("name")).append("\uff09");
                } else {
                    showValue.append(fieldDym.getString("number"));
                }
            } else if (NegativeTipConfConst.SHOWPROP_NAME.equals(showProp) && containsName) {
                showValue.append(fieldDym.getString("name"));
            } else if (NegativeTipConfConst.SHOWPROP_NUMBER.equals(showProp) && containsNum) {
                showValue.append(fieldDym.getString("number"));
            }
            return showValue.toString();
        }
        if (obj instanceof Timestamp && obj.toString().contains(" 00:00:00.0")) {
            return obj.toString().replace(" 00:00:00.0", "");
        }
        return obj;
    }
}

