/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;

public class ReserveRecordDataSetHelper {
    private String recordSelectSql = null;
    private static final String SUP_SEQ = "s_entryseq";
    private static final List<String> recordFieldList = Arrays.asList("bill_obj", "bal_obj", "bal_id", "bal_entryid", "bill_no", "bill_id", "billentry_id", "reserve_scheme", "create_date", "reserveprctype", "base_qty", "qty", "qty2nd", "billentry_seq");
    private Set<String> recordFieldSet = new HashSet<String>(recordFieldList);
    private Set<String> billModelFieldSet = new HashSet<String>(Collections.singletonList("bill_entry"));
    private Set<String> balModelFieldSet = new HashSet<String>(16);
    private static Log logger = LogFactory.getLog(ReserveRecordDataSetHelper.class);

    public DataSet getReserveRecordInfo(List<QFilter> recordFilter) {
        this.initSelectInfo();
        String algoKey = this.getClass().getName() + ":upgradeReserveRecord";
        DataSet reserveRecord = null;
        logger.info("ReserveRecordNewFiledsUpServiceImpl:\u5f00\u59cb\u67e5\u8be2\u9884\u7559\u8bb0\u5f55\u57fa\u672c\u4fe1\u606f\u3002");
        reserveRecord = QueryServiceHelper.queryDataSet((String)algoKey, (String)"msmod_reserve_record", (String)this.recordSelectSql, (QFilter[])recordFilter.toArray(new QFilter[recordFilter.size()]), null);
        logger.info("ReserveRecordNewFiledsUpServiceImpl:\u7ed3\u675f\u67e5\u8be2\u9884\u7559\u8bb0\u5f55\u57fa\u672c\u4fe1\u606f\u3002");
        HashMap<String, Set<Object>> billIdMap = new HashMap<String, Set<Object>>(16);
        HashMap<String, Set<Object>> balIdMap = new HashMap<String, Set<Object>>(16);
        this.collectBalIdAndBillId(reserveRecord.copy(), billIdMap, balIdMap);
        if (!billIdMap.isEmpty() && !balIdMap.isEmpty()) {
            reserveRecord = this.getBalAndBillData(algoKey, reserveRecord, billIdMap, balIdMap);
        }
        return reserveRecord;
    }

    private void initSelectInfo() {
        Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
        this.billModelFieldSet = new HashSet<String>(Collections.singletonList("bill_entry"));
        this.balModelFieldSet = new HashSet<String>(16);
        for (String key : allFieldMap.keySet()) {
            if (key.startsWith("r_")) {
                this.billModelFieldSet.add(key);
                continue;
            }
            if (key.startsWith("s_")) {
                this.balModelFieldSet.add(key);
                continue;
            }
            if ("reserveid".equals(key)) continue;
            this.recordFieldSet.add(key);
        }
        this.buildRecordSelectSql();
    }

    private void buildRecordSelectSql() {
        StringBuilder sb = new StringBuilder();
        for (String field : this.recordFieldSet) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(field);
        }
        this.recordSelectSql = sb.append(",id as reserveid").toString();
    }

    private void collectBalIdAndBillId(DataSet copy, Map<String, Set<Object>> billIdMap, Map<String, Set<Object>> balIdMap) {
        while (copy.hasNext()) {
            Row next = copy.next();
            String billNum = next.getString("bill_obj");
            String balNum = next.getString("bal_obj");
            Set<Object> billIds = billIdMap.get(billNum);
            Set<Object> balIds = balIdMap.get(balNum);
            if (billIds == null) {
                billIds = new HashSet<Object>(16);
                billIdMap.put(billNum, billIds);
            }
            if (balIds == null) {
                balIds = new HashSet<Object>(16);
                balIdMap.put(balNum, balIds);
            }
            billIds.add(next.get("bill_id"));
            balIds.add(next.get("bal_id"));
        }
    }

    private DataSet getBalAndBillData(String algoKey, DataSet reserveRecord, Map<String, Set<Object>> billIdMap, Map<String, Set<Object>> balIdMap) {
        Map<String, String> balSelectMap = this.getSupBillSelectSqlMap(balIdMap.keySet(), this.balModelFieldSet, ReserveHelper.getBalDefaultMap(), "msmod_std_inv_field");
        DataSet balData = ReserveHelper.queryObjData(algoKey, balIdMap, balSelectMap);
        logger.info("ReserveRecordNewFiledsUpServiceImpl:\u6784\u9020\u4f9b\u65b9\u4fe1\u606fdataset\u3002");
        reserveRecord = reserveRecord.join(balData, JoinType.LEFT).on("bal_entryid", "entryid").select(reserveRecord.getRowMeta().getFieldNames(), balData.getRowMeta().getFieldNames()).finish();
        logger.info("ReserveRecordNewFiledsUpServiceImpl:\u7ed3\u675f\u6784\u9020\u4f9b\u65b9\u4fe1\u606f\u3002");
        Map<String, String> billSelectMap = this.getBillSelectSqlMap(billIdMap.keySet(), this.billModelFieldSet, ReserveHelper.getBillDefaultMap(), "msmod_std_request_bill");
        DataSet billData = ReserveHelper.queryObjData(algoKey, billIdMap, billSelectMap);
        if (billData == null) {
            return reserveRecord;
        }
        logger.info("ReserveRecordNewFiledsUpServiceImpl:\u5f00\u59cb\u6784\u9020\u9700\u65b9\u4fe1\u606f\u3002");
        reserveRecord = reserveRecord.join(billData, JoinType.LEFT).on("billentry_id", "bill_entry").select(reserveRecord.getRowMeta().getFieldNames(), billData.getRowMeta().getFieldNames()).finish();
        logger.info("ReserveRecordNewFiledsUpServiceImpl:\u7ed3\u675f\u6784\u9020\u9700\u65b9\u4fe1\u606f\u3002");
        return reserveRecord;
    }

    private Map<String, String> getSupBillSelectSqlMap(Set<String> billObjs, Set<String> modelFields, Map<String, Object> fieldDefaultMap, String modelFormId) {
        Map<String, ColsMap> billColMaps = ColsMapHelper.findBillColMaps(billObjs, modelFormId);
        Map<String, String> sqlKeyMap = this.getEntrySeqMap(billObjs, billColMaps);
        Map<String, String> billSelectSqlMap = this.getBillSelectSqlMap(billObjs, modelFields, fieldDefaultMap, modelFormId);
        Iterator<String> it = billSelectSqlMap.values().iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        for (Map.Entry<String, String> entrySql : billSelectSqlMap.entrySet()) {
            if (entrySql.getValue() == null) continue;
            String key = entrySql.getKey();
            StringBuilder sqlSb = new StringBuilder(entrySql.getValue());
            if (sqlKeyMap == null) continue;
            sqlSb.append(',').append(sqlKeyMap.get(key));
            entrySql.setValue(sqlSb.toString());
        }
        return billSelectSqlMap;
    }

    private Map<String, String> getEntrySeqMap(Set<String> billObjs, Map<String, ColsMap> billColMaps) {
        HashMap<String, String> sqlKeyMap = new HashMap<String, String>(billColMaps.size());
        Map<String, Boolean> isPredictMap = ReserveHelper.getIsPredictMap(billObjs);
        for (Map.Entry<String, ColsMap> entry : billColMaps.entrySet()) {
            String formId = entry.getKey();
            ColsMap colsMap = entry.getValue();
            Map<String, String> balColMap = colsMap.getBalColMap();
            String materiel = balColMap.get("materiel");
            if (materiel == null) {
                return null;
            }
            String[] materielArray = materiel.split("\\.");
            Boolean isPredict = isPredictMap.get(formId);
            if (isPredict != null && isPredict.booleanValue()) {
                String entryKey = balColMap.get("billentry");
                StringBuilder sb = new StringBuilder();
                if (entryKey != null && materielArray.length > 1) {
                    sb.append(entryKey).append('.').append("seq").append(" AS ").append(SUP_SEQ).append(',').append(entryKey).append('.').append("id").append(" AS ").append("entryid");
                } else {
                    sb.append(0).append(" AS ").append(SUP_SEQ).append(',').append(0).append(" AS ").append("entryid");
                }
                sqlKeyMap.put(formId, sb.toString());
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(0).append(" AS ").append(SUP_SEQ);
            sb.append(',').append("id").append(" AS ").append("entryid");
            sqlKeyMap.put(formId, sb.toString());
        }
        return sqlKeyMap;
    }

    private Map<String, String> getBillSelectSqlMap(Set<String> billObjs, Set<String> modelFields, Map<String, Object> fieldDefaultMap, String modelFormId) {
        HashMap<String, String> billSelectSqlMap = new HashMap<String, String>(16);
        Map<String, ColsMap> billColMaps = ColsMapHelper.findBillColMaps(billObjs, modelFormId);
        for (Map.Entry<String, ColsMap> entry : billColMaps.entrySet()) {
            String formId = entry.getKey();
            ColsMap colsMap = entry.getValue();
            Map<String, String> balColMap = colsMap.getBalColMap();
            String select = this.getSelectByCol(balColMap, modelFields, fieldDefaultMap);
            billSelectSqlMap.put(formId, select);
        }
        return billSelectSqlMap;
    }

    private String getSelectByCol(Map<String, String> colMap, Set<String> modelFields, Map<String, Object> fieldDefaultMap) {
        StringBuilder sb = new StringBuilder();
        for (String modelField : modelFields) {
            String billField;
            if (SUP_SEQ.equals(modelField)) continue;
            String field = modelField;
            if (modelField.startsWith("r_") || modelField.startsWith("s_")) {
                field = modelField.substring(2);
            }
            if (StringUtils.isBlank((CharSequence)(billField = colMap.get(field)))) {
                billField = colMap.get("bill_entry." + field);
            }
            if (sb.length() > 0) {
                sb.append(" , ");
            }
            if (StringUtils.isNotBlank((CharSequence)billField)) {
                if ("bill_entry".equals(modelField)) {
                    billField = billField + ".id";
                }
                sb.append(billField).append(" as ").append(modelField);
                continue;
            }
            sb.append(fieldDefaultMap.get(field)).append(" as ").append(modelField);
        }
        return sb.toString();
    }
}

