/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.record.BalanceReplaceData;

public class ReserveReplaceHelper {
    private static String algo = ReserveReplaceHelper.class.getName();
    private static final Log logger = LogFactory.getLog(ReserveReplaceHelper.class);

    public static void reserveReplace(String billName, List<Object> ids) {
        HashSet<Object> idSet = new HashSet<Object>(ids.size());
        idSet.addAll(ids);
        ReserveReplaceHelper.initSelectInfo();
        QFilter idF = new QFilter("billid", "in", idSet);
        QFilter qtyF = new QFilter("base_qty", ">", (Object)BigDecimal.ZERO);
        DynamicObject[] releaseRecords = BusinessDataServiceHelper.load((String)"msmod_release_record", (String)"billid,entryid,base_qty,qty,qty2nd,reserve_record", (QFilter[])new QFilter[]{idF, qtyF});
        if (releaseRecords.length == 0) {
            return;
        }
        HashSet<Long> reserveIds = new HashSet<Long>(releaseRecords.length);
        for (DynamicObject releaseRecord : releaseRecords) {
            reserveIds.add(releaseRecord.getLong("reserve_record"));
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record");
        DynamicObject[] oldReserves = BusinessDataServiceHelper.load((Object[])reserveIds.toArray(), (DynamicObjectType)entityType);
        HashSet<String> balFormIds = new HashSet<String>(16);
        HashMap<Long, DynamicObject> oldReserveMap = new HashMap<Long, DynamicObject>(oldReserves.length);
        for (DynamicObject dynamicObject : oldReserves) {
            String billObj = dynamicObject.getString("bill_obj.id");
            if (dynamicObject.getBoolean("ispredict") || dynamicObject.getBoolean("isweak") || billName.equals(billObj)) continue;
            balFormIds.add(dynamicObject.getString("bal_obj.id"));
            oldReserveMap.put((Long)dynamicObject.getPkValue(), dynamicObject);
        }
        StringBuilder sb = new StringBuilder(" ( ");
        int i = 0;
        for (Object e : idSet) {
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append(e);
            ++i;
        }
        sb.append(" ) ");
        String balTbCols = "fbillid,fentryid,fbaseqty_sp,fqty_sp,fqty2nd_sp,fkeycol";
        HashMap<String, Map<Long, BalanceReplaceData>> hashMap = new HashMap<String, Map<Long, BalanceReplaceData>>(16);
        for (String balFormId : balFormIds) {
            ReserveReplaceHelper.handleBalModel(sb, balTbCols, hashMap, balFormId);
        }
        ReserveReplaceHelper.bulid(releaseRecords, oldReserveMap, hashMap, billName);
        DeleteServiceHelper.delete((String)"msmod_release_record", (QFilter[])new QFilter[]{idF});
    }

    private static void handleBalModel(StringBuilder sb, String balTbCols, Map<String, Map<Long, BalanceReplaceData>> transModelMap, String balFormId) {
        MainEntityType balType = MetadataServiceHelper.getDataEntityType((String)balFormId);
        String routeKey = balType.getDBRouteKey();
        String alias = balType.getAlias();
        DBRoute route = new DBRoute(routeKey);
        StringBuilder selectSQL = new StringBuilder("SELECT ").append(balTbCols).append(" FROM ");
        selectSQL.append(alias).append("_tp").append(" WHERE ").append("fstatus").append("=").append(" '").append("A").append("' and ").append("fupdatetype").append("=").append(1).append(" and ").append("fbillid").append(" in ").append((CharSequence)sb);
        DataSet balData = DB.queryDataSet((String)(algo + ":reserveReplace"), (DBRoute)route, (String)selectSQL.toString());
        transModelMap.put(balFormId, ReserveReplaceHelper.getReplaceBalModel(alias, balData, route));
    }

    public static void doNewTransAndReserveRecord(List<Map<String, Object>> paramCol, Map<Object, Map<Object, Object>> tranSupMap, Map<String, Set<Long>> supInfoMap, Map<Object, DynamicObject> recordDynaMap) {
        ArrayList<Long> recordId = new ArrayList<Long>(paramCol.size());
        HashMap<Object, Object> recordToSupId = new HashMap<Object, Object>(recordDynaMap.size());
        for (Map<String, Object> map : paramCol) {
            recordId.add((Long)map.get("recordId"));
            recordToSupId.put(map.get("recordId"), map.get("supId"));
        }
        HashMap supIdToRecordDyMap = new HashMap(recordDynaMap.size());
        for (Map.Entry<Object, DynamicObject> entry : recordDynaMap.entrySet()) {
            supIdToRecordDyMap.put(recordToSupId.get(entry.getKey()), entry.getValue());
        }
        QFilter qFilter = new QFilter("reserve_record", "in", recordId);
        QFilter qFilter2 = new QFilter("base_qty", ">", (Object)BigDecimal.ZERO);
        DynamicObject[] releaseRecords = BusinessDataServiceHelper.load((String)"msmod_release_record", (String)"billid,entryid,base_qty,qty,qty2nd,reserve_record", (QFilter[])new QFilter[]{qFilter, qFilter2});
        if (releaseRecords.length == 0) {
            return;
        }
        long[] ids = DB.genLongIds((String)"msmod_reserve_record", (int)releaseRecords.length);
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        int i = 0;
        DynamicObject[] reserves = new DynamicObject[paramCol.size()];
        DynamicObject[] reserveTransRecords = new DynamicObject[paramCol.size()];
        DataSet dataSet = null;
        for (Map.Entry<String, Set<Long>> entry : supInfoMap.entrySet()) {
            QFilter qFilter3 = new QFilter("id", "in", entry.getValue());
            Map<String, String> supColsMap = ColsMapHelper.findBillColMaps(entry.getKey(), "msmod_std_inv_field").getBalColMap();
            StringBuilder cols = new StringBuilder();
            int y = 0;
            for (Map.Entry<String, String> supCols : supColsMap.entrySet()) {
                if (y++ > 0) {
                    cols.append(',');
                }
                cols.append(supCols.getValue()).append("  as ").append(supCols.getKey());
            }
            cols.append(",id");
            dataSet = QueryServiceHelper.queryDataSet((String)ReserveReplaceHelper.class.getName(), (String)entry.getKey(), (String)cols.toString(), (QFilter[])qFilter3.toArray(), null);
        }
        HashMap supBillMap = new HashMap(16);
        for (Map.Entry<String, Set<Long>> entry : supInfoMap.entrySet()) {
            String supFormId = entry.getKey();
            Set<Long> billIds = entry.getValue();
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)supFormId.toString(), (QFilter[])new QFilter("id", "in", billIds).toArray());
            supBillMap.putAll(dynamicObjectMap);
        }
        if (dataSet != null) {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                DynamicObject dynamicObject = (DynamicObject)supBillMap.get(row.get("id"));
                Map<Object, Object> map = tranSupMap.get(((DynamicObject)supIdToRecordDyMap.get(row.get("id"))).getPkValue());
                DynamicObject reserveTrans = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reservetrans");
                reserveTrans.set("transbill", map.get("transBill"));
                reserveTrans.set("bfrecordid", map.get("recordId"));
                reserveTrans.set("afrecordid", (Object)ids[i]);
                reserveTrans.set("billid", map.get("transBillId"));
                reserveTrans.set("billentryid", map.get("transBillEntryId"));
                reserveTrans.set("creater", (Object)userId);
                reserveTrans.set("createdate", (Object)date);
                reserveTrans.set("transtype", (Object)"replace");
                reserveTransRecords[i] = reserveTrans;
                reserves[i] = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)supIdToRecordDyMap.get(row.get("id"))), (boolean)true, (boolean)true);
                Date now = TimeServiceHelper.now();
                reserves[i].set("bal_obj", map.get("supObj"));
                reserves[i].set("id", (Object)ids[i]);
                reserves[i].set("reserve_scheme", reserves[i].get("reserve_scheme.id"));
                reserves[i].set("base_qty", map.get("base_qty"));
                reserves[i].set("qty", map.get("qty"));
                reserves[i].set("qty2nd", map.get("qty2nd"));
                reserves[i].set("bal_id", map.get("supId"));
                reserves[i].set("reserveprctype", (Object)"3");
                reserves[i].set("bal_entryid", map.get("supEntryId"));
                reserves[i].set("create_date", (Object)now);
                ReserveReplaceHelper.setSupReserveRecordInfo(reserves[i], dynamicObject, (String)map.get("supObj"));
                ++i;
            }
            ReserveRecordHandler.createReserveRecordNew(Arrays.asList(reserves));
            SaveServiceHelper.save((DynamicObject[])reserveTransRecords);
        }
    }

    private static void bulid(DynamicObject[] releaseRecords, Map<Long, DynamicObject> oldReserveMap, Map<String, Map<Long, BalanceReplaceData>> transModelMap, String formId) {
        long[] ids = DB.genLongIds((String)"msmod_reserve_record", (int)releaseRecords.length);
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        int i = 0;
        DynamicObject[] reserves = new DynamicObject[releaseRecords.length];
        DynamicObject[] reserveTransRecords = new DynamicObject[releaseRecords.length];
        HashMap<String, Set> formIdToIdsMapping = new HashMap<String, Set>(transModelMap.size());
        for (Map.Entry<String, Map<Long, BalanceReplaceData>> stringMapEntry : transModelMap.entrySet()) {
            String supFormId = stringMapEntry.getKey();
            Map<Long, BalanceReplaceData> value = stringMapEntry.getValue();
            for (DynamicObject releaseRecord : releaseRecords) {
                long entryId = releaseRecord.getLong("entryid");
                BalanceReplaceData balanceReplaceData = value.get(entryId);
                long balanceRepId = balanceReplaceData.getId();
                Set billIds = formIdToIdsMapping.computeIfAbsent(supFormId, k -> new HashSet(16));
                billIds.add(balanceRepId);
            }
        }
        HashMap supBillMap = new HashMap(16);
        for (Map.Entry entry : formIdToIdsMapping.entrySet()) {
            Object supFormId = entry.getKey();
            Set billIds = (Set)entry.getValue();
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)supFormId.toString(), (QFilter[])new QFilter("id", "in", (Object)billIds).toArray());
            supBillMap.putAll(dynamicObjectMap);
        }
        for (DynamicObject releaseRecord : releaseRecords) {
            BalanceReplaceData transBalModel;
            long reserveId = releaseRecord.getLong("reserve_record");
            BigDecimal reBaseQty = releaseRecord.getBigDecimal("base_qty");
            BigDecimal reQty = releaseRecord.getBigDecimal("qty");
            BigDecimal reQty2nd = releaseRecord.getBigDecimal("qty2nd");
            DynamicObject oldReserve = oldReserveMap.get(reserveId);
            if (oldReserve == null) continue;
            String balFormId = oldReserve.getString("bal_obj_id");
            long entryId = releaseRecord.getLong("entryid");
            Map<Long, BalanceReplaceData> reserveTransMap = transModelMap.get(balFormId);
            if (reserveTransMap == null || (transBalModel = reserveTransMap.get(entryId)) == null) continue;
            DynamicObject supBill = (DynamicObject)supBillMap.get(transBalModel.getId());
            DynamicObject reserveTrans = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reservetrans");
            reserveTrans.set("transbill", (Object)formId);
            reserveTrans.set("bfrecordid", oldReserve.getPkValue());
            reserveTrans.set("afrecordid", (Object)ids[i]);
            reserveTrans.set("billid", (Object)transBalModel.getBillId());
            reserveTrans.set("billentryid", (Object)transBalModel.getEntryId());
            reserveTrans.set("creater", (Object)userId);
            reserveTrans.set("createdate", (Object)date);
            reserveTrans.set("transtype", (Object)"replace");
            reserveTransRecords[i] = reserveTrans;
            reserves[i] = (DynamicObject)OrmUtils.clone((IDataEntityBase)oldReserve, (boolean)true, (boolean)true);
            BigDecimal baseQty = transBalModel.getBaseQty().subtract(transBalModel.getLockBaseQty());
            BigDecimal qty = transBalModel.getQty().subtract(transBalModel.getLockQty());
            BigDecimal qty2nd = transBalModel.getQty2nd().subtract(transBalModel.getLockQty2nd());
            BigDecimal minBaseQty = baseQty.min(reBaseQty);
            BigDecimal minQty = qty.min(reQty);
            BigDecimal minQty2nd = qty2nd.min(reQty2nd);
            Date now = TimeServiceHelper.now();
            reserves[i].set("bal_obj", oldReserve.get("bal_obj.id"));
            reserves[i].set("id", (Object)ids[i]);
            reserves[i].set("reserve_scheme", oldReserve.get("reserve_scheme.id"));
            reserves[i].set("base_qty", (Object)minBaseQty);
            reserves[i].set("qty", (Object)minQty);
            reserves[i].set("qty2nd", (Object)minQty2nd);
            reserves[i].set("bal_id", (Object)transBalModel.getId());
            reserves[i].set("reserveprctype", (Object)"3");
            reserves[i].set("bal_entryid", (Object)transBalModel.getId());
            reserves[i].set("create_date", (Object)now);
            ReserveReplaceHelper.setSupReserveRecordInfo(reserves[i], supBill, balFormId);
            releaseRecord.set("base_qty", (Object)reBaseQty.subtract(minBaseQty));
            releaseRecord.set("qty", (Object)reQty.subtract(minQty));
            releaseRecord.set("qty2nd", (Object)reQty2nd.subtract(minQty2nd));
            transBalModel.addLockBaseQty(minBaseQty);
            transBalModel.addLockQty(minQty);
            transBalModel.addLockQty2nd(minQty2nd);
            ++i;
        }
        ReserveRecordHandler.createReserveRecord(Arrays.asList(reserves));
        SaveServiceHelper.save((DynamicObject[])reserveTransRecords);
        SaveServiceHelper.save((DynamicObject[])releaseRecords);
    }

    private static void setSupReserveRecordInfo(DynamicObject reserve, Row row, String supObj) {
        Set<String> balModelFieldSet = ReserveReplaceHelper.initSelectInfo();
        Map<String, String> balColMap = ColsMapHelper.findBillColMaps(supObj, "msmod_std_inv_field").getBalColMap();
        Iterator<String> iterator = balModelFieldSet.iterator();
        while (iterator.hasNext()) {
            String resModleInfo;
            String field = resModleInfo = iterator.next();
            if (resModleInfo.startsWith("r_") || resModleInfo.startsWith("s_")) {
                field = resModleInfo.substring(2);
            }
            if ("bill_entry".equals(field) || balColMap.get(field) == null || field == null) continue;
            Object value = row.get(field);
            reserve.set(resModleInfo, value);
        }
    }

    private static void setSupReserveRecordInfo(DynamicObject reserve, DynamicObject supBill, String balFormId) {
        ReserveContext reserveContext = new ReserveContext();
        ColsMap supColsMap = reserveContext.getSupColsMap(balFormId);
        Set<String> balModelFieldSet = ReserveReplaceHelper.initSelectInfo();
        Map<String, String> balColMap = supColsMap.getBalColMap();
        Iterator<String> iterator = balModelFieldSet.iterator();
        while (iterator.hasNext()) {
            String resModleInfo;
            String fild = resModleInfo = iterator.next();
            if (resModleInfo.startsWith("r_") || resModleInfo.startsWith("s_")) {
                fild = resModleInfo.substring(2);
            }
            String billkey = balColMap.get(fild);
            if ("bill_entry".equals(fild) || billkey == null) continue;
            Object value = supBill.get(billkey);
            reserve.set(resModleInfo, value);
        }
    }

    private static Map<Long, BalanceReplaceData> getReplaceBalModel(String balFormId, DataSet balData, DBRoute route) {
        HashMap<Long, BalanceReplaceData> transModelMap = new HashMap<Long, BalanceReplaceData>(16);
        HashSet<Object> keyColsSet = new HashSet<Object>(16);
        HashMap<Object, ArrayList<BalanceReplaceData>> keyColDataMap = new HashMap<Object, ArrayList<BalanceReplaceData>>(16);
        while (balData.hasNext()) {
            Row row = balData.next();
            Long entryId = row.getLong("fentryid");
            String keyCol = row.getString("fkeycol");
            BalanceReplaceData balanceReplaceData = new BalanceReplaceData();
            balanceReplaceData.setBillId(row.getLong("fbillid"));
            balanceReplaceData.setBaseQty(row.getBigDecimal("fbaseqty_sp"));
            balanceReplaceData.setEntryId(entryId);
            balanceReplaceData.setQty(row.getBigDecimal("fqty_sp"));
            balanceReplaceData.setQty2nd(row.getBigDecimal("fqty2nd_sp"));
            balanceReplaceData.setKeycol(keyCol);
            keyColsSet.add(keyCol);
            transModelMap.put(entryId, balanceReplaceData);
            ArrayList<BalanceReplaceData> models = (ArrayList<BalanceReplaceData>)keyColDataMap.get(keyCol);
            if (models == null) {
                models = new ArrayList<BalanceReplaceData>(16);
                keyColDataMap.put(keyCol, models);
            }
            models.add(balanceReplaceData);
        }
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("SELECT ").append("fid").append(',').append("fkeycol").append(" FROM ").append(balFormId).append(" WHERE ").append("fkeycol").append(" in ").append('(');
        int i = 0;
        for (String string : keyColsSet) {
            if (i > 0) {
                sbSql.append(',');
            }
            sbSql.append(" '").append(string).append("' ");
            ++i;
        }
        sbSql.append(')');
        DataSet bal = DB.queryDataSet((String)(algo + ":getReplaceBalModel"), (DBRoute)route, (String)sbSql.toString());
        while (bal.hasNext()) {
            Row row = bal.next();
            String keyCol = row.getString("fkeycol");
            List replaceDatas = (List)keyColDataMap.get(keyCol);
            if (replaceDatas == null) continue;
            Long balId = row.getLong("fid");
            replaceDatas.forEach(v -> v.setId(balId));
        }
        return transModelMap;
    }

    private static Set<String> initSelectInfo() {
        Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
        HashSet<String> balModelFieldSet = new HashSet<String>(16);
        for (String key : allFieldMap.keySet()) {
            if (!key.startsWith("s_")) continue;
            balModelFieldSet.add(key);
        }
        return balModelFieldSet;
    }
}

