/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.record;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.business.ConvRateContext;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.record.MsmodReleasebillEntryConst;
import kd.mpscmm.msbd.reserve.business.record.RecordBillEntryModel;
import kd.mpscmm.msbd.reserve.business.record.RecordData;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;

public class RecordReleaseModle {
    private String formId;
    private DynamicObject releaseRule;
    private Collection<Object> ids;
    private Collection<Object> entryIds;
    private ColsMap colsMap;
    private List<RecordBillEntryModel> entryList = new ArrayList<RecordBillEntryModel>(16);
    private Map<String, String> ruleMatchKeyMap;
    private Map<String, String> ruleSortKeyMap;
    private Map<String, String> ruleObjSortKeyMap;
    private Set<String> selectKey;
    private ConvRateContext convRate = new ConvRateContext();
    private static final String[] unitKeys = new String[]{"materiel", "baseunit", "unit"};
    private static Log logger = LogFactory.getLog(RecordReleaseModle.class);

    private RecordReleaseModle(String formId, Collection<Object> ids, DynamicObject releaseRule, Collection<Object> entryIds) {
        this.formId = formId;
        this.ids = ids;
        this.releaseRule = releaseRule;
        this.entryIds = entryIds;
    }

    public static RecordReleaseModle getInstance(String formId, Collection<Object> ids, DynamicObject releaseRule, Collection<Object> entryIds) {
        return new RecordReleaseModle(formId, ids, releaseRule, entryIds);
    }

    public static RecordReleaseModle getInstance(String formId, Collection<Object> ids, DynamicObject releaseRule) {
        return new RecordReleaseModle(formId, ids, releaseRule, null);
    }

    private void initModel() {
        this.colsMap = ColsMapHelper.findReleaseBillColMap(this.formId);
        String algoKey = this.getClass().getName() + ":initModel";
        this.initRuleMatchKeyMap();
        this.initRuleSortKeyMap();
        DataSet billDatas = QueryServiceHelper.queryDataSet((String)algoKey, (String)this.formId, (String)this.getBillCols4Select(), (QFilter[])new QFilter("id", "in", this.ids).toArray(), null);
        while (billDatas.hasNext()) {
            Row next = billDatas.next();
            Long enrtyId = next.getLong("entryid");
            if (this.entryIds != null && !this.entryIds.contains(enrtyId)) continue;
            RecordBillEntryModel entry = new RecordBillEntryModel();
            entry.setBillId(next.getLong("billid"));
            entry.setEntryId(enrtyId);
            entry.setBillNo(next.getString("billNum"));
            entry.setBaseQty(next.getBigDecimal("baseqty") == null ? BigDecimal.ZERO : next.getBigDecimal("baseqty"));
            entry.setQty(next.getBigDecimal("qty") == null ? BigDecimal.ZERO : next.getBigDecimal("qty"));
            entry.setQty2nd(next.getBigDecimal("qty2nd") == null ? BigDecimal.ZERO : next.getBigDecimal("qty2nd"));
            Map<String, Object> params = entry.getParams();
            if (params == null) {
                params = new HashMap<String, Object>(this.ruleMatchKeyMap.size());
            }
            for (String ruleMatchKey : this.ruleMatchKeyMap.keySet()) {
                params.put(ruleMatchKey, next.get(ruleMatchKey));
            }
            entry.setParams(params);
            this.entryList.add(entry);
        }
    }

    private void initRuleSortKeyMap() {
        this.ruleSortKeyMap = new HashMap<String, String>(16);
        if (this.releaseRule == null) {
            return;
        }
        DynamicObjectCollection sortEntry = this.releaseRule.getDynamicObjectCollection("sort_entry");
        for (DynamicObject rule : sortEntry) {
            this.ruleSortKeyMap.put(rule.getString("sort_field_no"), rule.getString("sort_way"));
        }
    }

    private void initRuleMatchKeyMap() {
        this.ruleMatchKeyMap = new HashMap<String, String>(16);
        if (this.releaseRule == null) {
            return;
        }
        DynamicObjectCollection ruleEntry = this.releaseRule.getDynamicObjectCollection("rule_entry");
        for (DynamicObject rule : ruleEntry) {
            this.ruleMatchKeyMap.put(rule.getString("std_inv_col_no"), rule.getString("release_col_no"));
        }
    }

    private List<RecordData> buildReleaseRecordData(DataSet recordDatas, List<String> aggregateField) {
        ArrayList<RecordData> records = new ArrayList<RecordData>(16);
        while (recordDatas.hasNext()) {
            Row next = recordDatas.next();
            Long entryId = next.getLong("billentry_id");
            RecordData record = new RecordData();
            record.setPkValue(next.getLong("id"));
            record.setEntryId(entryId);
            record.setBillObjId(this.formId);
            record.setBaseQty(next.getBigDecimal("base_qty"));
            record.setQty(next.getBigDecimal("qty"));
            record.setQty2nd(next.getBigDecimal("qty2nd"));
            record.setMaterialId(next.getLong("materiel"));
            record.setBaseUnitId(next.getLong("baseunit"));
            record.setUnitId(next.getLong("unit"));
            record.setReserveMethod(next.getString("reservemethod"));
            record.setBalObj(next.getString("bal_obj"));
            record.setBalId(next.getLong("bal_id"));
            record.setAggregateId(next.getLong("aggregateid"));
            Map<String, Object> params = record.getParams();
            if (params == null) {
                params = new HashMap<String, Object>(this.ruleMatchKeyMap.size());
            }
            for (String ruleMatchKey : this.ruleMatchKeyMap.keySet()) {
                if (aggregateField != null && !aggregateField.contains(ruleMatchKey)) continue;
                params.put(ruleMatchKey, next.get(ruleMatchKey));
            }
            record.setParams(params);
            records.add(record);
        }
        return records;
    }

    private String getBillCols4Select() {
        StringBuilder srcSelectCols = new StringBuilder();
        Map<String, String> billColMap = this.colsMap.getBalColMap();
        srcSelectCols.append("id").append(" AS ").append("billid");
        for (Map.Entry<String, String> ruleMatch : this.ruleMatchKeyMap.entrySet()) {
            if ("baseqty".equals(ruleMatch.getKey()) || "qty".equals(ruleMatch.getKey()) || "qty2nd".equals(ruleMatch.getKey())) continue;
            srcSelectCols.append(',').append(ruleMatch.getValue()).append(" AS ").append(ruleMatch.getKey());
        }
        srcSelectCols.append(',').append(billColMap.get("entryentity")).append('.').append("id").append(" AS ").append("entryid");
        srcSelectCols.append(',').append(billColMap.get(MsmodReleasebillEntryConst.getEntryField("qty"))).append(" AS ").append("qty");
        srcSelectCols.append(',').append(billColMap.get(MsmodReleasebillEntryConst.getEntryField("baseqty"))).append(" AS ").append("baseqty");
        srcSelectCols.append(',').append(billColMap.get(MsmodReleasebillEntryConst.getEntryField("qty2nd"))).append(" AS ").append("qty2nd");
        srcSelectCols.append(',').append(billColMap.get("billno")).append(" AS ").append("billNum");
        return srcSelectCols.toString();
    }

    public List<DynamicObject> matchReleaseRecord(DataSet releaseRuleDataSet) {
        if (this.colsMap == null) {
            this.initModel();
        }
        if (this.entryList.isEmpty()) {
            return new ArrayList<DynamicObject>(this.entryList.size());
        }
        HashSet<Long> outEntryIDset = new HashSet<Long>(this.entryList.size());
        Map<String, String> balColMap = this.colsMap.getBalColMap();
        String entryName = balColMap.get("entryentity");
        for (RecordBillEntryModel recordBillEntryModel : this.entryList) {
            outEntryIDset.add(recordBillEntryModel.getEntryId());
        }
        Set<Object> srcIds = ReserveHelper.getBotpLinkBillIds(this.formId, this.ids.toArray(new Long[this.ids.size()]));
        QFilter recordFilter = new QFilter("bill_id", "in", srcIds);
        recordFilter = recordFilter.and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
        String selectCols = "id,bal_obj,bal_id,billentry_id,base_qty,qty,qty2nd,aggregateid,reservemethod,reserveobjtype,bal_entryid";
        if (this.releaseRule == null) {
            selectCols = selectCols + ",s_materiel as materiel,s_unit as unit,s_baseunit as baseunit,s_unit2nd as unit2nd";
        }
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":matchReleaseRecord"), (String)"msmod_reserve_record", (String)selectCols, (QFilter[])recordFilter.toArray(), (String)"id");
        if (this.releaseRule != null) {
            this.recordSelectFields(this.releaseRule);
            DataSet hasReserveBill = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":msmod_reservebill"), (String)"msmod_reservebill", (String)"id", null, null).top(1);
            if (hasReserveBill.hasNext()) {
                DataSet objRecordDataSet;
                List<Long> reserveObjList = this.selectReleaseObjList(this.entryList);
                QFilter objFilter = null;
                if (reserveObjList != null && reserveObjList.size() != 0) {
                    objFilter = new QFilter("reservemethod", "=", (Object)"2");
                    objFilter.and("reserveobj", "in", reserveObjList).and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
                }
                if (objFilter != null && (objRecordDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":matchReleaseRecord"), (String)"msmod_reserve_record", (String)selectCols, (QFilter[])objFilter.toArray(), (String)"id")).hasNext()) {
                    recordDataSet = recordDataSet.union(objRecordDataSet);
                }
            }
        }
        List<DynamicObject> releaseList = new ArrayList<DynamicObject>(this.entryList.size());
        if (!recordDataSet.hasNext()) {
            return releaseList;
        }
        Map<Object, List<Object>> bOTPEntryIdMap = ReserveHelper.getBotpUpPath4EntryId(this.formId, entryName, outEntryIDset.toArray(new Long[outEntryIDset.size()]), this.ids.toArray(new Long[this.ids.size()]));
        DataSet detailRecordDataSet = recordDataSet.copy().filter("bal_id != 0");
        releaseList = releaseRuleDataSet == null ? this.dealReleaseList(null, detailRecordDataSet, bOTPEntryIdMap, null) : this.dealReleaseList(releaseRuleDataSet.copy(), detailRecordDataSet, bOTPEntryIdMap, null);
        DataSet aggRecordDataSet = recordDataSet.copy().filter("bal_id ==0");
        if (aggRecordDataSet.hasNext()) {
            List<String> aggregateField = ReserveAggregateHelper.getAggregateField();
            if (ReserveAggregateHelper.isAggregate() && this.releaseRule != null) {
                DynamicObjectCollection ruleEntry = this.releaseRule.getDynamicObjectCollection("rule_entry");
                for (DynamicObject rule : ruleEntry) {
                    if (aggregateField.contains(rule.getString("std_inv_col_no"))) continue;
                    this.ruleMatchKeyMap.keySet().removeIf(key -> key.equals(rule.getString("std_inv_col_no")));
                }
            }
            releaseList.addAll(this.dealAggReleaseList(releaseRuleDataSet, aggRecordDataSet, bOTPEntryIdMap, null));
        }
        return releaseList;
    }

    private List<DynamicObject> dealReleaseList(DataSet releaseRuleDataSetCopy, DataSet recordDataSet, Map<Object, List<Object>> bOTPEntryIdMap, List<RecordData> showRecordList) {
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(this.entryList.size());
        HashSet<String> supplierIdSet = new HashSet<String>(16);
        Map<String, Set<Object>> balIdMap = this.getReleaseBalIdMap(recordDataSet.copy(), supplierIdSet);
        if (supplierIdSet.isEmpty()) {
            return releaseList;
        }
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"msmod_release_record");
        DataSet recordDetailDataSet = this.mergeReleaseRecord(recordDataSet.copy(), supplierIdSet, balIdMap, this.releaseRule, releaseRuleDataSetCopy);
        List<RecordData> recordDatas = this.buildReleaseRecordData(recordDetailDataSet, null);
        logger.info("matchReleaseRecord=====recordMap.size()==" + recordDatas.size());
        this.getCanReleaseRecordList(bOTPEntryIdMap, showRecordList, recordDatas);
        for (RecordBillEntryModel entry : this.entryList) {
            this.createReleaseRecord(releaseList, entry, dt, recordDatas, bOTPEntryIdMap);
        }
        return releaseList;
    }

    private void getCanReleaseRecordList(Map<Object, List<Object>> bOTPEntryIdMap, List<RecordData> showRecordList, List<RecordData> recordDatas) {
        if (showRecordList != null) {
            HashMap<Long, Integer> recordMap = new HashMap<Long, Integer>(16);
            for (RecordBillEntryModel entry : this.entryList) {
                Iterator<RecordData> it = recordDatas.iterator();
                Map invFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_std_inv_field").getAllFields();
                while (it.hasNext()) {
                    RecordData record = it.next();
                    long recordId = record.getPkValue();
                    if (recordMap.get(recordId) != null || !entry.isMatch(this.ruleMatchKeyMap.keySet(), entry.getEntryId(), record, bOTPEntryIdMap, invFieldMap)) continue;
                    showRecordList.add(record);
                    recordMap.put(recordId, 1);
                }
            }
        }
    }

    private List<DynamicObject> dealAggReleaseList(DataSet releaseRuleDataSet, DataSet recordDataSet, Map<Object, List<Object>> bOTPEntryIdMap, List<RecordData> showRecordList) {
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(this.entryList.size());
        HashSet<String> supplierIdSet = new HashSet<String>(16);
        this.getReleaseBalIdMap(recordDataSet.copy(), supplierIdSet);
        if (supplierIdSet.isEmpty()) {
            return releaseList;
        }
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"msmod_release_record");
        List<String> aggregateField = ReserveAggregateHelper.getAggregateField();
        DataSet recordDetailDataSet = this.mergeReleaseRecordForAgg(recordDataSet.copy(), aggregateField, this.releaseRule, releaseRuleDataSet);
        List<RecordData> recordDatas = this.buildReleaseRecordData(recordDetailDataSet, aggregateField);
        logger.info("matchReleaseRecord=====recordMap.size()==" + recordDatas.size());
        this.getCanReleaseRecordList(bOTPEntryIdMap, showRecordList, recordDatas);
        for (RecordBillEntryModel entry : this.entryList) {
            this.createReleaseRecord(releaseList, entry, dt, recordDatas, bOTPEntryIdMap);
        }
        return releaseList;
    }

    private List<Long> selectReleaseObjList(List<RecordBillEntryModel> entryList) {
        ArrayList<Long> billIdList = new ArrayList<Long>(entryList.size());
        for (RecordBillEntryModel recordBillEntryModel : entryList) {
            billIdList.add(recordBillEntryModel.getBillId());
        }
        ArrayList<Long> reserveObjList = null;
        if (this.selectKey != null) {
            Object[] objects = new String[this.selectKey.size()];
            this.selectKey.toArray(objects);
            String selectKeyString = StringUtils.join((Object[])objects, (String)",");
            QFilter filter = new QFilter("id", "in", billIdList);
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)this.formId, (String)selectKeyString, (QFilter[])filter.toArray());
            reserveObjList = new ArrayList<Long>(dynamicObjectMap.size());
            long pkValue = 0L;
            for (Map.Entry dynamicObjectEntry : dynamicObjectMap.entrySet()) {
                for (String select : this.selectKey) {
                    DynamicObject reserveObjDyn = ((DynamicObject)dynamicObjectEntry.getValue()).getDynamicObject(select);
                    if (reserveObjDyn == null) continue;
                    pkValue = (Long)reserveObjDyn.getPkValue();
                    reserveObjList.add(pkValue);
                }
            }
        }
        return reserveObjList;
    }

    private void recordSelectFields(DynamicObject releaseRule) {
        DynamicObjectCollection sortEntry = releaseRule.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection matObjEntry = releaseRule.getDynamicObjectCollection("objresentity");
        this.ruleObjSortKeyMap = new HashMap<String, String>(sortEntry.size());
        this.selectKey = new HashSet<String>(matObjEntry.size());
        if (sortEntry.size() > 0) {
            for (DynamicObject rule : sortEntry) {
                this.ruleObjSortKeyMap.put(rule.getString("releasetype"), rule.getString("priority"));
            }
        }
        if (matObjEntry.size() > 0) {
            for (DynamicObject matObj : matObjEntry) {
                this.selectKey.add(matObj.getString("releasebillfield_no"));
            }
        }
    }

    private DataSet mergeReleaseRecord(DataSet recordDataSet, Set<String> supplierIdSet, Map<String, Set<Object>> balIdMap, DynamicObject releaseRule, DataSet releaseRuleDataSet) {
        if (releaseRule != null) {
            DataSet supplierDataSet = this.getReleaseSupplierDataSet(supplierIdSet, balIdMap);
            supplierDataSet = supplierDataSet.distinct();
            String resTypeSort = releaseRule.getString("reservetyperelord");
            String[] sortArray = new String[this.ruleSortKeyMap.size() + 2];
            String[] resPriority = new String[this.ruleSortKeyMap.size() + 3];
            if ("1".equals(resTypeSort)) {
                sortArray[0] = "reservemethod asc";
                resPriority[0] = "reservemethod asc";
            } else {
                sortArray[0] = "reservemethod desc";
                resPriority[0] = "reservemethod desc";
            }
            if (this.ruleObjSortKeyMap != null && releaseRuleDataSet != null) {
                resPriority[1] = "priority asc";
            }
            int i = 0;
            for (Map.Entry<String, String> ruleSortEntry : this.ruleSortKeyMap.entrySet()) {
                String key = ruleSortEntry.getKey();
                if ("qty".equals(key) || "base_qty".equals(key) || "qty2nd".equals(key)) {
                    key = "inv" + key;
                }
                sortArray[i + 1] = key + " " + ruleSortEntry.getValue();
                resPriority[i + 2] = key + " " + ruleSortEntry.getValue();
                ++i;
            }
            sortArray[this.ruleSortKeyMap.size() + 1] = "id asc";
            resPriority[this.ruleSortKeyMap.size() + 2] = "id asc";
            recordDataSet = recordDataSet.join(supplierDataSet, JoinType.INNER).on("bal_entryid", "barId").select(recordDataSet.getRowMeta().getFieldNames(), supplierDataSet.getRowMeta().getFieldNames()).finish().orderBy(sortArray);
            if (this.ruleObjSortKeyMap != null && releaseRuleDataSet != null) {
                recordDataSet = recordDataSet.join(releaseRuleDataSet, JoinType.LEFT).on("reserveobjtype", "releasetype").select(recordDataSet.getRowMeta().getFieldNames(), releaseRuleDataSet.getRowMeta().getFieldNames()).finish().orderBy(resPriority);
            }
        }
        return recordDataSet;
    }

    private DataSet mergeReleaseRecordForAgg(DataSet recordDataSet, List<String> aggregateField, DynamicObject releaseRule, DataSet releaseRuleDataSet) {
        if (releaseRule != null) {
            String balNum = "msmod_reserveaggre";
            DataSet supplierDataSet = this.getAggregateDataSet(recordDataSet.copy(), aggregateField, balNum);
            String resTypeSort = releaseRule.getString("reservetyperelord");
            String[] sortArray = new String[this.ruleSortKeyMap.size() + 2];
            String[] resPriority = new String[this.ruleSortKeyMap.size() + 3];
            if ("1".equals(resTypeSort)) {
                sortArray[0] = "reservemethod asc";
                resPriority[0] = "reservemethod asc";
            } else {
                sortArray[0] = "reservemethod desc";
                resPriority[0] = "reservemethod desc";
            }
            if (this.ruleObjSortKeyMap != null && releaseRuleDataSet != null) {
                resPriority[1] = "priority asc";
            }
            int i = 0;
            for (Map.Entry<String, String> ruleSortEntry : this.ruleSortKeyMap.entrySet()) {
                if (!aggregateField.contains(ruleSortEntry.getKey())) continue;
                sortArray[i + 1] = ruleSortEntry.getKey() + " " + ruleSortEntry.getValue();
                resPriority[i + 2] = ruleSortEntry.getKey() + " " + ruleSortEntry.getValue();
                ++i;
            }
            sortArray[this.ruleSortKeyMap.size() + 1] = "id asc";
            resPriority[this.ruleSortKeyMap.size() + 2] = "id asc";
            recordDataSet = recordDataSet.join(supplierDataSet, JoinType.INNER).on("aggregateid", "barId").select(recordDataSet.getRowMeta().getFieldNames(), supplierDataSet.getRowMeta().getFieldNames()).finish().orderBy(sortArray);
            if (this.ruleObjSortKeyMap != null && releaseRuleDataSet != null) {
                recordDataSet = recordDataSet.join(releaseRuleDataSet, JoinType.LEFT).on("reserveobjtype", "releasetype").select(recordDataSet.getRowMeta().getFieldNames(), releaseRuleDataSet.getRowMeta().getFieldNames()).finish().orderBy(resPriority);
            }
        }
        return recordDataSet;
    }

    private DataSet getAggregateDataSet(DataSet recordDataSet, List<String> aggregateField, String balNum) {
        HashMap<String, String> billSelectSqlMap = new HashMap<String, String>(16);
        ColsMap colsMap = ColsMapHelper.findBillColMaps(balNum, "msmod_std_inv_field");
        StringBuilder supplierSelectField = new StringBuilder();
        supplierSelectField.append("id as barId");
        for (String string : this.ruleMatchKeyMap.keySet()) {
            if (!aggregateField.contains(string)) continue;
            supplierSelectField.append(',').append(colsMap.getByBalCol(string)).append(" as ").append(string);
        }
        for (String unitKey : unitKeys) {
            if (this.ruleMatchKeyMap.containsKey(unitKey) || this.ruleSortKeyMap.containsKey(unitKey)) continue;
            supplierSelectField.append(',').append(colsMap.getByBalCol(unitKey)).append(" as ").append(unitKey);
        }
        for (Map.Entry entry : this.ruleSortKeyMap.entrySet()) {
            String sortKey = (String)entry.getKey();
            if (this.ruleMatchKeyMap.containsKey(sortKey) || !aggregateField.contains(sortKey)) continue;
            supplierSelectField.append(',').append(colsMap.getByBalCol(sortKey)).append(" as ").append(sortKey);
        }
        billSelectSqlMap.put(balNum, supplierSelectField.toString());
        Map<String, Set<Object>> balIdMap = this.getAggregateBalIdMap(recordDataSet, balNum);
        return ReserveHelper.queryObjData(this.getClass().getName() + ":getReleaseSupplierDataSet", balIdMap, billSelectSqlMap);
    }

    private Map<String, Set<Object>> getAggregateBalIdMap(DataSet recordDataSet, String balNum) {
        HashMap<String, Set<Object>> balIdMap = new HashMap<String, Set<Object>>(16);
        while (recordDataSet.hasNext()) {
            Row next = recordDataSet.next();
            if (next.get("aggregateid") == null && next.getLong("aggregateid") == 0L) continue;
            HashSet<Object> balIds = (HashSet<Object>)balIdMap.get(balNum);
            if (balIds == null) {
                balIds = new HashSet<Object>(16);
                balIdMap.put(balNum, balIds);
            }
            balIds.add(next.get("aggregateid"));
        }
        return balIdMap;
    }

    private Map<String, Set<Object>> getReleaseBalIdMap(DataSet recordSetCopy, Set<String> supplierIdSet) {
        HashMap<String, Set<Object>> balIdMap = new HashMap<String, Set<Object>>(16);
        while (recordSetCopy.hasNext()) {
            Row next = recordSetCopy.next();
            String balNum = next.getString("bal_obj");
            supplierIdSet.add(balNum);
            HashSet<Object> balIds = (HashSet<Object>)balIdMap.get(balNum);
            if (balIds == null) {
                balIds = new HashSet<Object>(16);
                balIdMap.put(balNum, balIds);
            }
            balIds.add(next.get("bal_id"));
        }
        return balIdMap;
    }

    private DataSet getReleaseSupplierDataSet(Set<String> supplierIdSet, Map<String, Set<Object>> balIdMap) {
        Map<String, ColsMap> supplierColsMap = ColsMapHelper.findBillColMaps(supplierIdSet, "msmod_std_inv_field");
        HashMap<String, String> billSelectSqlMap = new HashMap<String, String>(16);
        for (Map.Entry<String, ColsMap> entry : supplierColsMap.entrySet()) {
            String formId = entry.getKey();
            ColsMap colsMap = entry.getValue();
            StringBuilder supplierSelectField = new StringBuilder();
            if (MetadataServiceHelper.getDataEntityType((String)formId).getProperty(colsMap.getBalColMap().get("billentry")) == null) {
                supplierSelectField.append("id as barId");
            } else {
                supplierSelectField.append(colsMap.getBalColMap().get("billentry")).append(".id as barId");
            }
            for (String string : this.ruleMatchKeyMap.keySet()) {
                if ("qty".equals(string) || "base_qty".equals(string) || "qty2nd".equals(string)) {
                    supplierSelectField.append(',').append(colsMap.getByBalCol(string)).append(" as ").append("inv").append(string);
                    continue;
                }
                supplierSelectField.append(',').append(colsMap.getByBalCol(string)).append(" as ").append(string);
            }
            for (Map.Entry entry2 : this.ruleSortKeyMap.entrySet()) {
                String sortKey = (String)entry2.getKey();
                if (this.ruleMatchKeyMap.containsKey(sortKey)) continue;
                if ("qty".equals(sortKey) || "base_qty".equals(sortKey) || "qty2nd".equals(sortKey)) {
                    supplierSelectField.append(',').append(colsMap.getByBalCol(sortKey)).append(" as ").append("inv").append(sortKey);
                    continue;
                }
                supplierSelectField.append(',').append(colsMap.getByBalCol(sortKey)).append(" as ").append(sortKey);
            }
            for (Iterator<Object> iterator : unitKeys) {
                if (this.ruleMatchKeyMap.containsKey(iterator) || this.ruleSortKeyMap.containsKey(iterator)) continue;
                supplierSelectField.append(",").append(colsMap.getByBalCol((String)((Object)iterator))).append(" as ").append((String)((Object)iterator));
            }
            billSelectSqlMap.put(formId, supplierSelectField.toString());
        }
        return ReserveHelper.queryObjData(this.getClass().getName() + ":getReleaseSupplierDataSet", balIdMap, billSelectSqlMap);
    }

    private void createReleaseRecord(List<DynamicObject> releaseRecordList, RecordBillEntryModel entry, MainEntityType dt, List<RecordData> recordDatas, Map<Object, List<Object>> bOTPEntryIdMap) {
        BigDecimal baseQty = entry.getBaseQty().abs();
        BigDecimal qty = entry.getQty().abs();
        BigDecimal qty2nd = entry.getQty2nd().abs();
        Iterator<RecordData> it = recordDatas.iterator();
        Map invFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_std_inv_field").getAllFields();
        while (it.hasNext()) {
            BigDecimal subQty2nd;
            RecordData record = it.next();
            if (baseQty.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            if (!entry.isMatch(this.ruleMatchKeyMap.keySet(), entry.getEntryId(), record, bOTPEntryIdMap, invFieldMap)) continue;
            Long releaseId = record.getReleaseId();
            DynamicObject releaseRecord = (DynamicObject)dt.createInstance();
            releaseRecordList.add(releaseRecord);
            if (releaseId != null) {
                releaseRecord.set("id", (Object)releaseId);
            }
            releaseRecord.set("reserve_record", (Object)record.getPkValue());
            releaseRecord.set("release_type", (Object)"release");
            releaseRecord.set("bill_obj", (Object)record.getBillObjId());
            releaseRecord.set("billid", (Object)entry.getBillId());
            releaseRecord.set("entryid", (Object)entry.getEntryId());
            releaseRecord.set("billno", (Object)entry.getBillNo());
            releaseRecord.set("balobj", (Object)record.getBalObj());
            releaseRecord.set("balid", (Object)record.getBalId());
            releaseRecord.set("aggregateid", (Object)record.getAggregateId());
            releaseRecord.set("op", ThreadCache.get((Object)"ReserveOpName"));
            BigDecimal reserveBaseQty = record.getBaseQty();
            BigDecimal reserveQty = record.getQty();
            BigDecimal reserveQty2nd = record.getQty2nd();
            BigDecimal baseSubQty = RecordReleaseModle.setReleaseQty(baseQty, releaseRecord, reserveBaseQty, "base_qty");
            if (BigDecimal.ZERO.compareTo(entry.getBaseQty()) < 0) {
                entry.setBaseQty(entry.getBaseQty().subtract(baseSubQty));
            } else {
                entry.setBaseQty(entry.getBaseQty().add(baseSubQty));
            }
            baseQty = baseQty.subtract(baseSubQty);
            reserveBaseQty = reserveBaseQty.subtract(baseSubQty);
            if (reserveBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                releaseRecord.set("qty", (Object)reserveQty);
                releaseRecord.set("qty2nd", (Object)reserveQty2nd);
                qty = qty.subtract(reserveQty);
                qty2nd = qty2nd.subtract(reserveQty2nd);
                if (BigDecimal.ZERO.compareTo(entry.getQty()) < 0) {
                    entry.setQty(entry.getQty().subtract(reserveQty));
                } else {
                    entry.setQty(entry.getQty().add(reserveQty));
                }
                if (BigDecimal.ZERO.compareTo(entry.getQty2nd()) < 0) {
                    entry.setQty2nd(entry.getQty2nd().subtract(reserveQty2nd));
                } else {
                    entry.setQty2nd(entry.getQty2nd().add(reserveQty2nd));
                }
                it.remove();
                continue;
            }
            BigDecimal subQty = this.convRate.getSrcQty(baseSubQty, record.getMaterialId(), record.getUnitId(), record.getBaseUnitId());
            if (reserveQty == null) {
                reserveQty = BigDecimal.ZERO;
            }
            if (reserveQty.compareTo(subQty) <= 0) {
                releaseRecord.set("qty", (Object)reserveQty);
            } else {
                releaseRecord.set("qty", (Object)subQty);
            }
            if (reserveQty2nd == null) {
                reserveQty2nd = BigDecimal.ZERO;
            }
            if (reserveQty2nd.compareTo(subQty2nd = RecordReleaseModle.setReleaseQty(qty2nd, releaseRecord, reserveQty2nd, "qty2nd")) <= 0) {
                releaseRecord.set("qty2nd", (Object)reserveQty2nd);
            } else {
                releaseRecord.set("qty2nd", (Object)subQty2nd);
            }
            record.setBaseQty(reserveBaseQty);
            BigDecimal remainQty = reserveQty.subtract(subQty);
            if (BigDecimal.ZERO.compareTo(remainQty) > 0) {
                remainQty = BigDecimal.ZERO;
            }
            record.setQty(remainQty);
            BigDecimal remainQty2nd = reserveQty2nd.subtract(subQty2nd);
            if (BigDecimal.ZERO.compareTo(remainQty2nd) > 0) {
                remainQty2nd = BigDecimal.ZERO;
            }
            record.setQty2nd(remainQty2nd);
            qty = qty.subtract(subQty);
            qty2nd = qty2nd.subtract(subQty2nd);
            if (BigDecimal.ZERO.compareTo(entry.getQty()) < 0) {
                entry.setQty(entry.getQty().subtract(subQty));
            } else {
                entry.setQty(entry.getQty().add(subQty));
            }
            if (BigDecimal.ZERO.compareTo(entry.getQty2nd()) < 0) {
                entry.setQty2nd(entry.getQty2nd().subtract(subQty2nd));
                continue;
            }
            entry.setQty2nd(entry.getQty2nd().add(subQty2nd));
        }
    }

    public List<DynamicObject> matchUnReleaseRecord() {
        if (this.colsMap == null) {
            this.initModel();
        }
        Map<Long, List<RecordData>> recordMap = this.getReleaseRecord4Entry();
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(this.entryList.size());
        if (this.entryList.isEmpty()) {
            return releaseList;
        }
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"msmod_release_record");
        for (RecordBillEntryModel entry : this.entryList) {
            this.createUnReleaseRecord(releaseList, entry, dt, recordMap);
        }
        logger.info("RecordReleaseModle createUnReleaseRecord==releaseList.size()===" + releaseList.size());
        return releaseList;
    }

    private void createUnReleaseRecord(List<DynamicObject> releaseRecordList, RecordBillEntryModel entry, MainEntityType dt, Map<Long, List<RecordData>> recordMap) {
        BigDecimal baseQty = entry.getBaseQty().abs();
        BigDecimal qty = entry.getQty() == null ? BigDecimal.ZERO : entry.getQty().abs();
        BigDecimal qty2nd = entry.getQty2nd() == null ? BigDecimal.ZERO : entry.getQty2nd().abs();
        List<RecordData> records = recordMap.get(entry.getEntryId());
        if (records == null) {
            return;
        }
        Iterator<RecordData> it = records.iterator();
        while (it.hasNext()) {
            RecordData record = it.next();
            if (baseQty.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            Long releaseId = record.getReleaseId();
            DynamicObject releaseRecord = (DynamicObject)dt.createInstance();
            releaseRecordList.add(releaseRecord);
            releaseRecord.set("id", (Object)releaseId);
            releaseRecord.set("reserve_record", (Object)record.getPkValue());
            releaseRecord.set("release_type", (Object)"release");
            releaseRecord.set("bill_obj", (Object)record.getBillObjId());
            releaseRecord.set("billid", (Object)entry.getBillId());
            releaseRecord.set("entryid", (Object)entry.getEntryId());
            releaseRecord.set("op", (Object)"audit");
            releaseRecord.set("billno", (Object)entry.getBillNo());
            releaseRecord.set("balobj", (Object)record.getBalObj());
            releaseRecord.set("balid", (Object)record.getBalId());
            releaseRecord.set("aggregateid", (Object)record.getAggregateId());
            BigDecimal reserveBaseQty = record.getBaseQty();
            BigDecimal reserveQty = record.getQty();
            BigDecimal reserveQty2nd = record.getQty2nd();
            BigDecimal baseSubQty = RecordReleaseModle.setReleaseQty(baseQty, releaseRecord, reserveBaseQty, "base_qty");
            baseQty = baseQty.subtract(baseSubQty);
            reserveBaseQty = reserveBaseQty.subtract(baseSubQty);
            if (reserveBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                releaseRecord.set("qty", (Object)reserveQty);
                releaseRecord.set("qty2nd", (Object)reserveQty2nd);
                qty = qty.subtract(reserveQty);
                qty2nd = qty2nd.subtract(reserveQty2nd);
                it.remove();
                continue;
            }
            BigDecimal subQty = this.convRate.getSrcQty(baseSubQty, record.getMaterialId(), record.getUnitId(), record.getBaseUnitId());
            releaseRecord.set("qty", (Object)subQty);
            BigDecimal subQty2nd = RecordReleaseModle.setReleaseQty(qty2nd, releaseRecord, reserveQty2nd, "qty2nd");
            record.setBaseQty(reserveBaseQty.subtract(baseSubQty));
            record.setQty(reserveQty.subtract(subQty));
            record.setQty2nd(reserveQty2nd.subtract(subQty2nd));
            qty = qty.subtract(subQty);
            qty2nd = qty2nd.subtract(subQty2nd);
        }
    }

    private Map<Long, List<RecordData>> getReleaseRecord4Entry() {
        HashMap<Long, List<RecordData>> recordMap = new HashMap<Long, List<RecordData>>(16);
        QFilter recordFilter = new QFilter("billid", "in", this.ids);
        recordFilter = recordFilter.and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
        recordFilter = recordFilter.and(new QFilter("bill_obj", "=", (Object)this.formId));
        DataSet recordDatas = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":getReleaseRecord4Entry"), (String)"msmod_release_record", (String)"id,reserve_record,entryid,base_qty,qty,qty2nd,bill_obj,billid,billno,balobj,balid,aggregateid", (QFilter[])recordFilter.toArray(), null);
        while (recordDatas.hasNext()) {
            Row next = recordDatas.next();
            Long entryId = next.getLong("entryid");
            ArrayList<RecordData> records = (ArrayList<RecordData>)recordMap.get(entryId);
            if (records == null) {
                records = new ArrayList<RecordData>(16);
                recordMap.put(entryId, records);
            }
            RecordData record = new RecordData();
            record.setPkValue(next.getLong("reserve_record"));
            record.setReleaseId(next.getLong("id"));
            record.setEntryId(entryId);
            record.setBillObjId(this.formId);
            record.setBaseQty(next.getBigDecimal("base_qty"));
            record.setQty(next.getBigDecimal("qty"));
            record.setQty2nd(next.getBigDecimal("qty2nd"));
            record.setBalObj(next.getString("balobj"));
            record.setBalId(next.getLong("balid"));
            record.setAggregateId(next.getLong("aggregateid"));
            records.add(record);
        }
        return recordMap;
    }

    private static BigDecimal setReleaseQty(BigDecimal qty, DynamicObject releaseRecord, BigDecimal reserveBaseQty, String releaseQty) {
        BigDecimal subQty = reserveBaseQty.min(qty);
        releaseRecord.set(releaseQty, (Object)subQty);
        return subQty;
    }

    public List<DynamicObject> matchTransReleaseRecord(DataSet releaseRuleDataSet) {
        if (this.colsMap == null) {
            this.initModel();
        }
        ArrayList<DynamicObject> releaseList = new ArrayList<DynamicObject>(this.entryList.size());
        if (this.entryList.isEmpty()) {
            return releaseList;
        }
        HashSet<Long> outEntryIDset = new HashSet<Long>(this.entryList.size());
        Map<String, String> balColMap = this.colsMap.getBalColMap();
        String entryName = balColMap.get("entryentity");
        for (RecordBillEntryModel recordBillEntryModel : this.entryList) {
            outEntryIDset.add(recordBillEntryModel.getEntryId());
        }
        Set<Object> srcIds = ReserveHelper.getBotpLinkBillIds(this.formId, this.ids.toArray(new Long[this.ids.size()]));
        Map<Object, List<Object>> bOTPEntryIdMap = ReserveHelper.getBotpUpPath4EntryId(this.formId, entryName, outEntryIDset.toArray(new Long[outEntryIDset.size()]), this.ids.toArray(new Long[this.ids.size()]));
        QFilter transFilter = new QFilter("billid", "in", srcIds);
        DataSet trans = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":matchTransReleaseRecord"), (String)"msmod_reservetrans", (String)"afrecordid", (QFilter[])transFilter.toArray(), null);
        HashSet reserveIds = new HashSet(16);
        trans.forEach(v -> reserveIds.add(v.getLong("afrecordid")));
        if (reserveIds.isEmpty()) {
            return releaseList;
        }
        this.recordSelectFields(this.releaseRule);
        List<Long> reserveObjList = this.selectReleaseObjList(this.entryList);
        QFilter recordFilter = new QFilter("id", "in", reserveIds);
        recordFilter = recordFilter.and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
        recordFilter = recordFilter.and(new QFilter("ispredict", "=", (Object)Boolean.FALSE));
        if (reserveObjList != null && reserveObjList.size() != 0) {
            recordFilter.or("reserveobj", "in", reserveObjList).and("reservemethod", "=", (Object)"2");
        }
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":matchReleaseRecord"), (String)"msmod_reserve_record", (String)"id,bal_obj,bal_id,billentry_id,base_qty,qty,qty2nd,aggregateid,reservemethod,reserveobjtype,bal_entryid", (QFilter[])recordFilter.toArray(), null);
        HashSet<String> supplierIdSet = new HashSet<String>(16);
        Map<String, Set<Object>> balIdMap = this.getReleaseBalIdMap(recordDataSet.copy(), supplierIdSet);
        if (supplierIdSet.isEmpty()) {
            return releaseList;
        }
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"msmod_release_record");
        DataSet recordDetailDataSet = this.mergeReleaseRecord(recordDataSet.copy(), supplierIdSet, balIdMap, this.releaseRule, releaseRuleDataSet);
        List<RecordData> recordDatas = this.buildReleaseRecordData(recordDetailDataSet, null);
        if (ReserveAggregateHelper.isAggregate()) {
            List<String> aggregateField = ReserveAggregateHelper.getAggregateField();
            DataSet recordAggDataSet = this.mergeReleaseRecordForAgg(recordDataSet.copy(), aggregateField, this.releaseRule, releaseRuleDataSet);
            recordDatas.addAll(this.buildReleaseRecordData(recordAggDataSet, aggregateField));
        }
        logger.info("matchReleaseRecord=====recordMap.size()==" + recordDatas.size());
        for (RecordBillEntryModel entry : this.entryList) {
            this.createReleaseRecord(releaseList, entry, dt, recordDatas, bOTPEntryIdMap);
        }
        return releaseList;
    }

    public List<DynamicObject> matchReleaseRecordForCheck(IFormView formView) {
        if (this.colsMap == null) {
            this.initModel();
        }
        if (this.entryList.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        HashSet<Long> outEntryIDset = new HashSet<Long>(this.entryList.size());
        Map<String, String> balColMap = this.colsMap.getBalColMap();
        String entryName = balColMap.get("entryentity");
        for (RecordBillEntryModel recordBillEntryModel : this.entryList) {
            outEntryIDset.add(recordBillEntryModel.getEntryId());
        }
        DataSet releaseRuleDataSet = null;
        if (this.releaseRule != null) {
            Object pkValue = this.releaseRule.getPkValue();
            QFilter qFilter = new QFilter("id", "=", pkValue);
            releaseRuleDataSet = QueryServiceHelper.queryDataSet((String)ReserveService.class.getName(), (String)"msmod_release_rule", (String)"entryentity.releasetype as releasetype,entryentity.priority as priority", (QFilter[])qFilter.toArray(), null);
        }
        HashMap<Long, Map<String, Object>> recordMap = new HashMap<Long, Map<String, Object>>(16);
        DataSet recordDataSet = this.getRecordDataSet(formView, recordMap);
        List<DynamicObject> releaseList = new ArrayList<DynamicObject>(this.entryList.size());
        if (recordDataSet == null || !recordDataSet.hasNext()) {
            return releaseList;
        }
        Map<Object, List<Object>> bOTPEntryIdMap = ReserveHelper.getBotpUpPath4EntryId(this.formId, entryName, outEntryIDset.toArray(new Long[outEntryIDset.size()]), this.ids.toArray(new Long[this.ids.size()]));
        DataSet detailRecordDataSet = recordDataSet.copy().filter("bal_id != 0");
        ArrayList<RecordData> showRecordList = new ArrayList<RecordData>(16);
        releaseList = releaseRuleDataSet == null ? this.dealReleaseList(null, detailRecordDataSet, bOTPEntryIdMap, showRecordList) : this.dealReleaseList(releaseRuleDataSet.copy(), detailRecordDataSet, bOTPEntryIdMap, showRecordList);
        DataSet aggRecordDataSet = recordDataSet.copy().filter("bal_id ==0");
        if (aggRecordDataSet.hasNext()) {
            List<String> aggregateField = ReserveAggregateHelper.getAggregateField();
            if (ReserveAggregateHelper.isAggregate() && this.releaseRule != null) {
                DynamicObjectCollection ruleEntry = this.releaseRule.getDynamicObjectCollection("rule_entry");
                for (DynamicObject rule : ruleEntry) {
                    if (aggregateField.contains(rule.getString("std_inv_col_no"))) continue;
                    this.ruleMatchKeyMap.keySet().removeIf(key -> key.equals(rule.getString("std_inv_col_no")));
                }
            }
            releaseList.addAll(this.dealAggReleaseList(releaseRuleDataSet, aggRecordDataSet, bOTPEntryIdMap, showRecordList));
        }
        formView.setVisible(Boolean.valueOf(true), new String[]{"userecordflex"});
        if (showRecordList.size() == 0) {
            formView.setVisible(Boolean.valueOf(false), new String[]{"entryentity1"});
            formView.getModel().setValue("recordinfo1", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u9884\u7559\u8bb0\u5f55\u3002", (String)"ReleaseCheckToolPlugin_17", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            formView.setVisible(Boolean.valueOf(true), new String[]{"entryentity21"});
            return new ArrayList<DynamicObject>(0);
        }
        formView.setVisible(Boolean.valueOf(true), new String[]{"entryentity1"});
        formView.setVisible(Boolean.valueOf(false), new String[]{"entryentity21"});
        AbstractFormDataModel model = (AbstractFormDataModel)formView.getModel();
        model.getDataEntity(true);
        model.deleteEntryData("entryentity1");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < showRecordList.size(); ++i) {
            RecordData recordData = (RecordData)showRecordList.get(i);
            Map record = (Map)recordMap.get(recordData.getPkValue());
            if (record == null) continue;
            vs.addField("recordid2", new Object[]{record.get("id")});
            vs.addField("bill_no1", new Object[]{record.get("bill_no")});
            vs.addField("billentry_seq1", new Object[]{record.get("billentry_seq")});
            vs.addField("s_materiel1", new Object[]{record.get("s_materiel.number")});
            vs.addField("s_materialname1", new Object[]{record.get("s_materiel.name")});
            vs.addField("s_unit1", new Object[]{record.get("s_unit")});
            vs.addField("qty2", new Object[]{record.get("qty")});
            vs.addField("s_baseunit1", new Object[]{record.get("s_baseunit")});
            vs.addField("base_qty2", new Object[]{record.get("base_qty")});
            vs.addField("s_unit2nd1", new Object[]{record.get("s_unit2nd")});
            vs.addField("qty2nd2", new Object[]{record.get("qty2nd")});
            vs.addField("create_date1", new Object[]{record.get("create_date")});
            vs.addField("bal_obj1", new Object[]{record.get("bal_obj")});
            vs.addField("bal_id1", new Object[]{record.get("bal_id")});
            vs.addField("s_billnum1", new Object[]{record.get("s_billnum")});
            vs.addField("s_entryseq1", new Object[]{record.get("s_entryseq")});
            vs.addField("aggregateid1", new Object[]{record.get("aggregateid")});
            vs.addField("reservemethod1", new Object[]{record.get("reservemethod")});
        }
        model.batchCreateNewEntryRow("entryentity1", vs);
        formView.updateView("entryentity1");
        formView.setVisible(Boolean.valueOf(true), new String[]{"releaseflex"});
        String matchEntryName = "matchentry";
        if (releaseList.size() == 0) {
            formView.setVisible(Boolean.valueOf(false), new String[]{matchEntryName});
            formView.getModel().setValue("matchinfo", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u9884\u7559\u91ca\u653e\u5339\u914d\u7ed3\u679c\u3002", (String)"ReleaseCheckToolPlugin_14", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            formView.setVisible(Boolean.valueOf(true), new String[]{"matchentry3"});
            return new ArrayList<DynamicObject>(0);
        }
        formView.setVisible(Boolean.valueOf(true), new String[]{matchEntryName});
        formView.setVisible(Boolean.valueOf(false), new String[]{"matchentry3"});
        AbstractFormDataModel model2 = (AbstractFormDataModel)formView.getModel();
        model2.getDataEntity(true);
        model2.deleteEntryData(matchEntryName);
        TableValueSetter vs2 = new TableValueSetter(new String[0]);
        for (DynamicObject obj : releaseList) {
            vs2.addField("recordid1", new Object[]{obj.getLong("reserve_record")});
            vs2.addField("qty1", new Object[]{obj.get("qty")});
            vs2.addField("base_qty1", new Object[]{obj.get("base_qty")});
            vs2.addField("qty2nd1", new Object[]{obj.get("qty2nd")});
            vs2.addField("billid", new Object[]{obj.getLong("billid")});
            vs2.addField("entryid", new Object[]{obj.getLong("entryid")});
        }
        model2.batchCreateNewEntryRow(matchEntryName, vs2);
        formView.updateView(matchEntryName);
        return releaseList;
    }

    private DataSet getRecordDataSet(IFormView formView, Map<Long, Map<String, Object>> recordMap) {
        TableValueSetter vs;
        AbstractFormDataModel model;
        Set<Object> srcIds = ReserveHelper.getBotpLinkBillIds(this.formId, this.ids.toArray(new Long[this.ids.size()]));
        QFilter recordFilter = new QFilter("bill_id", "in", srcIds);
        recordFilter = recordFilter.and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
        String recordSelectCols = "id,bal_obj,bal_id,billentry_id,base_qty,qty,qty2nd,aggregateid,reservemethod,reserveobjtype,bal_entryid,bill_no,billentry_seq,s_materiel.number,s_materiel.name,s_unit,s_baseunit,s_unit2nd,create_date,s_billnum,s_entryseq";
        if (this.releaseRule == null) {
            recordSelectCols = recordSelectCols + ",s_materiel as materiel,s_unit as unit,s_baseunit as baseunit,s_unit2nd as unit2nd";
        }
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":matchReleaseRecord"), (String)"msmod_reserve_record", (String)recordSelectCols, (QFilter[])recordFilter.toArray(), (String)"id");
        if (this.releaseRule != null) {
            this.recordSelectFields(this.releaseRule);
            DataSet hasReserveBill = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":msmod_reservebill"), (String)"msmod_reservebill", (String)"id", null, null).top(1);
            if (hasReserveBill.hasNext()) {
                DataSet objRecorddDataSet;
                List<Long> reserveObjList = this.selectReleaseObjList(this.entryList);
                QFilter objFilter = null;
                if (reserveObjList != null && reserveObjList.size() != 0) {
                    objFilter = new QFilter("reservemethod", "=", (Object)"2");
                    objFilter.and("reserveobj", "in", reserveObjList).and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
                }
                if (objFilter != null && (objRecorddDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":matchReleaseRecord"), (String)"msmod_reserve_record", (String)recordSelectCols, (QFilter[])objFilter.toArray(), (String)"id")).hasNext()) {
                    recordDataSet = recordDataSet.union(objRecorddDataSet);
                }
            }
        }
        String recordEntryName = "entryentity";
        if (recordDataSet.hasNext()) {
            formView.setVisible(Boolean.valueOf(true), new String[]{"recordflex"});
            formView.setVisible(Boolean.valueOf(true), new String[]{recordEntryName});
            DataSet recordDataSetCopy = recordDataSet.copy();
            model = (AbstractFormDataModel)formView.getModel();
            model.getDataEntity(true);
            model.deleteEntryData(recordEntryName);
            vs = new TableValueSetter(new String[0]);
            String[] fieldNameArray = recordDataSetCopy.getRowMeta().getFieldNames();
            while (recordDataSetCopy.hasNext()) {
                Row row = recordDataSetCopy.next();
                long recordId = row.getLong("id");
                HashMap<String, Object> valMap = new HashMap<String, Object>(32);
                for (int i = 0; i < fieldNameArray.length; ++i) {
                    valMap.put(fieldNameArray[i], row.get(fieldNameArray[i]));
                }
                recordMap.put(recordId, valMap);
                vs.addField("recordid", new Object[]{recordId});
                vs.addField("bill_no", new Object[]{row.getString("bill_no")});
                vs.addField("billentry_seq", new Object[]{row.get("billentry_seq")});
                vs.addField("s_materiel", new Object[]{row.get("s_materiel.number")});
                vs.addField("s_materialname", new Object[]{row.get("s_materiel.name")});
                vs.addField("s_unit", new Object[]{row.get("s_unit")});
                vs.addField("qty", new Object[]{row.get("qty")});
                vs.addField("s_baseunit", new Object[]{row.get("s_baseunit")});
                vs.addField("base_qty", new Object[]{row.get("base_qty")});
                vs.addField("s_unit2nd", new Object[]{row.get("s_unit2nd")});
                vs.addField("qty2nd", new Object[]{row.get("qty2nd")});
                vs.addField("create_date", new Object[]{row.get("create_date")});
                vs.addField("bal_obj", new Object[]{row.get("bal_obj")});
                vs.addField("bal_id", new Object[]{row.get("bal_id")});
                vs.addField("s_billnum", new Object[]{row.get("s_billnum")});
                vs.addField("s_entryseq", new Object[]{row.get("s_entryseq")});
                vs.addField("aggregateid", new Object[]{row.get("aggregateid")});
                vs.addField("reservemethod", new Object[]{row.getString("reservemethod")});
            }
        } else {
            formView.setVisible(Boolean.valueOf(false), new String[]{recordEntryName});
            formView.getModel().setValue("recordinfo", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u9884\u7559\u8bb0\u5f55\u3002", (String)"ReleaseCheckToolPlugin_13", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            formView.setVisible(Boolean.valueOf(true), new String[]{"entryentity2"});
            return null;
        }
        model.batchCreateNewEntryRow(recordEntryName, vs);
        formView.updateView(recordEntryName);
        formView.setVisible(Boolean.valueOf(false), new String[]{"entryentity2"});
        return recordDataSet;
    }
}

