/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.record;

import java.math.BigDecimal;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RequestEntryMatch {
    private static final Log logger = LogFactory.getLog(RequestEntryMatch.class);
    private String compareType = null;
    private Object srcVal = null;
    private String tarKey = null;

    private RequestEntryMatch(String compareType, Object srcVal, String tarKey) {
        this.compareType = compareType;
        this.srcVal = srcVal;
        this.tarKey = tarKey;
    }

    public static RequestEntryMatch getInstance(String compareType, Object srcVal, String tarKey) {
        return new RequestEntryMatch(compareType, srcVal, tarKey);
    }

    public boolean match(Object tarVal) {
        if (this.compareType == null || "".equals(this.compareType) || this.srcVal == null || "".equals(this.srcVal)) {
            return true;
        }
        if (tarVal instanceof BigDecimal && this.srcVal instanceof BigDecimal) {
            int compareTo = ((BigDecimal)tarVal).compareTo((BigDecimal)this.srcVal);
            return this.compareTo(compareTo);
        }
        if ("=".equals(this.compareType)) {
            return this.srcVal.equals(tarVal);
        }
        try {
            if (tarVal instanceof Long && this.srcVal instanceof Long) {
                return this.compareTo(Long.compare((Long)tarVal, (Long)this.srcVal));
            }
            return this.compareTo(Long.compare(Long.parseLong(tarVal.toString()), Long.parseLong(this.srcVal.toString())));
        }
        catch (Exception e) {
            logger.error("tarVal:" + tarVal + ", srcVal:" + this.srcVal + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u5b57\u7c7b\u578b\u3002" + e.getMessage());
            return true;
        }
    }

    public String getTarKey() {
        return this.tarKey;
    }

    private boolean compareTo(int compareTo) {
        switch (this.compareType) {
            case ">": {
                return compareTo > 0;
            }
            case "=": {
                return compareTo == 0;
            }
            case "<": {
                return compareTo < 0;
            }
        }
        return true;
    }
}

