/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.record;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveCommonHelper;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;

public class ReserveRecordHelper {
    private static final Log logger = LogFactory.getLog(ReserveRecordHelper.class);
    private static List<String> billModelFieldSet = new ArrayList<String>(32);
    private static List<String> balModelFieldSet = new ArrayList<String>(32);

    public static List<DynamicObject> fromEntryResult(EntryReserveResult entryResult, ReserveContext context, Map<Object, DynamicObject> supInfoMap, Map<Long, Integer> entryIdExpireDateMap, boolean isAggScheme) {
        LinkedList<DynamicObject> reserveRecords = new LinkedList<DynamicObject>();
        List<StdInvResult> stdInvResults = entryResult.getStdInvResultList();
        billModelFieldSet = context.getBillModelFieldSet();
        balModelFieldSet = context.getBalModelFieldSet();
        ArrayList<StdInvResult> aggInvResults = new ArrayList<StdInvResult>(8);
        ArrayList<StdInvResult> invResults = new ArrayList<StdInvResult>(8);
        for (StdInvResult stdInvResult : stdInvResults) {
            if (!stdInvResult.isPredict() && context.isAggregate() && isAggScheme) {
                aggInvResults.add(stdInvResult);
                continue;
            }
            invResults.add(stdInvResult);
        }
        if (invResults.size() > 0) {
            ReserveRecordHelper.createDetailReserveRecord(entryResult, context, reserveRecords, invResults, supInfoMap, entryIdExpireDateMap);
        }
        if (aggInvResults.size() > 0) {
            ReserveRecordHelper.createAggregateReserveRecord(entryResult, context, reserveRecords, aggInvResults, entryIdExpireDateMap);
        }
        return reserveRecords;
    }

    public static void createDetailReserveRecord(EntryReserveResult entryResult, ReserveContext context, List<DynamicObject> reserveRecords, List<StdInvResult> stdInvResults, Map<Object, DynamicObject> supInfoMap, Map<Long, Integer> entryIdExpireDateMap) {
        Date now = TimeServiceHelper.now();
        Long creator = RequestContext.get().getCurrUserId();
        for (int i = 0; i < stdInvResults.size(); ++i) {
            if (stdInvResults.get(i).getBaseQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject reserveRecord = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_record");
            reserveRecord.set("billentry_id", entryResult.getEntryId());
            ReserveRecordHelper.putRequestBillInfo(reserveRecord, context);
            ReserveRecordHelper.putInvInfo(reserveRecord, stdInvResults.get(i), entryResult.getSeq());
            ReserveRecordHelper.putRequestInfo(reserveRecord, context);
            ReserveRecordHelper.putSuppleInfo(stdInvResults.get(i), reserveRecord, context, supInfoMap);
            long schemeId = 0L;
            if (context.getScheme() != null) {
                schemeId = (Long)context.getScheme().getPkValue();
            }
            reserveRecord.set("reserve_scheme", (Object)schemeId);
            reserveRecord.set("create_date", (Object)now);
            reserveRecord.set("creater", (Object)creator);
            reserveRecord.set("reserveprctype", (Object)context.getReserveType());
            if ("msmod_reservebill".equals(context.getRequestFormId())) {
                String reserveObjTypeId = (String)entryResult.getReserveObjTypeId();
                if (StringUtils.isNotEmpty((CharSequence)reserveObjTypeId)) {
                    reserveRecord.set("reserveobjtype", entryResult.getReserveObjTypeId());
                    reserveRecord.set("reserveobj", entryResult.getReserveObj());
                    reserveRecord.set("reservemethod", (Object)"2");
                } else {
                    reserveRecord.set("reservemethod", (Object)"3");
                }
            } else {
                reserveRecord.set("reservemethod", (Object)"1");
            }
            ReserveRecordHelper.buildExpireDate(stdInvResults.get(i), entryIdExpireDateMap, now, i, reserveRecord);
            reserveRecords.add(reserveRecord);
        }
    }

    public static void createAggregateReserveRecord(EntryReserveResult entryResult, ReserveContext context, List<DynamicObject> reserveRecords, List<StdInvResult> stdInvResults, Map<Long, Integer> entryIdExpireDateMap) {
        Date now = TimeServiceHelper.now();
        Long creator = RequestContext.get().getCurrUserId();
        List<String> aggregateField = context.getAggregateField();
        for (int i = 0; i < stdInvResults.size(); ++i) {
            if (stdInvResults.get(i).getBaseQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            StdInvResult stdInvResult = stdInvResults.get(i);
            DynamicObject reserveRecord = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_record");
            reserveRecord.set("billentry_id", entryResult.getEntryId());
            reserveRecord.set("aggregateid", stdInvResult.getInvInfo().get("aggid"));
            ReserveRecordHelper.putRequestBillInfo(reserveRecord, context);
            reserveRecord.set("billentry_seq", (Object)entryResult.getSeq());
            reserveRecord.set("ispredict", (Object)stdInvResult.isPredict());
            Object srcObj = stdInvResult.getInvInfo().get("source_bal_obj");
            if (StringUtils.isBlank((Object)srcObj)) {
                srcObj = "im_inv_realbalance";
            }
            reserveRecord.set("bal_obj", srcObj);
            reserveRecord.set("base_qty", (Object)stdInvResult.getBaseQty());
            if (aggregateField.contains("unit")) {
                reserveRecord.set("qty", (Object)stdInvResult.getQty());
            }
            if (aggregateField.contains("unit2nd")) {
                reserveRecord.set("qty2nd", (Object)stdInvResult.getQty2nd());
            }
            reserveRecord.set("bal_source", stdInvResult.getInvInfo().get("source_type"));
            ReserveRecordHelper.putRequestInfo(reserveRecord, context);
            ReserveRecordHelper.putSuppleInfoForAggregate(stdInvResult, reserveRecord, context);
            long schemeId = 0L;
            if (context.getScheme() != null) {
                schemeId = (Long)context.getScheme().getPkValue();
            }
            reserveRecord.set("reserve_scheme", (Object)schemeId);
            reserveRecord.set("create_date", (Object)now);
            reserveRecord.set("creater", (Object)creator);
            reserveRecord.set("reserveprctype", (Object)context.getReserveType());
            if ("msmod_reservebill".equals(context.getRequestFormId())) {
                String reserveObjTypeId = (String)entryResult.getReserveObjTypeId();
                if (StringUtils.isNotEmpty((CharSequence)reserveObjTypeId)) {
                    reserveRecord.set("reserveobjtype", entryResult.getReserveObjTypeId());
                    reserveRecord.set("reserveobj", entryResult.getReserveObj());
                    reserveRecord.set("reservemethod", (Object)"2");
                } else {
                    reserveRecord.set("reservemethod", (Object)"3");
                }
            } else {
                reserveRecord.set("reservemethod", (Object)"1");
            }
            ReserveRecordHelper.buildExpireDate(stdInvResult, entryIdExpireDateMap, now, i, reserveRecord);
            reserveRecords.add(reserveRecord);
        }
    }

    private static void buildExpireDate(StdInvResult stdInvResult, Map<Long, Integer> entryIdExpireDateMap, Date now, int i, DynamicObject reserveRecord) {
        if (entryIdExpireDateMap.size() == 0) {
            return;
        }
        long entryId = Long.parseLong(stdInvResult.getInvInfo().get("entryid").toString());
        if (entryIdExpireDateMap.get(entryId) != null) {
            int expireDay = entryIdExpireDateMap.get(entryId);
            Calendar cal = Calendar.getInstance();
            cal.setTime(now);
            cal.add(5, expireDay);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            reserveRecord.set("expiredate", (Object)cal.getTime());
        }
    }

    private static void putSuppleInfo(StdInvResult stdInvResult, DynamicObject reserveRecord, ReserveContext context, Map<Object, DynamicObject> supBillMap) {
        Object billId = stdInvResult.getInvInfo().get("id");
        Object entryId = stdInvResult.getInvInfo().get("entryid");
        String supFormId = stdInvResult.getInvInfo().get("source_bal_obj").toString();
        reserveRecord.set("bal_obj", (Object)supFormId);
        reserveRecord.set("bal_id", billId);
        reserveRecord.set("bal_entryid", entryId);
        Map<String, String> balColMap = context.getSupColsMap(supFormId).getBalColMap();
        DynamicObject supBillDynamic = supBillMap.get(billId);
        ReserveRecordHelper.resBillInfo(balModelFieldSet, balColMap, reserveRecord, supBillDynamic, entryId, "billentry", true, billId);
    }

    private static void putSuppleInfoForAggregate(StdInvResult stdInvResult, DynamicObject reserveRecord, ReserveContext context) {
        List<String> fieldList = context.getAggregateField();
        Iterator<String> iterator = balModelFieldSet.iterator();
        while (iterator.hasNext()) {
            String modelFieldName;
            String field = modelFieldName = iterator.next();
            if (modelFieldName.startsWith("s_")) {
                field = modelFieldName.substring(2);
            }
            if (!fieldList.contains(field)) continue;
            reserveRecord.set(modelFieldName, stdInvResult.getInvInfo().get(field));
        }
    }

    private static void putRequestInfo(DynamicObject reserveRecord, ReserveContext context) {
        ColsMap demandColsMap = context.getDemandColsMap(context.getRequestFormId());
        Map<String, String> billColMap = demandColsMap.getBalColMap();
        DynamicObject requestBill = context.getRequestBill();
        long entryId = reserveRecord.getLong("billentry_id");
        ReserveRecordHelper.resBillInfo(billModelFieldSet, billColMap, reserveRecord, requestBill, entryId, "bill_entry", false, 0L);
    }

    private static void resBillInfo(List<String> billModelFieldSet, Map<String, String> billColMap, DynamicObject reserveRecord, DynamicObject bill, Object entryid, String billEntry, boolean isSup, Object billId) {
        if (isSup && billId.equals(entryid)) {
            reserveRecord.set("s_entryseq", null);
        }
        String bill_entry = billColMap.get(billEntry);
        Iterator<String> iterator = billModelFieldSet.iterator();
        while (iterator.hasNext()) {
            String resModleInfo;
            String field = resModleInfo = iterator.next();
            if (resModleInfo.startsWith("r_") || resModleInfo.startsWith("s_")) {
                field = resModleInfo.substring(2);
            }
            String fieldName = billColMap.get(field);
            if ("bill_entry".equals(field) || fieldName == null || fieldName.length() <= 0) continue;
            Object value = null;
            if (bill_entry != null && fieldName.startsWith(bill_entry)) {
                fieldName = fieldName.substring(bill_entry.length() + 1);
                DynamicObjectCollection billentrys = bill.getDynamicObjectCollection(bill_entry);
                for (DynamicObject billentry : billentrys) {
                    int entryIdIndex;
                    long entryId = billentry.getLong(entryIdIndex = ((IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)"id")).getOrdinal());
                    if (!entryid.equals(entryId)) continue;
                    value = ReserveRecordHelper.getFieldValue(fieldName, billentry);
                    if (isSup) {
                        if (billentry.getDataEntityType().getProperties().get((Object)"seq") == null) {
                            reserveRecord.set("s_entryseq", billentry.get("seq"));
                        } else {
                            reserveRecord.set("s_entryseq", billentry.get(((IDataEntityProperty)billentry.getDataEntityType().getProperties().get((Object)"seq")).getOrdinal()));
                        }
                    }
                    break;
                }
            } else {
                value = ReserveRecordHelper.getFieldValue(fieldName, bill);
            }
            reserveRecord.set(resModleInfo, value);
        }
    }

    private static Object getFieldValue(String fieldName, DynamicObject entryObj) {
        Object value;
        if (entryObj.getDataEntityType().getProperties().get((Object)fieldName) == null) {
            value = entryObj.get(fieldName);
        } else {
            int keyIndex = ((IDataEntityProperty)entryObj.getDataEntityType().getProperties().get((Object)fieldName)).getOrdinal();
            value = entryObj.get(keyIndex);
        }
        return value;
    }

    public static void initSelectInfo() {
        Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
        billModelFieldSet = new ArrayList<String>(32);
        balModelFieldSet = new ArrayList<String>(32);
        for (String key : allFieldMap.keySet()) {
            if (key.startsWith("r_")) {
                billModelFieldSet.add(key);
                continue;
            }
            if (!key.startsWith("s_")) continue;
            balModelFieldSet.add(key);
        }
    }

    public static Map<Long, Integer> getInventoryExpireMap(List<StdInvResult> stdInvResults, Map<Long, QFilter> orgFilterMap) {
        HashMap<Long, Integer> entryIdExpireDateMap = new HashMap<Long, Integer>(8);
        if (!ReserveCommonHelper.getScmParam("RESERVE002")) {
            return entryIdExpireDateMap;
        }
        long i = 0L;
        if (orgFilterMap == null) {
            orgFilterMap = new HashMap<Long, QFilter>(8);
        }
        for (StdInvResult stdInvResult : stdInvResults) {
            if (stdInvResult.getInvInfo().get("entryid") == null) {
                stdInvResult.getInvInfo().put("entryid", i);
                ++i;
            }
            if (stdInvResult.getInvInfo().get("org") == null) continue;
            String entityID = "bd_materialinventoryinfo";
            String selectProperties = "reservationperiod";
            long orgId = 0L;
            Object id = stdInvResult.getInvInfo().get("org");
            orgId = id instanceof Long ? (Long)id : Long.parseLong(id.toString());
            QFilter orgQFilter = orgFilterMap.get(orgId);
            if (orgQFilter == null) {
                orgQFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)orgId);
                orgFilterMap.put(orgId, orgQFilter);
            }
            QFilter materialQFilter = new QFilter("masterid", "=", stdInvResult.getInvInfo().get("materiel"));
            materialQFilter.and(selectProperties, "!=", null);
            materialQFilter.and(selectProperties, "!=", (Object)0);
            materialQFilter.and("enable", "=", (Object)Boolean.TRUE);
            materialQFilter.and("status", "=", (Object)Character.valueOf('C'));
            DynamicObject inventoryInfo = BusinessDataServiceHelper.loadSingleFromCache((String)entityID, (String)selectProperties, (QFilter[])new QFilter[]{orgQFilter, materialQFilter});
            if (inventoryInfo == null) continue;
            if (stdInvResult.getInvInfo().get("entryid") instanceof Integer) {
                entryIdExpireDateMap.put((Long)stdInvResult.getInvInfo().get("aggid"), inventoryInfo.getInt(selectProperties));
                continue;
            }
            entryIdExpireDateMap.put((Long)stdInvResult.getInvInfo().get("entryid"), inventoryInfo.getInt(selectProperties));
        }
        return entryIdExpireDateMap;
    }

    private static void putRequestBillInfo(DynamicObject reserveRecord, ReserveContext context) {
        reserveRecord.set("bill_obj", (Object)context.getRequestBill().getDataEntityType().getName());
        reserveRecord.set("bill_no", context.getBillNo());
        reserveRecord.set("bill_id", context.getRequestBillId());
        if (context.getRequestBill().getDynamicObjectType().getName().equals("msmod_std_request_bill")) {
            reserveRecord.set("bill_source", (Object)"2");
        } else {
            reserveRecord.set("bill_source", (Object)"1");
        }
    }

    private static void putInvInfo(DynamicObject reserveRecord, StdInvResult stdInvResult, int seq) {
        reserveRecord.set("entry_name", (Object)"billentry");
        reserveRecord.set("billentry_seq", (Object)seq);
        reserveRecord.set("aggregateid", stdInvResult.getInvInfo().get("aggid"));
        reserveRecord.set("ispredict", (Object)stdInvResult.isPredict());
        reserveRecord.set("base_qty", (Object)stdInvResult.getBaseQty());
        reserveRecord.set("qty", (Object)stdInvResult.getQty());
        reserveRecord.set("qty2nd", (Object)stdInvResult.getQty2nd());
        reserveRecord.set("bal_source", stdInvResult.getInvInfo().get("source_type"));
    }

    public static DynamicObjectCollection queryReserveRecordList(QFilter fs) {
        logger.info("\u67e5\u8be2\u9884\u7559\u8bb0\u5f55Filter\uff1a " + fs.toString());
        StringBuilder sb = new StringBuilder();
        List<String> aggregateField = ReserveAggregateHelper.getAggregateField();
        for (String field : aggregateField) {
            sb.append("s_").append(field).append(',');
        }
        sb.append("id,").append("bal_obj").append(',');
        sb.append("bal_id").append(',').append("base_qty").append(',');
        sb.append("qty").append(',').append("qty2nd").append(',');
        sb.append("reserve_scheme").append(", ispredict , isweak,aggregateid,bill_obj,bill_id,bill_no,billentry_seq,billentry_id");
        DynamicObjectCollection recordList = QueryServiceHelper.query((String)"msmod_reserve_record", (String)sb.toString(), (QFilter[])fs.toArray());
        return recordList;
    }

    public static void removeReserveRecord(List<DynamicObject> reserveRecordList) {
        Object[] ids = new Object[reserveRecordList.size()];
        for (int i = 0; i < reserveRecordList.size(); ++i) {
            ids[i] = reserveRecordList.get(i).getPkValue();
        }
        QFilter filter = new QFilter("id", "in", (Object)ids);
        int count = DeleteServiceHelper.delete((String)"msmod_reserve_record", (QFilter[])filter.toArray());
        logger.info("\u89e3\u9664\u9884\u7559\u8bb0\u5f55\uff1a" + count);
    }

    public static Map<Object, DynamicObject> getSupInfoMap(List<StdInvResult> stdInvResults) {
        HashMap<Object, DynamicObject> supInfoMap = new HashMap<Object, DynamicObject>(16);
        HashMap<Object, Set> formIdToIdsMapping = new HashMap<Object, Set>(8);
        for (StdInvResult stdInvResult : stdInvResults) {
            Map<String, Object> invInfo = stdInvResult.getInvInfo();
            if (invInfo == null) continue;
            Object formId = invInfo.get("source_bal_obj");
            if (StringUtils.isBlank((Object)formId)) {
                formId = "im_inv_realbalance";
            }
            Long billId = 0L;
            if (invInfo.get("id") != null) {
                billId = Long.valueOf(String.valueOf(invInfo.get("id")));
            }
            Set billIds = formIdToIdsMapping.computeIfAbsent(formId, k -> new HashSet(16));
            billIds.add(billId);
        }
        for (Map.Entry entry : formIdToIdsMapping.entrySet()) {
            DynamicObject[] supList;
            Object formId = entry.getKey();
            Set supIdSet = (Set)entry.getValue();
            for (DynamicObject sup : supList = BusinessDataServiceHelper.load((Object[])supIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)formId.toString()))) {
                supInfoMap.put(sup.getLong("id"), sup);
            }
        }
        return supInfoMap;
    }
}

