/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.replace;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ConvRateContext;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveCommonHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.ReserveServiceCfgFilterHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.datasource.DefaultDataReader;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.helper.ReserveOpLogHelper;
import kd.mpscmm.msbd.reserve.business.record.BalanceHelper;
import kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceBalRecordModel;
import kd.mpscmm.msbd.reserve.common.constant.ReplaceOpStatusEnum;

public class ReserveReplaceHelper {
    private static final Log log = LogFactory.getLog(ReserveReplaceHelper.class);
    private static String[] reserveFields = new String[]{"bill_obj", "bill_no", "bill_id", "billentry_id", "bill_source", "entry_name", "billentry_seq", "reserve_scheme", "reservemethod", "reserveobjtype", "reserveobj"};
    private static List<String> reserveFieldList = new ArrayList<String>(Arrays.asList(reserveFields));
    public static final String[] RESERVE_QTY_PROS = new String[]{"reserve_base_qty", "reserve_qty", "reserve_qty2nd"};
    public static final String INTRANSIT_INSTOCK = "1";
    public static final String INSTOCK_INSTOCK = "2";
    public static final String INSTOCK_INSTOCK_NO = "3";
    public static final String BY_RESERVERECORD = "4";

    public static boolean replacePredictRecord(BalanceUpdateArgs args, Set<Object> realBillIdSet) {
        try (TraceSpan ruleSpan = Tracer.create((String)"ReserveReplaceHelper", (String)"replacePredictRecord");){
            String entityNumber = args.getCtx().getEntityNumber();
            UpdateRule rule = args.getRule();
            String entryName = rule.getEntryName();
            BalanceTB balanceTB = rule.getBalanceTB();
            if (rule.getUpdateType() < 0) {
                boolean bl = false;
                return bl;
            }
            DataSet snapData = ReserveReplaceHelper.getSnapData(args, realBillIdSet);
            Map<Long, ReserveReplaceBalRecordModel> entry4BalIdMap = ReserveReplaceHelper.getEntryBalRecordMap(snapData, balanceTB.getName());
            if (entry4BalIdMap.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Map<Object, Set<Object>> srcEntryMap = ReserveReplaceHelper.getBotpSrcEntryMap(entityNumber, entryName, entry4BalIdMap);
            HashSet<Object> reserveBalIds = new HashSet<Object>(1024);
            for (Set<Object> srcEntryIds : srcEntryMap.values()) {
                reserveBalIds.addAll(srcEntryIds);
            }
            QFilter idF = new QFilter("bal_entryid", "in", reserveBalIds);
            idF = idF.and("base_qty", ">", (Object)BigDecimal.ZERO);
            idF = idF.and("ispredict", "=", (Object)INTRANSIT_INSTOCK);
            QFilter qtyF = new QFilter("reserve_scheme.aggregate", "=", (Object)"0");
            qtyF = qtyF.or("reserve_scheme", "=", (Object)0L);
            if ("msmod_reserveaggre".equals(balanceTB.getName())) {
                qtyF = new QFilter("reserve_scheme.aggregate", "=", (Object)INTRANSIT_INSTOCK);
            }
            StringBuilder reserveCols = new StringBuilder("bill_obj,bill_no,bill_id,billentry_id,bill_source,entry_name,billentry_seq,bal_obj,bal_id,bal_entryid,base_qty,qty,qty2nd,reserve_scheme,bal_source,reservemethod,reserveobjtype,reserveobj,aggregateid");
            Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
            HashSet<String> billModelFieldSet = new HashSet<String>(16);
            HashSet<String> balModelFieldSet = new HashSet<String>(16);
            for (String key : allFieldMap.keySet()) {
                if (key.startsWith("r_")) {
                    billModelFieldSet.add(key);
                    continue;
                }
                if (!key.startsWith("s_")) continue;
                balModelFieldSet.add(key);
            }
            for (String requesFiledInfo : billModelFieldSet) {
                reserveCols.append(',').append(requesFiledInfo);
            }
            for (String suppleFiledInfo : balModelFieldSet) {
                reserveCols.append(',').append(suppleFiledInfo);
            }
            DynamicObject[] reserveRecords = BusinessDataServiceHelper.load((String)"msmod_reserve_record", (String)reserveCols.toString(), (QFilter[])new QFilter[]{idF, qtyF}, (String)"create_date");
            if (reserveRecords.length == 0) {
                boolean bl = false;
                return bl;
            }
            ReserveReplaceHelper.savePredictReplaceResult(entityNumber, balanceTB, entry4BalIdMap, srcEntryMap, billModelFieldSet, balModelFieldSet, reserveRecords);
            ReserveReplaceHelper.saveOpForPredictIn(entityNumber, realBillIdSet);
        }
        return true;
    }

    private static void saveOpForPredictIn(String billName, Set<Object> realBillIdSet) {
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        DynamicObject[] opObjArray = new DynamicObject[realBillIdSet.size()];
        int i = 0;
        for (Object id : realBillIdSet) {
            DynamicObject opObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reservereplace_op");
            opObj.set("billobj", (Object)billName);
            opObj.set("billid", id);
            opObj.set("opstatus", (Object)ReplaceOpStatusEnum.ONCOMMIT);
            opObj.set("creater", (Object)userId);
            opObj.set("create_date", (Object)date);
            opObjArray[i] = opObj;
            ++i;
        }
        SaveServiceHelper.save((DynamicObject[])opObjArray);
    }

    private static void savePredictReplaceResult(String entityNumber, BalanceTB balanceTB, Map<Long, ReserveReplaceBalRecordModel> entry4BalIdMap, Map<Object, Set<Object>> srcEntryMap, Set<String> billModelFieldSet, Set<String> balModelFieldSet, DynamicObject[] reserveRecord) {
        if (reserveRecord.length == 0) {
            return;
        }
        Map<String, List<DynamicObject>> recordsMap = ReserveReplaceHelper.getHandleRecords(entityNumber, entry4BalIdMap, reserveRecord, srcEntryMap, balanceTB, balModelFieldSet, billModelFieldSet);
        List<DynamicObject> reserveTransList = recordsMap.get("msmod_reservetrans");
        SaveServiceHelper.save((DynamicObject[])reserveTransList.toArray(new DynamicObject[reserveTransList.size()]));
        SaveServiceHelper.save((DynamicObject[])reserveRecord);
        ThreadCache.put((Object)"ReserveOpType", (Object)"replaceout");
        ReserveOpLogHelper.createNewLogByRecord((Collection<DynamicObject>)recordsMap.get("msmod_reserve_record2"), false);
        ReserveRecordHandler.saveNewReserveRecord((Collection<DynamicObject>)recordsMap.get("msmod_reserve_record"));
        ThreadCache.put((Object)"ReserveOpType", (Object)"replacein");
        ReserveOpLogHelper.createNewLogByRecord((Collection<DynamicObject>)recordsMap.get("new_reserve_record4Log"), false);
    }

    private static void executeMethod(String sql, List<Object[]> pramsList, DBRoute scmRoute) {
        DB.executeBatch((DBRoute)scmRoute, (String)sql, pramsList);
    }

    private static Map<Long, List<DynamicObject>> getEntryReserveMap(Map<Object, Set<Object>> srcEntryMap, DynamicObject[] reserveRecords) {
        HashMap<Long, List<DynamicObject>> entryIdReserveMap = new HashMap<Long, List<DynamicObject>>(reserveRecords.length);
        for (DynamicObject reserveRecord : reserveRecords) {
            long balId = reserveRecord.getLong("bal_entryid");
            for (Map.Entry<Object, Set<Object>> entrySet : srcEntryMap.entrySet()) {
                Set<Object> entryIds = entrySet.getValue();
                Long key = (Long)entrySet.getKey();
                if (!entryIds.contains(balId)) continue;
                ArrayList<DynamicObject> reserveRecordList = (ArrayList<DynamicObject>)entryIdReserveMap.get(key);
                if (reserveRecordList == null) {
                    reserveRecordList = new ArrayList<DynamicObject>(16);
                }
                reserveRecordList.add(reserveRecord);
                entryIdReserveMap.put(key, reserveRecordList);
            }
        }
        return entryIdReserveMap;
    }

    private static DataSet getSnapData(BalanceUpdateArgs args, Set<Object> realBillIdSet) {
        String snapCols = "fkeycol,fbillid,fentryid,fbaseqty_sp,fqty_sp,fqty2nd_sp,fbillno,fentryseq";
        StringBuilder balSpQfb = new StringBuilder("fbaseqty_sp > 0 or fqty_sp > 0 or fqty2nd_sp > 0 ");
        DataSet balData = args.getUpdatedBalData("fid,fkeycol,fmaterialid,fbaseunitid,funitid", null, balSpQfb.toString());
        int i = 0;
        balSpQfb.append(" and fbillid in ( ");
        for (Object billId : realBillIdSet) {
            if (i > 0) {
                balSpQfb.append(',');
            }
            balSpQfb.append(billId);
            ++i;
        }
        balSpQfb.append(" )");
        DataSet snapData = args.getUpdatedSnapData(snapCols, balSpQfb.toString()).groupBy(new String[]{"fkeycol", "fbillid", "fentryid", "fbillno", "fentryseq"}).sum("fbaseqty_sp").sum("fqty_sp").sum("fqty2nd_sp").finish();
        snapData = snapData.join(balData, JoinType.INNER).on("fkeycol", "fkeycol").select(new String[]{"fbillid", "fentryid", "fbaseqty_sp", "fqty_sp", "fqty2nd_sp", "fbillno", "fentryseq"}, new String[]{"fid", "fmaterialid", "fbaseunitid", "funitid"}).finish();
        return snapData;
    }

    private static Map<Long, DynamicObject> getInvBillInfo(Map<Long, List<DynamicObject>> entryIdReserveMap, String balName, Map<Long, Long> entry4BalIdMap) {
        ArrayList<Long> entryIds = new ArrayList<Long>(entryIdReserveMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entryIdReserve : entryIdReserveMap.entrySet()) {
            Long entryId = entryIdReserve.getKey();
            entryIds.add(entry4BalIdMap.get(entryId));
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)balName);
        DynamicObject[] invBalance = BusinessDataServiceHelper.load((Object[])entryIds.toArray(), (DynamicObjectType)dataEntityType);
        HashMap<Long, DynamicObject> invBalanceMap = new HashMap<Long, DynamicObject>(invBalance.length);
        for (int i = 0; i < invBalance.length; ++i) {
            invBalanceMap.put(invBalance[i].getLong("id"), invBalance[i]);
        }
        return invBalanceMap;
    }

    private static Map<String, List<DynamicObject>> getHandleRecords(String entityNumber, Map<Long, ReserveReplaceBalRecordModel> entry4BalIdMap, DynamicObject[] reserveRecords, Map<Object, Set<Object>> srcEntryMap, BalanceTB balanceTB, Set<String> balModelFieldSet, Set<String> billModelFieldSet) {
        Map<Long, List<DynamicObject>> entryIdReserveMap = ReserveReplaceHelper.getEntryReserveMap(srcEntryMap, reserveRecords);
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(2);
        if (entryIdReserveMap.isEmpty()) {
            return result;
        }
        String balName = balanceTB.getName();
        Map<Long, Map<String, Long>> entryUnitMap = ReserveReplaceHelper.getEntryUnitMap(reserveRecords);
        ConvRateContext convRate = new ConvRateContext();
        ArrayList<DynamicObject> newReserveRecords = new ArrayList<DynamicObject>(reserveRecords.length);
        ArrayList<DynamicObject> reserveTransRecords = new ArrayList<DynamicObject>(reserveRecords.length);
        result.put("msmod_reserve_record", newReserveRecords);
        ArrayList<DynamicObject> oldReserveRecordList = new ArrayList<DynamicObject>(reserveRecords.length);
        ArrayList<DynamicObject> newReserveRecordList = new ArrayList<DynamicObject>(reserveRecords.length);
        result.put("msmod_reserve_record2", oldReserveRecordList);
        result.put("msmod_reservetrans", reserveTransRecords);
        result.put("new_reserve_record4Log", newReserveRecordList);
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        int length = 0;
        for (List<DynamicObject> values : entryIdReserveMap.values()) {
            length += values.size();
        }
        long[] ids = DB.genLongIds((String)"t_msmod_reserverecord", (int)length);
        int i = 0;
        HashMap<Long, Long> entryIdInvIdMap = new HashMap<Long, Long>(1024);
        for (Map.Entry<Long, ReserveReplaceBalRecordModel> entry : entry4BalIdMap.entrySet()) {
            entryIdInvIdMap.put(entry.getKey(), entry.getValue().getBalId());
        }
        Map<Long, Integer> entryIdExpireDateMap = ReserveReplaceHelper.getInventoryExpireMap(balName, entryIdInvIdMap.values());
        Map<Long, DynamicObject> invBalanceMap = ReserveReplaceHelper.getInvBillInfo(entryIdReserveMap, balName, entryIdInvIdMap);
        Map<Long, Long> aggInvMap = ReserveReplaceHelper.getAggInvMap(balName, entryIdInvIdMap.values(), null);
        for (Map.Entry<Long, List<DynamicObject>> entryIdReserve : entryIdReserveMap.entrySet()) {
            List<DynamicObject> reserveRecordList = entryIdReserve.getValue();
            Long entryId = entryIdReserve.getKey();
            ReserveReplaceBalRecordModel balRecordModel = entry4BalIdMap.get(entryId);
            if (balRecordModel == null) continue;
            for (DynamicObject reserveRecord : reserveRecordList) {
                long newEntryID = balRecordModel.getBalId();
                Map<String, Long> unitMap = entryUnitMap.get(reserveRecord.getLong("bal_entryid"));
                if (unitMap == null) {
                    unitMap = entryUnitMap.get(0L);
                }
                if (unitMap == null && entryUnitMap.size() == 1) {
                    unitMap = entryUnitMap.get(entryUnitMap.keySet().toArray()[0]);
                }
                if (unitMap == null) continue;
                BigDecimal baseQty = reserveRecord.getBigDecimal("base_qty");
                BigDecimal qty = reserveRecord.getBigDecimal("qty");
                BigDecimal qty2nd = reserveRecord.getBigDecimal("qty2nd");
                Long reMaterialId = unitMap.get("materiel");
                Long reBaseUnitId = unitMap.get("baseunit");
                Long reUnitId = unitMap.get("unit");
                BigDecimal balbaseQty = balRecordModel.getAvbBaseQty();
                BigDecimal balQty = balRecordModel.getAvbQty();
                BigDecimal balQty2nd = balRecordModel.getAvbQty2nd();
                Long materialId = balRecordModel.getMaterialId();
                Long baseUnitId = balRecordModel.getBaseUnitId();
                Long unitId = balRecordModel.getUnitId();
                if (baseQty.compareTo(BigDecimal.ZERO) == 0 || balbaseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                DynamicObject reserveTrans = ReserveReplaceHelper.createTransObjForPredict(entityNumber, balanceTB, reserveTransRecords, userId, date, ids[i], entryId, balRecordModel, reserveRecord, newEntryID);
                DynamicObject suppleBill = invBalanceMap.get(newEntryID);
                DynamicObject newReserveRecord = ReserveReplaceHelper.createNewReserveRecord(reserveRecord, userId, date, newEntryID, billModelFieldSet);
                DynamicObject reserveRecord4Log = ReserveReplaceHelper.createReserveRecord4Log(entityNumber, balRecordModel);
                if (!"msmod_reserveaggre".equals(balName)) {
                    newReserveRecord.set("bal_id", (Object)newEntryID);
                    newReserveRecord.set("bal_entryid", (Object)newEntryID);
                    newReserveRecord.set("bal_obj", (Object)balName);
                    reserveRecord4Log.set("bal_id", (Object)newEntryID);
                    reserveRecord4Log.set("bal_obj", (Object)balName);
                } else {
                    newReserveRecord.set("bal_obj", (Object)suppleBill.getString("barobj"));
                    reserveRecord4Log.set("bal_obj", (Object)suppleBill.getString("barobj"));
                }
                if (aggInvMap.get(newEntryID) != null) {
                    newReserveRecord.set("aggregateid", (Object)aggInvMap.get(newEntryID));
                    reserveRecord4Log.set("aggregateid", (Object)aggInvMap.get(newEntryID));
                }
                ReserveReplaceHelper.setRserveeRcordInfo(newReserveRecord, balName, suppleBill, balModelFieldSet);
                newReserveRecord.set("bal_source", (Object)INTRANSIT_INSTOCK);
                DynamicObject oldReserveRecord = ReserveReplaceHelper.createOldReserveRecord4Log(entityNumber, balRecordModel, reserveRecord);
                if (entryIdExpireDateMap.get(newEntryID) != null) {
                    int expireDay = entryIdExpireDateMap.get(newEntryID);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    cal.add(5, expireDay);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    newReserveRecord.set("expiredate", (Object)cal.getTime());
                } else {
                    newReserveRecord.set("expiredate", null);
                }
                BigDecimal subBaseQty = BigDecimal.ZERO;
                BigDecimal subQty = BigDecimal.ZERO;
                BigDecimal subQty2nd = qty2nd.min(balQty2nd);
                if (baseQty.compareTo(balbaseQty) >= 0) {
                    subBaseQty = balbaseQty;
                    subQty = convRate.getSrcQty(subBaseQty, reMaterialId, reUnitId, reBaseUnitId).min(qty);
                    balRecordModel.addLockBaseQty(balbaseQty);
                    balRecordModel.addLockQty(balQty);
                    balRecordModel.addLockQty2nd(balQty2nd);
                    reserveRecord.set("base_qty", (Object)baseQty.subtract(subBaseQty));
                    reserveRecord.set("qty", (Object)qty.subtract(subQty));
                    reserveRecord.set("qty2nd", (Object)qty2nd.subtract(subQty2nd));
                    oldReserveRecord.set("base_qty", (Object)subBaseQty.negate());
                    oldReserveRecord.set("qty", (Object)subQty.negate());
                    oldReserveRecord.set("qty2nd", (Object)subQty2nd.negate());
                    newReserveRecord.set("id", (Object)ids[i]);
                    newReserveRecord.set("base_qty", (Object)subBaseQty);
                    newReserveRecord.set("qty", (Object)balQty);
                    newReserveRecord.set("qty2nd", (Object)subQty2nd);
                    newReserveRecords.add(newReserveRecord);
                    reserveTrans.set("replacebaseqty", (Object)subBaseQty);
                    if (subQty.compareTo(BigDecimal.ZERO) > 0) {
                        reserveTrans.set("replaceqty", (Object)subQty);
                    }
                    reserveTrans.set("replaceqty2nd", (Object)subQty2nd);
                    reserveTrans.set("outbaseqty", (Object)subBaseQty);
                    if (subQty.compareTo(BigDecimal.ZERO) > 0) {
                        reserveTrans.set("outqty", (Object)subQty);
                    }
                    reserveTrans.set("outqty2nd", (Object)subQty2nd);
                    reserveRecord4Log.set("id", (Object)ids[i]);
                    reserveRecord4Log.set("base_qty", (Object)subBaseQty);
                    reserveRecord4Log.set("qty", (Object)balQty);
                    reserveRecord4Log.set("qty2nd", (Object)subQty2nd);
                } else {
                    subBaseQty = baseQty;
                    subQty = convRate.getSrcQty(baseQty, materialId, unitId, baseUnitId).min(qty);
                    balRecordModel.addLockBaseQty(baseQty);
                    balRecordModel.addLockQty(qty);
                    balRecordModel.addLockQty2nd(qty2nd);
                    reserveRecord.set("base_qty", (Object)BigDecimal.ZERO);
                    reserveRecord.set("qty", (Object)BigDecimal.ZERO);
                    reserveRecord.set("qty2nd", (Object)BigDecimal.ZERO);
                    oldReserveRecord.set("base_qty", (Object)baseQty.negate());
                    oldReserveRecord.set("qty", (Object)subQty.negate());
                    oldReserveRecord.set("qty2nd", (Object)subQty2nd.negate());
                    newReserveRecord.set("id", (Object)ids[i]);
                    newReserveRecord.set("base_qty", (Object)baseQty);
                    newReserveRecord.set("qty", (Object)subQty);
                    newReserveRecord.set("qty2nd", (Object)subQty2nd);
                    newReserveRecords.add(newReserveRecord);
                    reserveTrans.set("replacebaseqty", (Object)baseQty);
                    if (subQty.compareTo(BigDecimal.ZERO) > 0) {
                        reserveTrans.set("replaceqty", (Object)subQty);
                    }
                    reserveTrans.set("replaceqty2nd", (Object)subQty2nd);
                    reserveTrans.set("outbaseqty", (Object)baseQty);
                    if (subQty.compareTo(BigDecimal.ZERO) > 0) {
                        reserveTrans.set("outqty", (Object)subQty);
                    }
                    reserveTrans.set("outqty2nd", (Object)subQty2nd);
                    reserveRecord4Log.set("id", (Object)ids[i]);
                    reserveRecord4Log.set("base_qty", (Object)baseQty);
                    reserveRecord4Log.set("qty", (Object)subQty);
                    reserveRecord4Log.set("qty2nd", (Object)subQty2nd);
                }
                oldReserveRecordList.add(oldReserveRecord);
                newReserveRecordList.add(reserveRecord4Log);
                ++i;
            }
        }
        return result;
    }

    private static DynamicObject createTransObjForPredict(String entityNumber, BalanceTB balanceTB, List<DynamicObject> reserveTransRecords, long userId, Date date, long id, Long entryId, ReserveReplaceBalRecordModel balRecordModel, DynamicObject reserveRecord, long newEntryID) {
        DynamicObject reserveTrans = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reservetrans");
        reserveTrans.set("transbill", (Object)entityNumber);
        reserveTrans.set("bfrecordid", reserveRecord.getPkValue());
        reserveTrans.set("afrecordid", (Object)id);
        reserveTrans.set("billid", (Object)balRecordModel.getBillId());
        reserveTrans.set("billentryid", (Object)entryId);
        reserveTrans.set("transtype", (Object)"trans");
        reserveTrans.set("creater", (Object)userId);
        reserveTrans.set("createdate", (Object)date);
        reserveTrans.set("invid", (Object)newEntryID);
        reserveTrans.set("baltablename", (Object)balanceTB.getTb());
        reserveTrans.set("billno", (Object)balRecordModel.getBillNo());
        reserveTrans.set("billentryseq", (Object)balRecordModel.getBillEntrySeq());
        reserveTransRecords.add(reserveTrans);
        return reserveTrans;
    }

    private static DynamicObject createReserveRecord4Log(String entityNumber, ReserveReplaceBalRecordModel balRecordModel) {
        DynamicObject reserveRecord4Log = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_record");
        reserveRecord4Log.set("bill_obj", (Object)entityNumber);
        reserveRecord4Log.set("bill_id", (Object)balRecordModel.getBillId());
        reserveRecord4Log.set("bill_no", (Object)balRecordModel.getBillNo());
        reserveRecord4Log.set("billentry_id", (Object)balRecordModel.getEntryId());
        reserveRecord4Log.set("billentry_seq", (Object)balRecordModel.getBillEntrySeq());
        return reserveRecord4Log;
    }

    private static DynamicObject createOldReserveRecord4Log(String entityNumber, ReserveReplaceBalRecordModel balRecordModel, DynamicObject reserveRecord) {
        DynamicObject oldReserveRecord = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_record");
        oldReserveRecord.set("id", reserveRecord.getPkValue());
        oldReserveRecord.set("bal_id", (Object)reserveRecord.getLong("bal_id"));
        oldReserveRecord.set("bal_obj", (Object)reserveRecord.getDynamicObject("bal_obj").getString("number"));
        oldReserveRecord.set("bill_obj", (Object)entityNumber);
        oldReserveRecord.set("bill_id", (Object)balRecordModel.getBillId());
        oldReserveRecord.set("bill_no", (Object)balRecordModel.getBillNo());
        oldReserveRecord.set("billentry_id", (Object)balRecordModel.getEntryId());
        oldReserveRecord.set("billentry_seq", (Object)balRecordModel.getBillEntrySeq());
        return oldReserveRecord;
    }

    public static Map<Long, Long> getAggInvMap(String balName, Collection<Long> balIdSet, QFilter[] aggFilter) {
        HashMap<Long, Long> aggInvMap = new HashMap<Long, Long>(16);
        if (ReserveAggregateHelper.isAggregateInit()) {
            Map<String, String> aggBalMap = ColsMapHelper.findBillColMaps("msmod_reserveaggre", "msmod_std_inv_field").getBalColMap();
            List<String> aggregateField = ReserveAggregateHelper.getAggregateField();
            StringBuilder sb = new StringBuilder();
            for (String field : aggregateField) {
                sb.append(aggBalMap.get(field)).append(" as ").append(field).append(',');
            }
            DataSet aggSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserveaggre", (String)org.apache.commons.lang3.StringUtils.join((Object[])new String[]{sb.toString(), "id as aggid"}), (QFilter[])aggFilter, null);
            QFilter qFilter = new QFilter("id", "in", balIdSet);
            DataSet invSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)balName, (String)org.apache.commons.lang3.StringUtils.join((Object[])new String[]{sb.toString(), "id as invId"}), (QFilter[])qFilter.toArray(), null);
            JoinDataSet joinDataSet = invSet.join(aggSet);
            for (String field : aggregateField) {
                joinDataSet.on(field, field);
            }
            invSet = joinDataSet.select(new String[]{"aggid", "invId"}).finish();
            while (invSet.hasNext()) {
                Row row = invSet.next();
                aggInvMap.put(row.getLong("invId"), row.getLong("aggid"));
            }
        }
        return aggInvMap;
    }

    private static void setRserveeRcordInfo(DynamicObject newReserveRecord, String balName, DynamicObject suppleBill, Set<String> balModelFieldSet) {
        ColsMap supColsMap = ColsMapHelper.findBillColMaps(balName, "msmod_std_inv_field");
        if (supColsMap != null) {
            Map<String, String> balColMap = supColsMap.getBalColMap();
            Iterator<String> iterator = balModelFieldSet.iterator();
            while (iterator.hasNext()) {
                String billkey;
                String suppleModleInfo;
                String fild = suppleModleInfo = iterator.next();
                if (suppleModleInfo.startsWith("s_")) {
                    fild = suppleModleInfo.substring(2);
                }
                if ((billkey = balColMap.get(fild)) == null || billkey.length() <= 0) continue;
                Object value = suppleBill.get(billkey);
                newReserveRecord.set(suppleModleInfo, value);
            }
        }
    }

    private static Map<Long, Integer> getInventoryExpireMap(String balName, Collection<Long> invIdList) {
        HashMap<Long, Integer> entryIdExpireDateMap = new HashMap<Long, Integer>(8);
        if (!ReserveCommonHelper.getScmParam("RESERVE002")) {
            return entryIdExpireDateMap;
        }
        ColsMap colsMap = ColsMapHelper.findBillColMaps(balName, "msmod_std_inv_field");
        StringBuilder sb = new StringBuilder();
        String selectEntryId = " id ";
        if (colsMap.getByBalCol("billentry") != null) {
            selectEntryId = StringUtils.join((Object[])new String[]{colsMap.getByBalCol("billentry"), ".id "});
        }
        sb.append(selectEntryId).append(" as entryID,");
        sb.append(colsMap.getByBalCol("materiel")).append(" as ").append("materialId,");
        sb.append(colsMap.getByBalCol("org")).append(" as ").append("orgId");
        if (sb.length() < 1) {
            return entryIdExpireDateMap;
        }
        QFilter qFilter = new QFilter(selectEntryId, "in", invIdList);
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)"ReserveReplaceHelper:getInventoryExpireMap", (String)balName, (String)sb.toString(), (QFilter[])new QFilter[]{qFilter}, null);
        String entityID = "bd_materialinventoryinfo";
        while (materialDataSet.hasNext()) {
            Row row = materialDataSet.next();
            QFilter orgQFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)row.getLong("orgId"));
            QFilter materialQFilter = new QFilter("masterid", "=", (Object)row.getLong("materialId"));
            materialQFilter.and("reservationperiod", "!=", null);
            materialQFilter.and("reservationperiod", "!=", (Object)0);
            String selectProperties = "reservationperiod";
            DynamicObject inventoryInfo = BusinessDataServiceHelper.loadSingle((String)entityID, (String)selectProperties, (QFilter[])new QFilter[]{orgQFilter, materialQFilter});
            if (inventoryInfo == null) continue;
            entryIdExpireDateMap.put(row.getLong("entryID"), inventoryInfo.getInt("reservationperiod"));
        }
        return entryIdExpireDateMap;
    }

    private static Map<Long, Map<String, Long>> getEntryUnitMap(DynamicObject[] reserveRecords) {
        HashMap<Long, Map<String, Long>> entryUnitMap = new HashMap<Long, Map<String, Long>>(reserveRecords.length);
        HashMap<String, HashSet<Long>> formBalIdMap = new HashMap<String, HashSet<Long>>(8);
        for (DynamicObject reserveRecord : reserveRecords) {
            String formId = reserveRecord.getString("bal_obj.id");
            HashSet<Long> balIds = (HashSet<Long>)formBalIdMap.get(formId);
            if (balIds == null) {
                balIds = new HashSet<Long>(16);
                formBalIdMap.put(formId, balIds);
            }
            balIds.add(reserveRecord.getLong("bal_id"));
        }
        Map<String, ColsMap> colsMapMap = ColsMapHelper.findBillColMaps(formBalIdMap.keySet(), "msmod_std_inv_field");
        for (Map.Entry entry : formBalIdMap.entrySet()) {
            String formId = (String)entry.getKey();
            Set balIds = (Set)entry.getValue();
            ColsMap colsMap = colsMapMap.get(formId);
            if (balIds.isEmpty() || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formId) || colsMap == null) {
                return entryUnitMap;
            }
            Map<String, String> colMap = colsMap.getBalColMap();
            StringBuilder sb = new StringBuilder();
            sb.append(colMap.get("materiel")).append(" as ").append("materiel");
            sb.append(" , ").append(colMap.get("baseunit")).append(" as ").append("baseunit");
            sb.append(" , ").append(colMap.get("unit")).append(" as ").append("unit");
            String materiel = colMap.get("materiel");
            if (materiel != null) {
                String[] materielArray = materiel.split("\\.");
                if (materielArray.length == 1) {
                    sb.append(" , ").append("id").append(" as ").append("entryid");
                } else {
                    if (colMap.get("billentry") == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7684\u9884\u7559\u4f9b\u5e94\u6a21\u578b\u914d\u7f6e\u4e2d\u6ca1\u6709\u914d\u7f6e\u5355\u636e\u4f53\u6807\u8bc6\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u4f9b\u5e94\u6a21\u578b\u914d\u7f6e\u3002", (String)"ReserveTransHelper_0", (String)"scmc-im-business", (Object[])new Object[0]), formId));
                    }
                    sb.append(" , ").append(colMap.get("billentry")).append(".id").append(" as ").append("entryid");
                }
            }
            DataSet bal = QueryServiceHelper.queryDataSet((String)(ReserveReplaceHelper.class.getName() + ":getEntryUnitMap"), (String)formId, (String)sb.toString(), (QFilter[])new QFilter("id", "in", (Object)balIds).toArray(), null);
            bal.forEach(v -> {
                Long balEntryId = v.getLong("entryid");
                HashMap<String, Long> unitMap = new HashMap<String, Long>(16);
                unitMap.put("materiel", v.getLong("materiel"));
                unitMap.put("baseunit", v.getLong("baseunit"));
                unitMap.put("unit", v.getLong("unit"));
                entryUnitMap.put(balEntryId, unitMap);
            });
        }
        return entryUnitMap;
    }

    private static DynamicObject createNewReserveRecord(DynamicObject reserveRecord, long userId, Date date, Long balId, Set<String> billModelFieldSet) {
        DynamicObject newReserveRecord = BusinessDataServiceHelper.newDynamicObject((String)reserveRecord.getDataEntityType().getName());
        if (reserveFieldList.size() < 15) {
            reserveFieldList.addAll(billModelFieldSet);
        }
        for (String reserveKey : reserveFieldList) {
            if ("reserve_scheme".equals(reserveKey)) {
                DynamicObject scheme;
                if (reserveRecord.get(reserveKey) == null || (scheme = reserveRecord.getDynamicObject(reserveKey)) == null) continue;
                newReserveRecord.set(reserveKey, (Object)scheme.getLong("id"));
                continue;
            }
            newReserveRecord.set(reserveKey, reserveRecord.get(reserveKey));
        }
        newReserveRecord.set("creater", (Object)userId);
        newReserveRecord.set("create_date", (Object)date);
        newReserveRecord.set("reserveprctype", (Object)INSTOCK_INSTOCK);
        return newReserveRecord;
    }

    private static Map<Long, ReserveReplaceBalRecordModel> getEntryBalRecordMap(DataSet snapData, String balFormId) {
        HashMap<Long, ReserveReplaceBalRecordModel> entryBalIdMap = new HashMap<Long, ReserveReplaceBalRecordModel>(1024);
        RowMeta rowMeta = snapData.getRowMeta();
        Integer[] rowKeyIndexArray = new Integer[]{rowMeta.getFieldIndex("fid"), rowMeta.getFieldIndex("fbillid"), rowMeta.getFieldIndex("fbaseqty_sp"), rowMeta.getFieldIndex("fqty_sp"), rowMeta.getFieldIndex("fqty2nd_sp"), rowMeta.getFieldIndex("fmaterialid"), rowMeta.getFieldIndex("fbaseunitid"), rowMeta.getFieldIndex("funitid"), rowMeta.getFieldIndex("fbillno"), rowMeta.getFieldIndex("fentryid"), rowMeta.getFieldIndex("fentryseq")};
        while (snapData.hasNext()) {
            Row row = snapData.next();
            ReserveReplaceBalRecordModel balRecordModel = new ReserveReplaceBalRecordModel();
            long entryId = row.getLong(rowKeyIndexArray[9].intValue());
            balRecordModel.setBalFormId(balFormId);
            balRecordModel.setBalId(row.getLong(rowKeyIndexArray[0].intValue()));
            balRecordModel.setBillId(row.getLong(rowKeyIndexArray[1].intValue()));
            balRecordModel.setBaseQty(row.getBigDecimal(rowKeyIndexArray[2].intValue()));
            balRecordModel.setQty(row.getBigDecimal(rowKeyIndexArray[3].intValue()));
            balRecordModel.setQty2nd(row.getBigDecimal(rowKeyIndexArray[4].intValue()));
            balRecordModel.setMaterialId(row.getLong(rowKeyIndexArray[5].intValue()));
            balRecordModel.setBaseUnitId(row.getLong(rowKeyIndexArray[6].intValue()));
            balRecordModel.setUnitId(row.getLong(rowKeyIndexArray[7].intValue()));
            balRecordModel.setBillNo(row.getString(rowKeyIndexArray[8].intValue()));
            balRecordModel.setEntryId(entryId);
            balRecordModel.setBillEntrySeq(row.getLong(rowKeyIndexArray[10].intValue()));
            entryBalIdMap.put(entryId, balRecordModel);
        }
        return entryBalIdMap;
    }

    private static Map<Object, Set<Object>> getBotpSrcEntryMap(String formId, String entryKey, Map<Long, ReserveReplaceBalRecordModel> entry4BalIdMap) {
        HashMap<Object, Set<Object>> srcEntryIdMap = new HashMap<Object, Set<Object>>(16);
        Set<Long> entryIds = entry4BalIdMap.keySet();
        if (entryIds.isEmpty()) {
            return srcEntryIdMap;
        }
        HashSet<Long> billIdSet = new HashSet<Long>(entry4BalIdMap.size());
        for (Map.Entry<Long, ReserveReplaceBalRecordModel> entry : entry4BalIdMap.entrySet()) {
            Long billId = entry.getValue().getBillId();
            billIdSet.add(billId);
        }
        Map<Object, List<Object>> botpUpPath4EntryId = ReserveHelper.getBotpUpPath4EntryId(formId, entryKey, entryIds.toArray(new Long[entryIds.size()]), billIdSet.toArray(new Long[billIdSet.size()]));
        for (Long entryId : entryIds) {
            HashSet<Object> srcEntryIds = new HashSet<Object>(16);
            List<Object> srcIds = botpUpPath4EntryId.get(entryId);
            if (srcIds != null) {
                srcEntryIds.addAll(srcIds);
            }
            srcEntryIds.add(entryId);
            srcEntryIdMap.put(entryId, srcEntryIds);
        }
        return srcEntryIdMap;
    }

    private static List<Object[]> handleBalAndReserveRecord(Map<Long, DynamicObject> bfObjMap, Map<Long, Long> reserveIdsMap, DBRoute dbRoute, boolean isRollBack) {
        ArrayList<Object[]> result = null;
        QFilter reserveIdF = new QFilter("id", "in", reserveIdsMap.keySet());
        String selectCols = "id,reserveprctype,bal_id,bal_entryid,base_qty,qty,qty2nd,aggregateid,bal_obj,bill_obj,bill_id,bill_no,billentry_id,billentry_seq";
        DynamicObjectCollection reserveReplaceRecords = QueryServiceHelper.query((String)ReserveReplaceHelper.class.getName(), (String)"msmod_reserve_record", (String)selectCols, (QFilter[])new QFilter[]{reserveIdF}, null);
        HashMap<DynamicObject[], ArrayList<DynamicObject>> balAFRecordMap = new HashMap<DynamicObject[], ArrayList<DynamicObject>>(reserveReplaceRecords.size());
        for (DynamicObject record : reserveReplaceRecords) {
            DynamicObject[] balTableName;
            Long bfReserveId = reserveIdsMap.get(record.getLong("id"));
            if (bfReserveId == null || (balTableName = bfObjMap.get(bfReserveId).getString("baltablename")) == null) continue;
            ArrayList<DynamicObject> recordList = (ArrayList<DynamicObject>)balAFRecordMap.get(balTableName);
            if (recordList == null) {
                recordList = new ArrayList<DynamicObject>();
            }
            recordList.add(record);
            balAFRecordMap.put(balTableName, recordList);
        }
        ReserveReplaceHelper.createLogForAfterReplace(bfObjMap, reserveIdsMap, reserveReplaceRecords, "unreplace");
        QFilter idF = new QFilter("id", "in", reserveIdsMap.values());
        idF = idF.and("ispredict", "=", (Object)"0");
        DynamicObject[] oldReserveRecord = BusinessDataServiceHelper.load((String)"msmod_reserve_record", (String)selectCols, (QFilter[])new QFilter[]{idF});
        HashMap<Long, Long> invOldRecordMap = new HashMap<Long, Long>(oldReserveRecord.length);
        for (DynamicObject record : oldReserveRecord) {
            invOldRecordMap.put(record.getLong("id"), record.getLong("id"));
        }
        HashMap<Long, Object[]> oldBalParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        HashSet<Long> bfReplaceIds = new HashSet<Long>(16);
        HashSet<Long> bfTransIds = new HashSet<Long>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : balAFRecordMap.entrySet()) {
            Object[] result2 = ReserveReplaceHelper.dealOneBalForUnAudit(bfObjMap, reserveIdsMap, dbRoute, isRollBack, invOldRecordMap, oldBalParamsMap, bfReplaceIds, bfTransIds, entry);
            if (result2 == null) continue;
            if (result == null) {
                result = new ArrayList<Object[]>(8);
            }
            result.add(result2);
        }
        return result;
    }

    public static void createLogForAfterReplace(Map<Long, DynamicObject> bfObjMap, Map<Long, Long> reserveIdsMap, DynamicObjectCollection reserveReplaceRecords, String replaceType) {
        ArrayList<DynamicObject> recordLogList = new ArrayList<DynamicObject>(reserveReplaceRecords.size());
        for (DynamicObject record : reserveReplaceRecords) {
            long recordId = record.getLong("id");
            DynamicObject newRecord = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_record");
            newRecord.set("id", (Object)recordId);
            newRecord.set("bal_obj", (Object)record.getString("bal_obj"));
            newRecord.set("bal_id", (Object)record.getLong("bal_id"));
            newRecord.set("aggregateid", (Object)record.getLong("aggregateid"));
            BigDecimal baseQty = record.getBigDecimal("base_qty");
            if ("unreplace".equals(replaceType)) {
                newRecord.set("base_qty", (Object)baseQty);
                newRecord.set("qty", (Object)record.getBigDecimal("qty"));
                newRecord.set("qty2nd", (Object)record.getBigDecimal("qty2nd"));
                ThreadCache.put((Object)"ReserveOpType", (Object)"replaceunin");
            }
            DynamicObject billObj = bfObjMap.get(reserveIdsMap.get(recordId));
            if ("backbefore".equals(replaceType)) {
                billObj = bfObjMap.get(recordId);
            }
            if (billObj != null) {
                newRecord.set("bill_obj", (Object)billObj.getString("transbill"));
                newRecord.set("bill_id", (Object)billObj.getLong("billid"));
                newRecord.set("bill_no", (Object)billObj.getString("billno"));
                newRecord.set("billentry_id", (Object)billObj.getLong("billentryid"));
                newRecord.set("billentry_seq", (Object)billObj.getLong("billentryseq"));
                if ("backbefore".equals(replaceType)) {
                    newRecord.set("base_qty", (Object)billObj.getBigDecimal("outbaseqty"));
                    newRecord.set("qty", (Object)billObj.getBigDecimal("outqty"));
                    newRecord.set("qty2nd", (Object)billObj.getBigDecimal("outqty2nd"));
                } else if ("backafter".equals(replaceType)) {
                    newRecord.set("base_qty", (Object)billObj.getBigDecimal("replacebaseqty").negate());
                    newRecord.set("qty", (Object)billObj.getBigDecimal("replaceqty").negate());
                    newRecord.set("qty2nd", (Object)billObj.getBigDecimal("replaceqty2nd").negate());
                }
            }
            recordLogList.add(newRecord);
        }
        ReserveOpLogHelper.createNewLogByRecord(recordLogList, true);
    }

    private static Object[] dealOneBalForUnAudit(Map<Long, DynamicObject> bfObjMap, Map<Long, Long> reserveIdsMap, DBRoute dbRoute, boolean isRollBack, Map<Long, Long> invOldRecordMap, Map<Long, Object[]> oldBalParamsMap, Set<Long> bfReplaceIds, Set<Long> bfTransIds, Map.Entry<String, List<DynamicObject>> entry) {
        HashMap<Long, Object[]> reserveParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        HashMap<Long, Object[]> balParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        HashMap<Long, Object[]> aggParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        String balTableName = entry.getKey();
        List<DynamicObject> recordList = entry.getValue();
        boolean isAggInit = ReserveAggregateHelper.isAggregateInit();
        for (DynamicObject afRecord : recordList) {
            long reserveId = afRecord.getLong("id");
            BigDecimal baseQty = afRecord.getBigDecimal("base_qty");
            BigDecimal qty = afRecord.getBigDecimal("qty");
            BigDecimal qty2nd = afRecord.getBigDecimal("qty2nd");
            long bfReserveId = reserveIdsMap.get(reserveId);
            DynamicObject replaceObj = bfObjMap.get(bfReserveId);
            BigDecimal oldBaseQty = baseQty;
            BigDecimal oldQty = qty.min(replaceObj.getBigDecimal("replaceqty"));
            BigDecimal oldQty2nd = qty2nd.min(replaceObj.getBigDecimal("replaceqty2nd"));
            BigDecimal outTotalBaseQty = replaceObj.getBigDecimal("outtotalbaseqty");
            BigDecimal inTotalBaseQty = replaceObj.getBigDecimal("intotalbaseqty");
            if (inTotalBaseQty != null && outTotalBaseQty != null && inTotalBaseQty.compareTo(BigDecimal.ZERO) > 0 && outTotalBaseQty.compareTo(BigDecimal.ZERO) > 0) {
                oldBaseQty = oldBaseQty.multiply(outTotalBaseQty).divide(inTotalBaseQty, RoundingMode.HALF_UP);
                oldQty = oldQty.multiply(outTotalBaseQty).divide(inTotalBaseQty, RoundingMode.HALF_UP);
                oldQty2nd = oldQty2nd.multiply(outTotalBaseQty).divide(inTotalBaseQty, RoundingMode.HALF_UP);
            }
            ReserveReplaceHelper.buildLockQtyParamForUnAudit(reserveParamsMap, oldBaseQty, oldQty, oldQty2nd, bfReserveId);
            Long balId = afRecord.getLong("bal_entryid");
            Long aggId = afRecord.getLong("aggregateid");
            if (afRecord.getLong("bal_id") == 0L) {
                ReserveReplaceHelper.buildLockQtyParamForUnAudit(aggParamsMap, baseQty, qty, qty2nd, aggId);
            } else {
                ReserveReplaceHelper.buildLockQtyParamForUnAudit(balParamsMap, baseQty, qty, qty2nd, balId);
                if (isAggInit) {
                    ReserveReplaceHelper.buildLockQtyParamForUnAudit(aggParamsMap, baseQty, qty, qty2nd, aggId);
                }
            }
            bfTransIds.add(bfReserveId);
            if (invOldRecordMap.get(bfReserveId) == null) continue;
            bfReplaceIds.add(bfReserveId);
        }
        String reserveSql = "update t_msmod_reserverecord set  f_base_qty = f_base_qty + ? ,f_qty = f_qty+ ? ,f_qty2nd = f_qty2nd + ? where fid = ?";
        ReserveReplaceHelper.updateReserveParams(bfTransIds, reserveParamsMap, bfObjMap);
        ReserveReplaceHelper.executeBatchRecordSql(reserveParamsMap, reserveSql, dbRoute);
        if (balParamsMap.size() > 0) {
            String balSql = "update " + balTableName + "_a  set flockbaseqty = flockbaseqty - ? ,flockqty = flockqty - ? ,flockqty2nd = flockqty2nd - ? where fid = ?";
            ReserveReplaceHelper.executeBatchRecordSql(balParamsMap, balSql, dbRoute);
        }
        if (aggParamsMap.size() > 0) {
            String aggSql = "update t_msmod_reserveaggregate_a  set flockbaseqty = flockbaseqty - ? ,flockqty = flockqty - ? ,flockqty2nd = flockqty2nd - ? where fid = ?";
            ReserveReplaceHelper.executeBatchRecordSql(aggParamsMap, aggSql, dbRoute);
        }
        return ReserveReplaceHelper.rollOldBalanceLockQty(reserveParamsMap, oldBalParamsMap, bfReplaceIds, dbRoute, balTableName, isRollBack);
    }

    private static void buildLockQtyParamForUnAudit(Map<Long, Object[]> paramsMap, BigDecimal baseQty, BigDecimal qty, BigDecimal qty2nd, Long id) {
        Object[] param = paramsMap.get(id);
        if (param == null) {
            param = new Object[]{baseQty, qty, qty2nd, id};
            paramsMap.put(id, param);
        } else {
            param[0] = baseQty.add((BigDecimal)param[0]);
            param[1] = qty.add((BigDecimal)param[1]);
            param[2] = qty2nd.add((BigDecimal)param[2]);
        }
    }

    private static void updateReserveParams(Set<Long> bfTransIds, Map<Long, Object[]> reserveParamsMap, Map<Long, DynamicObject> bfObjMap) {
        ConvRateContext convRateContext = new ConvRateContext();
        DynamicObjectCollection oldReserveRecordCol = QueryServiceHelper.query((String)"msmod_reserve_record", (String)"id,bal_entryid,bill_obj,bill_id,bill_no,billentry_id,billentry_seq,bal_obj,bal_id,aggregateid,base_qty,qty,qty2nd", (QFilter[])new QFilter("id", "in", bfTransIds).toArray());
        HashMap<Long, Long> oldBalIdsMap = new HashMap<Long, Long>(16);
        String formId = null;
        HashMap<Long, DynamicObject> oldRecordMap = new HashMap<Long, DynamicObject>(oldReserveRecordCol.size());
        for (DynamicObject record : oldReserveRecordCol) {
            if (formId == null) {
                formId = record.getString("bal_obj");
            }
            long recordId = record.getLong("id");
            long balEntryId = record.getLong("bal_entryid");
            if (balEntryId == 0L) {
                oldBalIdsMap.put(recordId, record.getLong("aggregateid"));
                formId = "msmod_reserveaggre";
            } else {
                oldBalIdsMap.put(recordId, balEntryId);
            }
            oldRecordMap.put(recordId, record);
        }
        ColsMap colsMap = ColsMapHelper.findBillColMaps(formId, "msmod_std_inv_field");
        if (oldBalIdsMap.isEmpty() || org.apache.commons.lang3.StringUtils.isEmpty(formId) || colsMap == null) {
            return;
        }
        Map<String, String> colMap = colsMap.getBalColMap();
        StringBuilder sb = new StringBuilder();
        sb.append(colMap.get("materiel")).append(" as ").append("materiel");
        sb.append(" , ").append(colMap.get("baseunit")).append(" as ").append("baseunit");
        sb.append(" , ").append(colMap.get("unit")).append(" as ").append("unit");
        QFilter qFilter = new QFilter(colMap.get("billentry") + ".id", "in", oldBalIdsMap.values());
        String materiel = colMap.get("materiel");
        if (materiel != null) {
            String[] materielArray = materiel.split("\\.");
            if (materielArray.length == 1) {
                sb.append(" , ").append("id").append(" as ").append("entryid");
                qFilter = new QFilter("id", "in", oldBalIdsMap.values());
            } else {
                sb.append(" , ").append(colMap.get("billentry")).append(".id").append(" as ").append("entryid");
            }
        }
        DataSet bal = QueryServiceHelper.queryDataSet((String)(ReserveReplaceHelper.class.getName() + ":updateReserveParams"), (String)formId, (String)sb.toString(), (QFilter[])qFilter.toArray(), null);
        HashMap entryUnitMap = new HashMap(16);
        bal.forEach(v -> {
            Long balEntryId = v.getLong("entryid");
            HashMap<String, Long> unitMap = new HashMap<String, Long>(16);
            unitMap.put("materiel", v.getLong("materiel"));
            unitMap.put("baseunit", v.getLong("baseunit"));
            unitMap.put("unit", v.getLong("unit"));
            entryUnitMap.put(balEntryId, unitMap);
        });
        for (Map.Entry<Long, Object[]> reserveParams : reserveParamsMap.entrySet()) {
            Long reserveId = reserveParams.getKey();
            Object[] objects = reserveParams.getValue();
            Map unitMap = (Map)entryUnitMap.get(oldBalIdsMap.get(reserveId));
            if (unitMap == null) continue;
            DynamicObject record = (DynamicObject)oldRecordMap.get(reserveId);
            BigDecimal baseQty = (BigDecimal)objects[0];
            if (record != null) {
                record.set("base_qty", (Object)baseQty);
                record.set("qty2nd", objects[2]);
            }
            if (unitMap.get("unit") != null) {
                BigDecimal qty = convRateContext.getSrcQty(baseQty, (Long)unitMap.get("materiel"), (Long)unitMap.get("unit"), (Long)unitMap.get("baseunit"));
                objects[1] = qty;
                if (record != null) {
                    record.set("qty", (Object)qty);
                }
            }
            DynamicObject oldRecord = bfObjMap.get(reserveId);
            if (record == null || oldRecord == null) continue;
            record.set("bill_obj", (Object)oldRecord.getString("transbill"));
            record.set("bill_id", (Object)oldRecord.getLong("billid"));
            record.set("bill_no", (Object)oldRecord.getString("billno"));
            record.set("billentry_id", (Object)oldRecord.getLong("billentryid"));
            record.set("billentry_seq", (Object)oldRecord.getLong("billentryseq"));
        }
        ThreadCache.put((Object)"ReserveOpType", (Object)"replaceunout");
        ReserveOpLogHelper.createNewLogByRecord(oldRecordMap.values(), false);
    }

    private static Object[] rollOldBalanceLockQty(Map<Long, Object[]> reserveParamsMap, Map<Long, Object[]> oldBalParamsMap, Set<Long> bfReserveIds, DBRoute scmRoute, String table, boolean isRollBack) {
        if (bfReserveIds.isEmpty()) {
            return null;
        }
        HashMap<Long, Object[]> oldAggParamsMap = new HashMap<Long, Object[]>(16);
        DataSet oldReserveRecords = QueryServiceHelper.queryDataSet((String)ReserveReplaceHelper.class.getName(), (String)"msmod_reserve_record", (String)"id,bal_id,aggregateid", (QFilter[])new QFilter("id", "in", bfReserveIds).toArray(), null);
        while (oldReserveRecords.hasNext()) {
            Object[] aggObj;
            Row next = oldReserveRecords.next();
            Long reserveId = next.getLong("id");
            Long balId = next.getLong("bal_id");
            Long aggId = next.getLong("aggregateid");
            Object[] reserveObj = reserveParamsMap.get(reserveId);
            if (reserveObj == null) continue;
            Object[] balObj = oldBalParamsMap.get(balId);
            if (balObj == null) {
                if (balId != 0L) {
                    balObj = new Object[]{reserveObj[0], reserveObj[1], reserveObj[2], balId};
                    oldBalParamsMap.put(balId, balObj);
                }
            } else {
                balObj[0] = ((BigDecimal)balObj[0]).add((BigDecimal)reserveObj[0]);
                balObj[1] = ((BigDecimal)balObj[1]).add((BigDecimal)reserveObj[1]);
                balObj[2] = ((BigDecimal)balObj[2]).add((BigDecimal)reserveObj[2]);
            }
            if ((aggObj = (Object[])oldAggParamsMap.get(aggId)) == null) {
                if (aggId == 0L) continue;
                aggObj = new Object[]{reserveObj[0], reserveObj[1], reserveObj[2], aggId};
                oldAggParamsMap.put(aggId, aggObj);
                continue;
            }
            aggObj[0] = ((BigDecimal)aggObj[0]).add((BigDecimal)reserveObj[0]);
            aggObj[1] = ((BigDecimal)aggObj[1]).add((BigDecimal)reserveObj[1]);
            aggObj[2] = ((BigDecimal)aggObj[2]).add((BigDecimal)reserveObj[2]);
        }
        String balSql = "update " + table + "_a  set flockbaseqty = flockbaseqty + ? ,flockqty = flockqty + ? ,flockqty2nd = flockqty2nd + ? where fid = ?";
        if (oldBalParamsMap.size() > 0) {
            ReserveReplaceHelper.executeBatchRecordSql(oldBalParamsMap, balSql, scmRoute);
        }
        Object[] result = new Object[3];
        if (ReserveAggregateHelper.isAggregateInit() && oldAggParamsMap.size() > 0) {
            String aggSql = "update  t_msmod_reserveaggregate_a  set flockbaseqty = flockbaseqty + ? ,flockqty = flockqty + ? ,flockqty2nd = flockqty2nd + ? where fid = ?";
            if (isRollBack) {
                ReserveReplaceHelper.executeBatchRecordSql(oldAggParamsMap, aggSql, scmRoute);
            } else {
                result[0] = scmRoute;
                result[1] = aggSql;
                result[2] = oldAggParamsMap;
            }
        } else {
            result = null;
        }
        return result;
    }

    public static void executeBatchRecordSql(Map<Long, Object[]> paramsMap, String sql, DBRoute scmRoute) {
        if (paramsMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(1024);
        for (Object[] reserveParam : paramsMap.values()) {
            if (params.size() > 1000) {
                ReserveReplaceHelper.executeMethod(sql, BalanceHelper.sortSqlParamList(params), scmRoute);
                params.clear();
            }
            params.add(reserveParam);
        }
        ReserveReplaceHelper.executeMethod(sql, BalanceHelper.sortSqlParamList(params), scmRoute);
    }

    public static void dealReserveReplace(String billName, Set<Object> realIdSet) {
        if (realIdSet.size() == 0) {
            return;
        }
        if (INTRANSIT_INSTOCK.equals(ReserveServiceCfgFilterHelper.isPredictReplaceInv(billName))) {
            return;
        }
        QFilter qFilter = new QFilter("billid", "in", realIdSet);
        qFilter = qFilter.and("opstatus", "=", (Object)ReplaceOpStatusEnum.ONCOMMIT);
        DynamicObjectCollection opObjList = QueryServiceHelper.query((String)"msmod_reservereplace_op", (String)ReserveReplaceHelper.getOpSelectCols(), (QFilter[])qFilter.toArray());
        if (opObjList.size() == 0) {
            return;
        }
        HashMap inDataBalMap = new HashMap(1024);
        HashMap outDataBalMap = new HashMap(1024);
        ArrayList<Long> replaceRecordList = new ArrayList<Long>(1024);
        HashMap<String, ArrayList<Long>> inStockIdMap = new HashMap<String, ArrayList<Long>>(1024);
        HashSet<String> balanceNameSet = new HashSet<String>(8);
        for (DynamicObject opObj : opObjList) {
            HashSet<DynamicObject> outSet;
            String balanceName = opObj.getString("balancename");
            if ("in".equals(opObj.getString("outorinflag"))) {
                HashSet<DynamicObject> inSet;
                HashMap<Long, HashSet<DynamicObject>> inDataMap = (HashMap<Long, HashSet<DynamicObject>>)inDataBalMap.get(balanceName);
                if (inDataMap == null) {
                    inDataMap = new HashMap<Long, HashSet<DynamicObject>>(1024);
                }
                if ((inSet = (HashSet<DynamicObject>)inDataMap.get(opObj.getLong("entryid"))) == null) {
                    inSet = new HashSet<DynamicObject>(16);
                }
                inSet.add(opObj);
                inDataMap.put(opObj.getLong("entryid"), inSet);
                inDataBalMap.put(balanceName, inDataMap);
                ArrayList<Long> inStockIdList = (ArrayList<Long>)inStockIdMap.get(balanceName);
                if (inStockIdList == null) {
                    inStockIdList = new ArrayList<Long>(1024);
                }
                inStockIdList.add(opObj.getLong("invid"));
                inStockIdMap.put(balanceName, inStockIdList);
                balanceNameSet.add(balanceName);
                continue;
            }
            Map<Long, HashSet<Object>> outDataMap = (Map)outDataBalMap.get(balanceName);
            if (outDataMap == null) {
                outDataMap = new HashMap<Long, HashSet<DynamicObject>>(1024);
            }
            if ((outSet = (HashSet<DynamicObject>)outDataMap.get(opObj.getLong("entryid"))) == null) {
                outSet = new HashSet<DynamicObject>(16);
            }
            outSet.add(opObj);
            replaceRecordList.add(opObj.getLong("recordid"));
            outDataMap.put(opObj.getLong("entryid"), outSet);
            outDataBalMap.put(balanceName, outDataMap);
        }
        Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
        HashSet<String> billModelFieldSet = new HashSet<String>(16);
        HashSet<String> balModelFieldSet = new HashSet<String>(16);
        for (String key : allFieldMap.keySet()) {
            if (key.startsWith("r_")) {
                billModelFieldSet.add(key);
                continue;
            }
            if (!key.startsWith("s_")) continue;
            balModelFieldSet.add(key);
        }
        Map<Long, DynamicObject> recordMap = ReserveReplaceHelper.getOldRecordMap(replaceRecordList, billModelFieldSet);
        Map<String, ColsMap> colsMap = ColsMapHelper.findBillColMaps(balanceNameSet, "msmod_std_inv_field");
        if (reserveFieldList.size() < 15) {
            reserveFieldList.addAll(billModelFieldSet);
        }
        int length = replaceRecordList.size();
        for (Map.Entry<String, List<Long>> entry : inStockIdMap.entrySet()) {
            ReserveReplaceHelper.dealTransByOneBal((Map)inDataBalMap.get(entry.getKey()), (Map)outDataBalMap.get(entry.getKey()), balModelFieldSet, recordMap, colsMap, length, entry);
        }
        for (Map.Entry entry : outDataBalMap.entrySet()) {
            String balName = (String)entry.getKey();
            if (inStockIdMap.get(balName) != null) continue;
            ReserveReplaceHelper.backLockQtyForJustHaveOut(balName, (Map)entry.getValue());
            break;
        }
        DeleteServiceHelper.delete((String)"msmod_reservereplace_op", (QFilter[])new QFilter[]{new QFilter("billid", "in", realIdSet)});
    }

    private static void backLockQtyForJustHaveOut(String balName, Map<Long, Set<DynamicObject>> outDataMap) {
        boolean isAggInit = ReserveAggregateHelper.isAggregateInit();
        String balTableName = "";
        if (outDataMap != null && outDataMap.size() > 0) {
            for (Set<DynamicObject> outObjSet : outDataMap.values()) {
                if (outObjSet == null || outObjSet.size() <= 0) continue;
                for (DynamicObject outObj : outObjSet) {
                    if (outObj != null && (balTableName = outObj.getString("baltablename")) != null) break;
                }
            }
            if (balTableName != null && balTableName.length() > 0) {
                ArrayList<String> tbLockFieldList = new ArrayList<String>(8);
                Map<String, String> balColMap = ColsMapHelper.findBillColMaps(balName, "msmod_std_inv_field").getBalColMap();
                ReserveReplaceHelper.getUpdateLockQtySql(balTableName, balName, balColMap, tbLockFieldList, "-");
                ReserveReplaceHelper.dealOtherOutReplace(outDataMap, balName, balColMap, tbLockFieldList, balTableName, isAggInit);
            }
        }
    }

    private static Map<Long, DynamicObject> getOldRecordMap(List<Long> replaceRecordList, Set<String> billModelFieldSet) {
        StringBuilder reserveCols = new StringBuilder("bill_obj,bill_no,bill_id,billentry_id,bill_source,entry_name,billentry_seq,bal_obj,bal_id,bal_entryid,base_qty,qty,qty2nd,reserve_scheme,bal_source,reservemethod,reserveobjtype,reserveobj,id,aggregateid");
        for (String requesFiledInfo : billModelFieldSet) {
            reserveCols.append(',').append(requesFiledInfo);
        }
        QFilter idF = new QFilter("id", "in", replaceRecordList);
        DynamicObjectCollection recordCol = QueryServiceHelper.query((String)"ReserveReplaceHelper.getOldRecordMap", (String)"msmod_reserve_record", (String)reserveCols.toString(), (QFilter[])new QFilter[]{idF}, (String)"bal_entryid");
        HashMap<Long, DynamicObject> recordMap = new HashMap<Long, DynamicObject>(recordCol.size());
        for (DynamicObject record : recordCol) {
            recordMap.put(record.getLong("id"), record);
        }
        return recordMap;
    }

    private static void dealTransByOneBal(Map<Long, Set<DynamicObject>> inDataMap, Map<Long, Set<DynamicObject>> outDataMap, Set<String> balModelFieldSet, Map<Long, DynamicObject> recordMap, Map<String, ColsMap> colsMap, int length, Map.Entry<String, List<Long>> entry) {
        MainEntityType mainEntityType2;
        if (inDataMap == null || inDataMap.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> transRecordList = new ArrayList<DynamicObject>(length);
        ArrayList<DynamicObject> newRecordList = new ArrayList<DynamicObject>(length);
        long[] ids = DB.genLongIds((String)"t_msmod_reserverecord", (int)(length * 10));
        int i = 0;
        String balName = entry.getKey();
        List<Long> invIdList = entry.getValue();
        Map<Long, Integer> entryIdExpireDateMap = ReserveReplaceHelper.getInventoryExpireMap(balName, invIdList);
        Map<Long, Long> aggInvMap = ReserveReplaceHelper.getAggInvMap(balName, invIdList, null);
        Map<String, String> balColMap = colsMap.get(balName).getBalColMap();
        String inStockSelectCol = ReserveReplaceHelper.getSelectColForInStock(balModelFieldSet, balColMap);
        QFilter invFilter = new QFilter("id", "in", invIdList);
        DynamicObjectCollection invInfoCol = QueryServiceHelper.query((String)"ReserveReplaceHelper:dealReserveReplace", (String)balName, (String)inStockSelectCol, (QFilter[])new QFilter[]{invFilter}, null);
        HashMap<Long, DynamicObject> invInfoMap = new HashMap<Long, DynamicObject>(invInfoCol.size());
        for (DynamicObject obj : invInfoCol) {
            invInfoMap.put(obj.getLong("id"), obj);
        }
        ArrayList<String> tbLockFieldList = new ArrayList<String>(8);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1024);
        ArrayList<Object[]> lockAggParamList = new ArrayList<Object[]>(1024);
        String balTableName = "";
        for (Set<DynamicObject> inObjSet : inDataMap.values()) {
            DynamicObject inObj;
            Iterator<DynamicObject> iterator = inObjSet.iterator();
            while (iterator.hasNext() && (balTableName = (inObj = iterator.next()).getString("baltablename")) == null) {
            }
        }
        String updateLockQtySql = ReserveReplaceHelper.getUpdateLockQtySql(balTableName, balName, balColMap, tbLockFieldList, "-");
        boolean isAggInit = ReserveAggregateHelper.isAggregateInit();
        ArrayList<DynamicObject> inObjList = new ArrayList<DynamicObject>(1024);
        ArrayList<DynamicObject> opLogList = new ArrayList<DynamicObject>(1024);
        for (Map.Entry<Long, Set<DynamicObject>> inEntry : inDataMap.entrySet()) {
            long entryId = inEntry.getKey();
            Set<DynamicObject> inObjSet = inEntry.getValue();
            if (outDataMap == null || outDataMap.get(entryId) == null) {
                for (DynamicObject in : inObjSet) {
                    ThreadCache.put((Object)"ReserveOpType", (Object)"replaceinunlock");
                    inObjList.add(in);
                    paramList.add(ReserveReplaceHelper.buildOutLockStockParam(balColMap, tbLockFieldList.size(), in.getBigDecimal("baseqty"), in.getBigDecimal("qty"), in.getBigDecimal("qty2nd"), in.getLong("invid")));
                }
                continue;
            }
            for (DynamicObject in : inObjSet) {
                long inInvId = in.getLong("invid");
                DynamicObject invInfo = (DynamicObject)invInfoMap.get(inInvId);
                if (invInfo == null) continue;
                BigDecimal inTotalBaseQty = in.getBigDecimal("totalbaseqty");
                BigDecimal inBaseQty = in.getBigDecimal("baseqty");
                BigDecimal inQty = in.getBigDecimal("qty");
                BigDecimal inQty2nd = in.getBigDecimal("qty2nd");
                long materialId = in.getLong("material");
                long baseUnitId = in.getLong("baseunit");
                long unitId = in.getLong("unit");
                ConvRateContext conRate = new ConvRateContext();
                Set<DynamicObject> outObjSet = outDataMap.get(entryId);
                for (DynamicObject outObj : outObjSet) {
                    BigDecimal outQty2nd;
                    BigDecimal outQty;
                    if (outObj.getBigDecimal("baseqty").compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal outTotalBaseQty = outObj.getBigDecimal("totalbaseqty");
                    BigDecimal outBaseQty = outObj.getBigDecimal("baseqty").multiply(inTotalBaseQty).divide(outTotalBaseQty, RoundingMode.HALF_UP);
                    BigDecimal oldBaseQty = outObj.getBigDecimal("baseqty");
                    BigDecimal oldQty = outObj.getBigDecimal("qty");
                    BigDecimal oldQty2nd = outObj.getBigDecimal("qty2nd");
                    if (inBaseQty.compareTo(outBaseQty) > 0) {
                        outQty = conRate.getSrcQty(outBaseQty, materialId, unitId, baseUnitId).min(inQty);
                        outQty2nd = outObj.getBigDecimal("qty2nd").multiply(inTotalBaseQty).divide(outTotalBaseQty, RoundingMode.HALF_UP).min(inQty2nd);
                        outObj.set("baseqty", (Object)BigDecimal.ZERO);
                        outObj.set("qty", (Object)BigDecimal.ZERO);
                        outObj.set("qty2nd", (Object)BigDecimal.ZERO);
                    } else {
                        outBaseQty = inBaseQty;
                        outQty = inQty;
                        outQty2nd = inQty2nd;
                        BigDecimal actOutBaseQty = inBaseQty.multiply(outTotalBaseQty).divide(inTotalBaseQty, RoundingMode.HALF_UP);
                        BigDecimal actOutQty = conRate.getSrcQty(actOutBaseQty, outObj.getLong("material"), outObj.getLong("unit"), outObj.getLong("baseunit"));
                        outObj.set("baseqty", (Object)outObj.getBigDecimal("baseqty").subtract(actOutBaseQty));
                        outObj.set("qty", (Object)outObj.getBigDecimal("qty").subtract(actOutQty).max(BigDecimal.ZERO));
                        BigDecimal actOutQty2nd = inQty2nd.multiply(outTotalBaseQty).divide(inTotalBaseQty, RoundingMode.HALF_UP);
                        outObj.set("qty2nd", (Object)outObj.getBigDecimal("qty2nd").subtract(actOutQty2nd).max(BigDecimal.ZERO));
                    }
                    inBaseQty = inBaseQty.subtract(outBaseQty);
                    inQty = inQty.subtract(outQty);
                    inQty2nd = inQty2nd.subtract(outQty2nd);
                    DynamicObject oldRecord = recordMap.get(outObj.getLong("recordid"));
                    if (oldRecord == null) continue;
                    long aggId = 0L;
                    if ("msmod_reserveaggre".equals(balName)) {
                        aggId = inInvId;
                    }
                    if (aggInvMap.get(inInvId) != null) {
                        aggId = aggInvMap.get(inInvId);
                    }
                    newRecordList.add(ReserveReplaceHelper.buildNewReserveRecord(balName, balModelFieldSet, ids[i], entryIdExpireDateMap.get(inInvId), aggId, balColMap, invInfo, in, outBaseQty, outQty, outQty2nd, oldRecord));
                    opLogList.add(ReserveReplaceHelper.buildOpLogObjByNewRecord(ReserveReplaceHelper.buildNewReserveRecord(balName, balModelFieldSet, ids[i], entryIdExpireDateMap.get(inInvId), aggId, balColMap, invInfo, in, outBaseQty, outQty, outQty2nd, oldRecord), in));
                    transRecordList.add(ReserveReplaceHelper.buildTransRecord(ids[i], oldRecord.getLong("id"), entryId, outObj, inTotalBaseQty, outTotalBaseQty, outBaseQty, outQty, outQty2nd, inInvId, balTableName, oldBaseQty, oldQty, oldQty2nd));
                    if (isAggInit && !"msmod_reserveaggre".equals(balName)) {
                        lockAggParamList.add(ReserveReplaceHelper.buildQtyParam(outBaseQty, outQty, outQty2nd, aggId));
                    }
                    ++i;
                }
                if (inBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                paramList.add(ReserveReplaceHelper.buildOutLockStockParam(balColMap, tbLockFieldList.size(), inBaseQty, inQty, inQty2nd, inInvId));
                in.set("baseqty", (Object)inBaseQty);
                in.set("qty", (Object)inQty);
                in.set("qty2nd", (Object)inQty2nd);
                inObjList.add(in);
            }
        }
        ReserveReplaceHelper.dealOtherOutReplace(outDataMap, balName, balColMap, tbLockFieldList, balTableName, isAggInit);
        if (newRecordList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newRecordList.toArray(new DynamicObject[newRecordList.size()]));
            ThreadCache.put((Object)"ReserveOpType", (Object)"replacein");
            ReserveOpLogHelper.createNewLogByRecord(opLogList, false);
        }
        if (transRecordList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])transRecordList.toArray(new DynamicObject[transRecordList.size()]));
        }
        if (paramList.size() > 0 && balTableName.length() > 0) {
            mainEntityType2 = MetadataServiceHelper.getDataEntityType((String)balName);
            DB.executeBatch((DBRoute)new DBRoute(mainEntityType2.getDBRouteKey()), (String)updateLockQtySql, BalanceHelper.sortSqlParamList(paramList));
        }
        if (lockAggParamList.size() > 0) {
            mainEntityType2 = MetadataServiceHelper.getDataEntityType((String)"msmod_reserveaggre");
            String lockAggQtySql = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty+?, flockqty =flockqty+?,flockqty2nd =flockqty2nd+? where fid=?";
            DB.executeBatch((DBRoute)new DBRoute(mainEntityType2.getDBRouteKey()), (String)lockAggQtySql, BalanceHelper.sortSqlParamList(lockAggParamList));
        }
        ThreadCache.put((Object)"ReserveOpType", (Object)"replaceinunlock");
        ReserveOpLogHelper.createNewLogByRePlaceRecord(inObjList, true);
    }

    private static DynamicObject buildOpLogObjByNewRecord(DynamicObject opLogObj1, DynamicObject in) {
        DynamicObject opLogObj = opLogObj1;
        opLogObj.set("bill_obj", (Object)in.getString("billobj"));
        opLogObj.set("bill_id", (Object)in.getLong("billid"));
        opLogObj.set("bill_no", (Object)in.getString("billno"));
        opLogObj.set("billentry_id", (Object)in.getLong("entryid"));
        opLogObj.set("billentry_seq", (Object)in.getLong("billentryseq"));
        return opLogObj;
    }

    private static void dealOtherOutReplace(Map<Long, Set<DynamicObject>> outDataMap, String balName, Map<String, String> balColMap, List<String> tbLockFieldList, String balTableName, boolean isAggInit) {
        if (outDataMap == null) {
            return;
        }
        ThreadCache.put((Object)"ReserveOpType", (Object)"replaceoutun");
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"msmod_reserveaggre");
        DBRoute scmRoute = new DBRoute(mainEntityType.getDBRouteKey());
        String updateOldRecordSql = "update t_msmod_reserverecord set f_base_qty = f_base_qty + ?,f_qty = f_qty + ?,f_qty2nd = f_qty2nd + ? where fid = ?";
        ArrayList<Object[]> recordParamList = new ArrayList<Object[]>(1024);
        String updateOutLockQtySql = ReserveReplaceHelper.getUpdateLockQtySql(balTableName, balName, balColMap, tbLockFieldList, "+");
        ArrayList<Object[]> outParamList = new ArrayList<Object[]>(1024);
        ArrayList<Object[]> outLockAggParamList = new ArrayList<Object[]>(1024);
        ArrayList<DynamicObject> opObjList = new ArrayList<DynamicObject>(1024);
        for (Set<DynamicObject> outObjSet : outDataMap.values()) {
            for (DynamicObject outObj : outObjSet) {
                if (outObj.getBigDecimal("baseqty").compareTo(BigDecimal.ZERO) == 0) continue;
                opObjList.add(outObj);
                recordParamList.add(ReserveReplaceHelper.buildQtyParam(outObj.getBigDecimal("baseqty"), outObj.getBigDecimal("qty"), outObj.getBigDecimal("qty2nd"), outObj.getLong("recordid")));
                outParamList.add(ReserveReplaceHelper.buildQtyParam(outObj.getBigDecimal("baseqty"), outObj.getBigDecimal("qty"), outObj.getBigDecimal("qty2nd"), outObj.getLong("invid")));
                if (!isAggInit || "msmod_reserveaggre".equals(balName)) continue;
                outLockAggParamList.add(ReserveReplaceHelper.buildQtyParam(outObj.getBigDecimal("baseqty"), outObj.getBigDecimal("qty"), outObj.getBigDecimal("qty2nd"), outObj.getLong("aggregateid")));
                DynamicObject aggOutObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)outObj, (boolean)false, (boolean)true);
                aggOutObj.set("balancename", (Object)"msmod_reserveaggre");
                aggOutObj.set("invid", (Object)aggOutObj.getLong("aggregateid"));
                opObjList.add(aggOutObj);
            }
        }
        if (recordParamList.size() > 0) {
            DB.executeBatch((DBRoute)scmRoute, (String)updateOldRecordSql, BalanceHelper.sortSqlParamList(recordParamList));
        }
        if (outParamList.size() > 0) {
            DB.executeBatch((DBRoute)scmRoute, (String)updateOutLockQtySql, BalanceHelper.sortSqlParamList(outParamList));
        }
        if (outLockAggParamList.size() > 0) {
            String lockAggQtySql = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty+?, flockqty =flockqty+?,flockqty2nd =flockqty2nd+? where fid=?";
            DB.executeBatch((DBRoute)scmRoute, (String)lockAggQtySql, BalanceHelper.sortSqlParamList(outLockAggParamList));
        }
        ReserveOpLogHelper.createNewLogByRePlaceRecord(opObjList, false);
    }

    private static Object[] buildUpdateOldRecordQtySql(DynamicObject outObj, BigDecimal outBaseQty, BigDecimal outQty, BigDecimal outQty2nd) {
        Object[] param = new Object[]{outBaseQty, outQty, outQty2nd, outObj.getLong("recordid")};
        return param;
    }

    private static String getSelectColForInStock(Set<String> balModelFieldSet, Map<String, String> balColMap) {
        StringBuilder sb = new StringBuilder();
        for (String suppleFiledInfo : balModelFieldSet) {
            String balFieldName = suppleFiledInfo.substring(2);
            if (balColMap.get(balFieldName) == null) continue;
            sb.append(balColMap.get(balFieldName)).append(" as ").append(suppleFiledInfo).append(',');
        }
        sb.append("id");
        return sb.toString();
    }

    private static DynamicObject buildNewReserveRecord(String balName, Set<String> balModelFieldSet, long newRecordId, Integer expireDay, Long aggId, Map<String, String> balColMap, DynamicObject invInfo, DynamicObject inObj, BigDecimal outBaseQty, BigDecimal outQty, BigDecimal outQty2nd, DynamicObject oldRecord) {
        DynamicObject newReserveRecord = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_record");
        newReserveRecord.set("id", (Object)newRecordId);
        if (aggId != null) {
            newReserveRecord.set("aggregateid", (Object)aggId);
        }
        for (String reserveKey : reserveFieldList) {
            newReserveRecord.set(reserveKey, oldRecord.get(reserveKey));
        }
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        newReserveRecord.set("creater", (Object)userId);
        newReserveRecord.set("create_date", (Object)date);
        newReserveRecord.set("reserveprctype", (Object)INSTOCK_INSTOCK);
        if (!"msmod_reserveaggre".equals(balName)) {
            newReserveRecord.set("bal_id", (Object)inObj.getLong("invid"));
            newReserveRecord.set("bal_entryid", (Object)inObj.getLong("invid"));
        }
        newReserveRecord.set("bal_obj", (Object)oldRecord.getString("bal_obj"));
        newReserveRecord.set("bal_source", (Object)INTRANSIT_INSTOCK);
        newReserveRecord.set("base_qty", (Object)outBaseQty);
        newReserveRecord.set("qty", (Object)outQty);
        newReserveRecord.set("qty2nd", (Object)outQty2nd);
        for (String balField : balModelFieldSet) {
            String balFieldName = balField.substring(2);
            if (balColMap.get(balFieldName) == null) continue;
            newReserveRecord.set(balField, invInfo.get(balField));
        }
        if (expireDay != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(5, expireDay);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            newReserveRecord.set("expiredate", (Object)cal.getTime());
        } else {
            newReserveRecord.set("expiredate", null);
        }
        return newReserveRecord;
    }

    private static DynamicObject buildTransRecord(long newRecordId, long oldRecordId, long entryId, DynamicObject outObj, BigDecimal inTotalBaseQty, BigDecimal outTotalBaseQty, BigDecimal outBaseQty, BigDecimal outQty, BigDecimal outQty2nd, long invId, String tableName, BigDecimal oldBaseQty, BigDecimal oldQty, BigDecimal oldQty2nd) {
        DynamicObject transRecord = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reservetrans");
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        transRecord.set("transbill", (Object)outObj.getString("billobj"));
        transRecord.set("bfrecordid", (Object)oldRecordId);
        transRecord.set("afrecordid", (Object)newRecordId);
        transRecord.set("billid", (Object)outObj.getLong("billid"));
        transRecord.set("billentryid", (Object)entryId);
        transRecord.set("billno", (Object)outObj.getString("billno"));
        transRecord.set("billentryseq", (Object)outObj.getLong("billentryseq"));
        transRecord.set("transtype", (Object)"trans");
        transRecord.set("creater", (Object)userId);
        transRecord.set("createdate", (Object)date);
        transRecord.set("intotalbaseqty", (Object)inTotalBaseQty);
        transRecord.set("outtotalbaseqty", (Object)outTotalBaseQty);
        transRecord.set("replacebaseqty", (Object)outBaseQty);
        transRecord.set("replaceqty", (Object)outQty);
        transRecord.set("replaceqty2nd", (Object)outQty2nd);
        transRecord.set("outbaseqty", (Object)oldBaseQty);
        transRecord.set("outqty", (Object)oldQty);
        transRecord.set("outqty2nd", (Object)oldQty2nd);
        transRecord.set("invid", (Object)invId);
        transRecord.set("baltablename", (Object)tableName);
        return transRecord;
    }

    public static String getUpdateLockQtySql(String tableName, String balName, Map<String, String> balColMap, List<String> tbLockFieldList, String op) {
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)balName);
        String tbGroup = null;
        for (String proStr : RESERVE_QTY_PROS) {
            String realBalCol = balColMap.get(proStr);
            if (realBalCol == null) continue;
            IDataEntityProperty pro = balEntityType.findProperty(realBalCol);
            tbGroup = pro.getTableGroup();
            if (tbLockFieldList.contains(pro.getAlias())) continue;
            tbLockFieldList.add(pro.getAlias());
        }
        StringBuilder lockQtySqlSb = new StringBuilder(" UPDATE ");
        lockQtySqlSb.append(tableName);
        if (tbGroup != null) {
            lockQtySqlSb.append('_').append(tbGroup);
        }
        lockQtySqlSb.append(" SET ");
        int i = 0;
        for (String fieldName : tbLockFieldList) {
            if (i++ > 0) {
                lockQtySqlSb.append(',');
            }
            lockQtySqlSb.append(fieldName).append('=').append(fieldName).append(op).append(" ? ");
        }
        lockQtySqlSb.append(" WHERE FID = ?");
        return lockQtySqlSb.toString();
    }

    public static Object[] buildOutLockStockParam(Map<String, String> balColMap, int fieldLength, BigDecimal actReplaceBaseQty, BigDecimal actReplaceQty, BigDecimal actReplaceQty2nd, long invId) {
        Object[] param = new Object[fieldLength + 1];
        int j = 0;
        param[j] = actReplaceBaseQty;
        ++j;
        if (balColMap.get("qty") != null) {
            param[j] = actReplaceQty;
            ++j;
        }
        if (balColMap.get("qty2nd") != null) {
            param[j] = actReplaceQty2nd;
            ++j;
        }
        param[j] = invId;
        return param;
    }

    public static void reserveReplaceRollBack(String billName, Set<Object> realIdSet) {
        DynamicObjectCollection opObjCol;
        if (realIdSet.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("billid", "in", realIdSet);
        QFilter opFilter = qFilter.and("opstatus", "=", (Object)ReplaceOpStatusEnum.ONCOMMIT);
        try (TXHandle tx = TX.requiresNew((String)"ReserveReplaceService-reserveReplaceRollBack");){
            opObjCol = QueryServiceHelper.query((String)"msmod_reservereplace_op", (String)ReserveReplaceHelper.getOpSelectCols(), (QFilter[])opFilter.toArray());
            if (opObjCol == null || opObjCol.size() < 1) {
                return;
            }
            try {
                String updateSql = "update t_msmod_reservereplace_op set fopstatus = 'ONROLLBACK' where fid = ?";
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(opObjCol.size());
                for (DynamicObject obj : opObjCol) {
                    Object[] param = new Object[]{obj.getLong("id")};
                    paramList.add(param);
                }
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updateSql, BalanceHelper.sortSqlParamList(paramList));
            }
            catch (Exception e) {
                log.error("ReserveReplaceService-reserveReplaceRollBack save msmod_reservereplace_op error:", (Throwable)e);
                tx.markRollback();
                return;
            }
        }
        tx = TX.requiresNew((String)"ReserveReplaceService-reserveReplaceRollBack2");
        var6_5 = null;
        try {
            try {
                if (INTRANSIT_INSTOCK.equals(ReserveServiceCfgFilterHelper.isPredictReplaceInv(billName))) {
                    DynamicObject opObj = (DynamicObject)opObjCol.get(0);
                    ReserveReplaceHelper.unReplace(realIdSet, opObj.getString("billobj"), new DBRoute("scm"), true);
                } else {
                    ReserveReplaceHelper.rollBackNotPredict(opObjCol);
                }
                DeleteServiceHelper.delete((String)"msmod_reservereplace_op", (QFilter[])new QFilter[]{new QFilter("billid", "in", realIdSet)});
            }
            catch (Exception e) {
                log.error("ReserveReplaceService-reserveReplaceRollBack  error:", (Throwable)e);
                tx.markRollback();
            }
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static void rollBackNotPredict(DynamicObjectCollection opObjCol) {
        Map<String, List<DynamicObject>> opObjBalMap = ReserveReplaceHelper.groupOpObjByBalanceName(opObjCol);
        boolean isAggInit = ReserveAggregateHelper.isAggregateInit();
        String addAggLockQty = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty+?, flockqty =flockqty+?,flockqty2nd =flockqty2nd+? where fid=?";
        ArrayList<Object[]> subAggParamList = new ArrayList<Object[]>(1024);
        String updateOldRecordSql = "update t_msmod_reserverecord set f_base_qty = f_base_qty + ?,f_qty = f_qty + ?,f_qty2nd = f_qty2nd + ? where fid = ?";
        ArrayList<Object[]> recordParamList = new ArrayList<Object[]>(1024);
        for (Map.Entry<String, List<DynamicObject>> entry : opObjBalMap.entrySet()) {
            String balName = entry.getKey();
            Map<String, String> balColMap = ColsMapHelper.findBillColMaps(balName, "msmod_std_inv_field").getBalColMap();
            ArrayList<String> tbLockFieldList = new ArrayList<String>(8);
            if (entry.getValue().size() == 0) continue;
            String balTableName = entry.getValue().get(0).getString("baltablename");
            String addLockQty = ReserveReplaceHelper.getUpdateLockQtySql(balTableName, balName, balColMap, tbLockFieldList, "+");
            String subLockQty = ReserveReplaceHelper.getUpdateLockQtySql(balTableName, balName, balColMap, tbLockFieldList, "-");
            ArrayList<Object[]> addParamList = new ArrayList<Object[]>(1024);
            ArrayList<Object[]> subParamList = new ArrayList<Object[]>(1024);
            for (DynamicObject opObj : entry.getValue()) {
                if ("in".equals(opObj.getString("outorinflag"))) {
                    subParamList.add(ReserveReplaceHelper.buildParamByObj(balColMap, tbLockFieldList, opObj));
                    continue;
                }
                addParamList.add(ReserveReplaceHelper.buildParamByObj(balColMap, tbLockFieldList, opObj));
                recordParamList.add(ReserveReplaceHelper.buildOutLockStockParam(balColMap, 3, opObj.getBigDecimal("baseqty"), opObj.getBigDecimal("qty"), opObj.getBigDecimal("qty2nd"), opObj.getLong("recordid")));
                if (!isAggInit || "msmod_reserveaggre".equals(balName)) continue;
                subAggParamList.add(ReserveReplaceHelper.buildQtyParam(opObj.getBigDecimal("baseqty"), opObj.getBigDecimal("qty"), opObj.getBigDecimal("qty2nd"), opObj.getLong("aggregateid")));
            }
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)balName);
            DBRoute scmRoute = new DBRoute(mainEntityType.getDBRouteKey());
            if (addParamList.size() > 0) {
                ReserveReplaceHelper.executeMethod(addLockQty, BalanceHelper.sortSqlParamList(addParamList), scmRoute);
            }
            if (subParamList.size() <= 0) continue;
            ReserveReplaceHelper.executeMethod(subLockQty, BalanceHelper.sortSqlParamList(subParamList), scmRoute);
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"msmod_reserveaggre");
        DBRoute scmRoute = new DBRoute(mainEntityType.getDBRouteKey());
        if (recordParamList.size() > 0) {
            ReserveReplaceHelper.executeMethod(updateOldRecordSql, BalanceHelper.sortSqlParamList(recordParamList), scmRoute);
        }
        if (subAggParamList.size() > 0) {
            ReserveReplaceHelper.executeMethod(addAggLockQty, BalanceHelper.sortSqlParamList(subAggParamList), scmRoute);
        }
        ReserveOpLogHelper.createNewLogByRePlaceRecord((Collection<DynamicObject>)opObjCol, true);
    }

    private static Map<String, List<DynamicObject>> groupOpObjByBalanceName(DynamicObjectCollection opObjCol) {
        HashMap<String, List<DynamicObject>> opObjBalMap = new HashMap<String, List<DynamicObject>>(1024);
        for (DynamicObject opObj : opObjCol) {
            String balName = opObj.getString("balancename");
            ArrayList<DynamicObject> opObjList = (ArrayList<DynamicObject>)opObjBalMap.get(balName);
            if (opObjList == null) {
                opObjList = new ArrayList<DynamicObject>(1024);
            }
            opObjList.add(opObj);
            opObjBalMap.put(balName, opObjList);
        }
        return opObjBalMap;
    }

    public static Object[] buildQtyParam(BigDecimal baseQty, BigDecimal qty, BigDecimal qty2nd, long invId) {
        Object[] lockParam = new Object[]{baseQty, qty, qty2nd, invId};
        return lockParam;
    }

    private static Object[] buildParamByObj(Map<String, String> balColMap, List<String> tbLockFieldList, DynamicObject opObj) {
        return ReserveReplaceHelper.buildOutLockStockParam(balColMap, tbLockFieldList.size(), opObj.getBigDecimal("baseqty"), opObj.getBigDecimal("qty"), opObj.getBigDecimal("qty2nd"), opObj.getLong("invid"));
    }

    public static List<Object[]> unReserveRecordReplace(Set<Object> billIds, String entityNumber, DBRoute dbRoute, boolean isRollBack) {
        return ReserveReplaceHelper.unReplace(billIds, entityNumber, dbRoute, false);
    }

    private static List<Object[]> unReplace(Set<Object> billIds, String entityNumber, DBRoute dbRoute, boolean isRollBack) {
        String algoKey = "kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceHelper.unReplace";
        HashSet<Long> transIds = new HashSet<Long>(billIds.size());
        DataSet transData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"msmod_reservetrans", (String)"id,afrecordid,replacebaseqty", (QFilter[])new QFilter("billid", "in", billIds).toArray(), null);
        Set<Long> reserveIds = ReserveReplaceHelper.getReserveIdBytrans(billIds, transData);
        DataSet reserveData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"msmod_reserve_record", (String)"id as reserveId,base_qty", (QFilter[])new QFilter("id", "in", reserveIds).toArray(), null);
        DataSet transIdData = transData.join(reserveData, JoinType.INNER).on("afrecordid", "reserveId").on("replacebaseqty", "base_qty").select(new String[]{"id"}).finish();
        while (transIdData.hasNext()) {
            Row row = transIdData.next();
            transIds.add(row.getLong("id"));
        }
        transIdData.close();
        if (transIds.isEmpty()) {
            return null;
        }
        QFilter idF = new QFilter("id", "in", transIds);
        QFilter formIdF = new QFilter("transbill", "=", (Object)entityNumber);
        DynamicObjectCollection reserveReplaceCols = QueryServiceHelper.query((String)"msmod_reservetrans", (String)"bfrecordid,afrecordid,billentryid,intotalbaseqty,outtotalbaseqty,baltablename,replacebaseqty,replaceqty,replaceqty2nd,invid,deletestatus,transbill,billid,billno,billentryseq", (QFilter[])new QFilter[]{idF, formIdF});
        if (reserveReplaceCols.isEmpty()) {
            return null;
        }
        if (((DynamicObject)reserveReplaceCols.get(0)).getBoolean("deletestatus")) {
            return ReserveReplaceHelper.dealRedoUnReplace(dbRoute, reserveReplaceCols);
        }
        HashMap<Long, Long> reserveIdsMap = new HashMap<Long, Long>(reserveReplaceCols.size());
        HashMap<Long, DynamicObject> bfObjMap = new HashMap<Long, DynamicObject>(reserveReplaceCols.size());
        for (DynamicObject reserveReplace : reserveReplaceCols) {
            reserveIdsMap.put(reserveReplace.getLong("afrecordid"), reserveReplace.getLong("bfrecordid"));
            bfObjMap.put(reserveReplace.getLong("bfrecordid"), reserveReplace);
        }
        List<Object[]> result = ReserveReplaceHelper.handleBalAndReserveRecord(bfObjMap, reserveIdsMap, dbRoute, isRollBack);
        String updateTransSql = "update t_msmod_reservetrans set fdeletestatus = '1' where fbillid = ?";
        ArrayList<Object[]> transParamList = new ArrayList<Object[]>(billIds.size());
        for (Object billId : billIds) {
            transParamList.add(new Object[]{billId});
        }
        if (transParamList.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)updateTransSql, BalanceHelper.sortSqlParamList(transParamList));
        }
        String updateRecordSql = "update t_msmod_reserverecord set fdeletestatus = '1',f_base_qty = ?,f_qty=?,f_qty2nd=? where fid = ?";
        ArrayList<Object[]> recordParamList = new ArrayList<Object[]>(billIds.size());
        for (Object recordId : reserveIdsMap.keySet()) {
            recordParamList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, recordId});
        }
        if (transParamList.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)updateRecordSql, BalanceHelper.sortSqlParamList(recordParamList));
        }
        return result;
    }

    private static Set<Long> getReserveIdBytrans(Set<Object> billIds, DataSet transData) {
        HashSet<Long> reserveIds = new HashSet<Long>(billIds.size());
        DataSet copyData = transData.copy();
        while (copyData.hasNext()) {
            Row row = copyData.next();
            reserveIds.add(row.getLong("afrecordid"));
        }
        return reserveIds;
    }

    private static List<Object[]> dealRedoUnReplace(DBRoute dbRoute, DynamicObjectCollection reserveReplaceCols) {
        Object[] obj3;
        ArrayList<Object[]> result = new ArrayList<Object[]>(8);
        HashMap<Long, Object[]> paramsMap = new HashMap<Long, Object[]>(16);
        HashMap<Long, Object[]> aggParamsMap = new HashMap<Long, Object[]>(16);
        boolean isAggInit = ReserveAggregateHelper.isAggregateInit();
        String balTableName = "";
        HashSet<Long> invIdSet = new HashSet<Long>(reserveReplaceCols.size());
        for (Object obj2 : reserveReplaceCols) {
            if ("t_msmod_reserveaggregate".equals(obj2.getString("baltablename"))) continue;
            balTableName = obj2.getString("baltablename");
            invIdSet.add(obj2.getLong("invid"));
        }
        Map<Long, Long> aggInvMap = ReserveReplaceHelper.getAggInvMap("im_inv_realbalance", invIdSet, null);
        for (Object[] obj3 : reserveReplaceCols) {
            Object[] param;
            long invId;
            BigDecimal baseQty = obj3.getBigDecimal("replacebaseqty");
            BigDecimal qty = obj3.getBigDecimal("replaceqty");
            BigDecimal qty2nd = obj3.getBigDecimal("replaceqty2nd");
            if ("t_msmod_reserveaggregate".equals(obj3.getString("baltablename"))) {
                invId = obj3.getLong("invid");
                param = ReserveReplaceHelper.getParam(aggParamsMap, baseQty, qty, qty2nd, invId);
                aggParamsMap.put(invId, param);
                continue;
            }
            invId = obj3.getLong("invid");
            param = ReserveReplaceHelper.getParam(paramsMap, baseQty, qty, qty2nd, invId);
            paramsMap.put(invId, param);
            if (!isAggInit || aggInvMap == null || aggInvMap.get(invId) == null) continue;
            long aggId = aggInvMap.get(invId);
            Object[] param2 = ReserveReplaceHelper.getParam(aggParamsMap, baseQty, qty, qty2nd, aggId);
            aggParamsMap.put(aggId, param2);
        }
        if (paramsMap.size() > 0) {
            String locQtySql = org.apache.commons.lang3.StringUtils.join((Object[])new String[]{"update ", balTableName, "_a set flockbaseqty =flockbaseqty-?, flockqty =flockqty-?,flockqty2nd =flockqty2nd-? where fid=?"});
            ReserveReplaceHelper.executeBatchRecordSql(paramsMap, locQtySql, dbRoute);
            obj3 = new Object[]{dbRoute, org.apache.commons.lang3.StringUtils.join((Object[])new String[]{"update ", balTableName, "_a set flockbaseqty =flockbaseqty+?, flockqty =flockqty+?,flockqty2nd =flockqty2nd+? where fid=?"}), paramsMap};
            result.add(obj3);
        }
        if (aggParamsMap.size() > 0) {
            String lockAggQtySql = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty-?, flockqty =flockqty-?,flockqty2nd =flockqty2nd-? where fid=?";
            ReserveReplaceHelper.executeBatchRecordSql(aggParamsMap, lockAggQtySql, dbRoute);
            obj3 = new Object[]{dbRoute, "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty+?, flockqty =flockqty+?,flockqty2nd =flockqty2nd+? where fid=?", aggParamsMap};
            result.add(obj3);
        }
        return result;
    }

    private static Object[] getParam(Map<Long, Object[]> paramsMap, BigDecimal baseQty, BigDecimal qty, BigDecimal qty2nd, long invId) {
        Object[] oldParam = paramsMap.get(invId);
        if (oldParam == null) {
            oldParam = ReserveReplaceHelper.buildQtyParam(baseQty, qty, qty2nd, invId);
        } else {
            oldParam[0] = ((BigDecimal)oldParam[0]).add(baseQty);
            oldParam[1] = ((BigDecimal)oldParam[1]).add(qty);
            oldParam[2] = ((BigDecimal)oldParam[2]).add(qty2nd);
        }
        return oldParam;
    }

    public static String getOpSelectCols() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"msmod_reservereplace_op");
        Map dataMap = mainEntityType.getFields();
        StringBuilder selectColSb = new StringBuilder();
        for (String field : dataMap.keySet()) {
            selectColSb.append(field).append(',');
        }
        selectColSb.append("id");
        return selectColSb.toString();
    }

    public static Set<Object> getReserveReplaceRealIdSet(String serviceName, String billName, Set<Object> billIdSet, String opName) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveReplaceService", (String)"getReserveReplaceRealIdList");){
            HashSet<Object> realBillSet = new HashSet<Object>(billIdSet.size());
            if (billIdSet == null || billIdSet.size() == 0) {
                Set<Object> set = billIdSet;
                return set;
            }
            Long[] idsArr = billIdSet.toArray(new Long[billIdSet.size()]);
            List<Object> objects = ReserveServiceCfgFilterHelper.canReserveBillIds(serviceName, idsArr, billName, opName);
            realBillSet.addAll(objects);
            HashSet<Object> hashSet = realBillSet;
            return hashSet;
        }
    }

    public static DynamicObject buildRecord4Log(String entityNumber, Row row, long entryId, ReserveReplaceBalRecordModel replaceBalRecordModel, BigDecimal actReplaceBaseQty, BigDecimal actReplaceQty, BigDecimal actReplaceQty2nd, String balName, long balId) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_record");
        record.set("id", (Object)row.getLong("id"));
        record.set("bill_obj", (Object)entityNumber);
        record.set("bill_no", (Object)replaceBalRecordModel.getBillNo());
        record.set("bill_id", (Object)replaceBalRecordModel.getBillId());
        record.set("billentry_id", (Object)entryId);
        record.set("billentry_seq", (Object)replaceBalRecordModel.getBillEntrySeq());
        record.set("bal_obj", (Object)balName);
        record.set("bal_id", (Object)balId);
        record.set("base_qty", (Object)actReplaceBaseQty);
        record.set("qty", (Object)actReplaceQty);
        record.set("qty2nd", (Object)actReplaceQty2nd);
        return record;
    }
}

