/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.reserve.business.strategy.IColsSelectStrategy;
import org.apache.commons.lang3.StringUtils;

public class DefaultSelectStrategy
implements IColsSelectStrategy {
    @Override
    public TreeNode buildNode4BaseData(TreeNode parentNode, TreeNode entryNode, BasedataProp pro, boolean needBaseDataSubAttr) {
        if (!this.filterBaseDataPro(pro)) {
            return null;
        }
        TreeNode baseDataNode = null;
        baseDataNode = needBaseDataSubAttr ? this.getLowerTreeNode(parentNode, entryNode, (IDataEntityProperty)pro) : this.getTreeNode(entryNode.getId(), pro.getName(), pro.getDisplayName().getLocaleValue());
        if (pro instanceof FlexProp) {
            return baseDataNode;
        }
        this.fillBaseDataTree(baseDataNode, pro.getBaseEntityId(), pro);
        return baseDataNode;
    }

    @Override
    public TreeNode buildNode4BaseData(TreeNode parentNode, BasedataProp pro, boolean needBaseDataSubAttr) {
        if (!this.filterBaseDataPro(pro)) {
            return null;
        }
        TreeNode baseDataNode = null;
        baseDataNode = needBaseDataSubAttr ? this.getLowerTreeNode(parentNode, (IDataEntityProperty)pro) : this.getTreeNode(parentNode.getId(), pro.getName(), pro.getDisplayName().getLocaleValue());
        if (pro instanceof FlexProp) {
            return baseDataNode;
        }
        this.fillBaseDataTree(baseDataNode, pro.getBaseEntityId(), pro);
        return baseDataNode;
    }

    private TreeNode getTreeNode(String parentId, IDataEntityProperty pro) {
        return this.getTreeNode(parentId, pro.getName(), pro.getDisplayName().getLocaleValue());
    }

    private void fillBaseDataTree(TreeNode baseDataNode, String baseDataNo, BasedataProp basedataProp) {
        if (StringUtils.isBlank((CharSequence)baseDataNo)) {
            return;
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)baseDataNo);
        Map fields = type.getFields();
        Set<String> cols = this.getNeedColsOfBaseData(baseDataNo);
        Set<String> addCols = this.getNeedColsOfBaseData(baseDataNo, basedataProp);
        if (cols == null) {
            cols = addCols;
        } else if (addCols != null) {
            cols.addAll(addCols);
        }
        if (cols == null) {
            for (IDataEntityProperty pro : fields.values()) {
                if (!this.fixedFilter(pro)) continue;
                baseDataNode.addChild(this.getLowerTreeNode(baseDataNode, pro));
            }
        } else {
            for (String col : cols) {
                IDataEntityProperty pro = (IDataEntityProperty)fields.get(col);
                if (pro == null || !this.fixedFilter(pro)) continue;
                baseDataNode.addChild(this.getLowerTreeNode(baseDataNode, pro));
            }
        }
    }

    private TreeNode getLowerTreeNode(TreeNode baseDataNode, IDataEntityProperty pro) {
        String parentId = baseDataNode.getId();
        String parentText = baseDataNode.getText();
        return this.getTreeNode(parentId, parentId + "." + pro.getName(), parentText + "." + pro.getDisplayName());
    }

    private TreeNode getLowerTreeNode(TreeNode parentbaseDataNode, TreeNode baseDataNode, IDataEntityProperty pro) {
        String grandParentId = parentbaseDataNode.getId();
        String grandparentText = parentbaseDataNode.getText();
        String parentId = baseDataNode.getId();
        String parentText = baseDataNode.getText();
        return this.getTreeNode(parentId, grandParentId + "." + parentId + "." + pro.getName(), grandparentText + "." + parentText + "." + pro.getDisplayName());
    }

    @Override
    public void buildNode4Head(TreeNode root, IDataEntityProperty pro) {
        if (!this.fixedFilter(pro)) {
            return;
        }
        if (!this.filterPro(pro)) {
            return;
        }
        TreeNode node = null;
        node = pro instanceof BasedataProp ? this.buildNode4BaseData(root, (BasedataProp)pro, false) : this.getTreeNode(root.getId(), pro);
        root.addChild(node);
    }

    @Override
    public void buildNode4Entry(TreeNode entryNode, IDataEntityProperty pro) {
        if (!this.fixedFilter(pro)) {
            return;
        }
        if (!this.filterPro(pro)) {
            return;
        }
        TreeNode node = null;
        node = pro instanceof BasedataProp ? this.buildNode4BaseData(entryNode, (BasedataProp)pro, true) : this.getLowerTreeNode(entryNode, pro);
        entryNode.addChild(node);
    }

    @Override
    public void buildNode4Entry(TreeNode parentEntryNode, TreeNode entryNode, IDataEntityProperty pro) {
        if (!this.fixedFilter(pro)) {
            return;
        }
        if (!this.filterPro(pro)) {
            return;
        }
        TreeNode node = null;
        node = pro instanceof BasedataProp ? this.buildNode4BaseData(parentEntryNode, entryNode, (BasedataProp)pro, true) : this.getLowerTreeNode(parentEntryNode, entryNode, pro);
        entryNode.addChild(node);
    }
}

